/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.rte.fe;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentServiceImpl;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.DeltaDDLGenerator;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Constraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.constraints.UniqueConstraint;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.PersistentTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;

public class GenericDeltaDdlGenerator
implements DeltaDDLGenerator {
    protected static final int CREATE = 1;
    protected static final int DROP = 2;
    protected static final int MODIFIED = 4;
    protected static final int RENAME = 8;
    protected static final int COMMENT = 16;
    protected static final int LABEL = 32;
    protected EChangeSummary changeSummary = null;
    protected Collection redoChanges = null;

    public final String[] generateDeltaDDL(EChangeSummary changeSummary, IProgressMonitor monitor) {
        this.changeSummary = changeSummary;
        this.changeSummary.summarize();
        Map changeMap = this.buildChangeMap(monitor);
        this.analyze(changeMap);
        String[] statements = this.processChangeMap(changeMap, monitor);
        this.changeSummary = null;
        this.redoChanges = null;
        return statements;
    }

    protected int getChangeFlag(EObject element, EObject changed, EStructuralFeature feature, ChangeSummary.Setting setting) {
        if (element != changed) {
            return 4;
        }
        if (feature == EcorePackage.eINSTANCE.getENamedElement_Name()) {
            return 8;
        }
        if (feature == SQLSchemaPackage.eINSTANCE.getSQLObject_Description()) {
            return 16;
        }
        if (feature == SQLSchemaPackage.eINSTANCE.getSQLObject_Label()) {
            return 32;
        }
        if (feature == SQLTablesPackage.eINSTANCE.getTable_Columns()) {
            return 4;
        }
        if (feature instanceof EReference && feature.isMany() && ((EReference)feature).getEOpposite() != null) {
            return 0;
        }
        return 4;
    }

    protected void analyze(Map changeMap) {
        LinkedList elements = new LinkedList();
        elements.addAll(changeMap.keySet());
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            int flag;
            EObject e = (EObject)it.next();
            if (!this.needRecreate(e, flag = ((Integer)changeMap.get(e)).intValue())) continue;
            if (e instanceof Column) {
                Column column = (Column)e;
                Table table = column.getTable();
                changeMap.put(table, new Integer(3));
                if (!(table instanceof PersistentTable)) continue;
                this.processModifiedTable((PersistentTable)table, changeMap);
                continue;
            }
            if (e instanceof PersistentTable) {
                flag = 3;
                changeMap.put(e, new Integer(flag));
                this.processModifiedTable((PersistentTable)e, changeMap);
                continue;
            }
            if (e instanceof UniqueConstraint) {
                flag = 3;
                changeMap.put(e, new Integer(flag));
                this.processModifiedUniqueConstraint((UniqueConstraint)e, changeMap);
                continue;
            }
            if (e instanceof Index) {
                flag = 3;
                changeMap.put(e, new Integer(flag));
                this.processModifiedIndex((Index)e, changeMap);
                continue;
            }
            flag = 3;
            changeMap.put(e, new Integer(flag));
        }
    }

    protected boolean needRecreate(EObject e, int flag) {
        return (flag & 0x3C) != 0;
    }

    protected String[] processChangeMap(Map changeMap, IProgressMonitor monitor) {
        DDLGenerator ddlGenerator = this.getDDLGenerator();
        this.undo();
        String[] drops = this.getDropStatements(ddlGenerator, changeMap, monitor);
        this.redo();
        String[] creates = this.getCreateStatements(ddlGenerator, changeMap, monitor);
        this.changeSummary = null;
        return this.merge(drops, creates);
    }

    protected final String[] merge(String[] s1, String[] s2) {
        String[] all = new String[s1.length + s2.length];
        int k = 0;
        int i = 0;
        while (i < s1.length) {
            all[k++] = s1[i];
            ++i;
        }
        i = 0;
        while (i < s2.length) {
            all[k++] = s2[i];
            ++i;
        }
        return all;
    }

    private void processModifiedUniqueConstraint(UniqueConstraint uk, Map changeMap) {
        Iterator it = uk.getForeignKey().iterator();
        while (it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            if (changeMap.containsKey(fk)) continue;
            changeMap.put(fk, new Integer(3));
        }
    }

    private void processModifiedIndex(Index index, Map changeMap) {
        Iterator it = index.getForeignKey().iterator();
        while (it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            if (changeMap.containsKey(fk)) continue;
            changeMap.put(fk, new Integer(3));
        }
    }

    private void processModifiedTable(PersistentTable table, Map changeMap) {
        Iterator it = table.getUniqueConstraints().iterator();
        while (it.hasNext()) {
            UniqueConstraint uk = (UniqueConstraint)it.next();
            if (changeMap.containsKey(uk)) continue;
            changeMap.put(uk, new Integer(3));
            this.processModifiedUniqueConstraint(uk, changeMap);
        }
        it = table.getIndex().iterator();
        while (it.hasNext()) {
            Index index = (Index)it.next();
            if (changeMap.containsKey(index)) continue;
            changeMap.put(index, new Integer(3));
            this.processModifiedIndex(index, changeMap);
        }
        it = table.getForeignKeys().iterator();
        while (it.hasNext()) {
            ForeignKey fk = (ForeignKey)it.next();
            if (changeMap.containsKey(fk)) continue;
            changeMap.put(fk, new Integer(3));
        }
        it = table.getConstraints().iterator();
        while (it.hasNext()) {
            Constraint ck = (Constraint)it.next();
            if (changeMap.containsKey(ck)) continue;
            changeMap.put(ck, new Integer(1));
        }
        it = table.getTriggers().iterator();
        while (it.hasNext()) {
            Trigger trigger = (Trigger)it.next();
            if (changeMap.containsKey(trigger)) continue;
            changeMap.put(trigger, new Integer(3));
        }
    }

    protected final void undo() {
        LinkedList<ChangeRecord> undoStack = new LinkedList<ChangeRecord>();
        LinkedList<ChangeRecord> redoStack = new LinkedList<ChangeRecord>();
        Iterator it = this.changeSummary.getChangedDataObjects().iterator();
        while (it.hasNext()) {
            EDataObject changed;
            List oldValues;
            Object changedObject = it.next();
            if (!(changedObject instanceof EDataObject) || (oldValues = this.changeSummary.getOldValues((DataObject)(changed = (EDataObject)changedObject))) == null) continue;
            Iterator vi = oldValues.iterator();
            while (vi.hasNext()) {
                ChangeSummary.Setting changeSetting = (ChangeSummary.Setting)vi.next();
                EProperty p = (EProperty)changeSetting.getProperty();
                EStructuralFeature f = p.getEStructuralFeature();
                changeSetting.getValue();
                ChangeRecord c1 = new ChangeRecord();
                c1.element = changed;
                c1.feature = f;
                c1.isSet = true;
                if (f.isUnsettable()) {
                    c1.isSet = changeSetting.isSet();
                }
                if (c1.isSet) {
                    c1.value = changeSetting.getValue();
                    if (c1.value instanceof Collection) {
                        LinkedList l = new LinkedList();
                        l.addAll((Collection)c1.value);
                        c1.value = l;
                    }
                } else {
                    c1.value = null;
                }
                undoStack.add(c1);
                ChangeRecord c2 = new ChangeRecord();
                c2.element = changed;
                c2.feature = f;
                c2.isSet = true;
                if (f.isUnsettable()) {
                    c2.isSet = changed.eIsSet(f);
                }
                if (c2.isSet) {
                    c2.value = changed.eGet(f);
                    if (c2.value instanceof Collection) {
                        LinkedList l = new LinkedList();
                        l.addAll((Collection)c2.value);
                        c2.value = l;
                    }
                }
                redoStack.add(c2);
            }
        }
        this.executeChangeRecords(undoStack);
        this.redoChanges = redoStack;
    }

    protected final void redo() {
        this.executeChangeRecords(this.redoChanges);
    }

    protected final String[] getDropStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor) {
        DDLGenerator generator = this.getDDLGenerator();
        Vector<EObject> elements = new Vector<EObject>();
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 2) == 0) continue;
            elements.add(key);
        }
        if (elements.size() > 0) {
            Object[] d = new SQLObject[elements.size()];
            elements.copyInto(d);
            generator.getOptions((SQLObject[])d);
            return gen.dropSQLObjects((SQLObject[])d, true, true, monitor);
        }
        return new String[0];
    }

    protected final String[] getCreateStatements(DDLGenerator gen, Map changeMap, IProgressMonitor monitor) {
        DDLGenerator generator = this.getDDLGenerator();
        Vector<EObject> elements = new Vector<EObject>();
        Iterator it = changeMap.keySet().iterator();
        while (it.hasNext()) {
            EObject key = (EObject)it.next();
            int flag = (Integer)changeMap.get(key);
            if ((flag & 1) == 0) continue;
            elements.add(key);
        }
        if (elements.size() > 0) {
            Object[] d = new SQLObject[elements.size()];
            elements.copyInto(d);
            generator.getOptions((SQLObject[])d);
            return gen.createSQLObjects((SQLObject[])d, true, true, monitor);
        }
        return new String[0];
    }

    protected final EObject getDisplayableElement(EObject e) {
        while (e != null && !ContainmentServiceImpl.INSTANCE.isDisplayableElement(e)) {
            e = ContainmentServiceImpl.INSTANCE.getContainer(e);
        }
        return e;
    }

    protected final DDLGenerator getDDLGenerator() {
        EObject x = (EObject)this.changeSummary.getDataGraph().getRootObject();
        Database database = (Database)ContainmentServiceImpl.INSTANCE.getRootElement(x);
        DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition(database);
        return def.getDDLGenerator();
    }

    protected final Object getOldValue(EStructuralFeature feature, EDataObject changed) {
        Iterator it = this.changeSummary.getOldValues((DataObject)changed).iterator();
        while (it.hasNext()) {
            ChangeSummary.Setting changeSetting = (ChangeSummary.Setting)it.next();
            EProperty p = (EProperty)changeSetting.getProperty();
            if (p.getEStructuralFeature() != feature) continue;
            return changeSetting.getValue();
        }
        return changed.eGet(feature);
    }

    protected final boolean ancestorModified(Map changeMap, EObject e) {
        Iterator it = ContainmentServiceImpl.INSTANCE.getAllContainers(e).iterator();
        while (it.hasNext()) {
            Object c = it.next();
            if (!changeMap.containsKey(c)) continue;
            changeMap.get(c);
            int flag = (Integer)changeMap.get(c);
            if ((flag & 0xF) == 0) continue;
            return true;
        }
        return false;
    }

    private Map buildChangeMap(IProgressMonitor monitor) {
        HashMap<EDataObject, Integer> changeMap = new HashMap<EDataObject, Integer>();
        Iterator it = this.changeSummary.getChangedDataObjects().iterator();
        while (it.hasNext()) {
            EDataObject changed;
            EDataObject element;
            Object changedObject = it.next();
            if (!(changedObject instanceof EDataObject) || (element = (EDataObject)this.getDisplayableElement((EObject)(changed = (EDataObject)changedObject))) == null) continue;
            int flag = 0;
            if (changeMap.containsKey(element)) {
                flag = (Integer)changeMap.get(element);
            }
            if (flag == 2 || flag == 1) continue;
            if (this.changeSummary.isCreated((DataObject)element)) {
                if (this.changeSummary.isDeleted((DataObject)element)) continue;
                flag = 1;
            } else if (this.changeSummary.isDeleted((DataObject)element)) {
                flag = 2;
            } else {
                List oldValues;
                if (this.changeSummary.isCreated((DataObject)changed) || this.changeSummary.isDeleted((DataObject)changed) || (oldValues = this.changeSummary.getOldValues((DataObject)changed)) == null) continue;
                Iterator vi = oldValues.iterator();
                while (vi.hasNext()) {
                    ChangeSummary.Setting changeSetting = (ChangeSummary.Setting)vi.next();
                    EProperty p = (EProperty)changeSetting.getProperty();
                    EStructuralFeature f = p.getEStructuralFeature();
                    if (!changeSetting.isSet() && !changed.eIsSet(f)) continue;
                    Object currentValue = changed.eGet(f);
                    Object previousValue = changeSetting.getValue();
                    if (previousValue == null) {
                        previousValue = "";
                    }
                    if (currentValue == null) {
                        if (this.underContainer(f, changed, previousValue)) {
                            flag = 2;
                            break;
                        }
                        currentValue = "";
                    }
                    if (currentValue.equals(previousValue)) continue;
                    flag |= this.getChangeFlag((EObject)element, (EObject)changed, f, changeSetting);
                }
            }
            if (flag == 0) continue;
            changeMap.put(element, new Integer(flag));
        }
        return changeMap;
    }

    private boolean underContainer(EStructuralFeature f, Object obj, Object container) {
        if (!(obj instanceof EObject) || !(container instanceof EObject)) {
            return false;
        }
        EStructuralFeature feature = ((EObject)container).eContainingFeature();
        if (feature != null) {
            return feature.getEContainingClass().isInstance(obj);
        }
        Iterator it = ((EObject)container).eClass().getEAllReferences().iterator();
        while (it.hasNext()) {
            EReference opposite;
            EReference reference = (EReference)it.next();
            if (!reference.isMany() || (opposite = reference.getEOpposite()) == null || !opposite.getContainerClass().isAssignableFrom(obj.getClass())) continue;
            return true;
        }
        return false;
    }

    private void executeChangeRecords(Collection changeRecords) {
        Iterator it = changeRecords.iterator();
        while (it.hasNext()) {
            ChangeRecord r = (ChangeRecord)it.next();
            boolean deliver = r.element.eDeliver();
            r.element.eSetDeliver(false);
            if (r.isSet) {
                if (r.feature.isMany()) {
                    Collection c = (Collection)r.element.eGet(r.feature);
                    c.clear();
                    c.addAll((Collection)r.value);
                } else {
                    r.element.eSet(r.feature, r.value);
                }
            } else {
                r.element.eUnset(r.feature);
            }
            r.element.eSetDeliver(deliver);
        }
    }

    private static class ChangeRecord {
        public EObject element;
        public EStructuralFeature feature;
        public Object value;
        public boolean isSet;

        private ChangeRecord() {
        }
    }
}

