/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.analyzer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.apache.xerces.util.URI;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.ServiceReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.WSDLElement;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLUtils;

public class CandidateInfo {
    private Definition[] definitions = null;
    private Import[] imports = null;
    private Types[] types = null;
    private Message[] messages = null;
    private Operation[] operations = null;
    private PortType[] portTypes = null;
    private Binding[] bindings = null;
    private Port[] ports = null;
    private URI[] endPoints = null;
    private WSDLDocument wsdlDocument;

    public CandidateInfo(ServiceReference serviceReference, WSDLDocument wsdlDocument) throws WSIException {
        WSDLElement wsdlElement = serviceReference.getWSDLElement();
        this.wsdlDocument = wsdlDocument;
        this.imports = this.getAllImports(wsdlDocument.getDefinitions()).toArray(new Import[0]);
        this.definitions = new Definition[this.imports.length + 1];
        this.definitions[0] = wsdlDocument.getDefinitions();
        Types[] tempTypes = new Types[this.definitions.length];
        int typesCount = 0;
        if (this.definitions[0].getTypes() != null) {
            tempTypes[0] = this.definitions[0].getTypes();
            ++typesCount;
        }
        int i = 0;
        while (i < this.imports.length) {
            this.definitions[i + 1] = this.imports[i].getDefinition();
            if (this.definitions[i + 1] != null && this.definitions[i + 1].getTypes() != null) {
                tempTypes[typesCount] = this.definitions[i + 1].getTypes();
                ++typesCount;
            }
            ++i;
        }
        if (typesCount > 0) {
            this.types = new Types[typesCount];
            i = 0;
            while (i < typesCount) {
                this.types[i] = tempTypes[i];
                ++i;
            }
        }
        if (wsdlElement.isPort()) {
            Port port = null;
            QName serviceName = wsdlElement.getParentElementQName();
            Service[] s = wsdlDocument.getServices();
            String portName = wsdlElement.getName();
            int i2 = 0;
            while (i2 < s.length && port == null) {
                if (s[i2].getQName().equals(serviceName)) {
                    port = s[i2].getPort(portName);
                }
                ++i2;
            }
            if (port == null) {
                throw new WSIException("WSDL Port '" + portName + "' for Service '" + serviceName + "' not found in service description");
            }
            this.ports = new Port[]{port};
            this.descendents(port);
        } else if (wsdlElement.isBinding()) {
            if (wsdlElement.getQName() != null && wsdlElement.getQName().getLocalPart() != null && wsdlElement.getQName().getLocalPart().length() > 0) {
                Binding binding = wsdlDocument.getDefinitions().getBinding(wsdlElement.getQName());
                if (binding == null) {
                    throw new WSIException("WSDL Binding named '" + wsdlElement.getQName() + "' not found in service description");
                }
                this.bindings = new Binding[]{binding};
                this.descendents(binding);
            }
        } else if (wsdlElement.isPortType()) {
            PortType portType = wsdlDocument.getDefinitions().getPortType(wsdlElement.getQName());
            this.portTypes = new PortType[]{portType};
            if (portType == null) {
                throw new WSIException("WSDL PortType named '" + wsdlElement.getQName() + "' not found in service description");
            }
            this.portTypes = new PortType[]{portType};
            this.descendents(portType);
        } else if (wsdlElement.isOperation()) {
            Operation operation = null;
            String configOpName = wsdlElement.getName();
            QName portTypeName = wsdlElement.getParentElementQName();
            PortType[] p = wsdlDocument.getPortTypes();
            int i3 = 0;
            while (i3 < p.length && operation == null) {
                if (p[i3].getQName().equals(portTypeName)) {
                    Iterator opIt = p[i3].getOperations().iterator();
                    Operation op = null;
                    while (opIt.hasNext() && operation == null) {
                        op = (Operation)opIt.next();
                        if (!configOpName.equals(op.getName())) continue;
                        operation = op;
                    }
                }
                ++i3;
            }
            if (operation == null) {
                throw new WSIException("No WSDL Operation named '" + wsdlElement.getQName() + "' found in service description");
            }
            this.operations = new Operation[]{operation};
            this.descendents(operation);
        } else if (wsdlElement.isMessage()) {
            Message message = wsdlDocument.getDefinitions().getMessage(wsdlElement.getQName());
            if (message == null) {
                throw new WSIException("No WSDL Message named '" + wsdlElement.getQName() + "' found in service description");
            }
            this.messages = new Message[]{message};
        } else {
            throw new WSIException("Unrecognised <WSDLElement type> in config: " + wsdlElement.getType());
        }
        this.endPoints = this.deriveEndpoints(serviceReference, this.ports, this.definitions);
    }

    protected void descendents(Port port) throws WSIException {
        if (port == null) {
            throw new WSIException("Internal error: expected a Port value");
        }
        this.bindings = new Binding[]{port.getBinding()};
        if (this.bindings[0] != null) {
            this.descendents(this.bindings[0]);
        }
    }

    protected void descendents(Binding binding) throws WSIException {
        if (binding == null) {
            throw new WSIException("Internal error: expected a Binding value");
        }
        this.portTypes = new PortType[]{binding.getPortType()};
        if (this.portTypes[0] != null) {
            this.descendents(this.portTypes[0]);
            Definition definition = this.definitions[0];
            HashSet<Message> messageSet = new HashSet<Message>();
            if (this.messages != null) {
                int i = 0;
                while (i < this.messages.length) {
                    messageSet.add(this.messages[i]);
                    ++i;
                }
            }
            HashSet bindingMessages = WSDLUtils.findMessages(definition, binding);
            messageSet.addAll(bindingMessages);
            this.messages = new Message[0];
            this.messages = messageSet.toArray(this.messages);
        }
    }

    protected void descendents(PortType portType) throws WSIException {
        if (portType == null) {
            throw new WSIException("Internal error: expected a PortType value");
        }
        this.operations = new Operation[0];
        this.operations = portType.getOperations().toArray(this.operations);
        if (this.operations.length > 0) {
            this.descendents(this.operations);
        }
    }

    protected void descendents(Operation operation) throws WSIException {
        if (operation == null) {
            throw new WSIException("Internal error: expected an Operation value");
        }
        this.descendents(new Operation[]{operation});
    }

    protected void descendents(Operation[] operations) throws WSIException {
        if (operations == null) {
            throw new WSIException("Internal error: expected an Operation[] value");
        }
        HashSet<Message> set = new HashSet<Message>();
        int i = 0;
        while (i < operations.length) {
            if (operations[i].getInput() != null) {
                set.add(operations[i].getInput().getMessage());
            }
            if (operations[i].getOutput() != null) {
                set.add(operations[i].getOutput().getMessage());
            }
            Iterator it = operations[i].getFaults().values().iterator();
            while (it.hasNext()) {
                set.add(((Fault)it.next()).getMessage());
            }
            ++i;
        }
        this.messages = new Message[0];
        this.messages = set.toArray(this.messages);
    }

    private HashSet getAllImports(Definition rootDef) throws WSIException {
        HashSet<Import> importSet = new HashSet<Import>();
        Map importMap = rootDef.getImports();
        Iterator i = importMap.values().iterator();
        while (i.hasNext()) {
            List nextImportList = (List)i.next();
            Iterator listIt = nextImportList.iterator();
            while (listIt.hasNext()) {
                Import nextImport = (Import)listIt.next();
                if (nextImport == null) continue;
                importSet.add(nextImport);
                if (nextImport.getDefinition() == null) continue;
                HashSet subTreeImports = this.getAllImports(nextImport.getDefinition());
                Iterator subIt = subTreeImports.iterator();
                while (subIt.hasNext()) {
                    importSet.add((Import)subIt.next());
                }
            }
        }
        return importSet;
    }

    private URI[] deriveEndpoints(ServiceReference serviceReference, Port[] ports, Definition[] definitions) {
        URI[] endp = null;
        try {
            String serviceLocation = null;
            serviceLocation = serviceReference.getServiceLocation();
            if (serviceLocation != null) {
                endp = new URI[]{new URI(serviceLocation)};
            } else if (serviceReference.getWSDLElement().isPort()) {
                if (ports.length != 1) {
                    throw new WSIException("Internal error - expected 1-element Port array");
                }
                Iterator i = ports[0].getExtensibilityElements().iterator();
                while (i.hasNext() && serviceLocation == null) {
                    ExtensibilityElement extElem = (ExtensibilityElement)i.next();
                    if (!(extElem instanceof SOAPAddress)) continue;
                    serviceLocation = ((SOAPAddress)extElem).getLocationURI();
                    endp = new URI[]{new URI(serviceLocation)};
                }
            } else {
                HashSet<String> endpointSet = new HashSet<String>();
                Iterator i = definitions[0].getExtensibilityElements().iterator();
                while (i.hasNext()) {
                    ExtensibilityElement extElem = (ExtensibilityElement)i.next();
                    if (!(extElem instanceof SOAPAddress)) continue;
                    endpointSet.add(((SOAPAddress)extElem).getLocationURI());
                }
                endp = new URI[]{};
                endp = endpointSet.toArray(endp);
            }
        }
        catch (Exception exception) {}
        return endp;
    }

    public Binding[] getBindings() {
        return this.bindings;
    }

    public URI[] getEndPoints() {
        return this.endPoints;
    }

    public URI[] getEndPoints(String hostAndPort) {
        Vector<URI> matchedEndpoints = new Vector<URI>();
        int i = 0;
        while (i < this.endPoints.length) {
            String port;
            String string = port = this.endPoints[i].getPort() == -1 ? "80" : String.valueOf(this.endPoints[i].getPort());
            if (hostAndPort.equals(String.valueOf(this.endPoints[i].getHost()) + ":" + port)) {
                matchedEndpoints.add(this.endPoints[i]);
            }
            ++i;
        }
        return matchedEndpoints.toArray(new URI[0]);
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public PortType[] getPortType() {
        return this.portTypes;
    }

    public boolean hasHostAndPort(String hostAndPortString) throws WSIException {
        URI hostAndPort;
        try {
            hostAndPort = new URI(hostAndPortString);
        }
        catch (Exception exception) {
            throw new WSIException("Could not convert string to URI: " + hostAndPortString);
        }
        String host = hostAndPort.getHost();
        int port = hostAndPort.getPort();
        int i = 0;
        while (i < this.endPoints.length) {
            if (this.endPoints[i].getHost().equals(host) && this.endPoints[i].getPort() == port) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Definition[] getDefinitions() {
        return this.definitions;
    }

    public Import[] getImports() {
        return this.imports;
    }

    public Message[] getMessages() {
        return this.messages;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public PortType[] getPortTypes() {
        return this.portTypes;
    }

    public Types[] getTypes() {
        return this.types;
    }

    public WSDLDocument getWsdlDocument() {
        return this.wsdlDocument;
    }

    public Definition getDefinition(Types types) {
        Definition definition = null;
        int i = 0;
        while (i < this.definitions.length && definition == null) {
            Types checkTypes = this.definitions[i].getTypes();
            if (checkTypes != null && checkTypes.equals(types)) {
                definition = this.definitions[i];
            }
            ++i;
        }
        return definition;
    }

    public Definition getDefinition(Binding binding) {
        Definition definition = null;
        int i = 0;
        while (i < this.definitions.length && definition == null) {
            if (this.definitions[i].getBinding(binding.getQName()) != null) {
                definition = this.definitions[i];
            }
            ++i;
        }
        return definition;
    }

    public Definition getDefinition(PortType portType) {
        Definition definition = null;
        int i = 0;
        while (i < this.definitions.length && definition == null) {
            if (this.definitions[i].getPortType(portType.getQName()) != null) {
                definition = this.definitions[i];
            }
            ++i;
        }
        return definition;
    }

    public Definition getDefinition(Message message) {
        Definition definition = null;
        int i = 0;
        while (i < this.definitions.length && definition == null) {
            if (this.definitions[i].getMessage(message.getQName()) != null) {
                definition = this.definitions[i];
            }
            ++i;
        }
        return definition;
    }
}

