/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.codegen.ecore.genmodel.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenBaseImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenClassImpl;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.codegen.ecore.Generator;
import org.eclipse.uml2.codegen.ecore.genmodel.GenClass;
import org.eclipse.uml2.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.uml2.codegen.ecore.genmodel.util.UML2GenModelUtil;

public class GenClassImpl
extends org.eclipse.emf.codegen.ecore.genmodel.impl.GenClassImpl
implements GenClass {
    public static final String copyright = "Copyright (c) IBM Corporation and others.";
    protected List duplicateGenFeatures = null;
    protected List duplicateGenOperations = null;

    protected GenClassImpl() {
    }

    protected EClass eStaticClass() {
        return GenModelPackage.Literals.GEN_CLASS;
    }

    public List getDuplicateGenFeatures() {
        ArrayList result = new ArrayList(this.getGenFeatures());
        if (this.duplicateGenFeatures == null) {
            this.duplicateGenFeatures = new ArrayList();
            Iterator duplicateEcoreFeatures = Generator.getDuplicateEcoreFeatures(this.getEcoreClass()).iterator();
            while (duplicateEcoreFeatures.hasNext()) {
                GenFeature duplicateGenFeature = this.getGenModel().createGenFeature();
                duplicateGenFeature.initialize((EStructuralFeature)duplicateEcoreFeatures.next());
                this.duplicateGenFeatures.add(duplicateGenFeature);
            }
        }
        result.addAll(this.duplicateGenFeatures);
        return result;
    }

    protected List collectDuplicateGenFeatures(List genClasses, List genFeatures, GenBaseImpl.GenFeatureFilter filter) {
        ArrayList result = new ArrayList();
        if (genClasses != null) {
            Iterator i = genClasses.iterator();
            while (i.hasNext()) {
                result.addAll(this.collectGenFeatures(null, UML2GenModelUtil.getDuplicateGenFeatures((org.eclipse.emf.codegen.ecore.genmodel.GenClass)i.next()), filter));
            }
        }
        if (genFeatures != null) {
            result.addAll(this.collectGenFeatures(null, genFeatures, filter));
        }
        return result;
    }

    protected List getAllDuplicateGenFeatures() {
        return this.collectDuplicateGenFeatures(this.getAllBaseGenClasses(), this.getDuplicateGenFeatures(), null);
    }

    public List getDeclaredGenFeatures() {
        LinkedHashMap<String, GenFeature> declaredGenFeatures = new LinkedHashMap<String, GenFeature>();
        List redefinedGenFeatures = this.collectGenFeatures(null, this.getRedefinedGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !GenClassImpl.this.getAllGenFeatures().contains(genFeature);
            }
        });
        Iterator i = redefinedGenFeatures.iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            declaredGenFeatures.put(genFeature.getName(), genFeature);
        }
        List duplicateGenFeatures = this.collectGenFeatures(null, this.getDuplicateGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !UML2GenModelUtil.isDuplicate(genFeature) || !UML2GenModelUtil.isRedefinition(genFeature);
            }
        });
        Iterator i2 = duplicateGenFeatures.iterator();
        while (i2.hasNext()) {
            GenFeature genFeature = (GenFeature)i2.next();
            declaredGenFeatures.put(genFeature.getName(), genFeature);
        }
        return new ArrayList(declaredGenFeatures.values());
    }

    protected List getImplementedGenFeatures(GenBaseImpl.GenFeatureFilter filter) {
        LinkedHashMap<String, GenFeature> implementedGenFeatures = new LinkedHashMap<String, GenFeature>();
        Iterator i = this.getImplementedGenClasses().iterator();
        while (i.hasNext()) {
            GenFeature genFeature;
            org.eclipse.emf.codegen.ecore.genmodel.GenClass genClass = (org.eclipse.emf.codegen.ecore.genmodel.GenClass)i.next();
            Iterator j = UML2GenModelUtil.getUnionGenFeatures(genClass).iterator();
            while (j.hasNext()) {
                genFeature = (GenFeature)j.next();
                implementedGenFeatures.put(genFeature.getName(), genFeature);
            }
            j = UML2GenModelUtil.getSupersetGenFeatures(genClass).iterator();
            while (j.hasNext()) {
                genFeature = (GenFeature)j.next();
                implementedGenFeatures.put(genFeature.getName(), genFeature);
            }
            j = UML2GenModelUtil.getRedefinedGenFeatures(genClass).iterator();
            while (j.hasNext()) {
                genFeature = (GenFeature)j.next();
                implementedGenFeatures.put(genFeature.getName(), genFeature);
            }
            j = UML2GenModelUtil.getDuplicateGenFeatures(genClass).iterator();
            while (j.hasNext()) {
                genFeature = (GenFeature)j.next();
                implementedGenFeatures.put(genFeature.getName(), genFeature);
            }
        }
        return this.collectGenFeatures(null, new ArrayList(implementedGenFeatures.values()), filter);
    }

    public List getDeclaredFieldGenFeatures() {
        return this.getImplementedGenFeatures(new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                if (UML2GenModelUtil.isDuplicate(genFeature)) {
                    Iterator i = UML2GenModelUtil.getRedefinedGenFeatures(genFeature).iterator();
                    while (i.hasNext()) {
                        GenFeature redefinedGenFeature = (GenFeature)i.next();
                        if (!GenClassImpl.this.getExtendedGenFeatures().contains(redefinedGenFeature)) continue;
                        return !UML2GenModelUtil.isUnion(redefinedGenFeature) && !GenClassImpl.this.isRedefined(redefinedGenFeature);
                    }
                }
                return !GenClassImpl.this.getExtendedGenFeatures().contains(genFeature) && !UML2GenModelUtil.isUnion(genFeature) && !GenClassImpl.this.isRedefined(genFeature);
            }
        });
    }

    public List getImplementedGenFeatures() {
        return this.getImplementedGenFeatures(new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !GenClassImpl.this.isRedefined(genFeature);
            }
        });
    }

    public List getExtendedGenFeatures() {
        return this.collectDuplicateGenFeatures(this.getExtendedGenClasses(), null, null);
    }

    public List getDuplicateGenOperations() {
        ArrayList result = new ArrayList(this.getGenOperations());
        if (this.duplicateGenOperations == null) {
            this.duplicateGenOperations = new ArrayList();
            Iterator duplicateEcoreOperations = Generator.getDuplicateEcoreOperations(this.getEcoreClass()).iterator();
            while (duplicateEcoreOperations.hasNext()) {
                GenOperation duplicateGenOperation = this.getGenModel().createGenOperation();
                duplicateGenOperation.initialize((EOperation)duplicateEcoreOperations.next());
                this.duplicateGenOperations.add(duplicateGenOperation);
            }
        }
        result.addAll(this.duplicateGenOperations);
        return result;
    }

    protected List collectDuplicateGenOperations(List genClasses, List genOperations, GenBaseImpl.GenOperationFilter filter) {
        ArrayList result = new ArrayList();
        if (genClasses != null) {
            Iterator i = genClasses.iterator();
            while (i.hasNext()) {
                result.addAll(this.collectGenOperations(null, UML2GenModelUtil.getDuplicateGenOperations((org.eclipse.emf.codegen.ecore.genmodel.GenClass)i.next()), filter));
            }
        }
        if (this.genFeatures != null) {
            result.addAll(this.collectGenOperations(null, genOperations, filter));
        }
        return result;
    }

    protected List getAllDuplicateGenOperations() {
        return this.collectDuplicateGenOperations(this.getAllBaseGenClasses(), this.getDuplicateGenOperations(), null);
    }

    public List getDeclaredGenOperations() {
        LinkedHashMap<String, GenOperation> declaredGenOperations = new LinkedHashMap<String, GenOperation>();
        List redefinedGenOperations = this.collectGenOperations(null, this.getRedefinedGenOperations(), new GenBaseImpl.GenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return !GenClassImpl.this.getAllDuplicateGenOperations().contains(genOperation);
            }
        });
        Iterator i = redefinedGenOperations.iterator();
        while (i.hasNext()) {
            GenOperation genOperation = (GenOperation)i.next();
            declaredGenOperations.put(String.valueOf(genOperation.getName()) + genOperation.getParameterTypes(""), genOperation);
        }
        List duplicateGenOperations = this.collectGenOperations(null, this.getDuplicateGenOperations(), new GenBaseImpl.GenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return !UML2GenModelUtil.isDuplicate(genOperation) || !UML2GenModelUtil.isRedefinition(genOperation);
            }
        });
        Iterator i2 = duplicateGenOperations.iterator();
        while (i2.hasNext()) {
            GenOperation genOperation = (GenOperation)i2.next();
            declaredGenOperations.put(String.valueOf(genOperation.getName()) + genOperation.getParameterTypes(""), genOperation);
        }
        return this.collectGenOperations(null, new ArrayList(declaredGenOperations.values()), (GenBaseImpl.GenOperationFilter)new CollidingGenOperationFilter());
    }

    protected List getImplementedGenOperations(GenBaseImpl.GenOperationFilter filter) {
        LinkedHashMap<String, GenOperation> implementedGenOperations = new LinkedHashMap<String, GenOperation>();
        Iterator i = this.getImplementedGenClasses().iterator();
        while (i.hasNext()) {
            GenOperation genOperation;
            org.eclipse.emf.codegen.ecore.genmodel.GenClass genClass = (org.eclipse.emf.codegen.ecore.genmodel.GenClass)i.next();
            Iterator j = UML2GenModelUtil.getRedefinedGenOperations(genClass).iterator();
            while (j.hasNext()) {
                genOperation = (GenOperation)j.next();
                implementedGenOperations.put(String.valueOf(genOperation.getName()) + genOperation.getParameterTypes(""), genOperation);
            }
            j = UML2GenModelUtil.getDuplicateGenOperations(genClass).iterator();
            while (j.hasNext()) {
                genOperation = (GenOperation)j.next();
                implementedGenOperations.put(String.valueOf(genOperation.getName()) + genOperation.getParameterTypes(""), genOperation);
            }
        }
        return this.collectGenOperations(null, new ArrayList(implementedGenOperations.values()), filter);
    }

    public List getImplementedGenOperations() {
        return this.getImplementedGenOperations((GenBaseImpl.GenOperationFilter)new CollidingGenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return super.accept(genOperation) && !GenClassImpl.this.isRedefined(genOperation);
            }
        });
    }

    public GenOperation getImplementedCollidingGetGenOperation(final GenFeature genFeature) {
        List implementedCollidingGenOperations = this.getImplementedGenOperations((GenBaseImpl.GenOperationFilter)new CollidingGenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return !super.accept(genOperation) && genOperation.getName().equals(genFeature.getGetAccessor());
            }
        });
        return implementedCollidingGenOperations.isEmpty() ? null : (GenOperation)implementedCollidingGenOperations.get(0);
    }

    public GenOperation getImplementedCollidingSetGenOperation(final GenFeature genFeature) {
        List implementedCollidingGenOperations = this.getImplementedGenOperations((GenBaseImpl.GenOperationFilter)new CollidingGenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return !super.accept(genOperation) && genOperation.getName().equals("set" + genFeature.getAccessorName());
            }
        });
        return implementedCollidingGenOperations.isEmpty() ? null : (GenOperation)implementedCollidingGenOperations.get(0);
    }

    public GenOperation getImplementedCollidingIsSetGenOperation(final GenFeature genFeature) {
        List implementedCollidingGenOperations = this.getImplementedGenOperations((GenBaseImpl.GenOperationFilter)new CollidingGenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return !super.accept(genOperation) && genOperation.getName().equals("isSet" + genFeature.getAccessorName());
            }
        });
        return implementedCollidingGenOperations.isEmpty() ? null : (GenOperation)implementedCollidingGenOperations.get(0);
    }

    public GenOperation getImplementedCollidingUnsetGenOperation(final GenFeature genFeature) {
        List implementedCollidingGenOperations = this.getImplementedGenOperations((GenBaseImpl.GenOperationFilter)new CollidingGenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return !super.accept(genOperation) && genOperation.getName().equals("unset" + genFeature.getAccessorName());
            }
        });
        return implementedCollidingGenOperations.isEmpty() ? null : (GenOperation)implementedCollidingGenOperations.get(0);
    }

    public List getExtendedGenOperations() {
        return this.collectDuplicateGenOperations(this.getExtendedGenClasses(), null, null);
    }

    public List getInvariantOperations() {
        return this.collectGenOperations(null, this.getDuplicateGenOperations(), new GenBaseImpl.GenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return genOperation.isInvariant();
            }
        });
    }

    public String getImportedOperationsClassName() {
        return this.getGenModel().getImportedName(this.getQualifiedOperationsClassName());
    }

    public String getOperationsClassName() {
        return String.valueOf(this.getName()) + "Operations";
    }

    public String getQualifiedOperationsClassName() {
        return String.valueOf(UML2GenModelUtil.getOperationsPackageName(this.getGenPackage())) + "." + this.getOperationsClassName();
    }

    public String getOperationID(GenOperation genOperation) {
        String prefix;
        if (genOperation.isInvariant() && !GenClassImpl.isBlank((String)(prefix = UML2GenModelUtil.getInvariantPrefix(this.getGenModel())))) {
            return String.valueOf(this.getClassifierID()) + "__" + this.format(genOperation.getName(), '_', prefix, false, false).toUpperCase();
        }
        return super.getOperationID(genOperation);
    }

    public String getOperationsClassExtends() {
        org.eclipse.emf.codegen.ecore.genmodel.GenClass classExtendsGenClass = this.getClassExtendsGenClass();
        while (classExtendsGenClass != null) {
            if (UML2GenModelUtil.isOperationsClasses(classExtendsGenClass.getGenPackage()) && !UML2GenModelUtil.getDuplicateGenOperations(classExtendsGenClass).isEmpty()) {
                return " extends " + UML2GenModelUtil.getImportedOperationsClassName(classExtendsGenClass);
            }
            classExtendsGenClass = classExtendsGenClass.getClassExtendsGenClass();
        }
        return "";
    }

    public List getEInverseAddGenFeatures() {
        return this.collectGenFeatures(null, super.getEInverseAddGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !genFeature.isDerived();
            }
        });
    }

    public List getEInverseRemoveGenFeatures() {
        return this.collectGenFeatures(null, super.getEInverseRemoveGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !genFeature.isDerived();
            }
        });
    }

    protected String getSubsetListConstructor(GenFeature genFeature) {
        return this.getSubsetSupersetListConstructor(genFeature);
    }

    protected String getSupersetListConstructor(GenFeature genFeature) {
        return this.getSubsetSupersetListConstructor(genFeature);
    }

    protected String getSubsetSupersetListConstructor(GenFeature genFeature) {
        String unsettable;
        StringBuffer sb = new StringBuffer();
        String string = unsettable = genFeature.isUnsettable() ? ".Unsettable" : "";
        if (genFeature.isMapType()) {
            return super.getListConstructor(genFeature);
        }
        if (genFeature.isFeatureMapType()) {
            return super.getListConstructor(genFeature);
        }
        if (this.getGenModel().isSuppressNotification()) {
            sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.BasicInternalEList"));
            sb.append("(");
            sb.append(genFeature.getListItemType());
            sb.append(".class)");
        } else if (genFeature.isEffectiveContains()) {
            if (genFeature.isBidirectional()) {
                GenFeature reverseFeature = genFeature.getReverse();
                sb.append(this.getGenModel().getImportedName("org.eclipse.uml2.common.util.SubsetSupersetEObjectContainmentWithInverseEList"));
                sb.append(unsettable);
                if (genFeature.isResolveProxies()) {
                    sb.append(".Resolving");
                }
                sb.append("(");
                sb.append(genFeature.getListItemType());
                sb.append(".class, this, ");
                sb.append(this.getQualifiedFeatureID(genFeature));
                sb.append(", ");
                if (UML2GenModelUtil.getSupersetGenFeatures(this, genFeature, false).isEmpty()) {
                    sb.append("null");
                } else {
                    sb.append(genFeature.getUpperName());
                    sb.append("_ESUPERSETS");
                }
                sb.append(", ");
                if (UML2GenModelUtil.getSubsetGenFeatures(this, genFeature, false).isEmpty()) {
                    sb.append("null");
                } else {
                    sb.append(genFeature.getUpperName());
                    sb.append("_ESUBSETS");
                }
                sb.append(", ");
                sb.append(reverseFeature.getGenClass().getQualifiedFeatureID(reverseFeature));
                sb.append(")");
            } else {
                sb.append(this.getGenModel().getImportedName("org.eclipse.uml2.common.util.SubsetSupersetEObjectContainmentEList"));
                sb.append(unsettable);
                if (genFeature.isResolveProxies()) {
                    sb.append(".Resolving");
                }
                sb.append("(");
                sb.append(genFeature.getListItemType());
                sb.append(".class, this, ");
                sb.append(this.getQualifiedFeatureID(genFeature));
                sb.append(", ");
                if (UML2GenModelUtil.getSupersetGenFeatures(this, genFeature, false).isEmpty()) {
                    sb.append("null");
                } else {
                    sb.append(genFeature.getUpperName());
                    sb.append("_ESUPERSETS");
                }
                sb.append(", ");
                if (UML2GenModelUtil.getSubsetGenFeatures(this, genFeature, false).isEmpty()) {
                    sb.append("null");
                } else {
                    sb.append(genFeature.getUpperName());
                    sb.append("_ESUBSETS");
                }
                sb.append(")");
            }
        } else if (genFeature.isReferenceType()) {
            if (genFeature.isBidirectional()) {
                GenFeature reverseFeature = genFeature.getReverse();
                if (genFeature.isResolveProxies()) {
                    sb.append(this.getGenModel().getImportedName("org.eclipse.uml2.common.util.SubsetSupersetEObjectWithInverseResolvingEList"));
                } else {
                    sb.append(this.getGenModel().getImportedName("org.eclipse.uml2.common.util.SubsetSupersetEObjectWithInverseEList"));
                }
                sb.append(unsettable);
                if (reverseFeature.isListType()) {
                    sb.append(".ManyInverse");
                }
                sb.append("(");
                sb.append(genFeature.getListItemType());
                sb.append(".class, this, ");
                sb.append(this.getQualifiedFeatureID(genFeature));
                sb.append(", ");
                if (UML2GenModelUtil.getSupersetGenFeatures(this, genFeature, false).isEmpty()) {
                    sb.append("null");
                } else {
                    sb.append(genFeature.getUpperName());
                    sb.append("_ESUPERSETS");
                }
                sb.append(", ");
                if (UML2GenModelUtil.getSubsetGenFeatures(this, genFeature, false).isEmpty()) {
                    sb.append("null");
                } else {
                    sb.append(genFeature.getUpperName());
                    sb.append("_ESUBSETS");
                }
                sb.append(", ");
                sb.append(reverseFeature.getGenClass().getQualifiedFeatureID(reverseFeature));
                sb.append(")");
            } else {
                if (genFeature.isResolveProxies()) {
                    sb.append(this.getGenModel().getImportedName("org.eclipse.uml2.common.util.SubsetSupersetEObjectResolvingEList"));
                } else {
                    sb.append(this.getGenModel().getImportedName("org.eclipse.uml2.common.util.SubsetSupersetEObjectEList"));
                }
                sb.append(unsettable);
                sb.append("(");
                sb.append(genFeature.getListItemType());
                sb.append(".class, this, ");
                sb.append(this.getQualifiedFeatureID(genFeature));
                sb.append(", ");
                if (UML2GenModelUtil.getSupersetGenFeatures(this, genFeature, false).isEmpty()) {
                    sb.append("null");
                } else {
                    sb.append(genFeature.getUpperName());
                    sb.append("_ESUPERSETS");
                }
                sb.append(", ");
                if (UML2GenModelUtil.getSubsetGenFeatures(this, genFeature, false).isEmpty()) {
                    sb.append("null");
                } else {
                    sb.append(genFeature.getUpperName());
                    sb.append("_ESUBSETS");
                }
                sb.append(")");
            }
        } else {
            return super.getListConstructor(genFeature);
        }
        return sb.toString();
    }

    protected String getDerivedUnionListConstructor(GenFeature genFeature) {
        StringBuffer sb = new StringBuffer();
        if (genFeature.isMapType()) {
            return super.getListConstructor(genFeature);
        }
        if (genFeature.isFeatureMapType()) {
            return super.getListConstructor(genFeature);
        }
        if (genFeature.isReferenceType()) {
            sb.append(this.getGenModel().getImportedName("org.eclipse.uml2.common.util.DerivedUnionEObjectEList"));
            sb.append("(");
            sb.append(genFeature.getListItemType());
            sb.append(".class, this, ");
            sb.append(this.getQualifiedFeatureID(genFeature));
            sb.append(", ");
            if (UML2GenModelUtil.getSubsetGenFeatures(this, genFeature, true).isEmpty()) {
                sb.append("null");
            } else {
                sb.append(genFeature.getUpperName());
                sb.append("_ESUBSETS");
            }
        } else {
            return super.getListConstructor(genFeature);
        }
        sb.append(")");
        return sb.toString();
    }

    public String getListConstructor(GenFeature genFeature) {
        if (UML2GenModelUtil.isUnion(genFeature)) {
            return this.getDerivedUnionListConstructor(genFeature);
        }
        if (this.isSuperset(genFeature) && !this.getSubsetGenFeatures(genFeature, false).isEmpty()) {
            return this.getSupersetListConstructor(genFeature);
        }
        if (UML2GenModelUtil.isSubset(genFeature) && !this.getSupersetGenFeatures(genFeature, false).isEmpty()) {
            return this.getSubsetListConstructor(genFeature);
        }
        return super.getListConstructor(genFeature);
    }

    public GenFeature findGenFeature(EStructuralFeature ecoreFeature) {
        org.eclipse.emf.codegen.ecore.genmodel.GenClass genClass = this.findGenClass(Generator.getEcoreContainingClass(ecoreFeature));
        Iterator i = UML2GenModelUtil.getDuplicateGenFeatures(genClass).iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            if (!ecoreFeature.getName().equals(genFeature.getEcoreFeature().getName())) continue;
            return genFeature;
        }
        return null;
    }

    public GenOperation findGenOperation(EOperation ecoreOperation) {
        org.eclipse.emf.codegen.ecore.genmodel.GenClass genClass = this.findGenClass(Generator.getEcoreContainingClass(ecoreOperation));
        Iterator i = UML2GenModelUtil.getDuplicateGenOperations(genClass).iterator();
        block0: while (i.hasNext()) {
            GenOperation genOperation = (GenOperation)i.next();
            if (!ecoreOperation.getName().equals(genOperation.getEcoreOperation().getName()) || ecoreOperation.getEParameters().size() != genOperation.getEcoreOperation().getEParameters().size()) continue;
            int j = 0;
            while (j < ecoreOperation.getEParameters().size()) {
                EParameter ecoreParameter = (EParameter)ecoreOperation.getEParameters().get(j);
                if (!ecoreParameter.getEType().getName().equals(((EParameter)genOperation.getEcoreOperation().getEParameters().get(j)).getEType().getName())) continue block0;
                ++j;
            }
            return genOperation;
        }
        return null;
    }

    public boolean isDerivedUnionListType(GenFeature genFeature) {
        if (UML2GenModelUtil.isUnion(genFeature) && genFeature.isListType()) {
            if (UML2GenModelUtil.isDuplicate(genFeature) && !UML2GenModelUtil.isRedefinition(genFeature)) {
                return false;
            }
            Iterator subsetGenFeatures = this.getSubsetGenFeatures(genFeature).iterator();
            while (subsetGenFeatures.hasNext()) {
                GenFeature subsetGenFeature = (GenFeature)subsetGenFeatures.next();
                if (!UML2GenModelUtil.isDuplicate(subsetGenFeature) || UML2GenModelUtil.isRedefinition(subsetGenFeature)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List getUnionGenFeatures() {
        UniqueEList.FastCompare unionGenFeatures = new UniqueEList.FastCompare();
        Iterator i = this.getDuplicateGenFeatures().iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            if (UML2GenModelUtil.isUnion(genFeature)) {
                unionGenFeatures.add(genFeature);
            }
            Iterator j = UML2GenModelUtil.getSubsettedGenFeatures(genFeature).iterator();
            while (j.hasNext()) {
                GenFeature subsettedGenFeature = (GenFeature)j.next();
                if (!UML2GenModelUtil.isUnion(subsettedGenFeature)) continue;
                unionGenFeatures.add(subsettedGenFeature);
            }
        }
        return unionGenFeatures;
    }

    public List getImplementedUnionGenFeatures() {
        return this.getImplementedGenFeatures(new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return UML2GenModelUtil.isUnion(genFeature) && !GenClassImpl.this.isRedefined(genFeature);
            }
        });
    }

    public boolean isSuperset(GenFeature genFeature) {
        final EStructuralFeature ecoreFeature = genFeature.getEcoreFeature();
        return !genFeature.isDerived() && !this.collectGenFeatures(null, this.getAllDuplicateGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return Generator.getSubsettedEcoreFeatures(genFeature.getEcoreFeature()).contains(ecoreFeature);
            }
        }).isEmpty();
    }

    public List getSupersetGenFeatures() {
        UniqueEList.FastCompare supersetGenFeatures = new UniqueEList.FastCompare();
        Iterator i = this.getDuplicateGenFeatures().iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            if (this.isSuperset(genFeature)) {
                supersetGenFeatures.add(genFeature);
            }
            Iterator j = UML2GenModelUtil.getSubsettedGenFeatures(genFeature).iterator();
            while (j.hasNext()) {
                GenFeature subsettedGenFeature = (GenFeature)j.next();
                if (!this.isSuperset(subsettedGenFeature)) continue;
                supersetGenFeatures.add(subsettedGenFeature);
            }
        }
        return supersetGenFeatures;
    }

    public List getSubsetGenFeatures(GenFeature supersetGenFeature) {
        return this.getSubsetGenFeatures(supersetGenFeature, true);
    }

    public List getSubsetGenFeatures(GenFeature supersetGenFeature, boolean includeDerived) {
        return this.getSubsetGenFeatures(supersetGenFeature, includeDerived, true);
    }

    public List getSubsetGenFeatures(GenFeature supersetGenFeature, boolean includeDerived, boolean includeListType) {
        LinkedHashMap<String, GenFeature> subsetGenFeatures = new LinkedHashMap<String, GenFeature>();
        EStructuralFeature supersetEcoreFeature = supersetGenFeature.getEcoreFeature();
        Iterator i = this.getAllDuplicateGenFeatures().iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            if (!Generator.getSubsettedEcoreFeatures(genFeature.getEcoreFeature()).contains(supersetEcoreFeature) || !includeDerived && genFeature.isDerived() || !includeListType && genFeature.isListType()) continue;
            subsetGenFeatures.put(genFeature.getName(), genFeature);
        }
        return new ArrayList(subsetGenFeatures.values());
    }

    public List getIsSetSubsetGenFeatures(GenFeature unionGenFeature) {
        return this.collectGenFeatures(null, this.getSubsetGenFeatures(unionGenFeature), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !GenClassImpl.this.getExtendedGenFeatures().contains(genFeature);
            }
        });
    }

    public List getSubsetGenFeatures() {
        return this.collectGenFeatures(null, this.getDuplicateGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return UML2GenModelUtil.isSubset(genFeature);
            }
        });
    }

    public List getImplementedSubsetGenFeatures() {
        return this.getImplementedGenFeatures(new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return UML2GenModelUtil.isSubset(genFeature) && !GenClassImpl.this.collectGenFeatures(null, GenClassImpl.this.getSupersetGenFeatures(genFeature), new GenBaseImpl.GenFeatureFilter(this){
                    final /* synthetic */ 19 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean accept(GenFeature genFeature) {
                        return !genFeature.isDerived();
                    }
                }).isEmpty();
            }
        });
    }

    public List getImplementedSubsetGenFeatures(final boolean listType) {
        return this.collectGenFeatures(null, this.getImplementedSubsetGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return listType == genFeature.isListType();
            }
        });
    }

    public String getSubsetFeatureAccessorArray(GenFeature supersetGenFeature) {
        return this.getSubsetFeatureAccessorArray(supersetGenFeature, false);
    }

    public String getSubsetFeatureAccessorArray(GenFeature supersetGenFeature, boolean includeDerived) {
        StringBuffer sb = new StringBuffer();
        Iterator subsetGenFeatures = this.getSubsetGenFeatures(supersetGenFeature, includeDerived).iterator();
        if (subsetGenFeatures.hasNext()) {
            sb.append("new ");
            sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.EStructuralFeature"));
            sb.append("[] {");
            while (subsetGenFeatures.hasNext()) {
                GenFeature subsetGenFeature = (GenFeature)subsetGenFeatures.next();
                sb.append(subsetGenFeature.getQualifiedFeatureAccessor());
                if (!subsetGenFeatures.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public String getSubsetFeatureIDArray(GenFeature supersetGenFeature) {
        return this.getSubsetFeatureIDArray(supersetGenFeature, false);
    }

    public String getSubsetFeatureIDArray(GenFeature supersetGenFeature, boolean includeDerived) {
        StringBuffer sb = new StringBuffer();
        Iterator subsetGenFeatures = this.getSubsetGenFeatures(supersetGenFeature, includeDerived).iterator();
        if (subsetGenFeatures.hasNext()) {
            sb.append("new int[] {");
            while (subsetGenFeatures.hasNext()) {
                GenFeature subsetGenFeature = (GenFeature)subsetGenFeatures.next();
                sb.append(this.getQualifiedFeatureID(subsetGenFeature));
                if (!subsetGenFeatures.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public List getSupersetGenFeatures(GenFeature subsetGenFeature) {
        return this.getSupersetGenFeatures(subsetGenFeature, true);
    }

    public List getSupersetGenFeatures(GenFeature subsetGenFeature, boolean includeDerived) {
        return this.getSupersetGenFeatures(subsetGenFeature, includeDerived, true);
    }

    public List getSupersetGenFeatures(GenFeature subsetGenFeature, final boolean includeDerived, final boolean includeListType) {
        return this.collectGenFeatures(null, UML2GenModelUtil.getSubsettedGenFeatures(subsetGenFeature), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !(!includeDerived && genFeature.isDerived() || !includeListType && genFeature.isListType());
            }
        });
    }

    public List getImplementedSupersetGenFeatures() {
        return this.getImplementedGenFeatures(new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return GenClassImpl.this.isSuperset(genFeature) && !GenClassImpl.this.getSubsetGenFeatures(genFeature, false).isEmpty();
            }
        });
    }

    public List getImplementedSupersetGenFeatures(final boolean listType) {
        return this.collectGenFeatures(null, this.getImplementedSupersetGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return listType == genFeature.isListType();
            }
        });
    }

    public String getSupersetFeatureAccessorArray(GenFeature subsetGenFeature) {
        StringBuffer sb = new StringBuffer();
        Iterator supersetGenFeatures = this.getSupersetGenFeatures(subsetGenFeature, false).iterator();
        if (supersetGenFeatures.hasNext()) {
            sb.append("new ");
            sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.EStructuralFeature"));
            sb.append("[] {");
            while (supersetGenFeatures.hasNext()) {
                GenFeature supersetGenFeature = (GenFeature)supersetGenFeatures.next();
                sb.append(supersetGenFeature.getQualifiedFeatureAccessor());
                if (!supersetGenFeatures.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public String getSupersetFeatureIDArray(GenFeature subsetGenFeature) {
        StringBuffer sb = new StringBuffer();
        Iterator supersetGenFeatures = this.getSupersetGenFeatures(subsetGenFeature, false).iterator();
        if (supersetGenFeatures.hasNext()) {
            sb.append("new int[] {");
            while (supersetGenFeatures.hasNext()) {
                GenFeature supersetGenFeature = (GenFeature)supersetGenFeatures.next();
                sb.append(this.getQualifiedFeatureID(supersetGenFeature));
                if (!supersetGenFeatures.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public boolean isRedefined(GenFeature genFeature) {
        final EStructuralFeature ecoreFeature = genFeature.getEcoreFeature();
        return !this.collectGenFeatures(null, this.getAllDuplicateGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return Generator.getRedefinedEcoreFeatures(genFeature.getEcoreFeature()).contains(ecoreFeature);
            }
        }).isEmpty();
    }

    public List getRedefinedGenFeatures() {
        UniqueEList.FastCompare redefinedGenFeatures = new UniqueEList.FastCompare();
        Iterator i = this.getDuplicateGenFeatures().iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            if (this.isRedefined(genFeature)) {
                redefinedGenFeatures.add(genFeature);
            }
            Iterator j = UML2GenModelUtil.getRedefinedGenFeatures(genFeature).iterator();
            while (j.hasNext()) {
                GenFeature redefinedGenFeature = (GenFeature)j.next();
                if (genFeature.getName().equals(redefinedGenFeature.getName())) continue;
                redefinedGenFeatures.add(redefinedGenFeature);
            }
        }
        return redefinedGenFeatures;
    }

    public List getImplementedRedefinedGenFeatures() {
        return this.getImplementedGenFeatures(new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return GenClassImpl.this.isRedefined(genFeature);
            }
        });
    }

    public List getRedefinitionGenFeatures(GenFeature redefinedGenFeature) {
        LinkedHashMap<String, GenFeature> redefinitionGenFeatures = new LinkedHashMap<String, GenFeature>();
        EStructuralFeature redefinedEcoreFeature = redefinedGenFeature.getEcoreFeature();
        Iterator i = this.getAllDuplicateGenFeatures().iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            if (!Generator.getRedefinedEcoreFeatures(genFeature.getEcoreFeature()).contains(redefinedEcoreFeature) || genFeature.getName().equals(redefinedGenFeature.getName())) continue;
            redefinitionGenFeatures.put(genFeature.getName(), genFeature);
        }
        return new ArrayList(redefinitionGenFeatures.values());
    }

    public boolean isRedefined(GenOperation genOperation) {
        final EOperation ecoreOperation = genOperation.getEcoreOperation();
        return !this.collectGenOperations(null, this.getAllDuplicateGenOperations(), new GenBaseImpl.GenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return Generator.getRedefinedEcoreOperations(genOperation.getEcoreOperation()).contains(ecoreOperation);
            }
        }).isEmpty();
    }

    public List getRedefinedGenOperations() {
        UniqueEList.FastCompare redefinedGenOperations = new UniqueEList.FastCompare();
        Iterator i = this.getDuplicateGenOperations().iterator();
        while (i.hasNext()) {
            GenOperation genOperation = (GenOperation)i.next();
            if (this.isRedefined(genOperation)) {
                redefinedGenOperations.add(genOperation);
            }
            Iterator j = UML2GenModelUtil.getRedefinedGenOperations(genOperation).iterator();
            while (j.hasNext()) {
                GenOperation redefinedGenOperation = (GenOperation)j.next();
                if ((String.valueOf(genOperation.getName()) + genOperation.getParameterTypes("")).equals(String.valueOf(redefinedGenOperation.getName()) + redefinedGenOperation.getParameterTypes(""))) continue;
                redefinedGenOperations.add(redefinedGenOperation);
            }
        }
        return redefinedGenOperations;
    }

    public List getImplementedRedefinedGenOperations() {
        return this.getImplementedGenOperations((GenBaseImpl.GenOperationFilter)new CollidingGenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return super.accept(genOperation) && GenClassImpl.this.isRedefined(genOperation);
            }
        });
    }

    public List getRedefinitionGenOperations(GenOperation redefinedGenOperation) {
        LinkedHashMap<String, GenOperation> redefinitionGenOperations = new LinkedHashMap<String, GenOperation>();
        EOperation redefinedEcoreOperation = redefinedGenOperation.getEcoreOperation();
        Iterator i = this.getAllDuplicateGenOperations().iterator();
        while (i.hasNext()) {
            GenOperation genOperation = (GenOperation)i.next();
            if (!Generator.getRedefinedEcoreOperations(genOperation.getEcoreOperation()).contains(redefinedEcoreOperation) || (String.valueOf(genOperation.getName()) + genOperation.getParameterTypes("")).equals(String.valueOf(redefinedGenOperation.getName()) + redefinedGenOperation.getParameterTypes(""))) continue;
            redefinitionGenOperations.put(genOperation.getName(), genOperation);
        }
        return new ArrayList(redefinitionGenOperations.values());
    }

    public List getKeyGenFeatures() {
        return this.getKeyGenFeatures(true);
    }

    public List getKeyGenFeatures(final boolean includeContains) {
        return this.collectGenFeatures(null, this.getAllGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return UML2GenModelUtil.isKey(genFeature) && !genFeature.isPrimitiveType() && (includeContains || !genFeature.isContains());
            }
        });
    }

    public boolean isFactoryMethods(GenFeature genFeature) {
        return UML2GenModelUtil.isFactoryMethods(genFeature.getGenModel()) && genFeature.isChangeable() && (genFeature.isEffectiveContains() || UML2GenModelUtil.isEffectiveContainsSubset(genFeature)) && this.getChildrenClasses(genFeature).size() > 0;
    }

    public boolean isESetField(GenFeature genFeature) {
        return super.isESetField(genFeature) && !UML2GenModelUtil.isUnion(genFeature) && !this.isRedefined(genFeature);
    }

    public boolean isField(GenFeature genFeature) {
        return super.isField(genFeature) && !UML2GenModelUtil.isUnion(genFeature) && !this.isRedefined(genFeature);
    }

    public List getToStringGenFeatures() {
        return this.collectGenFeatures(null, this.getImplementedGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isField() && !genFeature.isReferenceType();
            }
        });
    }

    protected class CollidingGenOperationFilter
    extends GenClassImpl.CollidingGenOperationFilter {
        protected CollidingGenOperationFilter() {
            super((org.eclipse.emf.codegen.ecore.genmodel.impl.GenClassImpl)GenClassImpl.this);
            this.allGenFeatures = GenClassImpl.this.getAllDuplicateGenFeatures();
        }
    }
}

