<?php
/**
 * The Notification_Listener:: class provides functionality for displaying
 * messages from the message stack as a status line.
 *
 * $Horde: framework/Notification/Notification/Listener.php,v 1.16.2.5 2005/07/03 05:11:47 selsky Exp $
 *
 * Copyright 2001-2005 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @since   Horde 2.1
 * @package Horde_Notification
 */
class Notification_Listener {

    /**
     * Array of message types that this listener handles.
     *
     * @var array
     */
    var $_handles = array();

    /**
     * Constructor
     */
    function Notification_Listener()
    {
    }

    /**
     * Does this listener handle a certain type of message?
     *
     * @param string $type  The message type in question.
     *
     * @return boolean  Whether this listener handles the type.
     */
    function handles($type)
    {
        return isset($this->_handles[$type]);
    }

    /**
     * Return a unique identifier for this listener.
     *
     * @return string  Unique id.
     */
    function getName()
    {
        return get_class($this);
    }

    /**
     * Outputs the status line, sends emails, pages, etc., if there
     * are any messages on this listener's message stack.
     *
     * @param array &$messageStack  The stack of messages.
     * @param array $options        An array of options.
     */
    function notify(&$messageStacks, $options = array())
    {
    }

    /**
     * Processes one message from the message stack.
     *
     * @param array $message  One message hash from the stack.
     */
    function getMessage($message)
    {
    }

    /**
     * Unserialize an event from the message stack, checking to see if the
     * appropriate class exists and kludging it into a base Notification_Event
     * object if not.
     */
    function getEvent($message)
    {
        $ob = false;
        if (class_exists($message['class'])) {
            $ob = @unserialize($message['event']);
        } else {
            require_once dirname(__FILE__) . '/Event.php';
            $ob = @unserialize($message['event']);
            if (!method_exists($ob, 'getMessage')) {
                if (isset($ob->_message)) {
                    $ob = &new Notification_Event($ob->_message);
                }
            }
        }

        /* If we've failed to create a valid Notification_Event object
         * (or subclass object) so far, return a PEAR_Error. */
        if (!method_exists($ob, 'getMessage')) {
            $ob = PEAR::raiseError('Unable to decode message event: ' . $message['event']);
        }

        /* Specially handle PEAR_Error objects and add userinfo if
         * it's there. */
        if (method_exists($ob, 'getUserInfo')) {
            $userinfo = $ob->getUserInfo();
            if ($userinfo) {
                if (is_array($userinfo)) {
                    $userinfo = @implode(', ', $userinfo);
                }
                $ob->_message = $ob->getMessage() . ' : ' . $userinfo;
            }
        }

        return $ob;
    }

    /**
     * Unserialize an array of event flags from the message stack.  If this
     * event has no flags, or the flags array could not be unserialized, an
     * empty array is returned.
     *
     * @return array  An array of flags.
     */
    function getFlags($message)
    {
        /* If this message doesn't have any flags, return an empty
         * array. */
        if (empty($message['flags'])) {
            return array();
        }

        /* Unserialize the flags array from the message. */
        $flags = @unserialize($message['flags']);

        /* If we couldn't unserialize the flags array, return an empty
         * array. */
        if (!is_array($flags)) {
            return array();
        }

        return $flags;
    }

}
