<?php
/**
* XOOPS installation md5 checksumminig script
*
* This script allows you to check that the XOOPS system files have been correctly uploaded.
* It reads all the XOOPS files and reports missing or invalid ones.
* 
* Instructions:
* - Upload xoops_md5.php and xoops.md5 to your XOOPS documents root
* - Browse to xoops_md5.php
* - Re-upload missing/invalid files
*
* @copyright	The XOOPS project http://www.xoops.org/
* @license      http://www.fsf.org/copyleft/gpl.html GNU public license
* @author       Skalpa Keo <skalpa@xoops.org>
* @since        2.0.14
* @version		$Id: xoops_md5.php 558 2006-06-20 06:35:23Z skalpa $
* @package 		xoops
*/

$action = @$_REQUEST['action'];

header( "Content-type: text/plain" );

$skip = array(
	'./cache', './extras', './Frameworks', './templates_c', './uploads', './themes',
	'./mainfile.php', './upgrade', './xoops_md5.php', './xoops.md5'
);
$sums = array();

function sumFolder( $path ) {
	global $sums, $skip;
	$content = scandir( $path );
	
	foreach ( $content as $file ) {
		if ( in_array( "$path/$file", $skip ) || substr( $file, 0, 1 ) == '.' )	continue;
		if ( $path == './modules' && $file != 'system' )	continue;			
		if ( is_dir( "$path/$file" ) ) {
			sumFolder( "$path/$file" );
		} else {
			$txt = file_get_contents( "$path/$file" );
			$txt = str_replace( array( "\r\n", "\r" ), "\n", $txt );
			$current = "$path/$file:" . md5($txt);
			echo $current . "\n";
			$sums[] = $current;
		}
	}
}

function checkSums() {
	global $sums;

	foreach ( $sums as $line ) {
		list( $file, $sum ) = explode( ":", $line, 2 );
		if ( !file_exists( $file ) ) {
			echo "$file missing !\n";
		} else {
			$txt = file_get_contents( "$file" );
			$txt = str_replace( array( "\r\n", "\r" ), "\n", $txt );
			if ( md5($txt) != $sum ) {
				echo "$file content invalid\n";
			}
		}
	}
}

if ( $action == 'create' ) {
	sumFolder( "." );
	$fp = fopen( "xoops.md5", "wb" );
	fwrite( $fp, implode( "\n", $sums ) );
	fclose( $fp );
} else {
	$sums = explode( "\n", file_get_contents( "xoops.md5" ) );
	checkSums();
	echo "End of files check.\n";
}



?>