/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.util.CustomObjectInputStream;

public final class FileStore
extends StoreBase
implements Store {
    private static final String FILE_EXT = ".session";
    private String directory = ".";
    private File directoryFile = null;
    private static final String info = "FileStore/1.0";
    private static final String storeName = "fileStore";
    private static final String threadName = "FileStore";

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String path) {
        String oldDirectory = this.directory;
        this.directory = path;
        this.directoryFile = null;
        this.support.firePropertyChange("directory", oldDirectory, this.directory);
    }

    public String getInfo() {
        return info;
    }

    public String getThreadName() {
        return threadName;
    }

    public String getStoreName() {
        return storeName;
    }

    public int getSize() throws IOException {
        File file = this.directory();
        if (file == null) {
            return 0;
        }
        String[] files = file.list();
        int keycount = 0;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(FILE_EXT)) continue;
            ++keycount;
        }
        return keycount;
    }

    public void clear() throws IOException {
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
    }

    public String[] keys() throws IOException {
        File file = this.directory();
        if (file == null) {
            return new String[0];
        }
        String[] files = file.list();
        ArrayList<String> list = new ArrayList<String>();
        int n = FILE_EXT.length();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(FILE_EXT)) continue;
            list.add(files[i].substring(0, files[i].length() - n));
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session load(String id) throws ClassNotFoundException, IOException {
        StandardSession standardSession;
        block17: {
            File file = this.file(id);
            if (file == null) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            if (this.debug >= 1) {
                this.log(this.sm.getString(this.getStoreName() + ".loading", (Object)id, (Object)file.getAbsolutePath()));
            }
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            try {
                fis = new FileInputStream(file.getAbsolutePath());
                BufferedInputStream bis = new BufferedInputStream(fis);
                Container container = this.manager.getContainer();
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                ois = classLoader != null ? new CustomObjectInputStream((InputStream)bis, classLoader) : new ObjectInputStream(bis);
            }
            catch (FileNotFoundException e) {
                if (this.debug >= 1) {
                    this.log("No persisted data file found");
                }
                return null;
            }
            catch (IOException e) {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException f) {
                        // empty catch block
                    }
                    ois = null;
                }
                throw e;
            }
            try {
                StandardSession session = (StandardSession)this.manager.createEmptySession();
                session.readObjectData(ois);
                session.setManager(this.manager);
                standardSession = session;
                Object var10_12 = null;
                if (ois == null) break block17;
            }
            catch (Throwable throwable) {
                block18: {
                    Object var10_13 = null;
                    if (ois == null) break block18;
                    try {
                        ois.close();
                    }
                    catch (IOException f) {}
                }
                throw throwable;
            }
            try {
                ois.close();
            }
            catch (IOException f) {
                // empty catch block
            }
        }
        return standardSession;
    }

    public void remove(String id) throws IOException {
        File file = this.file(id);
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(this.sm.getString(this.getStoreName() + ".removing", (Object)id, (Object)file.getAbsolutePath()));
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Session session) throws IOException {
        File file = this.file(session.getId());
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(this.sm.getString(this.getStoreName() + ".saving", (Object)session.getId(), (Object)file.getAbsolutePath()));
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
        }
        catch (IOException e) {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            ((StandardSession)session).writeObjectData(oos);
        }
        finally {
            oos.close();
        }
    }

    private File directory() {
        if (this.directory == null) {
            return null;
        }
        if (this.directoryFile != null) {
            return this.directoryFile;
        }
        File file = new File(this.directory);
        if (!file.isAbsolute()) {
            Container container = this.manager.getContainer();
            if (container instanceof Context) {
                ServletContext servletContext = ((Context)container).getServletContext();
                File work = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                file = new File(work, this.directory);
            } else {
                throw new IllegalArgumentException("Parent Container is not a Context");
            }
        }
        if (!file.exists() || !file.isDirectory()) {
            file.delete();
            file.mkdirs();
        }
        this.directoryFile = file;
        return file;
    }

    private File file(String id) {
        if (this.directory == null) {
            return null;
        }
        String filename = id + FILE_EXT;
        File file = new File(this.directory(), filename);
        return file;
    }
}

