<?php
/**
 * Functions required to start a Ingo session.
 *
 * $Horde: ingo/lib/Session.php,v 1.2.10.1 2005/01/03 12:25:38 jan Exp $
 *
 * Copyright 2004-2005 Michael Slusarz <slusarz@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Michael Slusarz <slusarz@horde.org>
 * @version $Revision: 1.2.10.1 $
 * @since   Ingo 1.0
 * @package Ingo
 */
class Ingo_Session {

    /**
     * Create an ingo session.
     * This function should only be called once, when the user first uses
     * Ingo in a session.
     *
     * Creates the $ingo session variable with the following entries:
     * 'backend' (array) - The backend configuration to use.
     * 'change' (integer) - The timestamp of the last time the rules were
     *                      altered.
     * 'storage' (array) - Used by Ingo_Storage:: for caching data.
     * 'script_categories' (array) - The list of available categories for the
     *                               Ingo_Script driver in use.
     * 'script_generate' (boolean) - Is the Ingo_Script::generate() call
     *                               available?
     *
     * @access public
     *
     * @return boolean  True on success, false on failure.
     */
    function createSession()
    {
        $_SESSION['ingo'] = array();
        $_SESSION['ingo']['change'] = 0;
        $_SESSION['ingo']['storage'] = array();

        /* Get the backend. */
        $_SESSION['ingo']['backend'] = Ingo::getBackend();

        /* Determine if the Ingo_Script:: generate() method is available. */
        $ingo_script = &Ingo::loadIngoScript();
        $_SESSION['ingo']['script_generate'] = $ingo_script->generateAvailable();

        /* Get the list of categories this driver supports. */
        $_SESSION['ingo']['script_categories'] = array_merge($ingo_script->availableActions(), $ingo_script->availableCategories());
    }

}
