<?php

require_once 'Horde/Prefs/ldap.php';

/**
 * Kolab implementation of the Horde preference system. Derives from the
 * Prefs_ldap LDAP authentication object, and simply provides parameters to it
 * based on the global Kolab configuration.
 *
 * $Horde: framework/Prefs/Prefs/kolab.php,v 1.1.10.5 2005/07/03 05:05:54 selsky Exp $
 *
 * Copyright 2004-2005 Stuart Binge <s.binge@codefusion.co.za>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Stuart Binge <s.binge@codefusion.co.za>
 * @since   Horde 1.3
 * @package Horde_Prefs
 */
class Prefs_kolab extends Prefs_ldap {

    /**
     * Constructs a new Kolab preferences object.
     *
     * @param string $user      The user who owns these preferences.
     * @param string $password  The password associated with $user.
     * @param string $scope     The current application scope.
     * @param array $params     A hash containing connection parameters.
     * @param boolean $caching  Should caching be used?
     */
    function Prefs_kolab($user, $password, $scope = '',
                         $params = array(), $caching = false)
    {
        $params['hostspec'] = $GLOBALS['conf']['kolab']['ldap']['server'];
        $params['port'] = $GLOBALS['conf']['kolab']['ldap']['port'];
        $params['version'] = '3';
        $params['basedn'] = $GLOBALS['conf']['kolab']['ldap']['basedn'];
        $params['rootdn'] = $GLOBALS['conf']['kolab']['ldap']['binddn'];
        $params['password'] = $GLOBALS['conf']['kolab']['ldap']['bindpw'];
        $params['uid'] = array('mail', 'uid');

        parent::Prefs_ldap($user, $password, $scope, $params, $caching);
    }

}
