%% Generated by the Erlang ASN.1 BER_V2-compiler version, utilizing bit-syntax:1.4.4.10
%% Purpose: encoder and decoder to the types in mod PKIX1Implicit88

-module('PKIX1Implicit88').
-include("PKIX1Implicit88.hrl").
-define('RT_BER',asn1rt_ber_bin_v2).
-export([encoding_rule/0]).
-export([
'enc_AuthorityKeyIdentifier'/2,
'enc_KeyIdentifier'/2,
'enc_SubjectKeyIdentifier'/2,
'enc_KeyUsage'/2,
'enc_PrivateKeyUsagePeriod'/2,
'enc_CertificatePolicies'/2,
'enc_PolicyInformation'/2,
'enc_CertPolicyId'/2,
'enc_PolicyQualifierInfo'/2,
'enc_PolicyQualifierId'/2,
'enc_CPSuri'/2,
'enc_UserNotice'/2,
'enc_NoticeReference'/2,
'enc_DisplayText'/2,
'enc_PolicyMappings'/2,
'enc_SubjectAltName'/2,
'enc_GeneralNames'/2,
'enc_GeneralName'/2,
'enc_AnotherName'/2,
'enc_EDIPartyName'/2,
'enc_IssuerAltName'/2,
'enc_SubjectDirectoryAttributes'/2,
'enc_BasicConstraints'/2,
'enc_NameConstraints'/2,
'enc_GeneralSubtrees'/2,
'enc_GeneralSubtree'/2,
'enc_BaseDistance'/2,
'enc_PolicyConstraints'/2,
'enc_SkipCerts'/2,
'enc_CRLDistributionPoints'/2,
'enc_DistributionPoint'/2,
'enc_DistributionPointName'/2,
'enc_ReasonFlags'/2,
'enc_ExtKeyUsageSyntax'/2,
'enc_KeyPurposeId'/2,
'enc_InhibitAnyPolicy'/2,
'enc_FreshestCRL'/2,
'enc_AuthorityInfoAccessSyntax'/2,
'enc_AccessDescription'/2,
'enc_SubjectInfoAccessSyntax'/2,
'enc_CRLNumber'/2,
'enc_IssuingDistributionPoint'/2,
'enc_BaseCRLNumber'/2,
'enc_CRLReason'/2,
'enc_CertificateIssuer'/2,
'enc_HoldInstructionCode'/2,
'enc_InvalidityDate'/2
]).

-export([
'dec_AuthorityKeyIdentifier'/2,
'dec_KeyIdentifier'/2,
'dec_SubjectKeyIdentifier'/2,
'dec_KeyUsage'/2,
'dec_PrivateKeyUsagePeriod'/2,
'dec_CertificatePolicies'/2,
'dec_PolicyInformation'/2,
'dec_CertPolicyId'/2,
'dec_PolicyQualifierInfo'/2,
'dec_PolicyQualifierId'/2,
'dec_CPSuri'/2,
'dec_UserNotice'/2,
'dec_NoticeReference'/2,
'dec_DisplayText'/2,
'dec_PolicyMappings'/2,
'dec_SubjectAltName'/2,
'dec_GeneralNames'/2,
'dec_GeneralName'/2,
'dec_AnotherName'/2,
'dec_EDIPartyName'/2,
'dec_IssuerAltName'/2,
'dec_SubjectDirectoryAttributes'/2,
'dec_BasicConstraints'/2,
'dec_NameConstraints'/2,
'dec_GeneralSubtrees'/2,
'dec_GeneralSubtree'/2,
'dec_BaseDistance'/2,
'dec_PolicyConstraints'/2,
'dec_SkipCerts'/2,
'dec_CRLDistributionPoints'/2,
'dec_DistributionPoint'/2,
'dec_DistributionPointName'/2,
'dec_ReasonFlags'/2,
'dec_ExtKeyUsageSyntax'/2,
'dec_KeyPurposeId'/2,
'dec_InhibitAnyPolicy'/2,
'dec_FreshestCRL'/2,
'dec_AuthorityInfoAccessSyntax'/2,
'dec_AccessDescription'/2,
'dec_SubjectInfoAccessSyntax'/2,
'dec_CRLNumber'/2,
'dec_IssuingDistributionPoint'/2,
'dec_BaseCRLNumber'/2,
'dec_CRLReason'/2,
'dec_CertificateIssuer'/2,
'dec_HoldInstructionCode'/2,
'dec_InvalidityDate'/2
]).

-export([
'id-ce'/0,
'id-ce-authorityKeyIdentifier'/0,
'id-ce-subjectKeyIdentifier'/0,
'id-ce-keyUsage'/0,
'id-ce-privateKeyUsagePeriod'/0,
'id-ce-certificatePolicies'/0,
'anyPolicy'/0,
'id-ce-policyMappings'/0,
'id-ce-subjectAltName'/0,
'id-ce-issuerAltName'/0,
'id-ce-subjectDirectoryAttributes'/0,
'id-ce-basicConstraints'/0,
'id-ce-nameConstraints'/0,
'id-ce-policyConstraints'/0,
'id-ce-cRLDistributionPoints'/0,
'id-ce-extKeyUsage'/0,
'anyExtendedKeyUsage'/0,
'id-kp-serverAuth'/0,
'id-kp-clientAuth'/0,
'id-kp-codeSigning'/0,
'id-kp-emailProtection'/0,
'id-kp-timeStamping'/0,
'id-kp-OCSPSigning'/0,
'id-ce-inhibitAnyPolicy'/0,
'id-ce-freshestCRL'/0,
'id-pe-authorityInfoAccess'/0,
'id-pe-subjectInfoAccess'/0,
'id-ce-cRLNumber'/0,
'id-ce-issuingDistributionPoint'/0,
'id-ce-deltaCRLIndicator'/0,
'id-ce-cRLReasons'/0,
'id-ce-certificateIssuer'/0,
'id-ce-holdInstructionCode'/0,
'holdInstruction'/0,
'id-holdinstruction-none'/0,
'id-holdinstruction-callissuer'/0,
'id-holdinstruction-reject'/0,
'id-ce-invalidityDate'/0
]).

-export([info/0]).


-export([encode/2,decode/2,encode_disp/2,decode_disp/2]).

encoding_rule() ->
   ber_bin_v2.

encode(Type,Data) ->
case catch encode_disp(Type,Data) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {Bytes,_Len} ->
    {ok,Bytes};
  Bytes ->
    {ok,Bytes}
end.

decode(Type,Data) ->
case catch decode_disp(Type,element(1,?RT_BER:decode(Data))
) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  Result ->
    {ok,Result}
end.

encode_disp('AuthorityKeyIdentifier',Data) -> 'enc_AuthorityKeyIdentifier'(Data);
encode_disp('KeyIdentifier',Data) -> 'enc_KeyIdentifier'(Data);
encode_disp('SubjectKeyIdentifier',Data) -> 'enc_SubjectKeyIdentifier'(Data);
encode_disp('KeyUsage',Data) -> 'enc_KeyUsage'(Data);
encode_disp('PrivateKeyUsagePeriod',Data) -> 'enc_PrivateKeyUsagePeriod'(Data);
encode_disp('CertificatePolicies',Data) -> 'enc_CertificatePolicies'(Data);
encode_disp('PolicyInformation',Data) -> 'enc_PolicyInformation'(Data);
encode_disp('CertPolicyId',Data) -> 'enc_CertPolicyId'(Data);
encode_disp('PolicyQualifierInfo',Data) -> 'enc_PolicyQualifierInfo'(Data);
encode_disp('PolicyQualifierId',Data) -> 'enc_PolicyQualifierId'(Data);
encode_disp('CPSuri',Data) -> 'enc_CPSuri'(Data);
encode_disp('UserNotice',Data) -> 'enc_UserNotice'(Data);
encode_disp('NoticeReference',Data) -> 'enc_NoticeReference'(Data);
encode_disp('DisplayText',Data) -> 'enc_DisplayText'(Data);
encode_disp('PolicyMappings',Data) -> 'enc_PolicyMappings'(Data);
encode_disp('SubjectAltName',Data) -> 'enc_SubjectAltName'(Data);
encode_disp('GeneralNames',Data) -> 'enc_GeneralNames'(Data);
encode_disp('GeneralName',Data) -> 'enc_GeneralName'(Data);
encode_disp('AnotherName',Data) -> 'enc_AnotherName'(Data);
encode_disp('EDIPartyName',Data) -> 'enc_EDIPartyName'(Data);
encode_disp('IssuerAltName',Data) -> 'enc_IssuerAltName'(Data);
encode_disp('SubjectDirectoryAttributes',Data) -> 'enc_SubjectDirectoryAttributes'(Data);
encode_disp('BasicConstraints',Data) -> 'enc_BasicConstraints'(Data);
encode_disp('NameConstraints',Data) -> 'enc_NameConstraints'(Data);
encode_disp('GeneralSubtrees',Data) -> 'enc_GeneralSubtrees'(Data);
encode_disp('GeneralSubtree',Data) -> 'enc_GeneralSubtree'(Data);
encode_disp('BaseDistance',Data) -> 'enc_BaseDistance'(Data);
encode_disp('PolicyConstraints',Data) -> 'enc_PolicyConstraints'(Data);
encode_disp('SkipCerts',Data) -> 'enc_SkipCerts'(Data);
encode_disp('CRLDistributionPoints',Data) -> 'enc_CRLDistributionPoints'(Data);
encode_disp('DistributionPoint',Data) -> 'enc_DistributionPoint'(Data);
encode_disp('DistributionPointName',Data) -> 'enc_DistributionPointName'(Data);
encode_disp('ReasonFlags',Data) -> 'enc_ReasonFlags'(Data);
encode_disp('ExtKeyUsageSyntax',Data) -> 'enc_ExtKeyUsageSyntax'(Data);
encode_disp('KeyPurposeId',Data) -> 'enc_KeyPurposeId'(Data);
encode_disp('InhibitAnyPolicy',Data) -> 'enc_InhibitAnyPolicy'(Data);
encode_disp('FreshestCRL',Data) -> 'enc_FreshestCRL'(Data);
encode_disp('AuthorityInfoAccessSyntax',Data) -> 'enc_AuthorityInfoAccessSyntax'(Data);
encode_disp('AccessDescription',Data) -> 'enc_AccessDescription'(Data);
encode_disp('SubjectInfoAccessSyntax',Data) -> 'enc_SubjectInfoAccessSyntax'(Data);
encode_disp('CRLNumber',Data) -> 'enc_CRLNumber'(Data);
encode_disp('IssuingDistributionPoint',Data) -> 'enc_IssuingDistributionPoint'(Data);
encode_disp('BaseCRLNumber',Data) -> 'enc_BaseCRLNumber'(Data);
encode_disp('CRLReason',Data) -> 'enc_CRLReason'(Data);
encode_disp('CertificateIssuer',Data) -> 'enc_CertificateIssuer'(Data);
encode_disp('HoldInstructionCode',Data) -> 'enc_HoldInstructionCode'(Data);
encode_disp('InvalidityDate',Data) -> 'enc_InvalidityDate'(Data);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('AuthorityKeyIdentifier',Data) -> 'dec_AuthorityKeyIdentifier'(Data);
decode_disp('KeyIdentifier',Data) -> 'dec_KeyIdentifier'(Data);
decode_disp('SubjectKeyIdentifier',Data) -> 'dec_SubjectKeyIdentifier'(Data);
decode_disp('KeyUsage',Data) -> 'dec_KeyUsage'(Data);
decode_disp('PrivateKeyUsagePeriod',Data) -> 'dec_PrivateKeyUsagePeriod'(Data);
decode_disp('CertificatePolicies',Data) -> 'dec_CertificatePolicies'(Data);
decode_disp('PolicyInformation',Data) -> 'dec_PolicyInformation'(Data);
decode_disp('CertPolicyId',Data) -> 'dec_CertPolicyId'(Data);
decode_disp('PolicyQualifierInfo',Data) -> 'dec_PolicyQualifierInfo'(Data);
decode_disp('PolicyQualifierId',Data) -> 'dec_PolicyQualifierId'(Data);
decode_disp('CPSuri',Data) -> 'dec_CPSuri'(Data);
decode_disp('UserNotice',Data) -> 'dec_UserNotice'(Data);
decode_disp('NoticeReference',Data) -> 'dec_NoticeReference'(Data);
decode_disp('DisplayText',Data) -> 'dec_DisplayText'(Data);
decode_disp('PolicyMappings',Data) -> 'dec_PolicyMappings'(Data);
decode_disp('SubjectAltName',Data) -> 'dec_SubjectAltName'(Data);
decode_disp('GeneralNames',Data) -> 'dec_GeneralNames'(Data);
decode_disp('GeneralName',Data) -> 'dec_GeneralName'(Data);
decode_disp('AnotherName',Data) -> 'dec_AnotherName'(Data);
decode_disp('EDIPartyName',Data) -> 'dec_EDIPartyName'(Data);
decode_disp('IssuerAltName',Data) -> 'dec_IssuerAltName'(Data);
decode_disp('SubjectDirectoryAttributes',Data) -> 'dec_SubjectDirectoryAttributes'(Data);
decode_disp('BasicConstraints',Data) -> 'dec_BasicConstraints'(Data);
decode_disp('NameConstraints',Data) -> 'dec_NameConstraints'(Data);
decode_disp('GeneralSubtrees',Data) -> 'dec_GeneralSubtrees'(Data);
decode_disp('GeneralSubtree',Data) -> 'dec_GeneralSubtree'(Data);
decode_disp('BaseDistance',Data) -> 'dec_BaseDistance'(Data);
decode_disp('PolicyConstraints',Data) -> 'dec_PolicyConstraints'(Data);
decode_disp('SkipCerts',Data) -> 'dec_SkipCerts'(Data);
decode_disp('CRLDistributionPoints',Data) -> 'dec_CRLDistributionPoints'(Data);
decode_disp('DistributionPoint',Data) -> 'dec_DistributionPoint'(Data);
decode_disp('DistributionPointName',Data) -> 'dec_DistributionPointName'(Data);
decode_disp('ReasonFlags',Data) -> 'dec_ReasonFlags'(Data);
decode_disp('ExtKeyUsageSyntax',Data) -> 'dec_ExtKeyUsageSyntax'(Data);
decode_disp('KeyPurposeId',Data) -> 'dec_KeyPurposeId'(Data);
decode_disp('InhibitAnyPolicy',Data) -> 'dec_InhibitAnyPolicy'(Data);
decode_disp('FreshestCRL',Data) -> 'dec_FreshestCRL'(Data);
decode_disp('AuthorityInfoAccessSyntax',Data) -> 'dec_AuthorityInfoAccessSyntax'(Data);
decode_disp('AccessDescription',Data) -> 'dec_AccessDescription'(Data);
decode_disp('SubjectInfoAccessSyntax',Data) -> 'dec_SubjectInfoAccessSyntax'(Data);
decode_disp('CRLNumber',Data) -> 'dec_CRLNumber'(Data);
decode_disp('IssuingDistributionPoint',Data) -> 'dec_IssuingDistributionPoint'(Data);
decode_disp('BaseCRLNumber',Data) -> 'dec_BaseCRLNumber'(Data);
decode_disp('CRLReason',Data) -> 'dec_CRLReason'(Data);
decode_disp('CertificateIssuer',Data) -> 'dec_CertificateIssuer'(Data);
decode_disp('HoldInstructionCode',Data) -> 'dec_HoldInstructionCode'(Data);
decode_disp('InvalidityDate',Data) -> 'dec_InvalidityDate'(Data);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).





info() ->
  [{vsn,'1.4.4.10'},   {module,'PKIX1Implicit88'},   {options,[ber_bin_v2,
 report_errors,
 {cwd,"/usr/obj/ports/erlang-11b.0/otp_src_R11B-0/lib/ssl/pkix"},
 {outdir,"/usr/obj/ports/erlang-11b.0/otp_src_R11B-0/lib/ssl/pkix"},
 noobj,
 optimize,
 compact_bit_string,
 der,
 {i,"."}]}].


%%================================
%%  AuthorityKeyIdentifier
%%================================
'enc_AuthorityKeyIdentifier'(Val) ->
    'enc_AuthorityKeyIdentifier'(Val, [<<48>>]).

'enc_AuthorityKeyIdentifier'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute keyIdentifier(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_octet_string([], Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute authorityCertIssuer(2)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute authorityCertSerialNumber(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_integer([], Cindex3, [<<130>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AuthorityKeyIdentifier'(Tlv) ->
   'dec_AuthorityKeyIdentifier'(Tlv, [16]).

'dec_AuthorityKeyIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute keyIdentifier(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {?RT_BER:decode_octet_string(V1,[],[]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute authorityCertIssuer(2)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_GeneralNames'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute authorityCertSerialNumber(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {?RT_BER:decode_integer(V3,[],[]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'AuthorityKeyIdentifier', Term1, Term2, Term3}.



%%================================
%%  KeyIdentifier
%%================================
'enc_KeyIdentifier'(Val) ->
    'enc_KeyIdentifier'(Val, [<<4>>]).


'enc_KeyIdentifier'({'KeyIdentifier',Val}, TagIn) ->
   'enc_KeyIdentifier'(Val, TagIn);

'enc_KeyIdentifier'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn).


'dec_KeyIdentifier'(Tlv) ->
   'dec_KeyIdentifier'(Tlv, [4]).

'dec_KeyIdentifier'(Tlv, TagIn) ->
?RT_BER:decode_octet_string(Tlv,[],TagIn).



%%================================
%%  SubjectKeyIdentifier
%%================================
'enc_SubjectKeyIdentifier'(Val) ->
    'enc_SubjectKeyIdentifier'(Val, [<<4>>]).


'enc_SubjectKeyIdentifier'({'SubjectKeyIdentifier',Val}, TagIn) ->
   'enc_SubjectKeyIdentifier'(Val, TagIn);

'enc_SubjectKeyIdentifier'(Val, TagIn) ->
?RT_BER:encode_octet_string([], Val, TagIn).


'dec_SubjectKeyIdentifier'(Tlv) ->
   'dec_SubjectKeyIdentifier'(Tlv, [4]).

'dec_SubjectKeyIdentifier'(Tlv, TagIn) ->
?RT_BER:decode_octet_string(Tlv,[],TagIn).



%%================================
%%  KeyUsage
%%================================
'enc_KeyUsage'(Val) ->
    'enc_KeyUsage'(Val, [<<3>>]).


'enc_KeyUsage'({'KeyUsage',Val}, TagIn) ->
   'enc_KeyUsage'(Val, TagIn);

'enc_KeyUsage'(Val, TagIn) ->
?RT_BER:encode_bit_string([], Val, [{digitalSignature,0},{nonRepudiation,1},{keyEncipherment,2},{dataEncipherment,3},{keyAgreement,4},{keyCertSign,5},{cRLSign,6},{encipherOnly,7},{decipherOnly,8}], TagIn).


'dec_KeyUsage'(Tlv) ->
   'dec_KeyUsage'(Tlv, [3]).

'dec_KeyUsage'(Tlv, TagIn) ->
?RT_BER:decode_compact_bit_string(Tlv,[],[{digitalSignature,0},{nonRepudiation,1},{keyEncipherment,2},{dataEncipherment,3},{keyAgreement,4},{keyCertSign,5},{cRLSign,6},{encipherOnly,7},{decipherOnly,8}],TagIn).



%%================================
%%  PrivateKeyUsagePeriod
%%================================
'enc_PrivateKeyUsagePeriod'(Val) ->
    'enc_PrivateKeyUsagePeriod'(Val, [<<48>>]).

'enc_PrivateKeyUsagePeriod'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute notBefore(1) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_generalized_time([], Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute notAfter(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_generalized_time([], Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PrivateKeyUsagePeriod'(Tlv) ->
   'dec_PrivateKeyUsagePeriod'(Tlv, [16]).

'dec_PrivateKeyUsagePeriod'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute notBefore(1) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {?RT_BER:decode_generalized_time(V1,[],[]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute notAfter(2) with type GeneralizedTime OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {?RT_BER:decode_generalized_time(V2,[],[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'PrivateKeyUsagePeriod', Term1, Term2}.



%%================================
%%  CertificatePolicies
%%================================
'enc_CertificatePolicies'(Val) ->
    'enc_CertificatePolicies'(Val, [<<48>>]).


'enc_CertificatePolicies'({'CertificatePolicies',Val}, TagIn) ->
   'enc_CertificatePolicies'(Val, TagIn);

'enc_CertificatePolicies'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CertificatePolicies_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_CertificatePolicies_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CertificatePolicies_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PolicyInformation'(H, [<<48>>]),
   'enc_CertificatePolicies_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_CertificatePolicies'(Tlv) ->
   'dec_CertificatePolicies'(Tlv, [16]).

'dec_CertificatePolicies'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_PolicyInformation'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PolicyInformation
%%================================
'enc_PolicyInformation'(Val) ->
    'enc_PolicyInformation'(Val, [<<48>>]).

'enc_PolicyInformation'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute policyIdentifier(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute policyQualifiers(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PolicyInformation_policyQualifiers'(Cindex2, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PolicyInformation_policyQualifiers
%%================================

'enc_PolicyInformation_policyQualifiers'({'PolicyInformation_policyQualifiers',Val}, TagIn) ->
   'enc_PolicyInformation_policyQualifiers'(Val, TagIn);

'enc_PolicyInformation_policyQualifiers'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PolicyInformation_policyQualifiers_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_PolicyInformation_policyQualifiers_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PolicyInformation_policyQualifiers_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PolicyQualifierInfo'(H, [<<48>>]),
   'enc_PolicyInformation_policyQualifiers_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_PolicyInformation_policyQualifiers'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_PolicyQualifierInfo'(V1, [16]) || V1 <- Tlv1].




'dec_PolicyInformation'(Tlv) ->
   'dec_PolicyInformation'(Tlv, [16]).

'dec_PolicyInformation'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute policyIdentifier(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute policyQualifiers(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_PolicyInformation_policyQualifiers'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'PolicyInformation', Term1, Term2}.



%%================================
%%  CertPolicyId
%%================================
'enc_CertPolicyId'(Val) ->
    'enc_CertPolicyId'(Val, [<<6>>]).


'enc_CertPolicyId'({'CertPolicyId',Val}, TagIn) ->
   'enc_CertPolicyId'(Val, TagIn);

'enc_CertPolicyId'(Val, TagIn) ->
?RT_BER:encode_object_identifier(Val, TagIn).


'dec_CertPolicyId'(Tlv) ->
   'dec_CertPolicyId'(Tlv, [6]).

'dec_CertPolicyId'(Tlv, TagIn) ->
?RT_BER:decode_object_identifier(Tlv,TagIn).



%%================================
%%  PolicyQualifierInfo
%%================================
'enc_PolicyQualifierInfo'(Val) ->
    'enc_PolicyQualifierInfo'(Val, [<<48>>]).

'enc_PolicyQualifierInfo'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute policyQualifierId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute qualifier(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_open_type(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PolicyQualifierInfo'(Tlv) ->
   'dec_PolicyQualifierInfo'(Tlv, [16]).

'dec_PolicyQualifierInfo'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute policyQualifierId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute qualifier(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_open_type_as_binary(V2,[]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'PolicyQualifierInfo', Term1, Term2}.



%%================================
%%  PolicyQualifierId
%%================================
'enc_PolicyQualifierId'(Val) ->
    'enc_PolicyQualifierId'(Val, [<<6>>]).


'enc_PolicyQualifierId'({'PolicyQualifierId',Val}, TagIn) ->
   'enc_PolicyQualifierId'(Val, TagIn);

'enc_PolicyQualifierId'(Val, TagIn) ->
?RT_BER:encode_object_identifier(Val, TagIn).


'dec_PolicyQualifierId'(Tlv) ->
   'dec_PolicyQualifierId'(Tlv, [6]).

'dec_PolicyQualifierId'(Tlv, TagIn) ->
?RT_BER:decode_object_identifier(Tlv,TagIn).



%%================================
%%  CPSuri
%%================================
'enc_CPSuri'(Val) ->
    'enc_CPSuri'(Val, [<<22>>]).


'enc_CPSuri'({'CPSuri',Val}, TagIn) ->
   'enc_CPSuri'(Val, TagIn);

'enc_CPSuri'(Val, TagIn) ->
?RT_BER:encode_restricted_string([], Val, 22, TagIn).


'dec_CPSuri'(Tlv) ->
   'dec_CPSuri'(Tlv, [22]).

'dec_CPSuri'(Tlv, TagIn) ->
?RT_BER:decode_restricted_string(Tlv,[],22,TagIn).



%%================================
%%  UserNotice
%%================================
'enc_UserNotice'(Val) ->
    'enc_UserNotice'(Val, [<<48>>]).

'enc_UserNotice'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute noticeRef(1)   External PKIX1Implicit88:NoticeReference OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_NoticeReference'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute explicitText(2)   External PKIX1Implicit88:DisplayText OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DisplayText'(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_UserNotice'(Tlv) ->
   'dec_UserNotice'(Tlv, [16]).

'dec_UserNotice'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute noticeRef(1)   External PKIX1Implicit88:NoticeReference OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{16,V1}|TempTlv2] ->
    {'dec_NoticeReference'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute explicitText(2)   External PKIX1Implicit88:DisplayText OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {22,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
[V2 = {26,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
[V2 = {30,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
[V2 = {12,_}|TempTlv3] ->
    {'dec_DisplayText'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'UserNotice', Term1, Term2}.



%%================================
%%  NoticeReference
%%================================
'enc_NoticeReference'(Val) ->
    'enc_NoticeReference'(Val, [<<48>>]).

'enc_NoticeReference'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute organization(1)   External PKIX1Implicit88:DisplayText
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_DisplayText'(Cindex1, []),

%%-------------------------------------------------
%% attribute noticeNumbers(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_NoticeReference_noticeNumbers'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  NoticeReference_noticeNumbers
%%================================

'enc_NoticeReference_noticeNumbers'({'NoticeReference_noticeNumbers',Val}, TagIn) ->
   'enc_NoticeReference_noticeNumbers'(Val, TagIn);

'enc_NoticeReference_noticeNumbers'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_NoticeReference_noticeNumbers_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_NoticeReference_noticeNumbers_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_NoticeReference_noticeNumbers_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_integer([], H, [<<2>>]),
   'enc_NoticeReference_noticeNumbers_components'(T,[EncBytes|AccBytes], AccLen + EncLen).

'dec_NoticeReference_noticeNumbers'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
[?RT_BER:decode_integer(V1,[],[2]) || V1 <- Tlv1].




'dec_NoticeReference'(Tlv) ->
   'dec_NoticeReference'(Tlv, [16]).

'dec_NoticeReference'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute organization(1)   External PKIX1Implicit88:DisplayText
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_DisplayText'(V1, []),

%%-------------------------------------------------
%% attribute noticeNumbers(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_NoticeReference_noticeNumbers'(V2, [16]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'NoticeReference', Term1, Term2}.



%%================================
%%  DisplayText
%%================================
'enc_DisplayText'(Val) ->
    'enc_DisplayText'(Val, []).


'enc_DisplayText'({'DisplayText',Val}, TagIn) ->
   'enc_DisplayText'(Val, TagIn);

'enc_DisplayText'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ia5String ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 22, [<<22>>]);
      visibleString ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 26, [<<26>>]);
      bmpString ->
         ?RT_BER:encode_BMP_string([], element(2,Val), [<<30>>]);
      utf8String ->
         ?RT_BER:encode_UTF8_string([], element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_DisplayText'(Tlv) ->
   'dec_DisplayText'(Tlv, []).

'dec_DisplayText'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ia5String'
    {22, V1} -> 
        {ia5String, ?RT_BER:decode_restricted_string(V1,{1,200},22,[])};


%% 'visibleString'
    {26, V1} -> 
        {visibleString, ?RT_BER:decode_restricted_string(V1,{1,200},26,[])};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, ?RT_BER:decode_BMP_string(V1,{1,200},[])};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, ?RT_BER:decode_UTF8_string(V1,[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  PolicyMappings
%%================================
'enc_PolicyMappings'(Val) ->
    'enc_PolicyMappings'(Val, [<<48>>]).


'enc_PolicyMappings'({'PolicyMappings',Val}, TagIn) ->
   'enc_PolicyMappings'(Val, TagIn);

'enc_PolicyMappings'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PolicyMappings_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_PolicyMappings_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PolicyMappings_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PolicyMappings_SEQOF'(H, [<<48>>]),
   'enc_PolicyMappings_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PolicyMappings_SEQOF
%%================================
'enc_PolicyMappings_SEQOF'(Val, TagIn) ->
   {_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute issuerDomainPolicy(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute subjectDomainPolicy(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_object_identifier(Cindex2, [<<6>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).
'dec_PolicyMappings_SEQOF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute issuerDomainPolicy(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute subjectDomainPolicy(2) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_object_identifier(V2,[6]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'PolicyMappings_SEQOF', Term1, Term2}.



'dec_PolicyMappings'(Tlv) ->
   'dec_PolicyMappings'(Tlv, [16]).

'dec_PolicyMappings'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_PolicyMappings_SEQOF'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SubjectAltName
%%================================
'enc_SubjectAltName'(Val) ->
    'enc_SubjectAltName'(Val, [<<48>>]).


'enc_SubjectAltName'({'SubjectAltName',Val}, TagIn) ->
   'enc_SubjectAltName'(Val, TagIn);

'enc_SubjectAltName'(Val, TagIn) ->
   'enc_GeneralNames'(Val, TagIn).


'dec_SubjectAltName'(Tlv) ->
   'dec_SubjectAltName'(Tlv, [16]).

'dec_SubjectAltName'(Tlv, TagIn) ->
'dec_GeneralNames'(Tlv, TagIn).



%%================================
%%  GeneralNames
%%================================
'enc_GeneralNames'(Val) ->
    'enc_GeneralNames'(Val, [<<48>>]).


'enc_GeneralNames'({'GeneralNames',Val}, TagIn) ->
   'enc_GeneralNames'(Val, TagIn);

'enc_GeneralNames'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_GeneralNames_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_GeneralNames_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_GeneralNames_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_GeneralName'(H, []),
   'enc_GeneralNames_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_GeneralNames'(Tlv) ->
   'dec_GeneralNames'(Tlv, [16]).

'dec_GeneralNames'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_GeneralName'(V1, []) || V1 <- Tlv1].




%%================================
%%  GeneralName
%%================================
'enc_GeneralName'(Val) ->
    'enc_GeneralName'(Val, []).


'enc_GeneralName'({'GeneralName',Val}, TagIn) ->
   'enc_GeneralName'(Val, TagIn);

'enc_GeneralName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      otherName ->
         'enc_AnotherName'(element(2,Val), [<<160>>]);
      rfc822Name ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 22, [<<129>>]);
      dNSName ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 22, [<<130>>]);
      x400Address ->
         'PKIX1Explicit88':'enc_ORAddress'(element(2,Val), [<<163>>]);
      directoryName ->
         'PKIX1Explicit88':'enc_Name'(element(2,Val), [<<164>>]);
      ediPartyName ->
         'enc_EDIPartyName'(element(2,Val), [<<165>>]);
      uniformResourceIdentifier ->
         ?RT_BER:encode_restricted_string([], element(2,Val), 22, [<<134>>]);
      iPAddress ->
         ?RT_BER:encode_octet_string([], element(2,Val), [<<135>>]);
      registeredID ->
         ?RT_BER:encode_object_identifier(element(2,Val), [<<136>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_GeneralName'(Tlv) ->
   'dec_GeneralName'(Tlv, []).

'dec_GeneralName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'otherName'
    {131072, V1} -> 
        {otherName, 'dec_AnotherName'(V1, [])};


%% 'rfc822Name'
    {131073, V1} -> 
        {rfc822Name, ?RT_BER:decode_restricted_string(V1,[],22,[])};


%% 'dNSName'
    {131074, V1} -> 
        {dNSName, ?RT_BER:decode_restricted_string(V1,[],22,[])};


%% 'x400Address'
    {131075, V1} -> 
        {x400Address, 'PKIX1Explicit88':'dec_ORAddress'(V1, [])};


%% 'directoryName'
    {131076, V1} -> 
        {directoryName, 'PKIX1Explicit88':'dec_Name'(V1, [])};


%% 'ediPartyName'
    {131077, V1} -> 
        {ediPartyName, 'dec_EDIPartyName'(V1, [])};


%% 'uniformResourceIdentifier'
    {131078, V1} -> 
        {uniformResourceIdentifier, ?RT_BER:decode_restricted_string(V1,[],22,[])};


%% 'iPAddress'
    {131079, V1} -> 
        {iPAddress, ?RT_BER:decode_octet_string(V1,[],[])};


%% 'registeredID'
    {131080, V1} -> 
        {registeredID, ?RT_BER:decode_object_identifier(V1,[])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  AnotherName
%%================================
'enc_AnotherName'(Val) ->
    'enc_AnotherName'(Val, [<<48>>]).

'enc_AnotherName'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute type-id(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_open_type(Cindex2, [<<160>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AnotherName'(Tlv) ->
   'dec_AnotherName'(Tlv, [16]).

'dec_AnotherName'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute type-id(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute value(2) with type ASN1_OPEN_TYPE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_open_type_as_binary(V2,[131072]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'AnotherName', Term1, Term2}.



%%================================
%%  EDIPartyName
%%================================
'enc_EDIPartyName'(Val) ->
    'enc_EDIPartyName'(Val, [<<48>>]).

'enc_EDIPartyName'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute nameAssigner(1)   External PKIX1Explicit88:DirectoryString OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Explicit88':'enc_DirectoryString'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute partyName(2)   External PKIX1Explicit88:DirectoryString
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'PKIX1Explicit88':'enc_DirectoryString'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_EDIPartyName'(Tlv) ->
   'dec_EDIPartyName'(Tlv, [16]).

'dec_EDIPartyName'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute nameAssigner(1)   External PKIX1Explicit88:DirectoryString OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'PKIX1Explicit88':'dec_DirectoryString'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute partyName(2)   External PKIX1Explicit88:DirectoryString
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'PKIX1Explicit88':'dec_DirectoryString'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'EDIPartyName', Term1, Term2}.



%%================================
%%  IssuerAltName
%%================================
'enc_IssuerAltName'(Val) ->
    'enc_IssuerAltName'(Val, [<<48>>]).


'enc_IssuerAltName'({'IssuerAltName',Val}, TagIn) ->
   'enc_IssuerAltName'(Val, TagIn);

'enc_IssuerAltName'(Val, TagIn) ->
   'enc_GeneralNames'(Val, TagIn).


'dec_IssuerAltName'(Tlv) ->
   'dec_IssuerAltName'(Tlv, [16]).

'dec_IssuerAltName'(Tlv, TagIn) ->
'dec_GeneralNames'(Tlv, TagIn).



%%================================
%%  SubjectDirectoryAttributes
%%================================
'enc_SubjectDirectoryAttributes'(Val) ->
    'enc_SubjectDirectoryAttributes'(Val, [<<48>>]).


'enc_SubjectDirectoryAttributes'({'SubjectDirectoryAttributes',Val}, TagIn) ->
   'enc_SubjectDirectoryAttributes'(Val, TagIn);

'enc_SubjectDirectoryAttributes'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SubjectDirectoryAttributes_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_SubjectDirectoryAttributes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SubjectDirectoryAttributes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'PKIX1Explicit88':'enc_Attribute'(H, [<<48>>]),
   'enc_SubjectDirectoryAttributes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_SubjectDirectoryAttributes'(Tlv) ->
   'dec_SubjectDirectoryAttributes'(Tlv, [16]).

'dec_SubjectDirectoryAttributes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['PKIX1Explicit88':'dec_Attribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  BasicConstraints
%%================================
'enc_BasicConstraints'(Val) ->
    'enc_BasicConstraints'(Val, [<<48>>]).

'enc_BasicConstraints'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute cA(1) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case catch asn1rt_check:check_bool(false, Cindex1) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_boolean(Cindex1, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute pathLenConstraint(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_integer([], Cindex2, [<<2>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_BasicConstraints'(Tlv) ->
   'dec_BasicConstraints'(Tlv, [16]).

'dec_BasicConstraints'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute cA(1) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{1,V1}|TempTlv2] ->
    {?RT_BER:decode_boolean(V1,[]), TempTlv2};
    _ ->
        {false,Tlv1}
end,

%%-------------------------------------------------
%% attribute pathLenConstraint(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{2,V2}|TempTlv3] ->
    {?RT_BER:decode_integer(V2,{0,'MAX'},[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'BasicConstraints', Term1, Term2}.



%%================================
%%  NameConstraints
%%================================
'enc_NameConstraints'(Val) ->
    'enc_NameConstraints'(Val, [<<48>>]).

'enc_NameConstraints'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute permittedSubtrees(1)   External PKIX1Implicit88:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralSubtrees'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute excludedSubtrees(2)   External PKIX1Implicit88:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralSubtrees'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_NameConstraints'(Tlv) ->
   'dec_NameConstraints'(Tlv, [16]).

'dec_NameConstraints'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute permittedSubtrees(1)   External PKIX1Implicit88:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_GeneralSubtrees'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute excludedSubtrees(2)   External PKIX1Implicit88:GeneralSubtrees OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_GeneralSubtrees'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'NameConstraints', Term1, Term2}.



%%================================
%%  GeneralSubtrees
%%================================
'enc_GeneralSubtrees'(Val) ->
    'enc_GeneralSubtrees'(Val, [<<48>>]).


'enc_GeneralSubtrees'({'GeneralSubtrees',Val}, TagIn) ->
   'enc_GeneralSubtrees'(Val, TagIn);

'enc_GeneralSubtrees'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_GeneralSubtrees_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_GeneralSubtrees_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_GeneralSubtrees_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_GeneralSubtree'(H, [<<48>>]),
   'enc_GeneralSubtrees_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_GeneralSubtrees'(Tlv) ->
   'dec_GeneralSubtrees'(Tlv, [16]).

'dec_GeneralSubtrees'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_GeneralSubtree'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  GeneralSubtree
%%================================
'enc_GeneralSubtree'(Val) ->
    'enc_GeneralSubtree'(Val, [<<48>>]).

'enc_GeneralSubtree'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute base(1)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_GeneralName'(Cindex1, []),

%%-------------------------------------------------
%% attribute minimum(2) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case catch asn1rt_check:check_int(0, Cindex2, []) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_integer([], Cindex2, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute maximum(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_integer([], Cindex3, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_GeneralSubtree'(Tlv) ->
   'dec_GeneralSubtree'(Tlv, [16]).

'dec_GeneralSubtree'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute base(1)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_GeneralName'(V1, []),

%%-------------------------------------------------
%% attribute minimum(2) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131072,V2}|TempTlv3] ->
    {?RT_BER:decode_integer(V2,{0,'MAX'},[]), TempTlv3};
    _ ->
        {0,Tlv2}
end,

%%-------------------------------------------------
%% attribute maximum(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131073,V3}|TempTlv4] ->
    {?RT_BER:decode_integer(V3,{0,'MAX'},[]), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'GeneralSubtree', Term1, Term2, Term3}.



%%================================
%%  BaseDistance
%%================================
'enc_BaseDistance'(Val) ->
    'enc_BaseDistance'(Val, [<<2>>]).


'enc_BaseDistance'({'BaseDistance',Val}, TagIn) ->
   'enc_BaseDistance'(Val, TagIn);

'enc_BaseDistance'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, TagIn).


'dec_BaseDistance'(Tlv) ->
   'dec_BaseDistance'(Tlv, [2]).

'dec_BaseDistance'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,{0,'MAX'},TagIn).



%%================================
%%  PolicyConstraints
%%================================
'enc_PolicyConstraints'(Val) ->
    'enc_PolicyConstraints'(Val, [<<48>>]).

'enc_PolicyConstraints'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute requireExplicitPolicy(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_integer([], Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute inhibitPolicyMapping(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_integer([], Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PolicyConstraints'(Tlv) ->
   'dec_PolicyConstraints'(Tlv, [16]).

'dec_PolicyConstraints'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute requireExplicitPolicy(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {?RT_BER:decode_integer(V1,{0,'MAX'},[]), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute inhibitPolicyMapping(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {?RT_BER:decode_integer(V2,{0,'MAX'},[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'PolicyConstraints', Term1, Term2}.



%%================================
%%  SkipCerts
%%================================
'enc_SkipCerts'(Val) ->
    'enc_SkipCerts'(Val, [<<2>>]).


'enc_SkipCerts'({'SkipCerts',Val}, TagIn) ->
   'enc_SkipCerts'(Val, TagIn);

'enc_SkipCerts'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, TagIn).


'dec_SkipCerts'(Tlv) ->
   'dec_SkipCerts'(Tlv, [2]).

'dec_SkipCerts'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,{0,'MAX'},TagIn).



%%================================
%%  CRLDistributionPoints
%%================================
'enc_CRLDistributionPoints'(Val) ->
    'enc_CRLDistributionPoints'(Val, [<<48>>]).


'enc_CRLDistributionPoints'({'CRLDistributionPoints',Val}, TagIn) ->
   'enc_CRLDistributionPoints'(Val, TagIn);

'enc_CRLDistributionPoints'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_CRLDistributionPoints_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_CRLDistributionPoints_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_CRLDistributionPoints_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_DistributionPoint'(H, [<<48>>]),
   'enc_CRLDistributionPoints_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_CRLDistributionPoints'(Tlv) ->
   'dec_CRLDistributionPoints'(Tlv, [16]).

'dec_CRLDistributionPoints'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_DistributionPoint'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  DistributionPoint
%%================================
'enc_DistributionPoint'(Val) ->
    'enc_DistributionPoint'(Val, [<<48>>]).

'enc_DistributionPoint'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute distributionPoint(1)   External PKIX1Implicit88:DistributionPointName OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DistributionPointName'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute reasons(2) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_bit_string([], Cindex2, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], [<<129>>])
       end,

%%-------------------------------------------------
%% attribute cRLIssuer(3)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_GeneralNames'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_DistributionPoint'(Tlv) ->
   'dec_DistributionPoint'(Tlv, [16]).

'dec_DistributionPoint'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute distributionPoint(1)   External PKIX1Implicit88:DistributionPointName OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_DistributionPointName'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute reasons(2) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {?RT_BER:decode_compact_bit_string(V2,[],[{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}],[]), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute cRLIssuer(3)   External PKIX1Implicit88:GeneralNames OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_GeneralNames'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'DistributionPoint', Term1, Term2, Term3}.



%%================================
%%  DistributionPointName
%%================================
'enc_DistributionPointName'(Val) ->
    'enc_DistributionPointName'(Val, []).


'enc_DistributionPointName'({'DistributionPointName',Val}, TagIn) ->
   'enc_DistributionPointName'(Val, TagIn);

'enc_DistributionPointName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      fullName ->
         'enc_GeneralNames'(element(2,Val), [<<160>>]);
      nameRelativeToCRLIssuer ->
         'PKIX1Explicit88':'enc_RelativeDistinguishedName'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

?RT_BER:encode_tags(TagIn, EncBytes, EncLen).




'dec_DistributionPointName'(Tlv) ->
   'dec_DistributionPointName'(Tlv, []).

'dec_DistributionPointName'(Tlv, TagIn) ->
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'fullName'
    {131072, V1} -> 
        {fullName, 'dec_GeneralNames'(V1, [])};


%% 'nameRelativeToCRLIssuer'
    {131073, V1} -> 
        {nameRelativeToCRLIssuer, 'PKIX1Explicit88':'dec_RelativeDistinguishedName'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  ReasonFlags
%%================================
'enc_ReasonFlags'(Val) ->
    'enc_ReasonFlags'(Val, [<<3>>]).


'enc_ReasonFlags'({'ReasonFlags',Val}, TagIn) ->
   'enc_ReasonFlags'(Val, TagIn);

'enc_ReasonFlags'(Val, TagIn) ->
?RT_BER:encode_bit_string([], Val, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], TagIn).


'dec_ReasonFlags'(Tlv) ->
   'dec_ReasonFlags'(Tlv, [3]).

'dec_ReasonFlags'(Tlv, TagIn) ->
?RT_BER:decode_compact_bit_string(Tlv,[],[{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}],TagIn).



%%================================
%%  ExtKeyUsageSyntax
%%================================
'enc_ExtKeyUsageSyntax'(Val) ->
    'enc_ExtKeyUsageSyntax'(Val, [<<48>>]).


'enc_ExtKeyUsageSyntax'({'ExtKeyUsageSyntax',Val}, TagIn) ->
   'enc_ExtKeyUsageSyntax'(Val, TagIn);

'enc_ExtKeyUsageSyntax'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_ExtKeyUsageSyntax_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_ExtKeyUsageSyntax_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ExtKeyUsageSyntax_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = ?RT_BER:encode_object_identifier(H, [<<6>>]),
   'enc_ExtKeyUsageSyntax_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ExtKeyUsageSyntax'(Tlv) ->
   'dec_ExtKeyUsageSyntax'(Tlv, [16]).

'dec_ExtKeyUsageSyntax'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
[?RT_BER:decode_object_identifier(V1,[6]) || V1 <- Tlv1].




%%================================
%%  KeyPurposeId
%%================================
'enc_KeyPurposeId'(Val) ->
    'enc_KeyPurposeId'(Val, [<<6>>]).


'enc_KeyPurposeId'({'KeyPurposeId',Val}, TagIn) ->
   'enc_KeyPurposeId'(Val, TagIn);

'enc_KeyPurposeId'(Val, TagIn) ->
?RT_BER:encode_object_identifier(Val, TagIn).


'dec_KeyPurposeId'(Tlv) ->
   'dec_KeyPurposeId'(Tlv, [6]).

'dec_KeyPurposeId'(Tlv, TagIn) ->
?RT_BER:decode_object_identifier(Tlv,TagIn).



%%================================
%%  InhibitAnyPolicy
%%================================
'enc_InhibitAnyPolicy'(Val) ->
    'enc_InhibitAnyPolicy'(Val, [<<2>>]).


'enc_InhibitAnyPolicy'({'InhibitAnyPolicy',Val}, TagIn) ->
   'enc_InhibitAnyPolicy'(Val, TagIn);

'enc_InhibitAnyPolicy'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, TagIn).


'dec_InhibitAnyPolicy'(Tlv) ->
   'dec_InhibitAnyPolicy'(Tlv, [2]).

'dec_InhibitAnyPolicy'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,{0,'MAX'},TagIn).



%%================================
%%  FreshestCRL
%%================================
'enc_FreshestCRL'(Val) ->
    'enc_FreshestCRL'(Val, [<<48>>]).


'enc_FreshestCRL'({'FreshestCRL',Val}, TagIn) ->
   'enc_FreshestCRL'(Val, TagIn);

'enc_FreshestCRL'(Val, TagIn) ->
   'enc_CRLDistributionPoints'(Val, TagIn).


'dec_FreshestCRL'(Tlv) ->
   'dec_FreshestCRL'(Tlv, [16]).

'dec_FreshestCRL'(Tlv, TagIn) ->
'dec_CRLDistributionPoints'(Tlv, TagIn).



%%================================
%%  AuthorityInfoAccessSyntax
%%================================
'enc_AuthorityInfoAccessSyntax'(Val) ->
    'enc_AuthorityInfoAccessSyntax'(Val, [<<48>>]).


'enc_AuthorityInfoAccessSyntax'({'AuthorityInfoAccessSyntax',Val}, TagIn) ->
   'enc_AuthorityInfoAccessSyntax'(Val, TagIn);

'enc_AuthorityInfoAccessSyntax'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AuthorityInfoAccessSyntax_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_AuthorityInfoAccessSyntax_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AuthorityInfoAccessSyntax_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AccessDescription'(H, [<<48>>]),
   'enc_AuthorityInfoAccessSyntax_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_AuthorityInfoAccessSyntax'(Tlv) ->
   'dec_AuthorityInfoAccessSyntax'(Tlv, [16]).

'dec_AuthorityInfoAccessSyntax'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_AccessDescription'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  AccessDescription
%%================================
'enc_AccessDescription'(Val) ->
    'enc_AccessDescription'(Val, [<<48>>]).

'enc_AccessDescription'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute accessMethod(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute accessLocation(2)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_GeneralName'(Cindex2, []),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AccessDescription'(Tlv) ->
   'dec_AccessDescription'(Tlv, [16]).

'dec_AccessDescription'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute accessMethod(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_object_identifier(V1,[6]),

%%-------------------------------------------------
%% attribute accessLocation(2)   External PKIX1Implicit88:GeneralName
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_GeneralName'(V2, []),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'AccessDescription', Term1, Term2}.



%%================================
%%  SubjectInfoAccessSyntax
%%================================
'enc_SubjectInfoAccessSyntax'(Val) ->
    'enc_SubjectInfoAccessSyntax'(Val, [<<48>>]).


'enc_SubjectInfoAccessSyntax'({'SubjectInfoAccessSyntax',Val}, TagIn) ->
   'enc_SubjectInfoAccessSyntax'(Val, TagIn);

'enc_SubjectInfoAccessSyntax'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SubjectInfoAccessSyntax_components'(Val,[],0),
   ?RT_BER:encode_tags(TagIn, EncBytes, EncLen).

'enc_SubjectInfoAccessSyntax_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SubjectInfoAccessSyntax_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AccessDescription'(H, [<<48>>]),
   'enc_SubjectInfoAccessSyntax_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_SubjectInfoAccessSyntax'(Tlv) ->
   'dec_SubjectInfoAccessSyntax'(Tlv, [16]).

'dec_SubjectInfoAccessSyntax'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 
['dec_AccessDescription'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CRLNumber
%%================================
'enc_CRLNumber'(Val) ->
    'enc_CRLNumber'(Val, [<<2>>]).


'enc_CRLNumber'({'CRLNumber',Val}, TagIn) ->
   'enc_CRLNumber'(Val, TagIn);

'enc_CRLNumber'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, TagIn).


'dec_CRLNumber'(Tlv) ->
   'dec_CRLNumber'(Tlv, [2]).

'dec_CRLNumber'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,{0,'MAX'},TagIn).



%%================================
%%  IssuingDistributionPoint
%%================================
'enc_IssuingDistributionPoint'(Val) ->
    'enc_IssuingDistributionPoint'(Val, [<<48>>]).

'enc_IssuingDistributionPoint'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5, Cindex6} = Val,

%%-------------------------------------------------
%% attribute distributionPoint(1)   External PKIX1Implicit88:DistributionPointName OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DistributionPointName'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute onlyContainsUserCerts(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case catch asn1rt_check:check_bool(false, Cindex2) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_boolean(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute onlyContainsCACerts(3) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case catch asn1rt_check:check_bool(false, Cindex3) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_boolean(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute onlySomeReasons(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            ?RT_BER:encode_bit_string([], Cindex4, [{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}], [<<131>>])
       end,

%%-------------------------------------------------
%% attribute indirectCRL(5) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case catch asn1rt_check:check_bool(false, Cindex5) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_boolean(Cindex5, [<<132>>])
       end,

%%-------------------------------------------------
%% attribute onlyContainsAttributeCerts(6) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case catch asn1rt_check:check_bool(false, Cindex6) of
            true -> {[],0};
         _ ->
            ?RT_BER:encode_boolean(Cindex6, [<<133>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IssuingDistributionPoint'(Tlv) ->
   'dec_IssuingDistributionPoint'(Tlv, [16]).

'dec_IssuingDistributionPoint'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute distributionPoint(1)   External PKIX1Implicit88:DistributionPointName OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_DistributionPointName'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute onlyContainsUserCerts(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {?RT_BER:decode_boolean(V2,[]), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute onlyContainsCACerts(3) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {?RT_BER:decode_boolean(V3,[]), TempTlv4};
    _ ->
        {false,Tlv3}
end,

%%-------------------------------------------------
%% attribute onlySomeReasons(4) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {?RT_BER:decode_compact_bit_string(V4,[],[{unused,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{privilegeWithdrawn,7},{aACompromise,8}],[]), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute indirectCRL(5) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131076,V5}|TempTlv6] ->
    {?RT_BER:decode_boolean(V5,[]), TempTlv6};
    _ ->
        {false,Tlv5}
end,

%%-------------------------------------------------
%% attribute onlyContainsAttributeCerts(6) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131077,V6}|TempTlv7] ->
    {?RT_BER:decode_boolean(V6,[]), TempTlv7};
    _ ->
        {false,Tlv6}
end,

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
   {'IssuingDistributionPoint', Term1, Term2, Term3, Term4, Term5, Term6}.



%%================================
%%  BaseCRLNumber
%%================================
'enc_BaseCRLNumber'(Val) ->
    'enc_BaseCRLNumber'(Val, [<<2>>]).


'enc_BaseCRLNumber'({'BaseCRLNumber',Val}, TagIn) ->
   'enc_BaseCRLNumber'(Val, TagIn);

'enc_BaseCRLNumber'(Val, TagIn) ->
?RT_BER:encode_integer([], Val, TagIn).


'dec_BaseCRLNumber'(Tlv) ->
   'dec_BaseCRLNumber'(Tlv, [2]).

'dec_BaseCRLNumber'(Tlv, TagIn) ->
?RT_BER:decode_integer(Tlv,{0,'MAX'},TagIn).



%%================================
%%  CRLReason
%%================================
'enc_CRLReason'(Val) ->
    'enc_CRLReason'(Val, [<<10>>]).


'enc_CRLReason'({'CRLReason',Val}, TagIn) ->
   'enc_CRLReason'(Val, TagIn);

'enc_CRLReason'(Val, TagIn) ->
case (case Val of {_,_}->element(2,Val);_->Val end) of
unspecified -> ?RT_BER:encode_enumerated(0,TagIn);
keyCompromise -> ?RT_BER:encode_enumerated(1,TagIn);
cACompromise -> ?RT_BER:encode_enumerated(2,TagIn);
affiliationChanged -> ?RT_BER:encode_enumerated(3,TagIn);
superseded -> ?RT_BER:encode_enumerated(4,TagIn);
cessationOfOperation -> ?RT_BER:encode_enumerated(5,TagIn);
certificateHold -> ?RT_BER:encode_enumerated(6,TagIn);
removeFromCRL -> ?RT_BER:encode_enumerated(8,TagIn);
privilegeWithdrawn -> ?RT_BER:encode_enumerated(9,TagIn);
aACompromise -> ?RT_BER:encode_enumerated(10,TagIn);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


'dec_CRLReason'(Tlv) ->
   'dec_CRLReason'(Tlv, [10]).

'dec_CRLReason'(Tlv, TagIn) ->
?RT_BER:decode_enumerated(Tlv,[],[{unspecified,0},{keyCompromise,1},{cACompromise,2},{affiliationChanged,3},{superseded,4},{cessationOfOperation,5},{certificateHold,6},{removeFromCRL,8},{privilegeWithdrawn,9},{aACompromise,10}],TagIn).



%%================================
%%  CertificateIssuer
%%================================
'enc_CertificateIssuer'(Val) ->
    'enc_CertificateIssuer'(Val, [<<48>>]).


'enc_CertificateIssuer'({'CertificateIssuer',Val}, TagIn) ->
   'enc_CertificateIssuer'(Val, TagIn);

'enc_CertificateIssuer'(Val, TagIn) ->
   'enc_GeneralNames'(Val, TagIn).


'dec_CertificateIssuer'(Tlv) ->
   'dec_CertificateIssuer'(Tlv, [16]).

'dec_CertificateIssuer'(Tlv, TagIn) ->
'dec_GeneralNames'(Tlv, TagIn).



%%================================
%%  HoldInstructionCode
%%================================
'enc_HoldInstructionCode'(Val) ->
    'enc_HoldInstructionCode'(Val, [<<6>>]).


'enc_HoldInstructionCode'({'HoldInstructionCode',Val}, TagIn) ->
   'enc_HoldInstructionCode'(Val, TagIn);

'enc_HoldInstructionCode'(Val, TagIn) ->
?RT_BER:encode_object_identifier(Val, TagIn).


'dec_HoldInstructionCode'(Tlv) ->
   'dec_HoldInstructionCode'(Tlv, [6]).

'dec_HoldInstructionCode'(Tlv, TagIn) ->
?RT_BER:decode_object_identifier(Tlv,TagIn).



%%================================
%%  InvalidityDate
%%================================
'enc_InvalidityDate'(Val) ->
    'enc_InvalidityDate'(Val, [<<24>>]).


'enc_InvalidityDate'({'InvalidityDate',Val}, TagIn) ->
   'enc_InvalidityDate'(Val, TagIn);

'enc_InvalidityDate'(Val, TagIn) ->
?RT_BER:encode_generalized_time([], Val, TagIn).


'dec_InvalidityDate'(Tlv) ->
   'dec_InvalidityDate'(Tlv, [24]).

'dec_InvalidityDate'(Tlv, TagIn) ->
?RT_BER:decode_generalized_time(Tlv,[],TagIn).

'id-ce'() ->
{2,5,29}.

'id-ce-authorityKeyIdentifier'() ->
{2,5,29,35}.

'id-ce-subjectKeyIdentifier'() ->
{2,5,29,14}.

'id-ce-keyUsage'() ->
{2,5,29,15}.

'id-ce-privateKeyUsagePeriod'() ->
{2,5,29,16}.

'id-ce-certificatePolicies'() ->
{2,5,29,32}.

'anyPolicy'() ->
{2,5,29,32,0}.

'id-ce-policyMappings'() ->
{2,5,29,33}.

'id-ce-subjectAltName'() ->
{2,5,29,17}.

'id-ce-issuerAltName'() ->
{2,5,29,18}.

'id-ce-subjectDirectoryAttributes'() ->
{2,5,29,9}.

'id-ce-basicConstraints'() ->
{2,5,29,19}.

'id-ce-nameConstraints'() ->
{2,5,29,30}.

'id-ce-policyConstraints'() ->
{2,5,29,36}.

'id-ce-cRLDistributionPoints'() ->
{2,5,29,31}.

'id-ce-extKeyUsage'() ->
{2,5,29,37}.

'anyExtendedKeyUsage'() ->
{2,5,29,37,0}.

'id-kp-serverAuth'() ->
{1,3,6,1,5,5,7,3,1}.

'id-kp-clientAuth'() ->
{1,3,6,1,5,5,7,3,2}.

'id-kp-codeSigning'() ->
{1,3,6,1,5,5,7,3,3}.

'id-kp-emailProtection'() ->
{1,3,6,1,5,5,7,3,4}.

'id-kp-timeStamping'() ->
{1,3,6,1,5,5,7,3,8}.

'id-kp-OCSPSigning'() ->
{1,3,6,1,5,5,7,3,9}.

'id-ce-inhibitAnyPolicy'() ->
{2,5,29,54}.

'id-ce-freshestCRL'() ->
{2,5,29,46}.

'id-pe-authorityInfoAccess'() ->
{1,3,6,1,5,5,7,1,1}.

'id-pe-subjectInfoAccess'() ->
{1,3,6,1,5,5,7,1,11}.

'id-ce-cRLNumber'() ->
{2,5,29,20}.

'id-ce-issuingDistributionPoint'() ->
{2,5,29,28}.

'id-ce-deltaCRLIndicator'() ->
{2,5,29,27}.

'id-ce-cRLReasons'() ->
{2,5,29,21}.

'id-ce-certificateIssuer'() ->
{2,5,29,29}.

'id-ce-holdInstructionCode'() ->
{2,5,29,23}.

'holdInstruction'() ->
{2,2,840,10040,2}.

'id-holdinstruction-none'() ->
{2,2,840,10040,2,1}.

'id-holdinstruction-callissuer'() ->
{2,2,840,10040,2,2}.

'id-holdinstruction-reject'() ->
{2,2,840,10040,2,3}.

'id-ce-invalidityDate'() ->
{2,5,29,24}.

