%%------------------------------------------------------------
%%
%% Implementation stub file
%% 
%% Target: mnesia_corba_session
%% Source: /usr/obj/ports/erlang-11b.0/otp_src_R11B-0/lib/mnesia_session/src/mnesia_corba_session.idl
%% IC vsn: 4.2.11
%% 
%% This file is automatically generated. DO NOT EDIT IT.
%%
%%------------------------------------------------------------

-module(mnesia_corba_session).
-ic_compiled("4_2_11").


%% Interface functions
-export([dirty_write/3, dirty_write/4, dirty_read/3]).
-export([dirty_read/4, dirty_update_counter/4, dirty_update_counter/5]).
-export([dirty_delete/3, dirty_delete/4, dirty_delete_object/3]).
-export([dirty_delete_object/4, dirty_slot/3, dirty_slot/4]).
-export([dirty_first/2, dirty_first/3, dirty_next/3]).
-export([dirty_next/4, dirty_all_keys/2, dirty_all_keys/3]).
-export([dirty_match_all/2, dirty_match_all/3, dirty_index_read/4]).
-export([dirty_index_read/5, create_table/3, create_table/4]).
-export([delete_table/2, delete_table/3, add_table_copy/4]).
-export([add_table_copy/5, del_table_copy/3, del_table_copy/4]).
-export([move_table_copy/4, move_table_copy/5, add_table_index/3]).
-export([add_table_index/4, del_table_index/3, del_table_index/4]).
-export([change_table_copy_type/4, change_table_copy_type/5, change_table_access_mode/3]).
-export([change_table_access_mode/4, wait_for_tables/3, wait_for_tables/4]).
-export([force_load_table/2, force_load_table/3, change_table_load_order/3]).
-export([change_table_load_order/4, set_master_nodes1/2, set_master_nodes1/3]).
-export([set_master_nodes2/3, set_master_nodes2/4, backup1/2]).
-export([backup1/3, backup2/3, backup2/4]).
-export([install_fallback1/2, install_fallback1/3, install_fallback2/3]).
-export([install_fallback2/4, uninstall_fallback/1, uninstall_fallback/2]).
-export([dump_log/1, dump_log/2, dump_tables/2]).
-export([dump_tables/3, activate_checkpoint/2, activate_checkpoint/3]).
-export([deactivate_checkpoint/2, deactivate_checkpoint/3, backup_checkpoint1/3]).
-export([backup_checkpoint1/4, backup_checkpoint2/4, backup_checkpoint2/5]).
-export([load_textfile/2, load_textfile/3, dump_to_textfile/2]).
-export([dump_to_textfile/3, table_info/2, table_info/3]).
-export([system_info/1, system_info/2]).

%% Type identification function
-export([typeID/0]).

%% Used to start server
-export([oe_create/0, oe_create_link/0, oe_create/1]).
-export([oe_create_link/1, oe_create/2, oe_create_link/2]).

%% TypeCode Functions and inheritance
-export([oe_tc/1, oe_is_a/1, oe_get_interface/0]).

%% gen server export stuff
-behaviour(gen_server).
-export([init/1, terminate/2, handle_call/3]).
-export([handle_cast/2, handle_info/2, code_change/3]).

-include_lib("orber/include/corba.hrl").


%%------------------------------------------------------------
%%
%% Object interface functions.
%%
%%------------------------------------------------------------



%%%% Operation: dirty_write
%% 
%%   Returns: RetVal, Reason
%%
dirty_write(OE_THIS, Tab, Object) ->
    corba:call(OE_THIS, dirty_write, [Tab, Object], ?MODULE).

dirty_write(OE_THIS, OE_Options, Tab, Object) ->
    corba:call(OE_THIS, dirty_write, [Tab, Object], ?MODULE, OE_Options).

%%%% Operation: dirty_read
%% 
%%   Returns: RetVal, Result, Reason
%%
dirty_read(OE_THIS, Tab, Key) ->
    corba:call(OE_THIS, dirty_read, [Tab, Key], ?MODULE).

dirty_read(OE_THIS, OE_Options, Tab, Key) ->
    corba:call(OE_THIS, dirty_read, [Tab, Key], ?MODULE, OE_Options).

%%%% Operation: dirty_update_counter
%% 
%%   Returns: RetVal, Newval, Reason
%%
dirty_update_counter(OE_THIS, Tab, Key, Val) ->
    corba:call(OE_THIS, dirty_update_counter, [Tab, Key, Val], ?MODULE).

dirty_update_counter(OE_THIS, OE_Options, Tab, Key, Val) ->
    corba:call(OE_THIS, dirty_update_counter, [Tab, Key, Val], ?MODULE, OE_Options).

%%%% Operation: dirty_delete
%% 
%%   Returns: RetVal, Reason
%%
dirty_delete(OE_THIS, Tab, Key) ->
    corba:call(OE_THIS, dirty_delete, [Tab, Key], ?MODULE).

dirty_delete(OE_THIS, OE_Options, Tab, Key) ->
    corba:call(OE_THIS, dirty_delete, [Tab, Key], ?MODULE, OE_Options).

%%%% Operation: dirty_delete_object
%% 
%%   Returns: RetVal, Reason
%%
dirty_delete_object(OE_THIS, Tab, Object) ->
    corba:call(OE_THIS, dirty_delete_object, [Tab, Object], ?MODULE).

dirty_delete_object(OE_THIS, OE_Options, Tab, Object) ->
    corba:call(OE_THIS, dirty_delete_object, [Tab, Object], ?MODULE, OE_Options).

%%%% Operation: dirty_slot
%% 
%%   Returns: RetVal, Result, Reason
%%
dirty_slot(OE_THIS, Tab, Slot) ->
    corba:call(OE_THIS, dirty_slot, [Tab, Slot], ?MODULE).

dirty_slot(OE_THIS, OE_Options, Tab, Slot) ->
    corba:call(OE_THIS, dirty_slot, [Tab, Slot], ?MODULE, OE_Options).

%%%% Operation: dirty_first
%% 
%%   Returns: RetVal, Next_key, Reason
%%
dirty_first(OE_THIS, Tab) ->
    corba:call(OE_THIS, dirty_first, [Tab], ?MODULE).

dirty_first(OE_THIS, OE_Options, Tab) ->
    corba:call(OE_THIS, dirty_first, [Tab], ?MODULE, OE_Options).

%%%% Operation: dirty_next
%% 
%%   Returns: RetVal, Next_key, Reason
%%
dirty_next(OE_THIS, Tab, Key) ->
    corba:call(OE_THIS, dirty_next, [Tab, Key], ?MODULE).

dirty_next(OE_THIS, OE_Options, Tab, Key) ->
    corba:call(OE_THIS, dirty_next, [Tab, Key], ?MODULE, OE_Options).

%%%% Operation: dirty_all_keys
%% 
%%   Returns: RetVal, Keys, Reason
%%
dirty_all_keys(OE_THIS, Tab) ->
    corba:call(OE_THIS, dirty_all_keys, [Tab], ?MODULE).

dirty_all_keys(OE_THIS, OE_Options, Tab) ->
    corba:call(OE_THIS, dirty_all_keys, [Tab], ?MODULE, OE_Options).

%%%% Operation: dirty_match_all
%% 
%%   Returns: RetVal, Result, Reason
%%
dirty_match_all(OE_THIS, Tab) ->
    corba:call(OE_THIS, dirty_match_all, [Tab], ?MODULE).

dirty_match_all(OE_THIS, OE_Options, Tab) ->
    corba:call(OE_THIS, dirty_match_all, [Tab], ?MODULE, OE_Options).

%%%% Operation: dirty_index_read
%% 
%%   Returns: RetVal, Result, Reason
%%
dirty_index_read(OE_THIS, Tab, Key, Pos) ->
    corba:call(OE_THIS, dirty_index_read, [Tab, Key, Pos], ?MODULE).

dirty_index_read(OE_THIS, OE_Options, Tab, Key, Pos) ->
    corba:call(OE_THIS, dirty_index_read, [Tab, Key, Pos], ?MODULE, OE_Options).

%%%% Operation: create_table
%% 
%%   Returns: RetVal, Reason
%%
create_table(OE_THIS, Tab, TabDefs) ->
    corba:call(OE_THIS, create_table, [Tab, TabDefs], ?MODULE).

create_table(OE_THIS, OE_Options, Tab, TabDefs) ->
    corba:call(OE_THIS, create_table, [Tab, TabDefs], ?MODULE, OE_Options).

%%%% Operation: delete_table
%% 
%%   Returns: RetVal, Reason
%%
delete_table(OE_THIS, Tab) ->
    corba:call(OE_THIS, delete_table, [Tab], ?MODULE).

delete_table(OE_THIS, OE_Options, Tab) ->
    corba:call(OE_THIS, delete_table, [Tab], ?MODULE, OE_Options).

%%%% Operation: add_table_copy
%% 
%%   Returns: RetVal, Reason
%%
add_table_copy(OE_THIS, Tab, Node, Type) ->
    corba:call(OE_THIS, add_table_copy, [Tab, Node, Type], ?MODULE).

add_table_copy(OE_THIS, OE_Options, Tab, Node, Type) ->
    corba:call(OE_THIS, add_table_copy, [Tab, Node, Type], ?MODULE, OE_Options).

%%%% Operation: del_table_copy
%% 
%%   Returns: RetVal, Reason
%%
del_table_copy(OE_THIS, Tab, Node) ->
    corba:call(OE_THIS, del_table_copy, [Tab, Node], ?MODULE).

del_table_copy(OE_THIS, OE_Options, Tab, Node) ->
    corba:call(OE_THIS, del_table_copy, [Tab, Node], ?MODULE, OE_Options).

%%%% Operation: move_table_copy
%% 
%%   Returns: RetVal, Reason
%%
move_table_copy(OE_THIS, Tab, From, To) ->
    corba:call(OE_THIS, move_table_copy, [Tab, From, To], ?MODULE).

move_table_copy(OE_THIS, OE_Options, Tab, From, To) ->
    corba:call(OE_THIS, move_table_copy, [Tab, From, To], ?MODULE, OE_Options).

%%%% Operation: add_table_index
%% 
%%   Returns: RetVal, Reason
%%
add_table_index(OE_THIS, Tab, Attrname) ->
    corba:call(OE_THIS, add_table_index, [Tab, Attrname], ?MODULE).

add_table_index(OE_THIS, OE_Options, Tab, Attrname) ->
    corba:call(OE_THIS, add_table_index, [Tab, Attrname], ?MODULE, OE_Options).

%%%% Operation: del_table_index
%% 
%%   Returns: RetVal, Reason
%%
del_table_index(OE_THIS, Tab, Attrname) ->
    corba:call(OE_THIS, del_table_index, [Tab, Attrname], ?MODULE).

del_table_index(OE_THIS, OE_Options, Tab, Attrname) ->
    corba:call(OE_THIS, del_table_index, [Tab, Attrname], ?MODULE, OE_Options).

%%%% Operation: change_table_copy_type
%% 
%%   Returns: RetVal, Reason
%%
change_table_copy_type(OE_THIS, Tab, Node, Type) ->
    corba:call(OE_THIS, change_table_copy_type, [Tab, Node, Type], ?MODULE).

change_table_copy_type(OE_THIS, OE_Options, Tab, Node, Type) ->
    corba:call(OE_THIS, change_table_copy_type, [Tab, Node, Type], ?MODULE, OE_Options).

%%%% Operation: change_table_access_mode
%% 
%%   Returns: RetVal, Reason
%%
change_table_access_mode(OE_THIS, Tab, Mode) ->
    corba:call(OE_THIS, change_table_access_mode, [Tab, Mode], ?MODULE).

change_table_access_mode(OE_THIS, OE_Options, Tab, Mode) ->
    corba:call(OE_THIS, change_table_access_mode, [Tab, Mode], ?MODULE, OE_Options).

%%%% Operation: wait_for_tables
%% 
%%   Returns: RetVal, Failed_tabs, Reason
%%
wait_for_tables(OE_THIS, Tabs, Timeout) ->
    corba:call(OE_THIS, wait_for_tables, [Tabs, Timeout], ?MODULE).

wait_for_tables(OE_THIS, OE_Options, Tabs, Timeout) ->
    corba:call(OE_THIS, wait_for_tables, [Tabs, Timeout], ?MODULE, OE_Options).

%%%% Operation: force_load_table
%% 
%%   Returns: RetVal, Reason
%%
force_load_table(OE_THIS, Tab) ->
    corba:call(OE_THIS, force_load_table, [Tab], ?MODULE).

force_load_table(OE_THIS, OE_Options, Tab) ->
    corba:call(OE_THIS, force_load_table, [Tab], ?MODULE, OE_Options).

%%%% Operation: change_table_load_order
%% 
%%   Returns: RetVal, Reason
%%
change_table_load_order(OE_THIS, Tab, Load_order) ->
    corba:call(OE_THIS, change_table_load_order, [Tab, Load_order], ?MODULE).

change_table_load_order(OE_THIS, OE_Options, Tab, Load_order) ->
    corba:call(OE_THIS, change_table_load_order, [Tab, Load_order], ?MODULE, OE_Options).

%%%% Operation: set_master_nodes1
%% 
%%   Returns: RetVal, Reason
%%
set_master_nodes1(OE_THIS, Nodes) ->
    corba:call(OE_THIS, set_master_nodes1, [Nodes], ?MODULE).

set_master_nodes1(OE_THIS, OE_Options, Nodes) ->
    corba:call(OE_THIS, set_master_nodes1, [Nodes], ?MODULE, OE_Options).

%%%% Operation: set_master_nodes2
%% 
%%   Returns: RetVal, Reason
%%
set_master_nodes2(OE_THIS, Tab, Nodes) ->
    corba:call(OE_THIS, set_master_nodes2, [Tab, Nodes], ?MODULE).

set_master_nodes2(OE_THIS, OE_Options, Tab, Nodes) ->
    corba:call(OE_THIS, set_master_nodes2, [Tab, Nodes], ?MODULE, OE_Options).

%%%% Operation: backup1
%% 
%%   Returns: RetVal, Reason
%%
backup1(OE_THIS, Filename) ->
    corba:call(OE_THIS, backup1, [Filename], ?MODULE).

backup1(OE_THIS, OE_Options, Filename) ->
    corba:call(OE_THIS, backup1, [Filename], ?MODULE, OE_Options).

%%%% Operation: backup2
%% 
%%   Returns: RetVal, Reason
%%
backup2(OE_THIS, Opaque, Modulename) ->
    corba:call(OE_THIS, backup2, [Opaque, Modulename], ?MODULE).

backup2(OE_THIS, OE_Options, Opaque, Modulename) ->
    corba:call(OE_THIS, backup2, [Opaque, Modulename], ?MODULE, OE_Options).

%%%% Operation: install_fallback1
%% 
%%   Returns: RetVal, Reason
%%
install_fallback1(OE_THIS, Filename) ->
    corba:call(OE_THIS, install_fallback1, [Filename], ?MODULE).

install_fallback1(OE_THIS, OE_Options, Filename) ->
    corba:call(OE_THIS, install_fallback1, [Filename], ?MODULE, OE_Options).

%%%% Operation: install_fallback2
%% 
%%   Returns: RetVal, Reason
%%
install_fallback2(OE_THIS, Opaque, Modulename) ->
    corba:call(OE_THIS, install_fallback2, [Opaque, Modulename], ?MODULE).

install_fallback2(OE_THIS, OE_Options, Opaque, Modulename) ->
    corba:call(OE_THIS, install_fallback2, [Opaque, Modulename], ?MODULE, OE_Options).

%%%% Operation: uninstall_fallback
%% 
%%   Returns: RetVal, Reason
%%
uninstall_fallback(OE_THIS) ->
    corba:call(OE_THIS, uninstall_fallback, [], ?MODULE).

uninstall_fallback(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, uninstall_fallback, [], ?MODULE, OE_Options).

%%%% Operation: dump_log
%% 
%%   Returns: RetVal, Reason
%%
dump_log(OE_THIS) ->
    corba:call(OE_THIS, dump_log, [], ?MODULE).

dump_log(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, dump_log, [], ?MODULE, OE_Options).

%%%% Operation: dump_tables
%% 
%%   Returns: RetVal, Reason
%%
dump_tables(OE_THIS, List) ->
    corba:call(OE_THIS, dump_tables, [List], ?MODULE).

dump_tables(OE_THIS, OE_Options, List) ->
    corba:call(OE_THIS, dump_tables, [List], ?MODULE, OE_Options).

%%%% Operation: activate_checkpoint
%% 
%%   Returns: RetVal, Reason
%%
activate_checkpoint(OE_THIS, Cpdef) ->
    corba:call(OE_THIS, activate_checkpoint, [Cpdef], ?MODULE).

activate_checkpoint(OE_THIS, OE_Options, Cpdef) ->
    corba:call(OE_THIS, activate_checkpoint, [Cpdef], ?MODULE, OE_Options).

%%%% Operation: deactivate_checkpoint
%% 
%%   Returns: RetVal, Reason
%%
deactivate_checkpoint(OE_THIS, CpName) ->
    corba:call(OE_THIS, deactivate_checkpoint, [CpName], ?MODULE).

deactivate_checkpoint(OE_THIS, OE_Options, CpName) ->
    corba:call(OE_THIS, deactivate_checkpoint, [CpName], ?MODULE, OE_Options).

%%%% Operation: backup_checkpoint1
%% 
%%   Returns: RetVal, Reason
%%
backup_checkpoint1(OE_THIS, CpName, Filename) ->
    corba:call(OE_THIS, backup_checkpoint1, [CpName, Filename], ?MODULE).

backup_checkpoint1(OE_THIS, OE_Options, CpName, Filename) ->
    corba:call(OE_THIS, backup_checkpoint1, [CpName, Filename], ?MODULE, OE_Options).

%%%% Operation: backup_checkpoint2
%% 
%%   Returns: RetVal, Reason
%%
backup_checkpoint2(OE_THIS, CpName, Opaque, Modulename) ->
    corba:call(OE_THIS, backup_checkpoint2, [CpName, Opaque, Modulename], ?MODULE).

backup_checkpoint2(OE_THIS, OE_Options, CpName, Opaque, Modulename) ->
    corba:call(OE_THIS, backup_checkpoint2, [CpName, Opaque, Modulename], ?MODULE, OE_Options).

%%%% Operation: load_textfile
%% 
%%   Returns: RetVal, Reason
%%
load_textfile(OE_THIS, Filename) ->
    corba:call(OE_THIS, load_textfile, [Filename], ?MODULE).

load_textfile(OE_THIS, OE_Options, Filename) ->
    corba:call(OE_THIS, load_textfile, [Filename], ?MODULE, OE_Options).

%%%% Operation: dump_to_textfile
%% 
%%   Returns: RetVal, Reason
%%
dump_to_textfile(OE_THIS, Filename) ->
    corba:call(OE_THIS, dump_to_textfile, [Filename], ?MODULE).

dump_to_textfile(OE_THIS, OE_Options, Filename) ->
    corba:call(OE_THIS, dump_to_textfile, [Filename], ?MODULE, OE_Options).

%%%% Operation: table_info
%% 
%%   Returns: RetVal, Info, Reason
%%
table_info(OE_THIS, Tab) ->
    corba:call(OE_THIS, table_info, [Tab], ?MODULE).

table_info(OE_THIS, OE_Options, Tab) ->
    corba:call(OE_THIS, table_info, [Tab], ?MODULE, OE_Options).

%%%% Operation: system_info
%% 
%%   Returns: RetVal, Info, Reason
%%
system_info(OE_THIS) ->
    corba:call(OE_THIS, system_info, [], ?MODULE).

system_info(OE_THIS, OE_Options) ->
    corba:call(OE_THIS, system_info, [], ?MODULE, OE_Options).

%%------------------------------------------------------------
%%
%% Inherited Interfaces
%%
%%------------------------------------------------------------
oe_is_a("IDL:mnesia/corba_session:1.0") -> true;
oe_is_a(_) -> false.

%%------------------------------------------------------------
%%
%% Interface TypeCode
%%
%%------------------------------------------------------------
oe_tc(dirty_write) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_any],
         [{tk_string,0}]};
oe_tc(dirty_read) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_any],
         [{tk_sequence,tk_any,0},{tk_string,0}]};
oe_tc(dirty_update_counter) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_any,tk_long],
         [tk_long,{tk_string,0}]};
oe_tc(dirty_delete) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_any],
         [{tk_string,0}]};
oe_tc(dirty_delete_object) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_any],
         [{tk_string,0}]};
oe_tc(dirty_slot) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_long],
         [{tk_sequence,tk_any,0},{tk_string,0}]};
oe_tc(dirty_first) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [tk_any,{tk_string,0}]};
oe_tc(dirty_next) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_any],
         [tk_any,{tk_string,0}]};
oe_tc(dirty_all_keys) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_sequence,tk_any,0},{tk_string,0}]};
oe_tc(dirty_match_all) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_sequence,tk_any,0},{tk_string,0}]};
oe_tc(dirty_index_read) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_any,tk_long],
         [{tk_sequence,tk_any,0},{tk_string,0}]};
oe_tc(create_table) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},
          {tk_struct,"IDL:mnesia/TableDef:1.0",
                     "TableDef",
                     [{"type",
                       {tk_enum,"IDL:mnesia/SetOrBag:1.0",
                                "SetOrBag",
                                ["set","bag"]}},
                      {"mode",
                       {tk_enum,"IDL:mnesia/AccessMode:1.0",
                                "AccessMode",
                                ["read_only","read_write"]}},
                      {"ram_copies",{tk_sequence,{tk_string,0},0}},
                      {"disc_copies",{tk_sequence,{tk_string,0},0}},
                      {"disc_only_copies",{tk_sequence,{tk_string,0},0}},
                      {"index_list",{tk_sequence,tk_long,0}},
                      {"attributes",{tk_sequence,{tk_string,0},0}},
                      {"record_name",{tk_string,0}}]}],
         [{tk_string,0}]};
oe_tc(delete_table) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_string,0}]};
oe_tc(add_table_copy) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},
          {tk_string,0},
          {tk_enum,"IDL:mnesia/Storage:1.0",
                   "Storage",
                   ["ram_copies","disc_copies","disc_only_copies"]}],
         [{tk_string,0}]};
oe_tc(del_table_copy) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},{tk_string,0}],
         [{tk_string,0}]};
oe_tc(move_table_copy) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},{tk_string,0},{tk_string,0}],
         [{tk_string,0}]};
oe_tc(add_table_index) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_long],
         [{tk_string,0}]};
oe_tc(del_table_index) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_long],
         [{tk_string,0}]};
oe_tc(change_table_copy_type) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},
          {tk_string,0},
          {tk_enum,"IDL:mnesia/Storage:1.0",
                   "Storage",
                   ["ram_copies","disc_copies","disc_only_copies"]}],
         [{tk_string,0}]};
oe_tc(change_table_access_mode) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},
          {tk_enum,"IDL:mnesia/AccessMode:1.0",
                   "AccessMode",
                   ["read_only","read_write"]}],
         [{tk_string,0}]};
oe_tc(wait_for_tables) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_sequence,{tk_string,0},0},tk_long],
         [{tk_sequence,{tk_string,0},0},{tk_string,0}]};
oe_tc(force_load_table) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_string,0}]};
oe_tc(change_table_load_order) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_long],
         [{tk_string,0}]};
oe_tc(set_master_nodes1) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_sequence,{tk_string,0},0}],
         [{tk_string,0}]};
oe_tc(set_master_nodes2) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},{tk_sequence,{tk_string,0},0}],
         [{tk_string,0}]};
oe_tc(backup1) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_string,0}]};
oe_tc(backup2) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [tk_any,{tk_string,0}],
         [{tk_string,0}]};
oe_tc(install_fallback1) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_string,0}]};
oe_tc(install_fallback2) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [tk_any,{tk_string,0}],
         [{tk_string,0}]};
oe_tc(uninstall_fallback) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [],
         [{tk_string,0}]};
oe_tc(dump_log) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [],
         [{tk_string,0}]};
oe_tc(dump_tables) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_sequence,{tk_string,0},0}],
         [{tk_string,0}]};
oe_tc(activate_checkpoint) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_struct,"IDL:mnesia/CheckpointDef:1.0",
                     "CheckpointDef",
                     [{"cpName",{tk_string,0}},
                      {"max",{tk_sequence,{tk_string,0},0}},
                      {"min",{tk_sequence,{tk_string,0},0}},
                      {"allow_remote",tk_boolean},
                      {"ram_overrides_dump",tk_boolean}]}],
         [{tk_string,0}]};
oe_tc(deactivate_checkpoint) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_string,0}]};
oe_tc(backup_checkpoint1) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},{tk_string,0}],
         [{tk_string,0}]};
oe_tc(backup_checkpoint2) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0},tk_any,{tk_string,0}],
         [{tk_string,0}]};
oe_tc(load_textfile) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_string,0}]};
oe_tc(dump_to_textfile) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_string,0}]};
oe_tc(table_info) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [{tk_string,0}],
         [{tk_struct,"IDL:mnesia/TableInfo:1.0",
                     "TableInfo",
                     [{"mode",
                       {tk_enum,"IDL:mnesia/AccessMode:1.0",
                                "AccessMode",
                                ["read_only","read_write"]}},
                      {"attributes",{tk_sequence,{tk_string,0},0}},
                      {"arity",tk_long},
                      {"checkpoints",{tk_sequence,{tk_string,0},0}},
                      {"ram_copies",{tk_sequence,{tk_string,0},0}},
                      {"disc_copies",{tk_sequence,{tk_string,0},0}},
                      {"disc_only_copies",{tk_sequence,{tk_string,0},0}},
                      {"indexlist",{tk_sequence,tk_long,0}},
                      {"load_order",tk_long},
                      {"local_content",tk_boolean},
                      {"master_nodes",{tk_sequence,{tk_string,0},0}},
                      {"memory",tk_long},
                      {"size",tk_long},
                      {"storage_type",
                       {tk_enum,"IDL:mnesia/Storage:1.0",
                                "Storage",
                                ["ram_copies",
                                 "disc_copies",
                                 "disc_only_copies"]}},
                      {"type",
                       {tk_enum,"IDL:mnesia/SetOrBag:1.0",
                                "SetOrBag",
                                ["set","bag"]}},
                      {"where_to_read",{tk_string,0}},
                      {"where_to_write",{tk_sequence,{tk_string,0},0}},
                      {"record_name",{tk_string,0}}]},
          {tk_string,0}]};
oe_tc(system_info) -> 
	{{tk_enum,"IDL:mnesia/Status:1.0",
                  "Status",
                  ["ok","end_of_table","timeout","error"]},
         [],
         [{tk_struct,"IDL:mnesia/SystemInfo:1.0",
                     "SystemInfo",
                     [{"auto_repair",tk_boolean},
                      {"backup_module",{tk_string,0}},
                      {"event_module",{tk_string,0}},
                      {"db_nodes",{tk_sequence,{tk_string,0},0}},
                      {"debug",{tk_string,0}},
                      {"directory",{tk_string,0}},
                      {"dump_log_load_regulation",tk_boolean},
                      {"dump_log_time_threshold",tk_long},
                      {"dump_log_update_in_place",tk_boolean},
                      {"dump_log_write_threshold",tk_long},
                      {"extra_db_nodes",{tk_sequence,{tk_string,0},0}},
                      {"is_running",tk_boolean},
                      {"schema_location",{tk_string,0}},
                      {"use_dir",tk_boolean},
                      {"checkpoints",{tk_sequence,{tk_string,0},0}},
                      {"fallback_activated",tk_boolean},
                      {"local_tables",{tk_sequence,{tk_string,0},0}},
                      {"master_node_tables",{tk_sequence,{tk_string,0},0}},
                      {"running_db_nodes",{tk_sequence,{tk_string,0},0}},
                      {"tables",{tk_sequence,{tk_string,0},0}},
                      {"transaction_failures",tk_long},
                      {"transaction_commits",tk_long},
                      {"transaction_restarts",tk_long},
                      {"transaction_log_writes",tk_long}]},
          {tk_string,0}]};
oe_tc(_) -> undefined.

oe_get_interface() -> 
	[{"system_info", oe_tc(system_info)},
	{"table_info", oe_tc(table_info)},
	{"dump_to_textfile", oe_tc(dump_to_textfile)},
	{"load_textfile", oe_tc(load_textfile)},
	{"backup_checkpoint2", oe_tc(backup_checkpoint2)},
	{"backup_checkpoint1", oe_tc(backup_checkpoint1)},
	{"deactivate_checkpoint", oe_tc(deactivate_checkpoint)},
	{"activate_checkpoint", oe_tc(activate_checkpoint)},
	{"dump_tables", oe_tc(dump_tables)},
	{"dump_log", oe_tc(dump_log)},
	{"uninstall_fallback", oe_tc(uninstall_fallback)},
	{"install_fallback2", oe_tc(install_fallback2)},
	{"install_fallback1", oe_tc(install_fallback1)},
	{"backup2", oe_tc(backup2)},
	{"backup1", oe_tc(backup1)},
	{"set_master_nodes2", oe_tc(set_master_nodes2)},
	{"set_master_nodes1", oe_tc(set_master_nodes1)},
	{"change_table_load_order", oe_tc(change_table_load_order)},
	{"force_load_table", oe_tc(force_load_table)},
	{"wait_for_tables", oe_tc(wait_for_tables)},
	{"change_table_access_mode", oe_tc(change_table_access_mode)},
	{"change_table_copy_type", oe_tc(change_table_copy_type)},
	{"del_table_index", oe_tc(del_table_index)},
	{"add_table_index", oe_tc(add_table_index)},
	{"move_table_copy", oe_tc(move_table_copy)},
	{"del_table_copy", oe_tc(del_table_copy)},
	{"add_table_copy", oe_tc(add_table_copy)},
	{"delete_table", oe_tc(delete_table)},
	{"create_table", oe_tc(create_table)},
	{"dirty_index_read", oe_tc(dirty_index_read)},
	{"dirty_match_all", oe_tc(dirty_match_all)},
	{"dirty_all_keys", oe_tc(dirty_all_keys)},
	{"dirty_next", oe_tc(dirty_next)},
	{"dirty_first", oe_tc(dirty_first)},
	{"dirty_slot", oe_tc(dirty_slot)},
	{"dirty_delete_object", oe_tc(dirty_delete_object)},
	{"dirty_delete", oe_tc(dirty_delete)},
	{"dirty_update_counter", oe_tc(dirty_update_counter)},
	{"dirty_read", oe_tc(dirty_read)},
	{"dirty_write", oe_tc(dirty_write)}].




%%------------------------------------------------------------
%%
%% Object server implementation.
%%
%%------------------------------------------------------------


%%------------------------------------------------------------
%%
%% Function for fetching the interface type ID.
%%
%%------------------------------------------------------------

typeID() ->
    "IDL:mnesia/corba_session:1.0".


%%------------------------------------------------------------
%%
%% Object creation functions.
%%
%%------------------------------------------------------------

oe_create() ->
    corba:create(?MODULE, "IDL:mnesia/corba_session:1.0").

oe_create_link() ->
    corba:create_link(?MODULE, "IDL:mnesia/corba_session:1.0").

oe_create(Env) ->
    corba:create(?MODULE, "IDL:mnesia/corba_session:1.0", Env).

oe_create_link(Env) ->
    corba:create_link(?MODULE, "IDL:mnesia/corba_session:1.0", Env).

oe_create(Env, RegName) ->
    corba:create(?MODULE, "IDL:mnesia/corba_session:1.0", Env, RegName).

oe_create_link(Env, RegName) ->
    corba:create_link(?MODULE, "IDL:mnesia/corba_session:1.0", Env, RegName).

%%------------------------------------------------------------
%%
%% Init & terminate functions.
%%
%%------------------------------------------------------------

init(Env) ->
%% Call to implementation init
    corba:handle_init(mnesia_corba_session_impl, Env).

terminate(Reason, State) ->
    corba:handle_terminate(mnesia_corba_session_impl, Reason, State).


%%%% Operation: dirty_write
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_write, [Tab, Object]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_write, [Tab, Object], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_read
%% 
%%   Returns: RetVal, Result, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_read, [Tab, Key]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_read, [Tab, Key], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_update_counter
%% 
%%   Returns: RetVal, Newval, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_update_counter, [Tab, Key, Val]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_update_counter, [Tab, Key, Val], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_delete
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_delete, [Tab, Key]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_delete, [Tab, Key], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_delete_object
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_delete_object, [Tab, Object]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_delete_object, [Tab, Object], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_slot
%% 
%%   Returns: RetVal, Result, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_slot, [Tab, Slot]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_slot, [Tab, Slot], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_first
%% 
%%   Returns: RetVal, Next_key, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_first, [Tab]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_first, [Tab], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_next
%% 
%%   Returns: RetVal, Next_key, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_next, [Tab, Key]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_next, [Tab, Key], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_all_keys
%% 
%%   Returns: RetVal, Keys, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_all_keys, [Tab]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_all_keys, [Tab], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_match_all
%% 
%%   Returns: RetVal, Result, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_match_all, [Tab]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_match_all, [Tab], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dirty_index_read
%% 
%%   Returns: RetVal, Result, Reason
%%
handle_call({OE_THIS, OE_Context, dirty_index_read, [Tab, Key, Pos]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dirty_index_read, [Tab, Key, Pos], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: create_table
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, create_table, [Tab, TabDefs]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, create_table, [Tab, TabDefs], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: delete_table
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, delete_table, [Tab]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, delete_table, [Tab], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: add_table_copy
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, add_table_copy, [Tab, Node, Type]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, add_table_copy, [Tab, Node, Type], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: del_table_copy
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, del_table_copy, [Tab, Node]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, del_table_copy, [Tab, Node], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: move_table_copy
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, move_table_copy, [Tab, From, To]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, move_table_copy, [Tab, From, To], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: add_table_index
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, add_table_index, [Tab, Attrname]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, add_table_index, [Tab, Attrname], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: del_table_index
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, del_table_index, [Tab, Attrname]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, del_table_index, [Tab, Attrname], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: change_table_copy_type
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, change_table_copy_type, [Tab, Node, Type]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, change_table_copy_type, [Tab, Node, Type], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: change_table_access_mode
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, change_table_access_mode, [Tab, Mode]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, change_table_access_mode, [Tab, Mode], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: wait_for_tables
%% 
%%   Returns: RetVal, Failed_tabs, Reason
%%
handle_call({OE_THIS, OE_Context, wait_for_tables, [Tabs, Timeout]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, wait_for_tables, [Tabs, Timeout], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: force_load_table
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, force_load_table, [Tab]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, force_load_table, [Tab], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: change_table_load_order
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, change_table_load_order, [Tab, Load_order]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, change_table_load_order, [Tab, Load_order], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: set_master_nodes1
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, set_master_nodes1, [Nodes]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, set_master_nodes1, [Nodes], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: set_master_nodes2
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, set_master_nodes2, [Tab, Nodes]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, set_master_nodes2, [Tab, Nodes], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: backup1
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, backup1, [Filename]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, backup1, [Filename], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: backup2
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, backup2, [Opaque, Modulename]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, backup2, [Opaque, Modulename], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: install_fallback1
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, install_fallback1, [Filename]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, install_fallback1, [Filename], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: install_fallback2
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, install_fallback2, [Opaque, Modulename]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, install_fallback2, [Opaque, Modulename], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: uninstall_fallback
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, uninstall_fallback, []}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, uninstall_fallback, [], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dump_log
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, dump_log, []}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dump_log, [], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dump_tables
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, dump_tables, [List]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dump_tables, [List], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: activate_checkpoint
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, activate_checkpoint, [Cpdef]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, activate_checkpoint, [Cpdef], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: deactivate_checkpoint
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, deactivate_checkpoint, [CpName]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, deactivate_checkpoint, [CpName], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: backup_checkpoint1
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, backup_checkpoint1, [CpName, Filename]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, backup_checkpoint1, [CpName, Filename], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: backup_checkpoint2
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, backup_checkpoint2, [CpName, Opaque, Modulename]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, backup_checkpoint2, [CpName, Opaque, Modulename], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: load_textfile
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, load_textfile, [Filename]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, load_textfile, [Filename], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: dump_to_textfile
%% 
%%   Returns: RetVal, Reason
%%
handle_call({OE_THIS, OE_Context, dump_to_textfile, [Filename]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, dump_to_textfile, [Filename], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: table_info
%% 
%%   Returns: RetVal, Info, Reason
%%
handle_call({OE_THIS, OE_Context, table_info, [Tab]}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, table_info, [Tab], OE_State, OE_Context, OE_THIS, false);

%%%% Operation: system_info
%% 
%%   Returns: RetVal, Info, Reason
%%
handle_call({OE_THIS, OE_Context, system_info, []}, _, OE_State) ->
  corba:handle_call(mnesia_corba_session_impl, system_info, [], OE_State, OE_Context, OE_THIS, false);



%%%% Standard gen_server call handle
%%
handle_call(stop, _, State) ->
    {stop, normal, ok, State};

handle_call(_, _, State) ->
    {reply, catch corba:raise(#'BAD_OPERATION'{minor=1163001857, completion_status='COMPLETED_NO'}), State}.


%%%% Standard gen_server cast handle
%%
handle_cast(stop, State) ->
    {stop, normal, State};

handle_cast(_, State) ->
    {noreply, State}.


%%%% Standard gen_server handles
%%
handle_info(_, State) ->
    {noreply, State}.


code_change(OldVsn, State, Extra) ->
    corba:handle_code_change(mnesia_corba_session_impl, OldVsn, State, Extra).

