/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;

public class ContentComparator {
    private boolean ignoreWhitespace = false;

    public ContentComparator(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    /*
     * Loose catch block
     */
    public boolean compare(Object e1, Object e2, IProgressMonitor monitor) {
        InputStream is1 = null;
        InputStream is2 = null;
        monitor.beginTask(null, 100);
        is1 = this.getContents(e1, Policy.subMonitorFor(monitor, 50));
        is2 = this.getContents(e2, Policy.subMonitorFor(monitor, 50));
        boolean bl = this.contentsEqual(is1, is2, this.shouldIgnoreWhitespace());
        try {
            try {
                if (is1 != null) {
                    is1.close();
                }
            }
            finally {
                if (is2 != null) {
                    is2.close();
                }
            }
        }
        catch (IOException iOException) {}
        monitor.done();
        return bl;
        catch (TeamException e) {
            try {
                TeamPlugin.log(e);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (is1 != null) {
                            is1.close();
                        }
                    }
                    finally {
                        if (is2 != null) {
                            is2.close();
                        }
                    }
                }
                catch (IOException iOException) {}
                monitor.done();
                throw throwable;
            }
            try {
                try {
                    if (is1 != null) {
                        is1.close();
                    }
                }
                finally {
                    if (is2 != null) {
                        is2.close();
                    }
                }
            }
            catch (IOException iOException) {}
            monitor.done();
            return false;
        }
    }

    protected boolean shouldIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    /*
     * Unable to fully structure code
     */
    private boolean contentsEqual(InputStream is1, InputStream is2, boolean ignoreWhitespace) {
        block40: {
            block38: {
                if (is1 != is2) break block38;
lbl3:
                // 3 sources

                while (true) {
                    try {
                        try {
                            if (is1 != null) {
                                is1.close();
                            }
                        }
                        finally {
                            if (is2 != null) {
                                is2.close();
                            }
                        }
                    }
                    catch (IOException v0) {}
                    return true;
                }
            }
            if (is1 == null && is2 == null) ** GOTO lbl3
            if (is1 != null && is2 != null) break block40;
            try {
                try {
                    if (is1 != null) {
                        is1.close();
                    }
                }
                finally {
                    if (is2 != null) {
                        is2.close();
                    }
                }
            }
            catch (IOException v1) {}
            return false;
        }
        try {
            try {
                do {
                    c1 = is1.read();
                    while (this.shouldIgnoreWhitespace() && this.isWhitespace(c1)) {
                        c1 = is1.read();
                    }
                    c2 = is2.read();
                    while (this.shouldIgnoreWhitespace() && this.isWhitespace(c2)) {
                        c2 = is2.read();
                    }
                    if (c1 != -1 || c2 != -1) ** break;
                    ** continue;
                } while (c1 == c2);
            }
            catch (IOException v2) {}
        }
        catch (Throwable var6_10) {
            try {
                try {
                    if (is1 != null) {
                        is1.close();
                    }
                }
                finally {
                    if (is2 != null) {
                        is2.close();
                    }
                }
            }
            catch (IOException v3) {}
            throw var6_10;
        }
        try {
            try {
                if (is1 != null) {
                    is1.close();
                }
            }
            finally {
                if (is2 != null) {
                    is2.close();
                }
            }
        }
        catch (IOException v4) {}
        return false;
    }

    private boolean isWhitespace(int c) {
        if (c == -1) {
            return false;
        }
        return Character.isWhitespace((char)c);
    }

    private InputStream getContents(Object resource, IProgressMonitor monitor) throws TeamException {
        try {
            if (resource instanceof IFile) {
                return new BufferedInputStream(((IFile)resource).getContents());
            }
            if (resource instanceof IResourceVariant) {
                IResourceVariant remote = (IResourceVariant)resource;
                if (!remote.isContainer()) {
                    return new BufferedInputStream(remote.getStorage(monitor).getContents());
                }
            } else if (resource instanceof IFileRevision) {
                IFileRevision remote = (IFileRevision)resource;
                return new BufferedInputStream(remote.getStorage(monitor).getContents());
            }
            return null;
        }
        catch (CoreException e) {
            throw TeamException.asTeamException(e);
        }
    }
}

