/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.swt.graphics.Image;

public class AssignToVariableAssistProposal
extends LinkedCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    private final String KEY_NAME = "name";
    private final String KEY_TYPE = "type";
    private final int fVariableKind;
    private final ASTNode fNodeToAssign;
    private final ITypeBinding fTypeBinding;
    private VariableDeclarationFragment fExistingFragment;

    public AssignToVariableAssistProposal(ICompilationUnit cu, int variableKind, ExpressionStatement node, ITypeBinding typeBinding, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fVariableKind = variableKind;
        this.fNodeToAssign = node;
        if (typeBinding.isWildcardType()) {
            typeBinding = ASTResolving.normalizeWildcardType(typeBinding, true, node.getAST());
        }
        this.fTypeBinding = typeBinding;
        if (variableKind == 1) {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assigntolocal_description);
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif"));
        } else {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assigntofield_description);
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
        }
        this.createImportRewrite((CompilationUnit)node.getRoot());
    }

    public AssignToVariableAssistProposal(ICompilationUnit cu, SingleVariableDeclaration parameter, VariableDeclarationFragment existingFragment, ITypeBinding typeBinding, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fVariableKind = 2;
        this.fNodeToAssign = parameter;
        this.fTypeBinding = typeBinding;
        this.fExistingFragment = existingFragment;
        if (existingFragment == null) {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assignparamtofield_description);
        } else {
            this.setDisplayName(Messages.format(CorrectionMessages.AssignToVariableAssistProposal_assigntoexistingfield_description, existingFragment.getName().getIdentifier()));
        }
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.field_private_obj.gif"));
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fVariableKind == 2) {
            return this.doAddField();
        }
        return this.doAddLocal();
    }

    private ASTRewrite doAddLocal() throws CoreException {
        Expression expression = ((ExpressionStatement)this.fNodeToAssign).getExpression();
        AST ast = this.fNodeToAssign.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((CompilationUnit)this.fNodeToAssign.getRoot());
        String[] varNames = this.suggestLocalVariableNames(this.fTypeBinding, expression);
        int i = 0;
        while (i < varNames.length) {
            this.addLinkedPositionProposal("name", varNames[i], null);
            ++i;
        }
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varNames[0]));
        newDeclFrag.setInitializer((Expression)rewrite.createCopyTarget((ASTNode)expression));
        VariableDeclarationExpression newDecl = ast.newVariableDeclarationExpression(newDeclFrag);
        Type type = this.evaluateType(ast);
        newDecl.setType(type);
        rewrite.replace((ASTNode)expression, (ASTNode)newDecl, null);
        this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), true, "name");
        this.addLinkedPosition(rewrite.track((ASTNode)newDecl.getType()), false, "type");
        this.setEndPosition(rewrite.track(this.fNodeToAssign));
        return rewrite;
    }

    private ASTRewrite doAddField() throws CoreException {
        ASTNode selectionNode;
        Block body;
        boolean isParamToField = this.fNodeToAssign.getNodeType() == 44;
        ASTNode newTypeDecl = ASTResolving.findParentType(this.fNodeToAssign);
        if (newTypeDecl == null) {
            return null;
        }
        SimpleName expression = isParamToField ? ((SingleVariableDeclaration)this.fNodeToAssign).getName() : ((ExpressionStatement)this.fNodeToAssign).getExpression();
        AST ast = newTypeDecl.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        this.createImportRewrite((CompilationUnit)this.fNodeToAssign.getRoot());
        BodyDeclaration bodyDecl = ASTResolving.findParentBodyDeclaration(this.fNodeToAssign);
        if (bodyDecl instanceof MethodDeclaration) {
            body = ((MethodDeclaration)bodyDecl).getBody();
        } else if (bodyDecl instanceof Initializer) {
            body = ((Initializer)bodyDecl).getBody();
        } else {
            return null;
        }
        boolean isAnonymous = newTypeDecl.getNodeType() == 1;
        boolean isStatic = Modifier.isStatic((int)bodyDecl.getModifiers()) && !isAnonymous;
        boolean isConstructorParam = isParamToField && this.fNodeToAssign.getParent() instanceof MethodDeclaration && ((MethodDeclaration)this.fNodeToAssign.getParent()).isConstructor();
        int modifiers = 2;
        if (isStatic) {
            modifiers |= 8;
        } else if (isConstructorParam) {
            modifiers |= 0x10;
        }
        VariableDeclarationFragment newDeclFrag = this.addFieldDeclaration(rewrite, newTypeDecl, modifiers, (Expression)expression);
        String varName = newDeclFrag.getName().getIdentifier();
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide((Expression)rewrite.createCopyTarget((ASTNode)expression));
        boolean needsThis = StubUtility.useThisForFieldAccess(this.getCompilationUnit().getJavaProject());
        if (isParamToField) {
            needsThis |= varName.equals(expression.getIdentifier());
        }
        SimpleName accessName = ast.newSimpleName(varName);
        if (needsThis) {
            FieldAccess fieldAccess = ast.newFieldAccess();
            fieldAccess.setName(accessName);
            if (isStatic) {
                String typeName = ((AbstractTypeDeclaration)newTypeDecl).getName().getIdentifier();
                fieldAccess.setExpression((Expression)ast.newSimpleName(typeName));
            } else {
                fieldAccess.setExpression((Expression)ast.newThisExpression());
            }
            assignment.setLeftHandSide((Expression)fieldAccess);
        } else {
            assignment.setLeftHandSide((Expression)accessName);
        }
        if (isParamToField) {
            ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
            int insertIdx = this.findAssignmentInsertIndex(body.statements());
            rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)statement, insertIdx, null);
            selectionNode = statement;
        } else {
            rewrite.replace((ASTNode)expression, (ASTNode)assignment, null);
            selectionNode = this.fNodeToAssign;
        }
        this.addLinkedPosition(rewrite.track((ASTNode)newDeclFrag.getName()), false, "name");
        if (!isParamToField) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)newDeclFrag.getParent();
            this.addLinkedPosition(rewrite.track((ASTNode)fieldDeclaration.getType()), false, "type");
        }
        this.addLinkedPosition(rewrite.track((ASTNode)accessName), true, "name");
        this.setEndPosition(rewrite.track(selectionNode));
        return rewrite;
    }

    private VariableDeclarationFragment addFieldDeclaration(ASTRewrite rewrite, ASTNode newTypeDecl, int modifiers, Expression expression) throws CoreException {
        if (this.fExistingFragment != null) {
            return this.fExistingFragment;
        }
        ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty(newTypeDecl);
        List decls = (List)newTypeDecl.getStructuralProperty((StructuralPropertyDescriptor)property);
        AST ast = newTypeDecl.getAST();
        String[] varNames = this.suggestFieldNames(this.fTypeBinding, expression, modifiers);
        int i = 0;
        while (i < varNames.length) {
            this.addLinkedPositionProposal("name", varNames[i], null);
            ++i;
        }
        String varName = varNames[0];
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varName));
        FieldDeclaration newDecl = ast.newFieldDeclaration(newDeclFrag);
        Type type = this.evaluateType(ast);
        newDecl.setType(type);
        newDecl.modifiers().addAll(ASTNodeFactory.newModifiers(ast, modifiers));
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this, rewrite, newDecl.modifiers(), false);
        int insertIndex = this.findFieldInsertIndex(decls, this.fNodeToAssign.getStartPosition());
        rewrite.getListRewrite(newTypeDecl, property).insertAt((ASTNode)newDecl, insertIndex, null);
        return newDeclFrag;
    }

    private Type evaluateType(AST ast) throws CoreException {
        ITypeBinding[] proposals = ASTResolving.getRelaxingTypes(ast, this.fTypeBinding);
        int i = 0;
        while (i < proposals.length) {
            this.addLinkedPositionProposal("type", proposals[i]);
            ++i;
        }
        return this.getImportRewrite().addImport(this.fTypeBinding, ast);
    }

    private String[] suggestLocalVariableNames(ITypeBinding binding, Expression expression) {
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        String[] excludedNames = this.getUsedVariableNames();
        return ASTResolving.suggestLocalVariableNames(project, binding, expression, excludedNames);
    }

    private String[] suggestFieldNames(ITypeBinding binding, Expression expression, int modifiers) {
        ArrayList<String> res = new ArrayList<String>();
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        ITypeBinding base = binding.isArray() ? binding.getElementType() : binding;
        IPackageBinding packBinding = base.getPackage();
        String packName = packBinding != null ? packBinding.getName() : "";
        String[] excludedNames = this.getUsedVariableNames();
        String name = ASTResolving.getBaseNameFromExpression(project, expression);
        if (name != null) {
            String[] argname = StubUtility.getFieldNameSuggestions(project, name, 0, modifiers, excludedNames);
            int i = 0;
            while (i < argname.length) {
                String curr = argname[i];
                if (!res.contains(curr)) {
                    res.add(curr);
                }
                ++i;
            }
        }
        String typeName = base.getName();
        String[] names = NamingConventions.suggestFieldNames((IJavaProject)project, (String)packName, (String)typeName, (int)binding.getDimensions(), (int)modifiers, (String[])excludedNames);
        int i = 0;
        while (i < names.length) {
            String curr = names[i];
            if (!res.contains(curr)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new String[res.size()]);
    }

    private String[] getUsedVariableNames() {
        return ASTResolving.getUsedVariableNames(this.fNodeToAssign);
    }

    private int findAssignmentInsertIndex(List statements) {
        HashSet<String> paramsBefore = new HashSet<String>();
        List params = ((MethodDeclaration)this.fNodeToAssign.getParent()).parameters();
        int i = 0;
        while (i < params.size() && params.get(i) != this.fNodeToAssign) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)params.get(i);
            paramsBefore.add(decl.getName().getIdentifier());
            ++i;
        }
        i = 0;
        i = 0;
        while (i < statements.size()) {
            Statement curr = (Statement)statements.get(i);
            switch (curr.getNodeType()) {
                case 17: 
                case 46: {
                    break;
                }
                case 21: {
                    IVariableBinding binding;
                    Assignment assignment;
                    Expression rightHand;
                    Expression expr = ((ExpressionStatement)curr).getExpression();
                    if (expr instanceof Assignment && (rightHand = (assignment = (Assignment)expr).getRightHandSide()) instanceof SimpleName && paramsBefore.contains(((SimpleName)rightHand).getIdentifier()) && ((binding = Bindings.getAssignedVariable(assignment)) == null || binding.isField())) break;
                    return i;
                }
                default: {
                    return i;
                }
            }
            ++i;
        }
        return i;
    }

    private int findFieldInsertIndex(List decls, int currPos) {
        int i = decls.size() - 1;
        while (i >= 0) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FieldDeclaration && currPos > curr.getStartPosition() + curr.getLength()) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

