/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.HistoryItem;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryActionImpl;
import org.eclipse.jdt.internal.ui.compare.JavaTextBufferNode;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;

class JavaReplaceWithEditionActionImpl
extends JavaHistoryActionImpl {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.ReplaceWithEditionAction";
    protected boolean fPrevious = false;

    JavaReplaceWithEditionActionImpl(boolean previous) {
        super(true);
        this.fPrevious = previous;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(ISelection selection) {
        block25: {
            block26: {
                block24: {
                    block23: {
                        errorTitle = CompareMessages.ReplaceFromHistory_title;
                        errorMessage = CompareMessages.ReplaceFromHistory_internalErrorMessage;
                        shell = this.getShell();
                        input = this.getEditionElement(selection);
                        if (input == null) {
                            invalidSelectionMessage = CompareMessages.ReplaceFromHistory_invalidSelectionMessage;
                            MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)invalidSelectionMessage);
                            return;
                        }
                        file = this.getFile(input);
                        if (file == null) {
                            MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                            return;
                        }
                        status = Resources.makeCommittable((IResource)file, (Object)shell);
                        if (!status.isOK()) {
                            return;
                        }
                        inEditor = this.beingEdited(file);
                        path = file.getFullPath();
                        bufferManager = FileBuffers.getTextFileBufferManager();
                        textFileBuffer = null;
                        try {
                            bufferManager.connect(path, null);
                            textFileBuffer = bufferManager.getTextFileBuffer(path);
                            document = textFileBuffer.getDocument();
                            bundle = ResourceBundle.getBundle("org.eclipse.jdt.internal.ui.compare.ReplaceWithEditionAction");
                            d = new EditionSelectionDialog(shell, bundle);
                            d.setHelpContextId("org.eclipse.jdt.ui.replace_element_with_history_dialog_context");
                            target = new JavaTextBufferNode(file, document, inEditor);
                            editions = this.buildEditions(target, file);
                            ti = null;
                            if (!this.fPrevious) break block23;
                            ti = d.selectPreviousEdition((ITypedElement)target, editions, (Object)input);
                            if (ti != null) break block24;
                            MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)CompareMessages.ReplaceFromHistory_parsingErrorMessage);
                        }
                        catch (Throwable var29_35) {
                            try {
                                if (textFileBuffer == null) throw var29_35;
                                bufferManager.disconnect(path, null);
                                throw var29_35;
                            }
                            catch (CoreException e) {
                                JavaPlugin.log(e);
                            }
                            throw var29_35;
                        }
                        {
                            catch (InvocationTargetException ex) {
                                ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                                break block25;
                            }
                            catch (InterruptedException v0) {
                                Assert.isTrue((boolean)false);
                                break block25;
                            }
                            catch (CoreException ex) {
                                ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                                break block25;
                            }
                        }
lbl53:
                        // 3 sources

                        while (true) {
                            try {
                                if (textFileBuffer == null) return;
                                bufferManager.disconnect(path, null);
                                return;
                            }
                            catch (CoreException e) {
                                JavaPlugin.log(e);
                            }
                            return;
                        }
                    }
                    ti = d.selectEdition((ITypedElement)target, editions, (Object)input);
                }
                if (!(ti instanceof IStreamContentAccessor)) break block25;
                content = JavaCompareUtilities.readString((IStreamContentAccessor)ti);
                newContent = JavaReplaceWithEditionActionImpl.trimTextBlock(content, TextUtilities.getDefaultLineDelimiter((IDocument)document), input.getJavaProject());
                if (newContent != null) break block26;
                MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                ** GOTO lbl53
            }
            compilationUnit = input.getCompilationUnit();
            root = JavaReplaceWithEditionActionImpl.parsePartialCompilationUnit(compilationUnit);
            nameRange = input.getNameRange();
            length = nameRange.getLength();
            if (length < 0) {
                length = 1;
            }
            if ((node = ASTNodes.getParent(node2 = NodeFinder.perform((ASTNode)root, new SourceRange(nameRange.getOffset(), length)), BodyDeclaration.class)) == null) {
                node = ASTNodes.getParent(node2, AnnotationTypeDeclaration.class);
            }
            if (node == null) {
                node = ASTNodes.getParent(node2, EnumDeclaration.class);
            }
            if (node == null) {
                MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                ** continue;
            }
            rewriter = ASTRewrite.create((AST)root.getAST());
            rewriter.replace(node, rewriter.createStringPlaceholder(newContent, node.getNodeType()), null);
            if (inEditor && (je = this.getEditor(file)) != null) {
                je.setFocus();
            }
            options = null;
            javaProject = compilationUnit.getJavaProject();
            if (javaProject != null) {
                options = javaProject.getOptions(true);
            }
            this.applyChanges(rewriter, document, textFileBuffer, shell, inEditor, options);
        }
        try {
            if (textFileBuffer == null) return;
            bufferManager.disconnect(path, null);
            return;
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    protected ITypedElement[] buildEditions(ITypedElement target, IFile file, IFileState[] states) {
        ITypedElement[] editions = new ITypedElement[states.length + 1];
        editions[0] = new ResourceNode((IResource)file);
        int i = 0;
        while (i < states.length) {
            editions[i + 1] = new HistoryItem(target, states[i]);
            ++i;
        }
        return editions;
    }
}

