/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.generics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ParameterizedType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ArrayElementVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ArrayTypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ImmutableTypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.IndependentTypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ParameterTypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ParameterizedTypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ReturnTypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.SubTypeConstraint2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TypeVariable2;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.VariableVariable2;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;

public class InferTypeArgumentsTCModel {
    protected static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/TypeConstraints"));
    private static final String INDEXED_COLLECTION_ELEMENTS = "IndexedCollectionElements";
    private static final String ARRAY_ELEMENT = "ArrayElement";
    private static final String USED_IN = "UsedIn";
    private static final String METHOD_RECEIVER = "MethodReceiver";
    private static final Map EMPTY_COLLECTION_ELEMENT_VARIABLES_MAP = Collections.EMPTY_MAP;
    protected static boolean fStoreToString = DEBUG;
    private HashMap fConstraintVariables;
    private HashMap fTypeConstraints;
    private Collection fCastVariables;
    private HashSet fCuScopedConstraintVariables;
    private TypeEnvironment fTypeEnvironment;
    private static final int MAX_TTYPE_CACHE = 1024;
    private Map fTTypeCache = new LinkedHashMap(1024, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1024;
        }
    };

    public InferTypeArgumentsTCModel() {
        this.fTypeConstraints = new HashMap();
        this.fConstraintVariables = new HashMap();
        this.fCastVariables = new ArrayList();
        this.fCuScopedConstraintVariables = new HashSet();
        this.fTypeEnvironment = new TypeEnvironment(true);
    }

    protected boolean keep(ConstraintVariable2 cv1, ConstraintVariable2 cv2) {
        if (cv1 == null || cv2 == null) {
            return false;
        }
        if (cv1.equals(cv2)) {
            if (cv1 == cv2) {
                return false;
            }
            Assert.isTrue((boolean)false);
        }
        if (cv1 instanceof CollectionElementVariable2 || cv2 instanceof CollectionElementVariable2) {
            return true;
        }
        if (cv1 instanceof IndependentTypeVariable2 || cv2 instanceof IndependentTypeVariable2) {
            return true;
        }
        if (InferTypeArgumentsTCModel.isAGenericType(cv1.getType())) {
            return true;
        }
        return InferTypeArgumentsTCModel.isAGenericType(cv2.getType());
    }

    public List getUsedIn(ConstraintVariable2 cv) {
        Object usedIn = cv.getData(USED_IN);
        if (usedIn == null) {
            return Collections.EMPTY_LIST;
        }
        if (usedIn instanceof ArrayList) {
            return Collections.unmodifiableList((ArrayList)usedIn);
        }
        return Collections.singletonList(usedIn);
    }

    public void newCu() {
        this.pruneUnusedCuScopedCvs();
        this.fCuScopedConstraintVariables.clear();
        this.fTTypeCache.clear();
    }

    private void pruneUnusedCuScopedCvs() {
        for (ConstraintVariable2 cv : this.fCuScopedConstraintVariables) {
            this.pruneCvIfUnused(cv);
        }
    }

    private boolean pruneCvIfUnused(ConstraintVariable2 cv) {
        if (this.getUsedIn(cv).size() != 0) {
            return false;
        }
        if (cv.getTypeEquivalenceSet() != null && cv.getTypeEquivalenceSet().getContributingVariables().length > 0) {
            return false;
        }
        ArrayElementVariable2 arrayElementVariable = this.getArrayElementVariable(cv);
        if (arrayElementVariable != null && !this.pruneCvIfUnused(arrayElementVariable)) {
            return false;
        }
        Map elementVariables = this.getElementVariables(cv);
        for (CollectionElementVariable2 elementVariable : elementVariables.values()) {
            if (this.pruneCvIfUnused(elementVariable)) continue;
            return false;
        }
        this.fConstraintVariables.remove(cv);
        return true;
    }

    public ConstraintVariable2[] getAllConstraintVariables() {
        ConstraintVariable2[] result = new ConstraintVariable2[this.fConstraintVariables.size()];
        int i = 0;
        Iterator iter = this.fConstraintVariables.keySet().iterator();
        while (iter.hasNext()) {
            result[i] = (ConstraintVariable2)iter.next();
            ++i;
        }
        return result;
    }

    public ITypeConstraint2[] getAllTypeConstraints() {
        Set typeConstraints = this.fTypeConstraints.keySet();
        return typeConstraints.toArray(new ITypeConstraint2[typeConstraints.size()]);
    }

    public CastVariable2[] getCastVariables() {
        return this.fCastVariables.toArray(new CastVariable2[this.fCastVariables.size()]);
    }

    public static void setStoreToString(boolean store) {
        fStoreToString = store;
    }

    public void createSubtypeConstraint(ConstraintVariable2 cv1, ConstraintVariable2 cv2) {
        ConstraintVariable2 storedCv2;
        if (!this.keep(cv1, cv2)) {
            return;
        }
        ConstraintVariable2 storedCv1 = this.storedCv(cv1);
        ITypeConstraint2 typeConstraint = new SubTypeConstraint2(storedCv1, storedCv2 = this.storedCv(cv2));
        Object storedTc = this.fTypeConstraints.get(typeConstraint);
        if (storedTc == null) {
            this.fTypeConstraints.put(typeConstraint, typeConstraint);
        } else {
            typeConstraint = (ITypeConstraint2)storedTc;
        }
        this.registerCvWithTc(storedCv1, typeConstraint);
        this.registerCvWithTc(storedCv2, typeConstraint);
    }

    private ConstraintVariable2 storedCv(ConstraintVariable2 cv) {
        Object stored = this.fConstraintVariables.get(cv);
        if (stored == null) {
            this.fConstraintVariables.put(cv, cv);
            return cv;
        }
        return (ConstraintVariable2)stored;
    }

    private void registerCvWithTc(ConstraintVariable2 storedCv, ITypeConstraint2 typeConstraint) {
        Object usedIn = storedCv.getData(USED_IN);
        if (usedIn == null) {
            storedCv.setData(USED_IN, typeConstraint);
        } else if (usedIn instanceof ArrayList) {
            ArrayList usedInList = (ArrayList)usedIn;
            usedInList.add(typeConstraint);
        } else {
            ArrayList<Object> usedInList = new ArrayList<Object>(2);
            usedInList.add(usedIn);
            usedInList.add(typeConstraint);
            storedCv.setData(USED_IN, usedInList);
        }
    }

    public void createEqualsConstraint(ConstraintVariable2 leftElement, ConstraintVariable2 rightElement) {
        if (leftElement == null || rightElement == null) {
            return;
        }
        TypeEquivalenceSet leftSet = leftElement.getTypeEquivalenceSet();
        TypeEquivalenceSet rightSet = rightElement.getTypeEquivalenceSet();
        if (leftSet == null) {
            if (rightSet == null) {
                TypeEquivalenceSet set = new TypeEquivalenceSet(leftElement, rightElement);
                leftElement.setTypeEquivalenceSet(set);
                rightElement.setTypeEquivalenceSet(set);
            } else {
                rightSet.add(leftElement);
                leftElement.setTypeEquivalenceSet(rightSet);
            }
        } else if (rightSet == null) {
            leftSet.add(rightElement);
            rightElement.setTypeEquivalenceSet(leftSet);
        } else {
            if (leftSet == rightSet) {
                return;
            }
            ConstraintVariable2[] cvs = rightSet.getContributingVariables();
            leftSet.addAll(cvs);
            int i = 0;
            while (i < cvs.length) {
                cvs[i].setTypeEquivalenceSet(leftSet);
                ++i;
            }
        }
    }

    public TType createTType(ITypeBinding typeBinding) {
        String key = typeBinding.getKey();
        TType cached = (TType)this.fTTypeCache.get(key);
        if (cached != null) {
            return cached;
        }
        TType type = this.fTypeEnvironment.create(typeBinding);
        this.fTTypeCache.put(key, type);
        return type;
    }

    private TType getBoxedType(ITypeBinding typeBinding, Expression expression) {
        if (typeBinding == null) {
            return null;
        }
        if (!typeBinding.isPrimitive()) {
            return this.createTType(typeBinding);
        }
        if (expression == null || !expression.resolveBoxing()) {
            return null;
        }
        String primitiveName = typeBinding.getName();
        ITypeBinding boxed = expression.getAST().resolveWellKnownType(this.getBoxedTypeName(primitiveName));
        return this.createTType(boxed);
    }

    private String getBoxedTypeName(String primitiveName) {
        if ("long".equals(primitiveName)) {
            return "java.lang.Long";
        }
        if ("int".equals(primitiveName)) {
            return "java.lang.Integer";
        }
        if ("short".equals(primitiveName)) {
            return "java.lang.Short";
        }
        if ("char".equals(primitiveName)) {
            return "java.lang.Character";
        }
        if ("byte".equals(primitiveName)) {
            return "java.lang.Byte";
        }
        if ("boolean".equals(primitiveName)) {
            return "java.lang.Boolean";
        }
        if ("float".equals(primitiveName)) {
            return "java.lang.Float";
        }
        if ("double".equals(primitiveName)) {
            return "java.lang.Double";
        }
        return null;
    }

    public VariableVariable2 makeVariableVariable(IVariableBinding variableBinding) {
        TType type = this.getBoxedType(variableBinding.getType(), null);
        if (type == null) {
            return null;
        }
        VariableVariable2 cv = new VariableVariable2(type, variableBinding);
        VariableVariable2 storedCv = (VariableVariable2)this.storedCv(cv);
        if (storedCv == cv) {
            if (!variableBinding.isField() || Modifier.isPrivate((int)variableBinding.getModifiers())) {
                this.fCuScopedConstraintVariables.add(storedCv);
            }
            this.makeElementVariables(storedCv, type);
            this.makeArrayElementVariable(storedCv);
            if (fStoreToString) {
                storedCv.setData("toString", String.valueOf('[') + variableBinding.getName() + ']');
            }
        }
        return storedCv;
    }

    public VariableVariable2 makeDeclaredVariableVariable(IVariableBinding variableBinding, ICompilationUnit cu) {
        VariableVariable2 cv = this.makeVariableVariable(variableBinding);
        if (cv == null) {
            return null;
        }
        cv.setCompilationUnit(cu);
        return cv;
    }

    public TypeVariable2 makeTypeVariable(Type type) {
        ICompilationUnit cu = RefactoringASTParser.getCompilationUnit((ASTNode)type);
        TType ttype = this.getBoxedType(type.resolveBinding(), null);
        if (ttype == null) {
            return null;
        }
        CompilationUnitRange range = new CompilationUnitRange(cu, (ASTNode)type);
        TypeVariable2 typeVariable = new TypeVariable2(ttype, range);
        TypeVariable2 storedCv = (TypeVariable2)this.storedCv(typeVariable);
        if (storedCv == typeVariable) {
            this.fCuScopedConstraintVariables.add(storedCv);
            if (InferTypeArgumentsTCModel.isAGenericType(ttype)) {
                this.makeElementVariables(storedCv, ttype);
            }
            this.makeArrayElementVariable(storedCv);
            if (fStoreToString) {
                storedCv.setData("toString", type.toString());
            }
        }
        return storedCv;
    }

    public IndependentTypeVariable2 makeIndependentTypeVariable(TypeVariable type) {
        IndependentTypeVariable2 cv = new IndependentTypeVariable2(type);
        IndependentTypeVariable2 storedCv = (IndependentTypeVariable2)this.storedCv(cv);
        if (cv == storedCv) {
            this.fCuScopedConstraintVariables.add(storedCv);
            if (fStoreToString) {
                storedCv.setData("toString", "IndependentType(" + type.getPrettySignature() + ")");
            }
        }
        return storedCv;
    }

    public ParameterizedTypeVariable2 makeParameterizedTypeVariable(ITypeBinding typeBinding) {
        TType type = this.createTType(typeBinding);
        return this.makeParameterizedTypeVariable(type);
    }

    private ParameterizedTypeVariable2 makeParameterizedTypeVariable(TType type) {
        Assert.isTrue((boolean)InferTypeArgumentsTCModel.isAGenericType(type));
        ParameterizedTypeVariable2 cv = new ParameterizedTypeVariable2(type);
        ParameterizedTypeVariable2 storedCv = (ParameterizedTypeVariable2)this.storedCv(cv);
        if (cv == storedCv) {
            this.fCuScopedConstraintVariables.add(storedCv);
            this.makeElementVariables(storedCv, type);
            if (fStoreToString) {
                storedCv.setData("toString", "ParameterizedType(" + type.getPrettySignature() + ")");
            }
        }
        return storedCv;
    }

    public ArrayTypeVariable2 makeArrayTypeVariable(ITypeBinding typeBinding) {
        TType type = this.createTType(typeBinding);
        return this.makeArrayTypeVariable((ArrayType)type);
    }

    private ArrayTypeVariable2 makeArrayTypeVariable(ArrayType type) {
        ArrayTypeVariable2 cv = new ArrayTypeVariable2(type);
        ArrayTypeVariable2 storedCv = (ArrayTypeVariable2)this.storedCv(cv);
        if (cv == storedCv) {
            this.fCuScopedConstraintVariables.add(storedCv);
            this.makeArrayElementVariable(storedCv);
            if (fStoreToString) {
                storedCv.setData("toString", "ArrayType(" + type.getPrettySignature() + ")");
            }
        }
        return storedCv;
    }

    public ParameterTypeVariable2 makeParameterTypeVariable(IMethodBinding methodBinding, int parameterIndex) {
        TType type = this.getBoxedType(methodBinding.getParameterTypes()[parameterIndex], null);
        if (type == null) {
            return null;
        }
        ParameterTypeVariable2 cv = new ParameterTypeVariable2(type, parameterIndex, methodBinding);
        ParameterTypeVariable2 storedCv = (ParameterTypeVariable2)this.storedCv(cv);
        if (storedCv == cv) {
            if (methodBinding.getDeclaringClass().isLocal() || Modifier.isPrivate((int)methodBinding.getModifiers())) {
                this.fCuScopedConstraintVariables.add(cv);
            }
            this.makeElementVariables(storedCv, type);
            this.makeArrayElementVariable(storedCv);
            if (fStoreToString) {
                storedCv.setData("toString", "[Parameter(" + parameterIndex + "," + Bindings.asString((IBinding)methodBinding) + ")]");
            }
        }
        return storedCv;
    }

    public ParameterTypeVariable2 makeDeclaredParameterTypeVariable(IMethodBinding methodBinding, int parameterIndex, ICompilationUnit cu) {
        ParameterTypeVariable2 cv = this.makeParameterTypeVariable(methodBinding, parameterIndex);
        if (cv == null) {
            return null;
        }
        cv.setCompilationUnit(cu);
        return cv;
    }

    public ReturnTypeVariable2 makeReturnTypeVariable(IMethodBinding methodBinding) {
        TType returnType = this.getBoxedType(methodBinding.getReturnType(), null);
        if (returnType == null) {
            return null;
        }
        ReturnTypeVariable2 cv = new ReturnTypeVariable2(returnType, methodBinding);
        ReturnTypeVariable2 storedCv = (ReturnTypeVariable2)this.storedCv(cv);
        if (cv == storedCv) {
            this.makeElementVariables(storedCv, returnType);
            this.makeArrayElementVariable(storedCv);
            if (fStoreToString) {
                storedCv.setData("toString", "[ReturnType(" + Bindings.asString((IBinding)methodBinding) + ")]");
            }
        }
        return storedCv;
    }

    public ReturnTypeVariable2 makeDeclaredReturnTypeVariable(IMethodBinding methodBinding, ICompilationUnit cu) {
        ReturnTypeVariable2 cv = this.makeReturnTypeVariable(methodBinding);
        if (cv == null) {
            return null;
        }
        cv.setCompilationUnit(cu);
        if (methodBinding.getDeclaringClass().isLocal()) {
            this.fCuScopedConstraintVariables.add(cv);
        }
        return cv;
    }

    public ImmutableTypeVariable2 makeImmutableTypeVariable(ITypeBinding typeBinding, Expression expression) {
        TType type = this.getBoxedType(typeBinding, expression);
        if (type == null) {
            return null;
        }
        return this.makeImmutableTypeVariable(type);
    }

    public ImmutableTypeVariable2 makeImmutableTypeVariable(TType type) {
        ImmutableTypeVariable2 cv = new ImmutableTypeVariable2(type);
        ImmutableTypeVariable2 storedCv = (ImmutableTypeVariable2)this.storedCv(cv);
        if (cv == storedCv) {
            this.makeFixedElementVariables(storedCv, type);
            this.makeArrayElementVariable(storedCv);
        }
        return storedCv;
    }

    public static boolean isAGenericType(TType type) {
        return type.isGenericType() || type.isParameterizedType() || type.isRawType();
    }

    public static boolean isAGenericType(ITypeBinding type) {
        return type.isGenericType() || type.isParameterizedType() || type.isRawType();
    }

    public CastVariable2 makeCastVariable(CastExpression castExpression, ConstraintVariable2 expressionCv) {
        ITypeBinding typeBinding = castExpression.resolveTypeBinding();
        ICompilationUnit cu = RefactoringASTParser.getCompilationUnit((ASTNode)castExpression);
        CompilationUnitRange range = new CompilationUnitRange(cu, (ASTNode)castExpression);
        CastVariable2 castCv = new CastVariable2(this.createTType(typeBinding), range, expressionCv);
        this.fCastVariables.add(castCv);
        return castCv;
    }

    public TypeEnvironment getTypeEnvironment() {
        return this.fTypeEnvironment;
    }

    public CollectionElementVariable2 getElementVariable(ConstraintVariable2 constraintVariable, ITypeBinding typeVariable) {
        Assert.isTrue((boolean)typeVariable.isTypeVariable());
        HashMap typeVarToElementVars = (HashMap)constraintVariable.getData(INDEXED_COLLECTION_ELEMENTS);
        if (typeVarToElementVars == null) {
            return null;
        }
        return (CollectionElementVariable2)typeVarToElementVars.get(typeVariable.getKey());
    }

    public Map getElementVariables(ConstraintVariable2 constraintVariable) {
        Map elementVariables = (Map)constraintVariable.getData(INDEXED_COLLECTION_ELEMENTS);
        if (elementVariables == null) {
            return EMPTY_COLLECTION_ELEMENT_VARIABLES_MAP;
        }
        return elementVariables;
    }

    public ArrayElementVariable2 getArrayElementVariable(ConstraintVariable2 constraintVariable) {
        return (ArrayElementVariable2)constraintVariable.getData(ARRAY_ELEMENT);
    }

    private void setArrayElementVariable(ConstraintVariable2 constraintVariable, ArrayElementVariable2 arrayElementVariable) {
        constraintVariable.setData(ARRAY_ELEMENT, arrayElementVariable);
    }

    public void makeArrayElementVariable(ConstraintVariable2 constraintVariable2) {
        if (constraintVariable2.getType() == null || !constraintVariable2.getType().isArrayType()) {
            return;
        }
        ArrayElementVariable2 storedArrayElementVariable = this.getArrayElementVariable(constraintVariable2);
        if (storedArrayElementVariable != null) {
            return;
        }
        ArrayElementVariable2 arrayElementCv = new ArrayElementVariable2(constraintVariable2);
        arrayElementCv = (ArrayElementVariable2)this.storedCv(arrayElementCv);
        this.setArrayElementVariable(constraintVariable2, arrayElementCv);
        this.makeArrayElementVariable(arrayElementCv);
    }

    public void makeElementVariables(ConstraintVariable2 expressionCv, TType type) {
        if (InferTypeArgumentsTCModel.isAGenericType(type)) {
            GenericType genericType = (GenericType)type.getTypeDeclaration();
            TypeVariable[] typeParameters = genericType.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                TypeVariable typeVariable = typeParameters[i];
                this.makeElementVariable(expressionCv, typeVariable, i);
                int cfr_ignored_0 = typeVariable.getBounds().length;
                ++i;
            }
        }
        this.makeElementVariablesFromSupertypes(expressionCv, type.getTypeDeclaration());
    }

    private void makeElementVariablesFromSupertypes(ConstraintVariable2 expressionCv, TType type) {
        TType superclass = type.getSuperclass();
        if (superclass != null) {
            this.makeSupertypeElementVariables(expressionCv, superclass);
        }
        TType[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.makeSupertypeElementVariables(expressionCv, interfaces[i]);
            ++i;
        }
    }

    private void makeSupertypeElementVariables(ConstraintVariable2 expressionCv, TType supertype) {
        if (supertype.isParameterizedType() || supertype.isRawType()) {
            TType[] typeArguments = null;
            if (supertype.isParameterizedType()) {
                typeArguments = ((ParameterizedType)supertype).getTypeArguments();
            }
            TypeVariable[] typeParameters = ((GenericType)supertype.getTypeDeclaration()).getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                TypeVariable typeParameter = typeParameters[i];
                TType referenceTypeArgument = typeArguments == null ? typeParameter.getErasure() : typeArguments[i];
                if (referenceTypeArgument.isTypeVariable()) {
                    CollectionElementVariable2 referenceTypeArgumentCv = this.getElementVariable(expressionCv, (TypeVariable)referenceTypeArgument);
                    this.setElementVariable(expressionCv, referenceTypeArgumentCv, typeParameter);
                } else {
                    this.makeElementVariable(expressionCv, typeParameter, -1);
                }
                ++i;
            }
        }
        this.makeElementVariablesFromSupertypes(expressionCv, supertype);
    }

    public void makeFixedElementVariables(ConstraintVariable2 expressionCv, TType type) {
        if (InferTypeArgumentsTCModel.isAGenericType(type)) {
            GenericType genericType = (GenericType)type.getTypeDeclaration();
            TypeVariable[] typeParameters = genericType.getTypeParameters();
            TType[] typeArguments = null;
            if (type.isParameterizedType()) {
                typeArguments = ((ParameterizedType)type).getTypeArguments();
            }
            int i = 0;
            while (i < typeParameters.length) {
                TypeVariable typeVariable = typeParameters[i];
                CollectionElementVariable2 elementCv = this.makeElementVariable(expressionCv, typeVariable, i);
                if (typeArguments != null) {
                    TType referenceTypeArgument = typeArguments[i];
                    this.createEqualsConstraint(elementCv, this.makeImmutableTypeVariable(referenceTypeArgument));
                }
                ++i;
            }
        }
        this.makeFixedElementVariablesFromSupertypes(expressionCv, type.getTypeDeclaration());
    }

    private void makeFixedElementVariablesFromSupertypes(ConstraintVariable2 expressionCv, TType type) {
        TType superclass = type.getSuperclass();
        if (superclass != null) {
            this.makeFixedSupertypeElementVariables(expressionCv, superclass);
        }
        TType[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.makeFixedSupertypeElementVariables(expressionCv, interfaces[i]);
            ++i;
        }
    }

    private void makeFixedSupertypeElementVariables(ConstraintVariable2 expressionCv, TType supertype) {
        if (supertype.isParameterizedType() || supertype.isRawType()) {
            TType[] typeArguments = null;
            if (supertype.isParameterizedType()) {
                typeArguments = ((ParameterizedType)supertype).getTypeArguments();
            }
            TypeVariable[] typeParameters = ((GenericType)supertype.getTypeDeclaration()).getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                TypeVariable typeParameter = typeParameters[i];
                if (typeArguments != null) {
                    TType referenceTypeArgument = typeArguments[i];
                    if (referenceTypeArgument.isTypeVariable()) {
                        CollectionElementVariable2 referenceTypeArgumentCv = this.getElementVariable(expressionCv, (TypeVariable)referenceTypeArgument);
                        this.setElementVariable(expressionCv, referenceTypeArgumentCv, typeParameter);
                    } else {
                        CollectionElementVariable2 elementCv = this.makeElementVariable(expressionCv, typeParameter, -1);
                        this.createEqualsConstraint(elementCv, this.makeImmutableTypeVariable(referenceTypeArgument));
                    }
                }
                ++i;
            }
        }
        this.makeFixedElementVariablesFromSupertypes(expressionCv, supertype);
    }

    public void createTypeVariablesEqualityConstraints(ConstraintVariable2 expressionCv, Map methodTypeVariables, ConstraintVariable2 referenceCv, TType reference) {
        if (reference.isParameterizedType() || reference.isRawType()) {
            TType[] referenceTypeArguments = null;
            if (reference.isParameterizedType()) {
                referenceTypeArguments = ((ParameterizedType)reference).getTypeArguments();
            }
            TypeVariable[] referenceTypeParameters = ((GenericType)reference.getTypeDeclaration()).getTypeParameters();
            int i = 0;
            while (i < referenceTypeParameters.length) {
                CollectionElementVariable2 referenceTypeParametersCv;
                ConstraintVariable2 referenceTypeArgumentCv;
                TypeVariable referenceTypeParameter = referenceTypeParameters[i];
                TType referenceTypeArgument = referenceTypeArguments == null ? referenceTypeParameter.getErasure() : referenceTypeArguments[i];
                if (referenceTypeArgument.isTypeVariable()) {
                    referenceTypeArgumentCv = this.getElementTypeCv(referenceTypeArgument, expressionCv, methodTypeVariables);
                    referenceTypeParametersCv = this.getElementVariable(referenceCv, referenceTypeParameter);
                    this.createEqualsConstraint(referenceTypeArgumentCv, referenceTypeParametersCv);
                } else if (referenceTypeArgument.isWildcardType()) {
                    referenceTypeArgumentCv = this.makeImmutableTypeVariable(this.fTypeEnvironment.VOID);
                    referenceTypeParametersCv = this.getElementVariable(referenceCv, referenceTypeParameter);
                    this.createEqualsConstraint(referenceTypeArgumentCv, referenceTypeParametersCv);
                }
                ++i;
            }
        } else if (reference.isArrayType()) {
            TType elementType = ((ArrayType)reference).getElementType();
            if (elementType.isRawType()) {
                elementType = elementType.getErasure();
            }
            ConstraintVariable2 elementTypeCv = this.getElementTypeCv(elementType, expressionCv, methodTypeVariables);
            ArrayElementVariable2 arrayElementTypeCv = this.getArrayElementVariable(referenceCv);
            this.createEqualsConstraint(elementTypeCv, arrayElementTypeCv);
        }
    }

    private ConstraintVariable2 getElementTypeCv(TType elementType, ConstraintVariable2 expressionCv, Map methodTypeVariables) {
        if (elementType.isTypeVariable()) {
            ConstraintVariable2 elementTypeCv = (ConstraintVariable2)methodTypeVariables.get(elementType.getBindingKey());
            if (elementTypeCv != null) {
                return elementTypeCv;
            }
            if (expressionCv != null) {
                return this.getElementVariable(expressionCv, (TypeVariable)elementType);
            }
        }
        return null;
    }

    private CollectionElementVariable2 makeElementVariable(ConstraintVariable2 expressionCv, TypeVariable typeVariable, int declarationTypeVariableIndex) {
        if (expressionCv == null) {
            return null;
        }
        CollectionElementVariable2 storedElementVariable = this.getElementVariable(expressionCv, typeVariable);
        if (storedElementVariable != null) {
            return storedElementVariable;
        }
        CollectionElementVariable2 cv = new CollectionElementVariable2(expressionCv, typeVariable, declarationTypeVariableIndex);
        cv = (CollectionElementVariable2)this.storedCv(cv);
        this.setElementVariable(expressionCv, cv, typeVariable);
        return cv;
    }

    private void setElementVariable(ConstraintVariable2 typeConstraintVariable, CollectionElementVariable2 elementVariable, TypeVariable typeVariable) {
        HashMap<String, CollectionElementVariable2> keyToElementVar = (HashMap<String, CollectionElementVariable2>)typeConstraintVariable.getData(INDEXED_COLLECTION_ELEMENTS);
        String key = typeVariable.getBindingKey();
        if (keyToElementVar == null) {
            keyToElementVar = new HashMap<String, CollectionElementVariable2>();
            typeConstraintVariable.setData(INDEXED_COLLECTION_ELEMENTS, keyToElementVar);
        } else {
            Object existingElementVar = keyToElementVar.get(key);
            if (existingElementVar != null) {
                Assert.isTrue((existingElementVar == elementVariable ? 1 : 0) != 0);
            }
        }
        keyToElementVar.put(key, elementVariable);
    }

    public CollectionElementVariable2 getElementVariable(ConstraintVariable2 constraintVariable, TypeVariable typeVariable) {
        Assert.isTrue((boolean)typeVariable.isTypeVariable());
        HashMap typeVarToElementVars = (HashMap)constraintVariable.getData(INDEXED_COLLECTION_ELEMENTS);
        if (typeVarToElementVars == null) {
            return null;
        }
        return (CollectionElementVariable2)typeVarToElementVars.get(typeVariable.getBindingKey());
    }

    public void createElementEqualsConstraints(ConstraintVariable2 cv, ConstraintVariable2 initializerCv) {
        this.internalCreateElementEqualsConstraints(cv, initializerCv, false);
    }

    public void createAssignmentElementConstraints(ConstraintVariable2 cv, ConstraintVariable2 initializerCv) {
        this.internalCreateElementEqualsConstraints(cv, initializerCv, true);
    }

    private void internalCreateElementEqualsConstraints(ConstraintVariable2 cv, ConstraintVariable2 initializerCv, boolean isAssignment) {
        if (cv == null || initializerCv == null) {
            return;
        }
        Map leftElements = this.getElementVariables(cv);
        Map rightElements = this.getElementVariables(initializerCv);
        for (Map.Entry leftEntry : leftElements.entrySet()) {
            String leftTypeVariableKey = (String)leftEntry.getKey();
            CollectionElementVariable2 rightElementVariable = (CollectionElementVariable2)rightElements.get(leftTypeVariableKey);
            if (rightElementVariable == null) continue;
            CollectionElementVariable2 leftElementVariable = (CollectionElementVariable2)leftEntry.getValue();
            this.createEqualsConstraint(leftElementVariable, rightElementVariable);
            this.internalCreateElementEqualsConstraints(leftElementVariable, rightElementVariable, false);
        }
        ArrayElementVariable2 leftArrayElement = this.getArrayElementVariable(cv);
        ArrayElementVariable2 rightArrayElement = this.getArrayElementVariable(initializerCv);
        if (leftArrayElement != null && rightArrayElement != null) {
            if (isAssignment) {
                this.createSubtypeConstraint(rightArrayElement, leftArrayElement);
            } else {
                this.createEqualsConstraint(leftArrayElement, rightArrayElement);
            }
            this.internalCreateElementEqualsConstraints(leftArrayElement, rightArrayElement, false);
        }
    }

    public ConstraintVariable2 getMethodReceiverCv(ConstraintVariable2 expressionVariable) {
        return (ConstraintVariable2)expressionVariable.getData(METHOD_RECEIVER);
    }

    public void setMethodReceiverCV(ConstraintVariable2 expressionVariable, ConstraintVariable2 methodReceiverCV) {
        expressionVariable.setData(METHOD_RECEIVER, methodReceiverCV);
    }
}

