/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import com.ibm.icu.text.MessageFormat;
import com.sun.jdi.InvocationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.eval.ast.engine.IRuntimeContext;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public abstract class AbstractRuntimeContext
implements IRuntimeContext {
    private IJavaObject fClassLoader;
    private IJavaClassType fJavaLangClass;
    protected IJavaProject fProject;
    public static final String CLASS = "java.lang.Class";
    public static final String FOR_NAME = "forName";
    public static final String FOR_NAME_SIGNATURE = "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;";

    public AbstractRuntimeContext(IJavaProject project) {
        this.fProject = project;
    }

    protected IJavaObject getClassLoaderObject() throws CoreException {
        if (this.fClassLoader == null) {
            this.fClassLoader = this.getReceivingType().getClassLoaderObject();
        }
        return this.fClassLoader;
    }

    protected IJavaClassType getJavaLangClass() throws CoreException {
        if (this.fJavaLangClass == null) {
            IJavaType[] types = this.getVM().getJavaTypes(CLASS);
            if (types == null || types.length != 1) {
                throw new CoreException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format((String)InstructionsEvaluationMessages.Instruction_No_type, (Object[])new String[]{CLASS}), null));
            }
            this.fJavaLangClass = (IJavaClassType)types[0];
        }
        return this.fJavaLangClass;
    }

    protected IJavaClassObject classForName(String qualifiedName, IJavaObject loader) throws CoreException {
        IJavaValue loaderArg = loader;
        if (loader == null) {
            loaderArg = this.getVM().nullValue();
        }
        IJavaValue[] args = new IJavaValue[]{this.getVM().newValue(qualifiedName), this.getVM().newValue(true), loaderArg};
        try {
            return (IJavaClassObject)this.getJavaLangClass().sendMessage(FOR_NAME, FOR_NAME_SIGNATURE, args, this.getThread());
        }
        catch (CoreException e) {
            if (e.getStatus().getException() instanceof InvocationException && ((InvocationException)e.getStatus().getException()).exception().referenceType().name().equals("java.lang.ClassNotFoundException")) {
                return null;
            }
            throw e;
        }
    }

    public IJavaClassObject classForName(String name) throws CoreException {
        return this.classForName(name, this.getClassLoaderObject());
    }

    public IJavaProject getProject() {
        return this.fProject;
    }
}

