/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.generatedfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.Messages;
import org.eclipse.jdt.apt.core.internal.generatedfile.FileGenerationResult;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.internal.generatedfile.WorkingCopyCleanupListener;
import org.eclipse.jdt.apt.core.internal.util.FileSystemUtil;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedFileManager {
    private static final int SERIALIZATION_VERSION = 1;
    public static final boolean GENERATE_TYPE_DURING_RECONCILE = false;
    private Map<IFile, Set<IFile>> _parentFile2GeneratedFiles = new HashMap<IFile, Set<IFile>>();
    private Map<IFile, Set<IFile>> _generatedFile2ParentFiles = new HashMap<IFile, Set<IFile>>();
    private Map<ICompilationUnit, Set<IFile>> _generatedWorkingCopy2OpenParentFiles = new HashMap<ICompilationUnit, Set<IFile>>();
    private Map<IFile, ICompilationUnit> _generatedFile2WorkingCopy = new HashMap<IFile, ICompilationUnit>();
    private final IJavaProject _jProject;
    private final GeneratedSourceFolderManager _gsfm;
    private IPackageFragmentRoot _generatedPackageFragmentRoot;
    private boolean _skipTypeGeneration = false;
    private String _snapshotFolderName = null;
    private boolean _mapsDirty = false;

    static {
        int mask = 1;
        JavaCore.addElementChangedListener((IElementChangedListener)new WorkingCopyCleanupListener(), (int)mask);
    }

    public GeneratedFileManager(AptProject aptProject, GeneratedSourceFolderManager gsfm) {
        this._jProject = aptProject.getJavaProject();
        this._gsfm = gsfm;
        this.readState();
    }

    public FileGenerationResult generateFileDuringBuild(IFile parentFile, String typeName, String contents, IProgressMonitor progressMonitor) throws CoreException {
        if (this._skipTypeGeneration) {
            return null;
        }
        if (this._generatedPackageFragmentRoot == null) {
            String message = Messages.bind((String)Messages.GeneratedFileManager_missing_classpath_entry, (Object[])new String[]{this._snapshotFolderName});
            IMarker marker = this._jProject.getProject().createMarker("org.eclipse.jdt.apt.core.configproblem");
            marker.setAttributes(new String[]{"message", "severity"}, new Object[]{message, 2});
            this._skipTypeGeneration = true;
            return null;
        }
        try {
            String typeSimpleName;
            String pkgName;
            int separatorIndex;
            if (typeName.indexOf(47) != -1) {
                typeName = typeName.replace('/', '.');
            }
            if ((separatorIndex = typeName.lastIndexOf(46)) == -1) {
                pkgName = "";
                typeSimpleName = typeName;
            } else {
                pkgName = typeName.substring(0, separatorIndex);
                typeSimpleName = typeName.substring(separatorIndex + 1, typeName.length());
            }
            IFolder genSrcFolder = (IFolder)this._generatedPackageFragmentRoot.getResource();
            Set<IContainer> newFolders = this.getNewPackageFolders(pkgName, genSrcFolder);
            IPackageFragment pkgFrag = this._generatedPackageFragmentRoot.createPackageFragment(pkgName, true, progressMonitor);
            if (pkgFrag == null) {
                IllegalStateException e = new IllegalStateException("failed to locate package '" + pkgName + "'");
                e.printStackTrace();
                throw e;
            }
            this.markNewFoldersAsDerived((IContainer)pkgFrag.getResource(), newFolders);
            String cuName = String.valueOf(typeSimpleName) + ".java";
            ICompilationUnit unit = pkgFrag.getCompilationUnit(cuName);
            IFile file = (IFile)unit.getResource();
            boolean contentsDiffer = true;
            if (unit.exists()) {
                InputStream oldData = null;
                ByteArrayInputStream is = null;
                try {
                    try {
                        is = new ByteArrayInputStream(contents.getBytes());
                        oldData = new BufferedInputStream(((IFile)unit.getResource()).getContents());
                        contentsDiffer = !FileSystemUtil.compareStreams(oldData, is);
                    }
                    catch (CoreException coreException) {}
                }
                catch (Throwable throwable) {
                    if (oldData != null) {
                        try {
                            oldData.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (oldData != null) {
                    try {
                        oldData.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (contentsDiffer) {
                if (unit.exists() && unit.isOpen()) {
                    IBuffer buffer = unit.getBuffer();
                    if (buffer == null) {
                        throw new IllegalStateException("Unable to update unit for " + cuName);
                    }
                    buffer.setContents(contents.toCharArray());
                    buffer.save(progressMonitor, true);
                } else {
                    ICompilationUnit newUnit = null;
                    newUnit = pkgFrag.createCompilationUnit(cuName, contents, true, progressMonitor);
                    if (newUnit == null) {
                        throw new IllegalStateException("Unable to create unit for " + cuName);
                    }
                    if (AptPlugin.DEBUG) {
                        AptPlugin.trace("generated " + typeName);
                    }
                    newUnit.save(progressMonitor, true);
                }
            }
            if (file.exists()) {
                file.setDerived(true);
            }
            if (parentFile != null) {
                this.addEntryToFileMaps(parentFile, file);
            }
            return new FileGenerationResult(file, contentsDiffer);
        }
        catch (Throwable e) {
            AptPlugin.log(e, "(2)failed to generate type " + typeName);
            e.printStackTrace();
            return null;
        }
    }

    public FileGenerationResult generateFileDuringReconcile(ICompilationUnit parentCompilationUnit, String typeName, String contents, WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    public synchronized boolean isGeneratedFile(IFile f) {
        Set<IFile> s = this._generatedFile2ParentFiles.get(f);
        return s != null && !s.isEmpty();
    }

    public synchronized boolean isParentFile(IFile f) {
        Set<IFile> s = this._parentFile2GeneratedFiles.get(f);
        return s != null && !s.isEmpty();
    }

    public synchronized Set<IFile> getGeneratedFilesForParent(IFile parent) {
        Set<Object> s = this._parentFile2GeneratedFiles.get(parent);
        s = s == null ? Collections.emptySet() : new HashSet<IFile>(s);
        return s;
    }

    private void discardGeneratedWorkingCopy(IFile generatedFile, IFile parentFile) throws JavaModelException {
        this.removeFromWorkingCopyMaps(generatedFile, parentFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parentWorkingCopyDiscarded(IFile parentFile) throws JavaModelException {
        Set<IFile> generatedFiles;
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            generatedFiles = this._parentFile2GeneratedFiles.get(parentFile);
            if (generatedFiles == null || generatedFiles.size() == 0) {
                return;
            }
            generatedFiles = new HashSet<IFile>(generatedFiles);
        }
        for (IFile generatedFile : generatedFiles) {
            this.discardGeneratedWorkingCopy(generatedFile, parentFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parentFileDeleted(IFile parent, IProgressMonitor monitor) throws CoreException {
        Set<IFile> generatedFiles;
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            generatedFiles = this._parentFile2GeneratedFiles.get(parent);
            generatedFiles = new HashSet<IFile>(generatedFiles);
        }
        for (IFile generatedFile : generatedFiles) {
            this.deleteGeneratedFile(generatedFile, parent, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteGeneratedFile(IFile generatedFile, IFile parentFile, IProgressMonitor progressMonitor) throws CoreException {
        this.removeFromFileMaps(generatedFile, parentFile);
        boolean delete = false;
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            Set<IFile> parents = this._generatedFile2ParentFiles.get(generatedFile);
            if (parents == null) {
                throw new RuntimeException("unexpected null value for parents set for file " + generatedFile);
            }
            if (parents == null || parents.size() == 0) {
                delete = true;
            }
        }
        if (delete) {
            IFolder genFolder = this._gsfm.getFolder();
            assert (genFolder != null) : "Generated folder == null";
            IContainer parent = generatedFile.getParent();
            try {
                generatedFile.delete(true, true, progressMonitor);
            }
            catch (CoreException ce) {
                AptPlugin.logWarning(ce, "Failed to delete file: " + generatedFile);
            }
            while (!genFolder.equals((Object)parent) && parent != null && parent.isDerived()) {
                IResource[] members = parent.members();
                IContainer grandParent = parent.getParent();
                if (members != null && members.length != 0) break;
                parent.delete(true, progressMonitor);
                parent = grandParent;
            }
        }
        return delete;
    }

    public boolean deleteGeneratedTypeInMemory(IFile generatedFile, ICompilationUnit parentWorkingCopy, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generatedFileDeleted(IFile generatedFile, IProgressMonitor progressMonitor) throws JavaModelException {
        Set<IFile> parentFiles;
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            parentFiles = this._generatedFile2ParentFiles.get(generatedFile);
            if (parentFiles == null || parentFiles.isEmpty()) {
                return;
            }
            parentFiles = new HashSet<IFile>(parentFiles);
        }
        for (IFile parentFile : parentFiles) {
            this.removeFromWorkingCopyMaps(generatedFile, parentFile);
            this.removeFromFileMaps(generatedFile, parentFile);
        }
    }

    private String getTypeNameForDerivedFile(IFile f) {
        IPath p = f.getFullPath();
        IFolder folder = this._gsfm.getFolder();
        IPath generatedSourcePath = folder.getFullPath();
        int count = p.matchingFirstSegments(generatedSourcePath);
        p = p.removeFirstSegments(count);
        String s = p.toPortableString();
        int idx = s.lastIndexOf(46);
        s = p.toPortableString().replace('/', '.');
        return s.substring(0, idx);
    }

    private IFile getIFileForTypeName(String typeName) {
        String[] parts = typeName.split("\\.");
        IFolder folder = this._gsfm.getFolder();
        int i = 0;
        while (i < parts.length - 1) {
            folder = folder.getFolder(parts[i]);
            ++i;
        }
        String fileName = String.valueOf(parts[parts.length - 1]) + ".java";
        IFile file = folder.getFile(fileName);
        return file;
    }

    private void markNewFoldersAsDerived(IContainer folder, Set<IContainer> newFolders) throws CoreException {
        while (folder != null) {
            if (newFolders.contains(folder)) {
                folder.setDerived(true);
            }
            folder = folder.getParent();
        }
    }

    private Set<IContainer> getNewPackageFolders(String pkgName, IFolder parent) {
        StringBuilder buffer = new StringBuilder();
        HashSet<IContainer> newFolders = new HashSet<IContainer>();
        int i = 0;
        int len = pkgName.length();
        while (i < len) {
            char c = pkgName.charAt(i);
            if (c != '.') {
                buffer.append(c);
            }
            if ((c == '.' || i == len - 1) && buffer.length() > 0) {
                IFolder folder = parent.getFolder(buffer.toString());
                if (!folder.exists()) {
                    newFolders.add((IContainer)folder);
                }
                parent = folder;
                buffer.setLength(0);
            }
            ++i;
        }
        return newFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compilationStarted() {
        IFolder genFolder;
        GeneratedFileManager marker;
        int n;
        try {
            IMarker[] markers = this._jProject.getProject().findMarkers("org.eclipse.jdt.apt.core.configproblem", true, 2);
            if (markers != null) {
                IMarker[] iMarkerArray = markers;
                int n2 = 0;
                n = iMarkerArray.length;
                while (n2 < n) {
                    marker = iMarkerArray[n2];
                    marker.delete();
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            AptPlugin.log(e, "Unable to delete configuration marker.");
        }
        this._skipTypeGeneration = false;
        this._gsfm.ensureFolderExists();
        marker = this;
        synchronized (marker) {
            genFolder = this._gsfm.getFolder();
            this._snapshotFolderName = genFolder.getProjectRelativePath().toString();
        }
        try {
            IPackageFragmentRoot[] roots;
            this._generatedPackageFragmentRoot = null;
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this._jProject.getAllPackageFragmentRoots();
            n = 0;
            int n3 = iPackageFragmentRootArray.length;
            while (n < n3) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n];
                IResource resource = root.getResource();
                if (resource != null && resource.equals((Object)genFolder)) {
                    this._generatedPackageFragmentRoot = root;
                    return;
                }
                ++n;
            }
        }
        catch (JavaModelException jme) {
            AptPlugin.log(jme, "Failure during start of compilation attempting to create generated source folder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICompilationUnit getCachedWorkingCopy(IFile parentFile, String typeName) {
        IFile derivedFile = this.getIFileForTypeName(typeName);
        ICompilationUnit workingCopy = null;
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            workingCopy = this._generatedFile2WorkingCopy.get(derivedFile);
        }
        if (workingCopy != null) {
            this.addEntryToWorkingCopyMaps(parentFile, workingCopy);
        }
        return workingCopy;
    }

    private ICompilationUnit createNewWorkingCopy(IFile parentFile, String typeName, String contents, WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor progressMonitor) throws JavaModelException {
        String fname;
        String pkgName;
        IFolder folder = this._gsfm.getFolder();
        int idx = typeName.lastIndexOf(46);
        if (idx > 0) {
            pkgName = typeName.substring(0, idx);
            fname = String.valueOf(typeName.substring(idx + 1, typeName.length())) + ".java";
        } else {
            pkgName = "";
            fname = String.valueOf(typeName) + ".java";
        }
        IPackageFragmentRoot root = this._jProject.getPackageFragmentRoot((IResource)folder);
        IPackageFragment pkgFragment = root.getPackageFragment(pkgName);
        ICompilationUnit cu = pkgFragment.getCompilationUnit(fname);
        cu.becomeWorkingCopy(problemRequestor, progressMonitor);
        ICompilationUnit workingCopy = cu;
        GeneratedFileManager.updateWorkingCopy(contents, workingCopy, workingCopyOwner, progressMonitor);
        this.addEntryToWorkingCopyMaps(parentFile, workingCopy);
        return workingCopy;
    }

    private static boolean updateWorkingCopy(String contents, ICompilationUnit workingCopy, WorkingCopyOwner workingCopyOwner, IProgressMonitor progressMonitor) throws JavaModelException {
        IBuffer b = workingCopy.getBuffer();
        char[] oldBuf = b.getCharacters();
        if (oldBuf.length == contents.length()) {
            boolean contentsMatch = true;
            int i = 0;
            while (i < oldBuf.length) {
                if (oldBuf[i] != contents.charAt(i)) {
                    contentsMatch = false;
                    break;
                }
                ++i;
            }
            if (contentsMatch) {
                return false;
            }
        }
        b.setContents(contents);
        workingCopy.reconcile(3, true, workingCopyOwner, progressMonitor);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntryToWorkingCopyMaps(IFile parentFile, ICompilationUnit workingCopy) {
        IFile generatedFile = (IFile)workingCopy.getResource();
        this.addEntryToFileMaps(parentFile, generatedFile);
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            ICompilationUnit cu = this._generatedFile2WorkingCopy.get(generatedFile);
            Set<IFile> parents = this._generatedWorkingCopy2OpenParentFiles.get(workingCopy);
            if (cu != null) {
                if (!cu.equals(workingCopy)) {
                    throw new RuntimeException("unexpected different instances of working copy for the same type");
                }
                if (parents == null || parents.size() < 1) {
                    throw new RuntimeException("Unexpected size of open-parents set.  Expected size >= 0");
                }
            } else {
                this._generatedFile2WorkingCopy.put(generatedFile, workingCopy);
            }
            if (parents == null) {
                parents = new HashSet<IFile>();
                this._generatedWorkingCopy2OpenParentFiles.put(workingCopy, parents);
            }
            parents.add(parentFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntryToFileMaps(IFile parentFile, IFile generatedFile) {
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            Set<IFile> fileSet = this._parentFile2GeneratedFiles.get(parentFile);
            if (fileSet == null) {
                fileSet = new HashSet<IFile>();
                this._parentFile2GeneratedFiles.put(parentFile, fileSet);
            }
            if (fileSet.add(generatedFile)) {
                this._mapsDirty = true;
            }
            if ((fileSet = this._generatedFile2ParentFiles.get(generatedFile)) == null) {
                fileSet = new HashSet<IFile>();
                this._generatedFile2ParentFiles.put(generatedFile, fileSet);
            }
            if (fileSet.add(parentFile)) {
                this._mapsDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromFileMaps(IFile generatedFile, IFile parentFile) throws JavaModelException {
        boolean discardWorkingCopy;
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            discardWorkingCopy = this._generatedFile2WorkingCopy.containsKey(generatedFile);
        }
        if (discardWorkingCopy) {
            this.discardGeneratedWorkingCopy(generatedFile, parentFile);
        }
        generatedFileManager = this;
        synchronized (generatedFileManager) {
            Set<IFile> parents;
            Set<IFile> derivedFiles = this._parentFile2GeneratedFiles.get(parentFile);
            if (derivedFiles == null) {
                throw new RuntimeException("derivedFiles is null and it shouldn't be");
            }
            if (derivedFiles.remove(generatedFile)) {
                this._mapsDirty = true;
            }
            if ((parents = this._generatedFile2ParentFiles.get(generatedFile)) == null) {
                throw new RuntimeException(" parents is null and it shouldn't be");
            }
            if (!parents.contains(parentFile)) {
                throw new RuntimeException("parents set does not contain parent. Parent: " + parentFile + ". Child: " + generatedFile);
            }
            if (parents.remove(parentFile)) {
                this._mapsDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromWorkingCopyMaps(IFile derivedFile, IFile parentFile) throws JavaModelException {
        ICompilationUnit workingCopy = null;
        boolean discard = false;
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            workingCopy = this._generatedFile2WorkingCopy.get(derivedFile);
            if (workingCopy == null) {
                return;
            }
            Set<IFile> parents = this._generatedWorkingCopy2OpenParentFiles.get(workingCopy);
            if (parents == null) {
                throw new RuntimeException("parents == null and it shouldnt");
            }
            if (!parents.contains(parentFile)) {
                throw new RuntimeException("parents set should contain parentCompilationUnit");
            }
            parents.remove(parentFile);
            if (parents.size() == 0) {
                this._generatedFile2WorkingCopy.remove(derivedFile);
                discard = true;
            }
        }
        if (discard) {
            workingCopy.discardWorkingCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWorkingCopyMaps() {
        ArrayList<ICompilationUnit> workingCopies;
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            workingCopies = new ArrayList<ICompilationUnit>(this._generatedFile2WorkingCopy.values());
            this._generatedWorkingCopy2OpenParentFiles.clear();
            this._generatedFile2WorkingCopy.clear();
        }
        for (ICompilationUnit workingCopy : workingCopies) {
            try {
                workingCopy.discardWorkingCopy();
            }
            catch (JavaModelException jme) {
                AptPlugin.log(jme, "Could not discard working copy");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllMaps() {
        this.clearWorkingCopyMaps();
        GeneratedFileManager generatedFileManager = this;
        synchronized (generatedFileManager) {
            boolean successfullyDeleted;
            this._parentFile2GeneratedFiles.clear();
            this._generatedFile2ParentFiles.clear();
            File state = this.getSerializationFile(this._jProject.getProject());
            if (state != null && !(successfullyDeleted = state.delete()) && state.exists()) {
                AptPlugin.log(new IOException("Could not delete apt dependency state file"), state.getPath());
            }
        }
    }

    public synchronized boolean containsWorkingCopyMapEntriesForParent(IFile f) {
        Set<IFile> generatedFiles;
        Collection<Set<IFile>> parentSets = this._generatedWorkingCopy2OpenParentFiles.values();
        if (parentSets != null) {
            for (Set<IFile> s : parentSets) {
                if (!s.contains(f)) continue;
                return true;
            }
        }
        if ((generatedFiles = this._parentFile2GeneratedFiles.get(f)) != null) {
            for (IFile gf : generatedFiles) {
                Set<IFile> parents;
                ICompilationUnit cu = this._generatedFile2WorkingCopy.get(gf);
                if (cu == null || !(parents = this._generatedWorkingCopy2OpenParentFiles.get(cu)).contains(cu) && parents.size() != 0) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized void readState() {
        File file = this.getSerializationFile(this._jProject.getProject());
        if (file == null || !file.exists()) {
            return;
        }
        FilterInputStream in = null;
        try {
            try {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                int version = ((DataInputStream)in).readInt();
                if (version != 1) {
                    throw new IOException("Dependency map file version does not match. Expected 1, but found " + version);
                }
                int sizeOfMap = ((DataInputStream)in).readInt();
                int parentIndex = 0;
                while (parentIndex < sizeOfMap) {
                    String parentPath = ((DataInputStream)in).readUTF();
                    IFile parent = this.convertPathToIFile(parentPath);
                    HashSet<IFile> children = new HashSet<IFile>();
                    this._parentFile2GeneratedFiles.put(parent, children);
                    int numChildren = ((DataInputStream)in).readInt();
                    int childIndex = 0;
                    while (childIndex < numChildren) {
                        String childPath = ((DataInputStream)in).readUTF();
                        IFile child = this.convertPathToIFile(childPath);
                        children.add(child);
                        Set<IFile> parentSet = this._generatedFile2ParentFiles.get(child);
                        if (parentSet == null) {
                            parentSet = new HashSet<IFile>();
                            this._generatedFile2ParentFiles.put(child, parentSet);
                        }
                        parentSet.add(parent);
                        ++childIndex;
                    }
                    ++parentIndex;
                }
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, "Could not deserialize APT dependencies");
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void writeState() {
        if (!this._mapsDirty) {
            return;
        }
        File file = this.getSerializationFile(this._jProject.getProject());
        if (file == null) {
            return;
        }
        file.delete();
        DataOutputStream out = null;
        try {
            try {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                out.writeInt(1);
                out.writeInt(this._parentFile2GeneratedFiles.size());
                for (Map.Entry<IFile, Set<IFile>> entry : this._parentFile2GeneratedFiles.entrySet()) {
                    IFile parent = entry.getKey();
                    out.writeUTF(this.convertIFileToPath(parent));
                    Set<IFile> children = entry.getValue();
                    out.writeInt(children.size());
                    for (IFile child : children) {
                        out.writeUTF(this.convertIFileToPath(child));
                    }
                }
                this._mapsDirty = false;
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, "Could not serialize APT dependencies");
            }
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ioe) {
                    AptPlugin.log(ioe, "Failed to write the APT dependency state to disk");
                }
            }
        }
    }

    private IFile convertPathToIFile(String projectRelativeString) {
        Path path = new Path(projectRelativeString);
        return this._jProject.getProject().getFile((IPath)path);
    }

    private String convertIFileToPath(IFile file) {
        IPath path = file.getProjectRelativePath();
        return path.toOSString();
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.jdt.apt.core");
        return workingLocation.append("state.dat").toFile();
    }
}

