/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.Filer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.env.AbstractCompilationEnv;
import org.eclipse.jdt.apt.core.internal.env.MessagerImpl;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;

public class ReconcileEnv
extends AbstractCompilationEnv
implements EclipseAnnotationProcessorEnvironment {
    static ReconcileEnv newEnv(ReconcileContext reconcileContext) {
        CompilationUnit compilationUnit = null;
        try {
            compilationUnit = reconcileContext.getAST3();
        }
        catch (JavaModelException javaModelException) {}
        if (compilationUnit == null) {
            compilationUnit = EMPTY_AST_UNIT;
        }
        ICompilationUnit workingCopy = reconcileContext.getWorkingCopy();
        IJavaProject javaProject = workingCopy.getJavaProject();
        IFile file = (IFile)workingCopy.getResource();
        return new ReconcileEnv(compilationUnit, file, javaProject);
    }

    private ReconcileEnv(CompilationUnit astCompilationUnit, IFile file, IJavaProject javaProj) {
        super(astCompilationUnit, file, javaProj, Phase.RECONCILE);
    }

    void addMessage(IFile resource, int start, int end, MessagerImpl.Severity severity, String msg, int line, String[] arguments) {
        this.checkValid();
        if (resource == null) {
            resource = this.getFile();
        }
        assert (resource != null) : "don't know about the current resource";
        if (resource != null && !resource.equals((Object)this.getFile())) {
            return;
        }
        this._problems.add(this.createProblem(resource, start, end, severity, msg, line, arguments));
    }

    public CompilationUnit getASTFrom(IFile file) {
        if (this._file.equals((Object)file)) {
            return this._astRoot;
        }
        return null;
    }

    public void addTypeDependency(String fullyQualifiedTypeName) {
    }

    public Filer getFiler() {
        return new NoOpFiler();
    }

    void openPipeline() {
        this._requestor = new CallbackRequestor();
        ReconcileEnv.createASTs(this._javaProject, NO_UNIT, this._requestor);
    }

    private static final class NoOpFiler
    implements Filer {
        private static final OutputStream NO_OP_STREAM = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        private static final PrintWriter NO_OP_WRITER = new PrintWriter(new NoOpWriter());

        private NoOpFiler() {
        }

        public OutputStream createBinaryFile(Filer.Location loc, String pkg, File relPath) throws IOException {
            return NO_OP_STREAM;
        }

        public OutputStream createClassFile(String name) throws IOException {
            return NO_OP_STREAM;
        }

        public PrintWriter createSourceFile(String typeName) throws IOException {
            return NO_OP_WRITER;
        }

        public PrintWriter createTextFile(Filer.Location loc, String pkg, File relPath, String charsetName) throws IOException {
            return NO_OP_WRITER;
        }
    }

    private static final class NoOpWriter
    extends Writer {
        private NoOpWriter() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    class CallbackRequestor
    extends ASTRequestor {
        CallbackRequestor() {
        }

        public void acceptBinding(String bindingKey, IBinding binding) {
            ReconcileEnv.this._callback.run(ReconcileEnv.this);
        }
    }
}

