/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal.beans;

import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ListenerSupport {
    private Set elementsListenedTo = new HashSet();
    private PropertyChangeListener listener;

    public ListenerSupport(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void hookListener(Object target) {
        Method addPropertyChangeListenerMethod = null;
        try {
            addPropertyChangeListenerMethod = target.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (addPropertyChangeListenerMethod != null) {
            try {
                addPropertyChangeListenerMethod.invoke(target, this.listener);
                this.elementsListenedTo.add(new IdentityWrapper(target));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public void setHookTargets(Object[] targets) {
        HashSet elementsToUnhook = new HashSet(this.elementsListenedTo);
        if (targets != null) {
            int i = 0;
            while (i < targets.length) {
                Object newValue = targets[i];
                IdentityWrapper identityWrapper = new IdentityWrapper(newValue);
                if (!elementsToUnhook.remove(identityWrapper)) {
                    this.hookListener(newValue);
                }
                ++i;
            }
        }
        for (Object o : elementsToUnhook) {
            if (o.getClass() != IdentityWrapper.class) {
                o = new IdentityWrapper(o);
            }
            this.elementsListenedTo.remove(o);
            this.unhookListener(o);
        }
    }

    public void unhookListener(Object target) {
        if (target.getClass() == IdentityWrapper.class) {
            target = ((IdentityWrapper)target).o;
        }
        Method removePropertyChangeListenerMethod = null;
        try {
            removePropertyChangeListenerMethod = target.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (removePropertyChangeListenerMethod != null) {
            try {
                removePropertyChangeListenerMethod.invoke(target, this.listener);
                this.elementsListenedTo.remove(new IdentityWrapper(target));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public void dispose() {
        if (this.elementsListenedTo != null) {
            Object[] targets = this.elementsListenedTo.toArray();
            int i = 0;
            while (i < targets.length) {
                this.unhookListener(targets[i]);
                ++i;
            }
            this.elementsListenedTo = null;
            this.listener = null;
        }
    }

    public Object[] getHookedTargets() {
        Object[] targets = null;
        if (this.elementsListenedTo != null && this.elementsListenedTo.size() > 0) {
            Object[] identityList = this.elementsListenedTo.toArray();
            targets = new Object[identityList.length];
            int i = 0;
            while (i < identityList.length) {
                targets[i] = ((IdentityWrapper)identityList[i]).o;
                ++i;
            }
        }
        return targets;
    }

    static class IdentityWrapper {
        final Object o;

        IdentityWrapper(Object o) {
            this.o = o;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != IdentityWrapper.class) {
                return false;
            }
            return this.o == ((IdentityWrapper)obj).o;
        }

        public int hashCode() {
            return System.identityHashCode(this.o);
        }
    }
}

