/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.HierarchicalModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElementSorter;
import org.eclipse.team.internal.ui.synchronize.UnchangedResourceModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class CompressedFoldersModelProvider
extends HierarchicalModelProvider {
    private static final CompressedFolderModelProviderDescriptor compressedDescriptor = new CompressedFolderModelProviderDescriptor();

    public CompressedFoldersModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(configuration, set);
    }

    public CompressedFoldersModelProvider(AbstractSynchronizeModelProvider parentProvider, ISynchronizeModelElement modelRoot, ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(parentProvider, modelRoot, configuration, set);
    }

    public ISynchronizeModelProviderDescriptor getDescriptor() {
        return compressedDescriptor;
    }

    public ViewerSorter getViewerSorter() {
        return new SynchronizeModelElementSorter(){

            protected int compareNames(IResource resource1, IResource resource2) {
                if (resource1.getType() == 2 && resource2.getType() == 2) {
                    return this.collator.compare(resource1.getProjectRelativePath().toString(), resource2.getProjectRelativePath().toString());
                }
                return super.compareNames(resource1, resource2);
            }
        };
    }

    protected IDiffElement[] createModelObjects(ISynchronizeModelElement container) {
        Object resource = null;
        resource = container == this.getModelRoot() ? ResourcesPlugin.getWorkspace().getRoot() : container.getResource();
        if (resource != null) {
            if (resource.getType() == 4) {
                return this.getProjectChildren(container, (IProject)resource);
            }
            if (resource.getType() == 2) {
                return this.getFolderChildren(container, (IResource)resource);
            }
        }
        return super.createModelObjects(container);
    }

    private IDiffElement[] getFolderChildren(ISynchronizeModelElement parent, IResource resource) {
        IResource[] children = this.getSyncInfoTree().members(resource);
        ArrayList<ISynchronizeModelElement> result = new ArrayList<ISynchronizeModelElement>();
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            if (child.getType() == 1) {
                result.add(this.createModelObject(parent, child));
            }
            ++i;
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    private IDiffElement[] getProjectChildren(ISynchronizeModelElement parent, IProject project) {
        SyncInfo[] outOfSync = this.getSyncInfoTree().getSyncInfos((IResource)project, 2);
        HashSet<ISynchronizeModelElement> result = new HashSet<ISynchronizeModelElement>();
        HashSet<Object> resourcesToShow = new HashSet<Object>();
        int i = 0;
        while (i < outOfSync.length) {
            SyncInfo syncInfo = outOfSync[i];
            IResource local = syncInfo.getLocal();
            if (local.getProjectRelativePath().segmentCount() == 1 && local.getType() == 1) {
                resourcesToShow.add(local);
            } else if (local.getType() == 1) {
                resourcesToShow.add(local.getParent());
            } else if (local.getType() == 2) {
                resourcesToShow.add(local);
            }
            ++i;
        }
        for (IResource iResource : resourcesToShow) {
            result.add(this.createModelObject(parent, iResource));
        }
        return result.toArray(new IDiffElement[result.size()]);
    }

    protected ISynchronizeModelElement createModelObject(ISynchronizeModelElement parent, IResource resource) {
        if (resource.getType() == 2) {
            SyncInfo info = this.getSyncInfoTree().getSyncInfo(resource);
            SynchronizeModelElement newNode = info != null ? new CompressedFolderDiffNode(parent, info) : new UnchangedCompressedDiffNode(parent, resource);
            this.addToViewer(newNode);
            return newNode;
        }
        return super.createModelObject(parent, resource);
    }

    protected void handleResourceAdditions(ISyncInfoTreeChangeEvent event) {
        SyncInfo[] infos = event.getAddedResources();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            this.addResource(info);
            ++i;
        }
    }

    protected void addResource(SyncInfo info) {
        IResource local = info.getLocal();
        ISynchronizeModelElement existingNode = this.getModelObject(local);
        if (existingNode == null) {
            if (local.getType() == 1) {
                ISynchronizeModelElement parentNode = this.getModelObject((IResource)local.getParent());
                if (parentNode == null) {
                    ISynchronizeModelElement projectNode = this.getModelObject((IResource)local.getProject());
                    if (projectNode == null) {
                        projectNode = this.createModelObject(this.getModelRoot(), (IResource)local.getProject());
                    }
                    parentNode = local.getParent().getType() == 4 ? projectNode : this.createModelObject(projectNode, (IResource)local.getParent());
                }
                this.createModelObject(parentNode, local);
            } else {
                ISynchronizeModelElement projectNode = this.getModelObject((IResource)local.getProject());
                if (projectNode == null) {
                    projectNode = this.createModelObject(this.getModelRoot(), (IResource)local.getProject());
                }
                this.createModelObject(projectNode, local);
            }
        } else {
            this.handleChange(existingNode, info);
        }
    }

    protected void handleResourceRemovals(ISyncInfoTreeChangeEvent event) {
        IResource[] roots = event.getRemovedSubtreeRoots();
        ArrayList<IResource> removedProjects = new ArrayList<IResource>();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            if (resource.getType() == 4) {
                this.removeFromViewer(resource);
                removedProjects.add(resource);
            }
            ++i;
        }
        IResource[] resources = event.getRemovedResources();
        ArrayList<Object> resourcesToRemove = new ArrayList<Object>();
        ArrayList resourcesToAdd = new ArrayList();
        int i2 = 0;
        while (i2 < resources.length) {
            IResource resource = resources[i2];
            if (!removedProjects.contains(resource.getProject())) {
                if (resource.getType() == 1) {
                    if (this.isCompressedParentEmpty(resource) && !this.isOutOfSync((IResource)resource.getParent())) {
                        resourcesToRemove.add(resource.getParent());
                    } else {
                        resourcesToRemove.add(resource);
                    }
                } else {
                    resourcesToRemove.add(resource);
                    if (this.hasFileMembers((IContainer)resource)) {
                        resourcesToAdd.addAll(Arrays.asList(this.getSyncInfosForFileMembers((IContainer)resource)));
                    }
                }
            }
            ++i2;
        }
        if (!resourcesToRemove.isEmpty()) {
            this.removeFromViewer(resourcesToRemove.toArray(new IResource[resourcesToRemove.size()]));
        }
        if (!resourcesToAdd.isEmpty()) {
            this.addResources(resourcesToAdd.toArray(new SyncInfo[resourcesToAdd.size()]));
        }
    }

    protected int getLogicalModelDepth(IResource resource) {
        if (resource.getType() == 4) {
            return 2;
        }
        return 1;
    }

    private boolean isCompressedParentEmpty(IResource resource) {
        IContainer parent = resource.getParent();
        if (parent == null || parent.getType() == 8 || parent.getType() == 4) {
            return false;
        }
        return !this.hasFileMembers(parent);
    }

    private boolean hasFileMembers(IContainer parent) {
        IResource[] members = this.getSyncInfoTree().members((IResource)parent);
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (member.getType() == 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private SyncInfo[] getSyncInfosForFileMembers(IContainer parent) {
        ArrayList<SyncInfo> result = new ArrayList<SyncInfo>();
        IResource[] members = this.getSyncInfoTree().members((IResource)parent);
        int i = 0;
        while (i < members.length) {
            IResource member = members[i];
            if (member.getType() == 1) {
                result.add(this.getSyncInfoTree().getSyncInfo(member));
            }
            ++i;
        }
        return result.toArray(new SyncInfo[result.size()]);
    }

    protected class UnchangedCompressedDiffNode
    extends UnchangedResourceModelElement {
        public UnchangedCompressedDiffNode(IDiffContainer parent, IResource resource) {
            super(parent, resource);
        }

        public String getName() {
            IResource resource = this.getResource();
            return resource.getProjectRelativePath().toString();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return TeamUIPlugin.getImageDescriptor("obj/compressed_folder_obj.gif");
        }
    }

    public class CompressedFolderDiffNode
    extends SyncInfoModelElement {
        public CompressedFolderDiffNode(IDiffContainer parent, SyncInfo info) {
            super(parent, info);
        }

        public String getName() {
            IResource resource = this.getResource();
            return resource.getProjectRelativePath().toString();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return TeamUIPlugin.getImageDescriptor("obj/compressed_folder_obj.gif");
        }
    }

    public static class CompressedFolderModelProviderDescriptor
    implements ISynchronizeModelProviderDescriptor {
        public static final String ID = "org.eclipse.team.ui.modelprovider_compressedfolders";

        public String getId() {
            return ID;
        }

        public String getName() {
            return TeamUIMessages.CompressedFoldersModelProvider_0;
        }

        public ImageDescriptor getImageDescriptor() {
            return TeamUIPlugin.getImageDescriptor("obj/compressed_folder_obj.gif");
        }
    }
}

