/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelTraversalCalculator;
import org.eclipse.team.internal.ui.mapping.SynchronizationResourceMappingContext;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelParticipantAction;

public abstract class ResourceModelParticipantAction
extends ModelParticipantAction {
    public ResourceModelParticipantAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected ResourceTraversal[] getResourceTraversals(IStructuredSelection selection, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(null, selection.size() * 100);
            CompoundResourceTraversal traversal = new CompoundResourceTraversal();
            if (selection instanceof ITreeSelection) {
                ITreeSelection ts = (ITreeSelection)selection;
                TreePath[] paths = ts.getPaths();
                int i = 0;
                while (i < paths.length) {
                    TreePath path = paths[i];
                    ResourceTraversal[] traversals = this.getTraversals(path, Policy.subMonitorFor(monitor, 100));
                    traversal.addTraversals(traversals);
                    ++i;
                }
            } else {
                for (Object element : selection) {
                    ResourceTraversal[] traversals = this.getTraversals(element, Policy.subMonitorFor(monitor, 100));
                    traversal.addTraversals(traversals);
                }
            }
            ResourceTraversal[] resourceTraversalArray = traversal.asTraversals();
            return resourceTraversalArray;
        }
        finally {
            monitor.done();
        }
    }

    private ResourceTraversal[] getTraversals(Object element, IProgressMonitor monitor) throws CoreException {
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            return mapping.getTraversals(this.getResourceMappingContext(), monitor);
        }
        return null;
    }

    protected ResourceMappingContext getResourceMappingContext() {
        return new SynchronizationResourceMappingContext(this.getSynchronizationContext());
    }

    protected ResourceModelTraversalCalculator getTraversalCalculator() {
        return (ResourceModelTraversalCalculator)this.getConfiguration().getProperty("org.eclipse.team.ui.resourceModelraversalCalculator");
    }

    private ResourceTraversal[] getTraversals(TreePath path, IProgressMonitor monitor) throws CoreException {
        if (path.getSegmentCount() > 0) {
            DiffChangeSet set = this.getChangeSet(path);
            Object o = path.getLastSegment();
            if (set != null) {
                if (path.getSegmentCount() == 1) {
                    return new ResourceTraversal[]{new ResourceTraversal(set.getResources(), 0, 0)};
                }
                if (o instanceof IResource) {
                    IResource resource = (IResource)o;
                    int depth = this.getTraversalCalculator().getLayoutDepth(resource, path);
                    IDiff[] diffs = set.getDiffTree().getDiffs(resource, depth);
                    HashSet<IResource> resources = new HashSet<IResource>();
                    int i = 0;
                    while (i < diffs.length) {
                        IDiff diff = diffs[i];
                        IResource r = ResourceDiffTree.getResourceFor((IDiff)diff);
                        if (r != null) {
                            resources.add(r);
                        }
                        ++i;
                    }
                    return new ResourceTraversal[]{new ResourceTraversal(resources.toArray(new IResource[resources.size()]), 0, 0)};
                }
            }
            if (this.getTraversalCalculator().isResourcePath(path)) {
                IResource resource = (IResource)o;
                return this.getTraversalCalculator().getTraversals(resource, path);
            }
            return this.getTraversals(o, monitor);
        }
        return null;
    }

    private DiffChangeSet getChangeSet(TreePath path) {
        Object o = path.getFirstSegment();
        if (o instanceof DiffChangeSet) {
            return (DiffChangeSet)o;
        }
        return null;
    }
}

