/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.bundle;

import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.text.bundle.CompositeManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;

public abstract class BasePackageHeader
extends CompositeManifestHeader {
    private static final long serialVersionUID = 1L;

    public BasePackageHeader(String name, String value, IBundle bundle, String lineDelimiter) {
        super(name, value, bundle, lineDelimiter, true);
    }

    protected String getVersionAttribute() {
        int manifestVersion = BundlePluginBase.getBundleManifestVersion(this.getBundle());
        return manifestVersion < 2 ? "specification-version" : "version";
    }

    public void addPackage(PackageObject object) {
        this.addManifestElement(object);
    }

    public Object removePackage(PackageObject object) {
        return this.removeManifestElement(object);
    }

    public boolean hasPackage(String packageName) {
        return this.hasElement(packageName);
    }

    public Object removePackage(String name) {
        return this.removeManifestElement(name);
    }

    public boolean renamePackage(String oldName, String newName) {
        if (this.hasPackage(oldName)) {
            PackageObject object = (PackageObject)this.removeManifestElement(oldName);
            object.setName(newName);
            this.addManifestElement(object);
            return true;
        }
        return false;
    }
}

