/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class PDEPluginConverter {
    public static void convertToOSGIFormat(IProject project, String target, Dictionary dictionary, IProgressMonitor monitor) throws CoreException {
        PDEPluginConverter.convertToOSGIFormat(project, target, dictionary, null, monitor);
    }

    public static void convertToOSGIFormat(IProject project, String target, Dictionary dictionary, HashMap newProps, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                File outputFile = new File(project.getLocation().append("META-INF/MANIFEST.MF").toOSString());
                File inputFile = new File(project.getLocation().toOSString());
                ServiceTracker tracker = new ServiceTracker(PDECore.getDefault().getBundleContext(), PluginConverter.class.getName(), null);
                tracker.open();
                PluginConverter converter = (PluginConverter)tracker.getService();
                converter.convertManifest(inputFile, outputFile, false, target, true, dictionary);
                if (newProps != null && newProps.size() > 0) {
                    converter.writeManifest(outputFile, (Dictionary)PDEPluginConverter.getProperties(outputFile, newProps), false);
                }
                project.refreshLocal(2, null);
                tracker.close();
            }
            catch (PluginConversionException pluginConversionException) {}
        }
        finally {
            monitor.done();
        }
    }

    public static void createBundleForFramework(IProject project, HashMap newProps, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                File outputFile = new File(project.getLocation().append("META-INF/MANIFEST.MF").toOSString());
                File inputFile = new File(project.getLocation().toOSString());
                ServiceTracker tracker = new ServiceTracker(PDECore.getDefault().getBundleContext(), PluginConverter.class.getName(), null);
                tracker.open();
                PluginConverter converter = (PluginConverter)tracker.getService();
                double version = TargetPlatform.getTargetVersion();
                String versionString = version <= 3.1 ? "3.1" : TargetPlatform.getTargetVersionString();
                converter.convertManifest(inputFile, outputFile, false, versionString, true, null);
                Properties prop = PDEPluginConverter.getProperties(outputFile, newProps);
                prop.remove("Eclipse-AutoStart");
                prop.remove("Eclipse-LazyStart");
                converter.writeManifest(outputFile, (Dictionary)prop, false);
                project.refreshLocal(2, null);
                tracker.close();
            }
            catch (PluginConversionException pluginConversionException) {
            }
            catch (CoreException coreException) {}
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getProperties(File file, HashMap newProps) {
        FileInputStream manifestStream;
        block13: {
            Properties properties;
            manifestStream = null;
            try {
                manifestStream = new FileInputStream(file);
                Manifest manifest = new Manifest(manifestStream);
                Properties prop = PDEPluginConverter.manifestToProperties(manifest.getMainAttributes());
                if (newProps != null && newProps.size() > 0) {
                    Iterator iter = newProps.keySet().iterator();
                    while (iter.hasNext()) {
                        String key = iter.next().toString();
                        prop.put(key, newProps.get(key));
                    }
                }
                properties = prop;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    break block13;
                    catch (IOException iOException) {
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (manifestStream == null) throw throwable;
                        ((InputStream)manifestStream).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (manifestStream == null) return properties;
                ((InputStream)manifestStream).close();
                return properties;
            }
            catch (IOException iOException) {}
            return properties;
        }
        try {
            if (manifestStream == null) return new Properties();
            ((InputStream)manifestStream).close();
            return new Properties();
        }
        catch (IOException iOException) {}
        return new Properties();
    }

    public static void modifyBundleClasspathHeader(IProject project, IPluginModelBase model) {
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        if (file.exists()) {
            InputStream manifestStream = null;
            try {
                try {
                    manifestStream = new FileInputStream(file.getLocation().toFile());
                    Manifest manifest = new Manifest(manifestStream);
                    Properties prop = PDEPluginConverter.manifestToProperties(manifest.getMainAttributes());
                    String classpath = prop.getProperty("Bundle-ClassPath");
                    if (classpath == null) {
                        prop.put("Bundle-ClassPath", ClasspathUtilCore.getFilename(model));
                    } else {
                        ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
                        StringBuffer buffer = new StringBuffer();
                        int i = 0;
                        while (i < elements.length) {
                            if (buffer.length() > 0) {
                                buffer.append(",");
                                buffer.append(System.getProperty("line.separator"));
                                buffer.append(" ");
                            }
                            if (elements[i].getValue().equals(".")) {
                                buffer.append(ClasspathUtilCore.getFilename(model));
                            } else {
                                buffer.append(elements[i].getValue());
                            }
                            ++i;
                        }
                        prop.put("Bundle-ClassPath", buffer.toString());
                    }
                    ServiceTracker tracker = new ServiceTracker(PDECore.getDefault().getBundleContext(), PluginConverter.class.getName(), null);
                    tracker.open();
                    PluginConverter converter = (PluginConverter)tracker.getService();
                    converter.writeManifest(new File(file.getLocation().toOSString()), (Dictionary)prop, false);
                    file.refreshLocal(1, null);
                    tracker.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                }
                catch (BundleException bundleException) {
                }
                catch (PluginConversionException pluginConversionException) {
                }
                catch (CoreException coreException) {}
            }
            catch (Throwable throwable) {
                try {
                    if (manifestStream != null) {
                        manifestStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (manifestStream != null) {
                    manifestStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }
}

