/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.dnd.NavigatorDnDService;
import org.eclipse.ui.internal.navigator.dnd.NavigatorPluginDropAction;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.PluginTransfer;

public final class CommonDropAdapter
extends PluginDropAdapter {
    private static final Transfer[] SUPPORTED_DROP_TRANSFERS = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
    private static final boolean DEBUG = false;
    private final INavigatorContentService contentService;
    private final NavigatorDnDService dndService;

    public CommonDropAdapter(INavigatorContentService aContentService, StructuredViewer aStructuredViewer) {
        super(aStructuredViewer);
        this.contentService = aContentService;
        this.dndService = (NavigatorDnDService)this.contentService.getDnDService();
    }

    public Transfer[] getSupportedDropTransfers() {
        return SUPPORTED_DROP_TRANSFERS;
    }

    public void dragEnter(DropTargetEvent event) {
        super.dragEnter(event);
        int i = 0;
        while (i < event.dataTypes.length) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                return;
            }
            ++i;
        }
        i = 0;
        while (i < event.dataTypes.length) {
            if (FileTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                event.detail = 1;
                return;
            }
            ++i;
        }
        i = 0;
        while (i < event.dataTypes.length) {
            if (PluginTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                return;
            }
            ++i;
        }
        event.detail = 0;
    }

    public void dragLeave(DropTargetEvent event) {
        super.dragLeave(event);
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            event.data = NavigatorPluginDropAction.createTransferData(this.contentService);
        }
    }

    public void drop(DropTargetEvent event) {
        if (PluginTransfer.getInstance().isSupportedType(event.currentDataType)) {
            super.drop(event);
        } else {
            Object target = this.getCurrentTarget() != null ? this.getCurrentTarget() : this.getViewer().getInput();
            CommonDropAdapterAssistant[] assistants = this.dndService.findCommonDropAdapterAssistants(target, this.getCurrentTransfer());
            IStatus valid = null;
            int i = 0;
            while (i < assistants.length) {
                try {
                    valid = assistants[i].validateDrop(this.getCurrentTarget(), this.getCurrentOperation(), this.getCurrentTransfer());
                    if (valid != null && valid.isOK()) {
                        assistants[i].handleDrop(this, event, this.getCurrentTarget());
                        return;
                    }
                }
                catch (Throwable t) {
                    NavigatorPlugin.logError(0, t.getMessage(), t);
                }
                ++i;
            }
        }
    }

    public boolean validateDrop(Object aDropTarget, int theDropOperation, TransferData theTransferData) {
        boolean result = false;
        IStatus valid = null;
        if (super.validateDrop(aDropTarget, theDropOperation, theTransferData)) {
            result = true;
        } else {
            Object target = aDropTarget != null ? aDropTarget : this.getViewer().getInput();
            CommonDropAdapterAssistant[] assistants = this.dndService.findCommonDropAdapterAssistants(target, theTransferData);
            int i = 0;
            while (i < assistants.length) {
                try {
                    valid = assistants[i].validateDrop(target, theDropOperation, theTransferData);
                }
                catch (Throwable t) {
                    NavigatorPlugin.logError(0, t.getMessage(), t);
                }
                if (valid != null && valid.isOK()) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public Rectangle getBounds(Item item) {
        return super.getBounds(item);
    }

    public int getCurrentLocation() {
        return super.getCurrentLocation();
    }

    public int getCurrentOperation() {
        return super.getCurrentOperation();
    }

    public Object getCurrentTarget() {
        return super.getCurrentTarget();
    }

    public TransferData getCurrentTransfer() {
        return super.getCurrentTransfer();
    }
}

