/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.filters.CommonFilterDescriptor;
import org.eclipse.ui.internal.navigator.filters.CommonFilterDescriptorManager;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorFilterService;

public class NavigatorFilterService
implements INavigatorFilterService {
    private static final ViewerFilter[] NO_FILTERS = new ViewerFilter[0];
    private static final String ACTIVATION_KEY = ".filterActivation";
    private static final String DELIM = ":";
    private final NavigatorContentService contentService;
    private final Map declaredViewerFilters = new HashMap();
    private final Set enforcedViewerFilters = new HashSet();
    private final Set activeFilters = new HashSet();

    public NavigatorFilterService(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.restoreFilterActivation();
    }

    private synchronized void restoreFilterActivation() {
        try {
            Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
            if (preferences.contains(this.getFilterActivationPreferenceKey())) {
                String activatedFiltersPreferenceValue = preferences.getString(this.getFilterActivationPreferenceKey());
                String[] activeFilterIds = activatedFiltersPreferenceValue.split(DELIM);
                int i = 0;
                while (i < activeFilterIds.length) {
                    this.activeFilters.add(activeFilterIds[i]);
                    ++i;
                }
            } else {
                ICommonFilterDescriptor[] visibleFilterDescriptors = this.getVisibleFilterDescriptors();
                int i = 0;
                while (i < visibleFilterDescriptors.length) {
                    if (visibleFilterDescriptors[i].isActiveByDefault()) {
                        this.activeFilters.add(visibleFilterDescriptors[i].getId());
                    }
                    ++i;
                }
            }
        }
        catch (RuntimeException e) {
            NavigatorPlugin.logError(0, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistFilterActivationState() {
        try {
            Set set = this.activeFilters;
            synchronized (set) {
                StringBuffer activatedFiltersPreferenceValue = new StringBuffer();
                Iterator activeItr = this.activeFilters.iterator();
                while (activeItr.hasNext()) {
                    activatedFiltersPreferenceValue.append(activeItr.next().toString()).append(DELIM);
                }
                Preferences preferences = NavigatorPlugin.getDefault().getPluginPreferences();
                preferences.setValue(this.getFilterActivationPreferenceKey(), activatedFiltersPreferenceValue.toString());
            }
        }
        catch (RuntimeException e) {
            NavigatorPlugin.logError(0, e.getMessage(), e);
        }
    }

    private String getFilterActivationPreferenceKey() {
        return String.valueOf(this.contentService.getViewerId()) + ACTIVATION_KEY;
    }

    public ViewerFilter[] getVisibleFilters(boolean toReturnOnlyActiveFilters) {
        CommonFilterDescriptor[] descriptors = CommonFilterDescriptorManager.getInstance().findVisibleFilters(this.contentService);
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        int i = 0;
        while (i < descriptors.length) {
            ViewerFilter instance;
            if ((!toReturnOnlyActiveFilters || this.isActive(descriptors[i].getId())) && (instance = this.getViewerFilter(descriptors[i])) != null) {
                filters.add(instance);
            }
            ++i;
        }
        filters.addAll(this.enforcedViewerFilters);
        if (filters.size() == 0) {
            return NO_FILTERS;
        }
        return filters.toArray(new ViewerFilter[filters.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewerFilter getViewerFilter(ICommonFilterDescriptor descriptor) {
        ViewerFilter filter = (ViewerFilter)this.declaredViewerFilters.get(descriptor);
        if (filter != null) {
            return filter;
        }
        Map map = this.declaredViewerFilters;
        synchronized (map) {
            filter = (ViewerFilter)this.declaredViewerFilters.get(descriptor);
            if (filter == null) {
                filter = ((CommonFilterDescriptor)descriptor).createFilter();
                this.declaredViewerFilters.put(descriptor, filter);
            }
        }
        return filter;
    }

    public ICommonFilterDescriptor[] getVisibleFilterDescriptors() {
        return CommonFilterDescriptorManager.getInstance().findVisibleFilters(this.contentService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(String aFilterId) {
        Set set = this.activeFilters;
        synchronized (set) {
            return this.activeFilters.contains(aFilterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveFilterIds(String[] theFilterIds) {
        Assert.isNotNull((Object)theFilterIds);
        Set set = this.activeFilters;
        synchronized (set) {
            this.activeFilters.clear();
            this.activeFilters.addAll((Collection)Arrays.asList(theFilterIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveFilterIds(String[] theFilterIds) {
        Assert.isNotNull((Object)theFilterIds);
        Set set = this.activeFilters;
        synchronized (set) {
            this.activeFilters.addAll((Collection)Arrays.asList(theFilterIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(String aFilterId, boolean toMakeActive) {
        Set set = this.activeFilters;
        synchronized (set) {
            boolean isActive = this.activeFilters.contains(aFilterId);
            if (isActive ^ toMakeActive) {
                if (toMakeActive) {
                    this.activeFilters.remove(aFilterId);
                } else {
                    this.activeFilters.add(aFilterId);
                }
            }
        }
    }
}

