/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceStats;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.localstore.SafeFileOutputStream;
import org.eclipse.core.internal.resources.DelayedSnapshotJob;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.SaveContext;
import org.eclipse.core.internal.resources.SavedState;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceTreeReader;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.IStringPoolParticipant;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.StringPool;
import org.eclipse.core.internal.utils.WrappedRuntimeException;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.ElementTreeWriter;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IElementInfoFlattener;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class SaveManager
implements IElementInfoFlattener,
IManager,
IStringPoolParticipant {
    protected static final String CLEAR_DELTA_PREFIX = "clearDelta_";
    protected static final String DELTA_EXPIRATION_PREFIX = "deltaExpiration_";
    protected static final int DONE_SAVING = 3;
    private static final long MIN_SNAPSHOT_DELAY = 30000L;
    protected static final int NO_OP_THRESHOLD = 20;
    protected static final int PREPARE_TO_SAVE = 1;
    protected static final int ROLLBACK = 4;
    protected static final String SAVE_NUMBER_PREFIX = "saveNumber_";
    protected static final int SAVING = 2;
    protected ElementTree lastSnap;
    protected Properties masterTable;
    private boolean isSaving = false;
    protected int noopCount = 0;
    protected int operationCount = 0;
    protected long persistMarkers = 0L;
    protected long persistSyncInfo = 0L;
    protected HashMap savedStates;
    protected HashMap saveParticipants;
    protected final DelayedSnapshotJob snapshotJob;
    protected boolean snapshotRequested;
    protected Workspace workspace;
    private static final String DEBUG_START = " starting...";
    private static final String DEBUG_FULL_SAVE = "Full save on workspace: ";
    private static final String DEBUG_PROJECT_SAVE = "Save on project ";
    private static final String DEBUG_SNAPSHOT = "Snapshot: ";

    public SaveManager(Workspace workspace) {
        this.workspace = workspace;
        this.snapshotJob = new DelayedSnapshotJob(this);
        this.snapshotRequested = false;
        this.saveParticipants = new HashMap(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISavedState addParticipant(Plugin plugin, ISaveParticipant participant) throws CoreException {
        HashMap hashMap = this.saveParticipants;
        synchronized (hashMap) {
            if (this.saveParticipants.put(plugin, participant) != null) {
                return null;
            }
        }
        String id = plugin.getBundle().getSymbolicName();
        SavedState state = (SavedState)this.savedStates.get(id);
        if (state != null) {
            if (this.isDeltaCleared(id)) {
                state.forgetTrees();
                this.removeClearDeltaMarks(id);
            } else {
                try {
                    this.workspace.prepareOperation(this.workspace.getRoot(), null);
                    this.workspace.beginOperation(true);
                    state.newTree = this.workspace.getElementTree();
                    return state;
                }
                finally {
                    this.workspace.endOperation(this.workspace.getRoot(), false, null);
                }
            }
        }
        if (this.getSaveNumber(id) <= 0) return null;
        return new SavedState(this.workspace, id, null, null);
    }

    protected void broadcastLifecycle(final int lifecycle, Map contexts, final MultiStatus warnings, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, contexts.size());
            final Iterator it = contexts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Plugin plugin = (Plugin)entry.getKey();
                final ISaveParticipant participant = (ISaveParticipant)this.saveParticipants.get(plugin);
                if (participant == null) {
                    monitor.worked(1);
                    continue;
                }
                final SaveContext context = (SaveContext)entry.getValue();
                ISafeRunnable code = new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        String message = Messages.resources_saveProblem;
                        Status status = new Status(2, "org.eclipse.core.resources", 566, message, e);
                        warnings.add((IStatus)status);
                        it.remove();
                    }

                    public void run() throws Exception {
                        SaveManager.this.executeLifecycle(lifecycle, participant, context);
                    }
                };
                SafeRunner.run((ISafeRunnable)code);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void cleanMasterTable() {
        Iterator<Object> it = this.masterTable.keySet().iterator();
        while (it.hasNext()) {
            IProject project;
            String prefix;
            String key = (String)it.next();
            if (!key.endsWith(".tree") || (prefix = key.substring(0, key.length() - ".tree".length())).equals(Path.ROOT.toString()) || (project = this.workspace.getRoot().getProject(prefix)).exists() && !project.isOpen()) continue;
            it.remove();
        }
        IPath location = this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources");
        IPath backup = this.workspace.getMetaArea().getBackupLocationFor(location);
        try {
            this.saveMasterTable(backup);
        }
        catch (CoreException e) {
            Policy.log(e.getStatus());
            backup.toFile().delete();
            return;
        }
        if (location.toFile().exists() && !location.toFile().delete()) {
            return;
        }
        try {
            this.saveMasterTable(location);
        }
        catch (CoreException e) {
            Policy.log(e.getStatus());
            location.toFile().delete();
            return;
        }
        backup.toFile().delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSavedDelta() {
        HashMap hashMap = this.saveParticipants;
        synchronized (hashMap) {
            Iterator i = this.saveParticipants.keySet().iterator();
            while (i.hasNext()) {
                String pluginId = ((Plugin)i.next()).getBundle().getSymbolicName();
                this.masterTable.setProperty(CLEAR_DELTA_PREFIX + pluginId, "true");
            }
        }
    }

    protected void collapseTrees() throws CoreException {
        ArrayList<ElementTree> trees = new ArrayList<ElementTree>();
        for (SavedState state : this.savedStates.values()) {
            if (state.oldTree == null) continue;
            trees.add(state.oldTree);
        }
        IProject[] projects = this.workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            ArrayList builderInfos;
            IProject project = projects[i];
            if (project.isOpen() && (builderInfos = this.workspace.getBuildManager().createBuildersPersistentInfo(project)) != null) {
                for (BuilderPersistentInfo info : builderInfos) {
                    trees.add(info.getLastBuiltTree());
                }
            }
            ++i;
        }
        if (trees.isEmpty()) {
            return;
        }
        trees.add(this.workspace.getElementTree());
        ElementTree[] treeArray = new ElementTree[trees.size()];
        trees.toArray(treeArray);
        ElementTree[] sorted = this.sortTrees(treeArray);
        if (sorted == null) {
            return;
        }
        int i2 = 1;
        while (i2 < sorted.length) {
            sorted[i2].collapseTo(sorted[i2 - 1]);
            ++i2;
        }
    }

    protected void commit(Map contexts) throws CoreException {
        Iterator i = contexts.values().iterator();
        while (i.hasNext()) {
            ((SaveContext)i.next()).commit();
        }
    }

    protected Map computeSaveContexts(Plugin[] plugins, int kind, IProject project) {
        HashMap<Plugin, SaveContext> result = new HashMap<Plugin, SaveContext>(plugins.length);
        int i = 0;
        while (i < plugins.length) {
            Plugin plugin = plugins[i];
            try {
                SaveContext context = new SaveContext(plugin, kind, project);
                result.put(plugin, context);
            }
            catch (CoreException e) {
                Policy.log(e.getStatus());
            }
            ++i;
        }
        return result;
    }

    protected Map computeStatesToSave(Map contexts, ElementTree current) {
        HashMap<String, ElementTree> result = new HashMap<String, ElementTree>(this.savedStates.size());
        for (SavedState state : this.savedStates.values()) {
            if (state.oldTree == null) continue;
            result.put(state.pluginId, state.oldTree);
        }
        for (SaveContext context : contexts.values()) {
            if (!context.isDeltaNeeded()) continue;
            String pluginId = context.getPlugin().getBundle().getSymbolicName();
            result.put(pluginId, current);
        }
        return result;
    }

    protected void executeLifecycle(int lifecycle, ISaveParticipant participant, SaveContext context) throws CoreException {
        switch (lifecycle) {
            case 1: {
                participant.prepareToSave(context);
                break;
            }
            case 2: {
                try {
                    if (ResourceStats.TRACE_SAVE_PARTICIPANTS) {
                        ResourceStats.startSave(participant);
                    }
                    participant.saving(context);
                    break;
                }
                finally {
                    if (ResourceStats.TRACE_SAVE_PARTICIPANTS) {
                        ResourceStats.endSave();
                    }
                }
            }
            case 3: {
                participant.doneSaving(context);
                break;
            }
            case 4: {
                participant.rollback(context);
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)"Invalid save lifecycle code");
            }
        }
    }

    public void forgetSavedTree(String pluginId) {
        if (pluginId == null) {
            Iterator i = this.savedStates.values().iterator();
            while (i.hasNext()) {
                ((SavedState)i.next()).forgetTrees();
            }
        } else {
            SavedState state = (SavedState)this.savedStates.get(pluginId);
            if (state != null) {
                state.forgetTrees();
            }
        }
    }

    protected long getDeltaExpiration(String pluginId) {
        String result = this.masterTable.getProperty(DELTA_EXPIRATION_PREFIX + pluginId);
        return result == null ? System.currentTimeMillis() : new Long(result);
    }

    protected Properties getMasterTable() {
        return this.masterTable;
    }

    public int getSaveNumber(String pluginId) {
        String value = this.masterTable.getProperty(SAVE_NUMBER_PREFIX + pluginId);
        return value == null ? 0 : new Integer(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Plugin[] getSaveParticipantPlugins() {
        HashMap hashMap = this.saveParticipants;
        synchronized (hashMap) {
            return this.saveParticipants.keySet().toArray(new Plugin[this.saveParticipants.size()]);
        }
    }

    private void hookEndSave(int kind, IProject project, long start) {
        if (ResourceStats.TRACE_SNAPSHOT && kind == 2) {
            ResourceStats.endSnapshot();
        }
        if (Policy.DEBUG_SAVE) {
            String endMessage = null;
            switch (kind) {
                case 1: {
                    endMessage = DEBUG_FULL_SAVE;
                    break;
                }
                case 2: {
                    endMessage = DEBUG_SNAPSHOT;
                    break;
                }
                case 3: {
                    endMessage = DEBUG_PROJECT_SAVE + project.getFullPath() + ": ";
                }
            }
            if (endMessage != null) {
                System.out.println(String.valueOf(endMessage) + (System.currentTimeMillis() - start) + "ms");
            }
        }
    }

    private void hookStartSave(int kind, Project project) {
        if (ResourceStats.TRACE_SNAPSHOT && kind == 2) {
            ResourceStats.startSnapshot();
        }
        if (Policy.DEBUG_SAVE) {
            switch (kind) {
                case 1: {
                    System.out.println("Full save on workspace:  starting...");
                    break;
                }
                case 2: {
                    System.out.println("Snapshot:  starting...");
                    break;
                }
                case 3: {
                    System.out.println(DEBUG_PROJECT_SAVE + project.getFullPath() + DEBUG_START);
                }
            }
        }
    }

    protected void initSnap(IProgressMonitor monitor) throws CoreException {
        this.snapshotJob.cancel();
        this.lastSnap = this.workspace.getElementTree();
        this.lastSnap.immutable();
        this.workspace.newWorkingTree();
        this.operationCount = 0;
        IPath snapPath = this.workspace.getMetaArea().getSnapshotLocationFor(this.workspace.getRoot());
        File file = snapPath.toFile();
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            String message = Messages.resources_snapInit;
            throw new ResourceException(569, null, message, null);
        }
    }

    protected boolean isDeltaCleared(String pluginId) {
        String clearDelta = this.masterTable.getProperty(CLEAR_DELTA_PREFIX + pluginId);
        return clearDelta != null && clearDelta.equals("true");
    }

    protected boolean isOldPluginTree(String pluginId) {
        if (this.isDeltaCleared(pluginId)) {
            return false;
        }
        long deltaAge = System.currentTimeMillis() - this.getDeltaExpiration(pluginId);
        return deltaAge > this.workspace.internalGetDescription().getDeltaExpiration();
    }

    public Object readElement(IPath path, DataInput input) throws IOException {
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)input);
        int flags = input.readInt();
        int type = (flags & 0xF00) >> 8;
        ResourceInfo info = this.workspace.newElement(type);
        info.readFrom(flags, input);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClearDeltaMarks() {
        HashMap hashMap = this.saveParticipants;
        synchronized (hashMap) {
            Iterator i = this.saveParticipants.keySet().iterator();
            while (i.hasNext()) {
                String pluginId = ((Plugin)i.next()).getBundle().getSymbolicName();
                this.removeClearDeltaMarks(pluginId);
            }
        }
    }

    protected void removeClearDeltaMarks(String pluginId) {
        this.masterTable.setProperty(CLEAR_DELTA_PREFIX + pluginId, "false");
    }

    protected void removeFiles(File root, String[] candidates, List exclude) {
        int i = 0;
        while (i < candidates.length) {
            boolean delete = true;
            ListIterator it = exclude.listIterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (!s.equals(candidates[i])) continue;
                it.remove();
                delete = false;
                break;
            }
            if (delete) {
                new File(root, candidates[i]).delete();
            }
            ++i;
        }
    }

    private void removeGarbage(DataOutputStream output, IPath location, IPath tempLocation) throws IOException {
        if (output.size() == 0) {
            output.close();
            location.toFile().delete();
            tempLocation.toFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipant(Plugin plugin) {
        HashMap hashMap = this.saveParticipants;
        synchronized (hashMap) {
            this.saveParticipants.remove(plugin);
        }
    }

    protected void removeUnusedSafeTables() {
        ArrayList<String> valuables = new ArrayList<String>(10);
        IPath location = this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources");
        valuables.add(location.lastSegment());
        Enumeration<Object> e = this.masterTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(SAVE_NUMBER_PREFIX)) continue;
            String pluginId = key.substring(SAVE_NUMBER_PREFIX.length());
            valuables.add(this.workspace.getMetaArea().getSafeTableLocationFor(pluginId).lastSegment());
        }
        File target = location.toFile().getParentFile();
        String[] candidates = target.list();
        if (candidates == null) {
            return;
        }
        this.removeFiles(target, candidates, valuables);
    }

    protected void removeUnusedTreeFiles() {
        ArrayList<String> valuables = new ArrayList<String>(10);
        IPath location = this.workspace.getMetaArea().getTreeLocationFor(this.workspace.getRoot(), false);
        valuables.add(location.lastSegment());
        File target = location.toFile().getParentFile();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".tree");
            }
        };
        String[] candidates = target.list(filter);
        if (candidates != null) {
            this.removeFiles(target, candidates, valuables);
        }
        IProject[] projects = this.workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            location = this.workspace.getMetaArea().getTreeLocationFor(projects[i], false);
            valuables.add(location.lastSegment());
            target = location.toFile().getParentFile();
            candidates = target.list(filter);
            if (candidates != null) {
                this.removeFiles(target, candidates, valuables);
            }
            ++i;
        }
    }

    public void requestSnapshot() {
        this.snapshotRequested = true;
    }

    protected void resetSnapshots(IResource resource) throws CoreException {
        Assert.isLegal((resource.getType() == 8 || resource.getType() == 4 ? 1 : 0) != 0);
        File file = this.workspace.getMetaArea().getMarkersSnapshotLocationFor(resource).toFile();
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            String message = Messages.resources_resetMarkers;
            throw new ResourceException(569, resource.getFullPath(), message, null);
        }
        file = this.workspace.getMetaArea().getSyncInfoSnapshotLocationFor(resource).toFile();
        if (file.exists()) {
            file.delete();
        }
        if (file.exists()) {
            String message = Messages.resources_resetSync;
            throw new ResourceException(569, resource.getFullPath(), message, null);
        }
        if (resource.getType() == 4) {
            return;
        }
        IProject[] projects = ((IWorkspaceRoot)resource).getProjects();
        int i = 0;
        while (i < projects.length) {
            this.resetSnapshots(projects[i]);
            ++i;
        }
    }

    protected void restore(IProgressMonitor monitor) throws CoreException {
        if (Policy.DEBUG_RESTORE) {
            System.out.println("Restore workspace: starting...");
        }
        long start = System.currentTimeMillis();
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, 50);
            this.workspace.newWorkingTree();
            try {
                String msg = Messages.resources_startupProblems;
                MultiStatus problems = new MultiStatus("org.eclipse.core.resources", 567, msg, null);
                this.restoreMasterTable();
                this.restoreTree(Policy.subMonitorFor(monitor, 10));
                this.restoreSnapshots(Policy.subMonitorFor(monitor, 10));
                try {
                    this.restoreMarkers(this.workspace.getRoot(), false, Policy.subMonitorFor(monitor, 10));
                }
                catch (CoreException e) {
                    problems.merge(e.getStatus());
                }
                try {
                    this.restoreSyncInfo(this.workspace.getRoot(), Policy.subMonitorFor(monitor, 10));
                }
                catch (CoreException e) {
                    problems.merge(e.getStatus());
                }
                this.restoreMetaInfo(problems, Policy.subMonitorFor(monitor, 10));
                IProject[] roots = this.workspace.getRoot().getProjects();
                int i = 0;
                while (i < roots.length) {
                    ((Project)roots[i]).startup();
                    ++i;
                }
                if (!problems.isOK()) {
                    Policy.log((IStatus)problems);
                }
            }
            finally {
                this.workspace.getElementTree().immutable();
            }
        }
        finally {
            monitor.done();
        }
        if (Policy.DEBUG_RESTORE) {
            System.out.println("Restore workspace: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void restore(Project project, IProgressMonitor monitor) throws CoreException {
        if (Policy.DEBUG_RESTORE) {
            System.out.println("Restore project " + project.getFullPath() + ": starting...");
        }
        long start = System.currentTimeMillis();
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, 40);
            if (project.isOpen()) {
                this.restoreTree(project, Policy.subMonitorFor(monitor, 10));
            } else {
                monitor.worked(10);
            }
            this.restoreMarkers(project, true, Policy.subMonitorFor(monitor, 10));
            this.restoreSyncInfo(project, Policy.subMonitorFor(monitor, 10));
            this.restoreMetaInfo(project, Policy.subMonitorFor(monitor, 10));
        }
        finally {
            monitor.done();
        }
        if (Policy.DEBUG_RESTORE) {
            System.out.println("Restore project " + project.getFullPath() + ": " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void restoreMarkers(IResource resource, boolean generateDeltas, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((resource.getType() == 8 || resource.getType() == 4 ? 1 : 0) != 0);
        long start = System.currentTimeMillis();
        MarkerManager markerManager = this.workspace.getMarkerManager();
        if (resource.isAccessible()) {
            markerManager.restore(resource, generateDeltas, monitor);
        }
        if (resource.getType() == 4) {
            if (Policy.DEBUG_RESTORE_MARKERS) {
                System.out.println("Restore Markers for " + resource.getFullPath() + ": " + (System.currentTimeMillis() - start) + "ms");
            }
            return;
        }
        IProject[] projects = ((IWorkspaceRoot)resource).getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                markerManager.restore(projects[i], generateDeltas, monitor);
            }
            ++i;
        }
        if (Policy.DEBUG_RESTORE_MARKERS) {
            System.out.println("Restore Markers for workspace: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void restoreMasterTable() throws CoreException {
        long start = System.currentTimeMillis();
        this.masterTable = new Properties();
        IPath location = this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources");
        File target = location.toFile();
        if (!target.exists() && !(target = (location = this.workspace.getMetaArea().getBackupLocationFor(location)).toFile()).exists()) {
            return;
        }
        try {
            SafeChunkyInputStream input = new SafeChunkyInputStream(target);
            try {
                this.masterTable.load(input);
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            String message = Messages.resources_exMasterTable;
            throw new ResourceException(566, null, message, e);
        }
        if (Policy.DEBUG_RESTORE_MASTERTABLE) {
            System.out.println("Restore master table for " + location + ": " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void restoreMetaInfo(MultiStatus problems, IProgressMonitor monitor) {
        if (Policy.DEBUG_RESTORE_METAINFO) {
            System.out.println("Restore workspace metainfo: starting...");
        }
        long start = System.currentTimeMillis();
        IProject[] roots = this.workspace.getRoot().getProjects();
        int i = 0;
        while (i < roots.length) {
            try {
                this.restoreMetaInfo((Project)roots[i], monitor);
            }
            catch (CoreException e) {
                problems.merge(e.getStatus());
            }
            ++i;
        }
        if (Policy.DEBUG_RESTORE_METAINFO) {
            System.out.println("Restore workspace metainfo: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void restoreMetaInfo(Project project, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        ProjectDescription description = null;
        CoreException failure = null;
        try {
            description = project.isOpen() ? this.workspace.getFileSystemManager().read(project, true) : this.workspace.getMetaArea().readOldDescription(project);
        }
        catch (CoreException e) {
            failure = e;
        }
        if (description == null) {
            description = new ProjectDescription();
            description.setName(project.getName());
            this.workspace.getMetaArea().readPrivateDescription(project, description);
        }
        project.internalSetDescription(description, false);
        if (failure != null) {
            project.internalClose();
            throw failure;
        }
        if (Policy.DEBUG_RESTORE_METAINFO) {
            System.out.println("Restore metainfo for " + project.getFullPath() + ": " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void restoreSnapshots(IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, 100);
            IPath snapLocation = this.workspace.getMetaArea().getSnapshotLocationFor(this.workspace.getRoot());
            File localFile = snapLocation.toFile();
            if (!localFile.exists()) {
                this.initSnap(Policy.subMonitorFor(monitor, 50));
                return;
            }
            this.workspace.setCrashed(true);
            try {
                ElementTree complete = this.workspace.getElementTree();
                complete.immutable();
                DataInputStream input = new DataInputStream(new SafeChunkyInputStream(localFile));
                try {
                    WorkspaceTreeReader reader = WorkspaceTreeReader.getReader(this.workspace, input.readInt());
                    complete = reader.readSnapshotTree(input, complete, monitor);
                }
                finally {
                    FileUtil.safeClose(input);
                    this.lastSnap = complete;
                    this.workspace.tree = complete = complete.newEmptyDelta();
                }
            }
            catch (Exception e) {
                String message = Messages.resources_snapRead;
                Policy.log(new ResourceStatus(567, null, message, e));
            }
        }
        finally {
            monitor.done();
        }
        if (Policy.DEBUG_RESTORE_SNAPSHOTS) {
            System.out.println("Restore snapshots for workspace: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void restoreSyncInfo(IResource resource, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal((resource.getType() == 8 || resource.getType() == 4 ? 1 : 0) != 0);
        long start = System.currentTimeMillis();
        Synchronizer synchronizer = (Synchronizer)this.workspace.getSynchronizer();
        if (resource.isAccessible()) {
            synchronizer.restore(resource, monitor);
        }
        if (resource.getType() == 4) {
            if (Policy.DEBUG_RESTORE_SYNCINFO) {
                System.out.println("Restore SyncInfo for " + resource.getFullPath() + ": " + (System.currentTimeMillis() - start) + "ms");
            }
            return;
        }
        IProject[] projects = ((IWorkspaceRoot)resource).getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                synchronizer.restore(projects[i], monitor);
            }
            ++i;
        }
        if (Policy.DEBUG_RESTORE_SYNCINFO) {
            System.out.println("Restore SyncInfo for workspace: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void restoreTree(IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        IPath treeLocation = this.workspace.getMetaArea().getTreeLocationFor(this.workspace.getRoot(), false);
        IPath tempLocation = this.workspace.getMetaArea().getBackupLocationFor(treeLocation);
        if (!treeLocation.toFile().exists() && !tempLocation.toFile().exists()) {
            this.savedStates = new HashMap(10);
            return;
        }
        try {
            DataInputStream input = new DataInputStream(new SafeFileInputStream(treeLocation.toOSString(), tempLocation.toOSString()));
            try {
                WorkspaceTreeReader.getReader(this.workspace, input.readInt()).readTree(input, monitor);
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.resources_readMeta, (Object)treeLocation.toOSString());
            throw new ResourceException(567, treeLocation, msg, e);
        }
        if (Policy.DEBUG_RESTORE_TREE) {
            System.out.println("Restore Tree for workspace: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void restoreTree(Project project, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, 100);
            IPath treeLocation = this.workspace.getMetaArea().getTreeLocationFor(project, false);
            IPath tempLocation = this.workspace.getMetaArea().getBackupLocationFor(treeLocation);
            if (!treeLocation.toFile().exists() && !tempLocation.toFile().exists()) {
                return;
            }
            try {
                DataInputStream input = new DataInputStream(new SafeFileInputStream(treeLocation.toOSString(), tempLocation.toOSString()));
                try {
                    WorkspaceTreeReader reader = WorkspaceTreeReader.getReader(this.workspace, input.readInt());
                    reader.readTree(project, input, Policy.subMonitorFor(monitor, 100));
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.resources_readMeta, (Object)project.getFullPath());
                throw new ResourceException(567, project.getFullPath(), message, e);
            }
        }
        finally {
            monitor.done();
        }
        if (Policy.DEBUG_RESTORE_TREE) {
            System.out.println("Restore Tree for " + project.getFullPath() + ": " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public IStatus save(int kind, Project project, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            this.isSaving = true;
            String message = Messages.resources_saving_0;
            monitor.beginTask(message, 7);
            message = Messages.resources_saveWarnings;
            MultiStatus warnings = new MultiStatus("org.eclipse.core.resources", 2, message, null);
            Project rule = project != null ? project : this.workspace.getRoot();
            this.workspace.prepareOperation(rule, monitor);
            this.workspace.beginOperation(false);
            this.hookStartSave(kind, project);
            long start = System.currentTimeMillis();
            Map contexts = this.computeSaveContexts(this.getSaveParticipantPlugins(), kind, project);
            this.broadcastLifecycle(1, contexts, warnings, Policy.subMonitorFor(monitor, 1));
            this.broadcastLifecycle(2, contexts, warnings, Policy.subMonitorFor(monitor, 1));
            switch (kind) {
                case 1: {
                    this.saveTree(contexts, Policy.subMonitorFor(monitor, 1));
                    this.initSnap(null);
                    this.cleanMasterTable();
                    this.persistMarkers = 0L;
                    this.persistSyncInfo = 0L;
                    this.visitAndSave(this.workspace.getRoot());
                    monitor.worked(1);
                    if (Policy.DEBUG_SAVE) {
                        Policy.debug("Total Save Markers: " + this.persistMarkers + "ms");
                        Policy.debug("Total Save Sync Info: " + this.persistSyncInfo + "ms");
                    }
                    this.resetSnapshots(this.workspace.getRoot());
                    this.removeUnusedSafeTables();
                    this.removeUnusedTreeFiles();
                    this.workspace.getFileSystemManager().getHistoryStore().clean(Policy.subMonitorFor(monitor, 1));
                    this.saveMetaInfo(warnings, Policy.subMonitorFor(monitor, 1));
                    break;
                }
                case 2: {
                    this.snapTree(this.workspace.getElementTree(), Policy.subMonitorFor(monitor, 1));
                    this.persistMarkers = 0L;
                    this.persistSyncInfo = 0L;
                    this.visitAndSnap(this.workspace.getRoot());
                    monitor.worked(1);
                    if (Policy.DEBUG_SAVE) {
                        Policy.debug("Total Snap Markers: " + this.persistMarkers + "ms");
                        Policy.debug("Total Snap Sync Info: " + this.persistSyncInfo + "ms");
                    }
                    this.collapseTrees();
                    this.clearSavedDelta();
                    this.saveMetaInfo(warnings, Policy.subMonitorFor(monitor, 1));
                    break;
                }
                case 3: {
                    this.writeTree(project, 2);
                    monitor.worked(1);
                    this.visitAndSave(project);
                    monitor.worked(1);
                    this.resetSnapshots(project);
                    IStatus result = this.saveMetaInfo(project, null);
                    if (!result.isOK()) {
                        warnings.merge(result);
                    }
                    monitor.worked(1);
                }
            }
            this.commit(contexts);
            if (kind == 1) {
                this.removeClearDeltaMarks();
            }
            this.saveMasterTable();
            this.broadcastLifecycle(3, contexts, warnings, Policy.subMonitorFor(monitor, 1));
            this.hookEndSave(kind, project, start);
            MultiStatus multiStatus = warnings;
            this.workspace.endOperation(rule, false, Policy.monitorFor(null));
            return multiStatus;
            {
                catch (CoreException e) {
                    try {
                        try {
                            void var5_5;
                            void var9_9;
                            this.broadcastLifecycle(4, (Map)var9_9, (MultiStatus)var5_5, Policy.subMonitorFor(monitor, 1));
                            this.restoreMasterTable();
                            throw e;
                        }
                        catch (OperationCanceledException e2) {
                            this.workspace.getWorkManager().operationCanceled();
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        void var6_6;
                        this.workspace.endOperation((ISchedulingRule)var6_6, false, Policy.monitorFor(null));
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.isSaving = false;
            monitor.done();
        }
    }

    protected void saveMasterTable() throws CoreException {
        this.saveMasterTable(this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources"));
    }

    protected void saveMasterTable(IPath location) throws CoreException {
        long start = System.currentTimeMillis();
        File target = location.toFile();
        try {
            SafeChunkyOutputStream output = new SafeChunkyOutputStream(target);
            try {
                this.masterTable.store(output, "master table");
                output.succeed();
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            String message = Messages.resources_exSaveMaster;
            throw new ResourceException(566, null, message, e);
        }
        if (Policy.DEBUG_SAVE_MASTERTABLE) {
            System.out.println("Save master table for " + location + ": " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void saveMetaInfo(MultiStatus problems, IProgressMonitor monitor) throws CoreException {
        if (Policy.DEBUG_SAVE_METAINFO) {
            System.out.println("Save workspace metainfo: starting...");
        }
        long start = System.currentTimeMillis();
        ResourcesPlugin.getPlugin().savePluginPreferences();
        IProject[] roots = this.workspace.getRoot().getProjects();
        int i = 0;
        while (i < roots.length) {
            IStatus result;
            if (roots[i].isAccessible() && !(result = this.saveMetaInfo((Project)roots[i], null)).isOK()) {
                problems.merge(result);
            }
            ++i;
        }
        if (Policy.DEBUG_SAVE_METAINFO) {
            System.out.println("Save workspace metainfo: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected IStatus saveMetaInfo(Project project, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        if (!this.workspace.getFileSystemManager().hasSavedDescription(project)) {
            this.workspace.getFileSystemManager().writeSilently(project);
            String msg = NLS.bind((String)Messages.resources_missingProjectMetaRepaired, (Object)project.getName());
            return new ResourceStatus(234, project.getFullPath(), msg);
        }
        if (Policy.DEBUG_SAVE_METAINFO) {
            System.out.println("Save metainfo for " + project.getFullPath() + ": " + (System.currentTimeMillis() - start) + "ms");
        }
        return Status.OK_STATUS;
    }

    protected void saveTree(Map contexts, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        IPath treeLocation = this.workspace.getMetaArea().getTreeLocationFor(this.workspace.getRoot(), true);
        try {
            IPath tempLocation = this.workspace.getMetaArea().getBackupLocationFor(treeLocation);
            DataOutputStream output = new DataOutputStream(new SafeFileOutputStream(treeLocation.toOSString(), tempLocation.toOSString()));
            try {
                output.writeInt(67305986);
                this.writeTree(this.computeStatesToSave(contexts, this.workspace.getElementTree()), output, monitor);
            }
            finally {
                output.close();
            }
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Messages.resources_writeWorkspaceMeta, (Object)treeLocation);
            throw new ResourceException(568, (IPath)Path.ROOT, msg, e);
        }
        if (Policy.DEBUG_SAVE_TREE) {
            System.out.println("Save Workspace Tree: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void setDeltaExpiration(String pluginId, long timestamp) {
        this.masterTable.setProperty(DELTA_EXPIRATION_PREFIX + pluginId, new Long(timestamp).toString());
    }

    void setPluginsSavedState(HashMap savedStates) {
        this.savedStates = savedStates;
    }

    protected void setSaveNumber(String pluginId, int number) {
        this.masterTable.setProperty(SAVE_NUMBER_PREFIX + pluginId, new Integer(number).toString());
    }

    public void shareStrings(StringPool pool) {
        this.lastSnap.shareStrings(pool);
    }

    public void shutdown(IProgressMonitor monitor) {
        int state = this.snapshotJob.getState();
        if (state == 2 || state == 1) {
            this.snapshotJob.run(Policy.monitorFor(monitor));
        }
        this.snapshotJob.cancel();
    }

    public void snapshotIfNeeded(boolean hasTreeChanges) {
        if (this.isSaving) {
            return;
        }
        if (this.snapshotRequested || this.operationCount >= this.workspace.internalGetDescription().getOperationsPerSnapshot()) {
            if (this.snapshotJob.getState() == 0) {
                this.snapshotJob.schedule();
            } else {
                this.snapshotJob.wakeUp();
            }
        } else if (hasTreeChanges) {
            ++this.operationCount;
            if (this.snapshotJob.getState() == 0) {
                if (Policy.DEBUG_SAVE) {
                    System.out.println("Scheduling workspace snapshot");
                }
                long interval = this.workspace.internalGetDescription().getSnapshotInterval();
                this.snapshotJob.schedule(Math.max(interval, 30000L));
            }
        } else if (++this.noopCount > 20) {
            ++this.operationCount;
            this.noopCount = 0;
        }
    }

    protected void snapTree(ElementTree tree, IProgressMonitor monitor) throws CoreException {
        long start = System.currentTimeMillis();
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, 100);
            tree.immutable();
            if (tree == this.lastSnap) {
                return;
            }
            this.operationCount = 0;
            IPath snapPath = this.workspace.getMetaArea().getSnapshotLocationFor(this.workspace.getRoot());
            ElementTreeWriter writer = new ElementTreeWriter(this);
            File localFile = snapPath.toFile();
            try {
                SafeChunkyOutputStream safeStream = new SafeChunkyOutputStream(localFile);
                DataOutputStream out = new DataOutputStream(safeStream);
                try {
                    out.writeInt(67305986);
                    this.writeWorkspaceFields(out, monitor);
                    writer.writeDelta(tree, this.lastSnap, (IPath)Path.ROOT, -1, out, ResourceComparator.getSaveComparator());
                    safeStream.succeed();
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.resources_writeWorkspaceMeta, (Object)localFile.getAbsolutePath());
                throw new ResourceException(568, (IPath)Path.ROOT, message, e);
            }
            this.lastSnap = tree;
        }
        finally {
            monitor.done();
        }
        if (Policy.DEBUG_SAVE_TREE) {
            System.out.println("Snapshot Workspace Tree: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected ElementTree[] sortTrees(ElementTree[] trees) {
        int numTrees = trees.length;
        ElementTree[] sorted = new ElementTree[numTrees];
        HashMap<ElementTree, ArrayList<Integer>> table = new HashMap<ElementTree, ArrayList<Integer>>(numTrees * 2 + 1);
        int i = 0;
        while (i < trees.length) {
            ArrayList<Integer> indices = (ArrayList<Integer>)table.get(trees[i]);
            if (indices == null) {
                indices = new ArrayList<Integer>(10);
                table.put(trees[i], indices);
            }
            indices.add(new Integer(i));
            ++i;
        }
        ElementTree oldest = trees[ElementTree.findOldest(trees)];
        int i2 = numTrees - 1;
        while (i2 >= 0) {
            List indices = (List)table.remove(oldest);
            Enumeration e = Collections.enumeration(indices);
            while (e.hasMoreElements()) {
                e.nextElement();
                sorted[i2] = oldest;
                --i2;
            }
            if (i2 < 0) continue;
            ElementTree parent = oldest.getParent();
            while (parent != null && table.get(parent) == null) {
                parent = parent.getParent();
            }
            if (parent == null) {
                Status status = new Status(2, "org.eclipse.core.resources", 566, "null parent found while collapsing trees", null);
                Policy.log((IStatus)status);
                return null;
            }
            oldest = parent;
        }
        return sorted;
    }

    public void startup(IProgressMonitor monitor) throws CoreException {
        this.restore(monitor);
        File table = this.workspace.getMetaArea().getSafeTableLocationFor("org.eclipse.core.resources").toFile();
        if (!table.exists()) {
            table.getParentFile().mkdirs();
        }
    }

    public void visitAndSave(IResource root) throws CoreException {
        Assert.isLegal((root.getType() == 8 || root.getType() == 4 ? 1 : 0) != 0);
        if (!root.isAccessible()) {
            return;
        }
        Synchronizer synchronizer = (Synchronizer)this.workspace.getSynchronizer();
        final MarkerManager markerManager = this.workspace.getMarkerManager();
        IPath markersLocation = this.workspace.getMetaArea().getMarkersLocationFor(root);
        IPath markersTempLocation = this.workspace.getMetaArea().getBackupLocationFor(markersLocation);
        IPath syncInfoLocation = this.workspace.getMetaArea().getSyncInfoLocationFor(root);
        IPath syncInfoTempLocation = this.workspace.getMetaArea().getBackupLocationFor(syncInfoLocation);
        ArrayList writtenTypes = new ArrayList(5);
        ArrayList writtenPartners = new ArrayList(synchronizer.registry.size());
        FilterOutputStream o1 = null;
        DataOutputStream o2 = null;
        try {
            o1 = new DataOutputStream(new SafeFileOutputStream(markersLocation.toOSString(), markersTempLocation.toOSString()));
            if (root.getType() != 8) {
                o2 = new DataOutputStream(new SafeFileOutputStream(syncInfoLocation.toOSString(), syncInfoTempLocation.toOSString()));
            }
        }
        catch (IOException e) {
            if (o1 != null) {
                try {
                    o1.close();
                }
                catch (IOException iOException) {}
            }
            String message = NLS.bind((String)Messages.resources_writeMeta, (Object)root.getFullPath());
            throw new ResourceException(568, root.getFullPath(), message, e);
        }
        FilterOutputStream markersOutput = o1;
        DataOutputStream syncInfoOutput = o2;
        long[] saveTimes = new long[2];
        IElementContentVisitor visitor = new IElementContentVisitor((DataOutputStream)markersOutput, writtenTypes, saveTimes, syncInfoOutput, synchronizer, writtenPartners, root){
            private final /* synthetic */ DataOutputStream val$markersOutput;
            private final /* synthetic */ List val$writtenTypes;
            private final /* synthetic */ long[] val$saveTimes;
            private final /* synthetic */ DataOutputStream val$syncInfoOutput;
            private final /* synthetic */ Synchronizer val$synchronizer;
            private final /* synthetic */ List val$writtenPartners;
            private final /* synthetic */ IResource val$root;
            {
                this.val$markersOutput = dataOutputStream;
                this.val$writtenTypes = list;
                this.val$saveTimes = lArray;
                this.val$syncInfoOutput = dataOutputStream2;
                this.val$synchronizer = synchronizer;
                this.val$writtenPartners = list2;
                this.val$root = iResource;
            }

            public boolean visitElement(ElementTree tree, IPathRequestor requestor, Object elementContents) {
                ResourceInfo info = (ResourceInfo)elementContents;
                if (info != null) {
                    try {
                        long start = System.currentTimeMillis();
                        markerManager.save(info, requestor, this.val$markersOutput, this.val$writtenTypes);
                        long markerSaveTime = System.currentTimeMillis() - start;
                        this.val$saveTimes[0] = this.val$saveTimes[0] + markerSaveTime;
                        SaveManager.this.persistMarkers += markerSaveTime;
                        if (this.val$syncInfoOutput != null) {
                            start = System.currentTimeMillis();
                            this.val$synchronizer.saveSyncInfo(info, requestor, this.val$syncInfoOutput, this.val$writtenPartners);
                            long syncInfoSaveTime = System.currentTimeMillis() - start;
                            this.val$saveTimes[1] = this.val$saveTimes[1] + syncInfoSaveTime;
                            SaveManager.this.persistSyncInfo += syncInfoSaveTime;
                        }
                    }
                    catch (IOException e) {
                        throw new WrappedRuntimeException(e);
                    }
                }
                return this.val$root.getType() != 8;
            }
        };
        try {
            try {
                try {
                    new ElementTreeIterator(this.workspace.getElementTree(), root.getFullPath()).iterate(visitor);
                }
                catch (WrappedRuntimeException e) {
                    throw (IOException)e.getTargetException();
                }
                if (Policy.DEBUG_SAVE_MARKERS) {
                    System.out.println("Save Markers for " + root.getFullPath() + ": " + saveTimes[0] + "ms");
                }
                if (Policy.DEBUG_SAVE_SYNCINFO) {
                    System.out.println("Save SyncInfo for " + root.getFullPath() + ": " + saveTimes[1] + "ms");
                }
                this.removeGarbage((DataOutputStream)markersOutput, markersLocation, markersTempLocation);
                if (syncInfoOutput != null) {
                    this.removeGarbage(syncInfoOutput, syncInfoLocation, syncInfoTempLocation);
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.resources_writeMeta, (Object)root.getFullPath());
                throw new ResourceException(568, root.getFullPath(), message, e);
            }
        }
        finally {
            FileUtil.safeClose(markersOutput);
            FileUtil.safeClose(syncInfoOutput);
        }
        if (root.getType() == 4) {
            return;
        }
        IProject[] projects = ((IWorkspaceRoot)root).getProjects();
        int i = 0;
        while (i < projects.length) {
            this.visitAndSave(projects[i]);
            ++i;
        }
    }

    public void visitAndSnap(final IResource root) throws CoreException {
        Assert.isLegal((root.getType() == 8 || root.getType() == 4 ? 1 : 0) != 0);
        if (!root.isAccessible()) {
            return;
        }
        final Synchronizer synchronizer = (Synchronizer)this.workspace.getSynchronizer();
        final MarkerManager markerManager = this.workspace.getMarkerManager();
        IPath markersLocation = this.workspace.getMetaArea().getMarkersSnapshotLocationFor(root);
        IPath syncInfoLocation = this.workspace.getMetaArea().getSyncInfoSnapshotLocationFor(root);
        SafeChunkyOutputStream safeMarkerStream = null;
        SafeChunkyOutputStream safeSyncInfoStream = null;
        DataOutputStream o1 = null;
        DataOutputStream o2 = null;
        try {
            safeMarkerStream = new SafeChunkyOutputStream(markersLocation.toFile());
            o1 = new DataOutputStream(safeMarkerStream);
            if (root.getType() != 8) {
                safeSyncInfoStream = new SafeChunkyOutputStream(syncInfoLocation.toFile());
                o2 = new DataOutputStream(safeSyncInfoStream);
            }
        }
        catch (IOException e) {
            FileUtil.safeClose(o1);
            String message = NLS.bind((String)Messages.resources_writeMeta, (Object)root.getFullPath());
            throw new ResourceException(568, root.getFullPath(), message, e);
        }
        final DataOutputStream markersOutput = o1;
        final DataOutputStream syncInfoOutput = o2;
        int markerFileSize = markersOutput.size();
        int syncInfoFileSize = safeSyncInfoStream == null ? -1 : syncInfoOutput.size();
        final long[] snapTimes = new long[2];
        IElementContentVisitor visitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree tree, IPathRequestor requestor, Object elementContents) {
                ResourceInfo info = (ResourceInfo)elementContents;
                if (info != null) {
                    try {
                        long start = System.currentTimeMillis();
                        markerManager.snap(info, requestor, markersOutput);
                        long markerSnapTime = System.currentTimeMillis() - start;
                        snapTimes[0] = snapTimes[0] + markerSnapTime;
                        SaveManager.this.persistMarkers += markerSnapTime;
                        if (syncInfoOutput != null) {
                            start = System.currentTimeMillis();
                            synchronizer.snapSyncInfo(info, requestor, syncInfoOutput);
                            long syncInfoSnapTime = System.currentTimeMillis() - start;
                            snapTimes[1] = snapTimes[1] + syncInfoSnapTime;
                            SaveManager.this.persistSyncInfo += syncInfoSnapTime;
                        }
                    }
                    catch (IOException e) {
                        throw new WrappedRuntimeException(e);
                    }
                }
                return root.getType() != 8;
            }
        };
        try {
            try {
                try {
                    new ElementTreeIterator(this.workspace.getElementTree(), root.getFullPath()).iterate(visitor);
                }
                catch (WrappedRuntimeException e) {
                    throw (IOException)e.getTargetException();
                }
                if (Policy.DEBUG_SAVE_MARKERS) {
                    System.out.println("Snap Markers for " + root.getFullPath() + ": " + snapTimes[0] + "ms");
                }
                if (Policy.DEBUG_SAVE_SYNCINFO) {
                    System.out.println("Snap SyncInfo for " + root.getFullPath() + ": " + snapTimes[1] + "ms");
                }
                if (markerFileSize != markersOutput.size()) {
                    safeMarkerStream.succeed();
                }
                if (safeSyncInfoStream != null && syncInfoFileSize != syncInfoOutput.size()) {
                    safeSyncInfoStream.succeed();
                }
            }
            catch (IOException e) {
                String message = NLS.bind((String)Messages.resources_writeMeta, (Object)root.getFullPath());
                throw new ResourceException(568, root.getFullPath(), message, e);
            }
        }
        finally {
            FileUtil.safeClose(markersOutput);
            FileUtil.safeClose(syncInfoOutput);
        }
        if (root.getType() == 4) {
            return;
        }
        IProject[] projects = ((IWorkspaceRoot)root).getProjects();
        int i = 0;
        while (i < projects.length) {
            this.visitAndSnap(projects[i]);
            ++i;
        }
    }

    protected void writeBuilderPersistentInfo(DataOutputStream output, List builders, List trees, IProgressMonitor monitor) throws IOException {
        monitor = Policy.monitorFor(monitor);
        try {
            int numBuilders = builders.size();
            output.writeInt(numBuilders);
            int i = 0;
            while (i < numBuilders) {
                BuilderPersistentInfo info = (BuilderPersistentInfo)builders.get(i);
                output.writeUTF(info.getProjectName());
                output.writeUTF(info.getBuilderName());
                IProject[] interestingProjects = info.getInterestingProjects();
                output.writeInt(interestingProjects.length);
                int j = 0;
                while (j < interestingProjects.length) {
                    output.writeUTF(interestingProjects[j].getName());
                    ++j;
                }
                ElementTree last = info.getLastBuiltTree();
                if (last == null) {
                    last = this.workspace.getElementTree();
                }
                trees.add(last);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void writeElement(IPath path, Object element, DataOutput output) throws IOException {
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)output);
        ResourceInfo info = (ResourceInfo)element;
        output.writeInt(info.getFlags());
        info.writeTo(output);
    }

    protected void writeTree(Map statesToSave, DataOutputStream output, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, 100);
            boolean wasImmutable = false;
            try {
                ElementTree current = this.workspace.getElementTree();
                wasImmutable = current.isImmutable();
                current.immutable();
                ArrayList<Object> trees = new ArrayList<Object>(statesToSave.size() * 2);
                monitor.worked(10);
                this.writeWorkspaceFields(output, Policy.subMonitorFor(monitor, Policy.opWork * 20 / 100));
                long lastTreeTimestamp = System.currentTimeMillis();
                output.writeInt(statesToSave.size());
                for (Map.Entry entry : statesToSave.entrySet()) {
                    String pluginId = (String)entry.getKey();
                    output.writeUTF(pluginId);
                    trees.add(entry.getValue());
                    this.setDeltaExpiration(pluginId, lastTreeTimestamp);
                }
                monitor.worked(10);
                IProject[] projects = this.workspace.getRoot().getProjects();
                ArrayList builders = new ArrayList(projects.length * 2);
                int i = 0;
                while (i < projects.length) {
                    ArrayList infos;
                    IProject project = projects[i];
                    if (project.isOpen() && (infos = this.workspace.getBuildManager().createBuildersPersistentInfo(project)) != null) {
                        builders.addAll(infos);
                    }
                    ++i;
                }
                this.writeBuilderPersistentInfo(output, builders, trees, Policy.subMonitorFor(monitor, 10));
                trees.add(current);
                ElementTreeWriter writer = new ElementTreeWriter(this);
                ElementTree[] treesToSave = trees.toArray(new ElementTree[trees.size()]);
                writer.writeDeltaChain(treesToSave, (IPath)Path.ROOT, -1, output, ResourceComparator.getSaveComparator());
                monitor.worked(50);
            }
            finally {
                if (!wasImmutable) {
                    this.workspace.newWorkingTree();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void writeTree(Project project, DataOutputStream output, IProgressMonitor monitor) throws IOException, CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, 10);
            boolean wasImmutable = false;
            try {
                ArrayList builderInfos = this.workspace.getBuildManager().createBuildersPersistentInfo(project);
                if (builderInfos == null) {
                    builderInfos = new ArrayList(5);
                }
                ArrayList<ElementTree> trees = new ArrayList<ElementTree>(builderInfos.size() + 1);
                monitor.worked(1);
                ElementTree current = this.workspace.getElementTree();
                wasImmutable = current.isImmutable();
                current.immutable();
                this.writeBuilderPersistentInfo(output, builderInfos, trees, Policy.subMonitorFor(monitor, 1));
                trees.add(current);
                ElementTreeWriter writer = new ElementTreeWriter(this);
                ElementTree[] treesToSave = trees.toArray(new ElementTree[trees.size()]);
                writer.writeDeltaChain(treesToSave, project.getFullPath(), -1, output, ResourceComparator.getSaveComparator());
                monitor.worked(8);
            }
            finally {
                if (output != null) {
                    output.close();
                }
                if (!wasImmutable) {
                    this.workspace.newWorkingTree();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void writeTree(Project project, int depth) throws CoreException {
        long start = System.currentTimeMillis();
        IPath treeLocation = this.workspace.getMetaArea().getTreeLocationFor(project, true);
        IPath tempLocation = this.workspace.getMetaArea().getBackupLocationFor(treeLocation);
        try {
            SafeFileOutputStream safe = new SafeFileOutputStream(treeLocation.toOSString(), tempLocation.toOSString());
            try {
                DataOutputStream output = new DataOutputStream(safe);
                output.writeInt(67305986);
                this.writeTree(project, output, null);
            }
            finally {
                safe.close();
            }
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.resources_writeMeta, (Object)project.getFullPath());
            throw new ResourceException(568, treeLocation, msg, e);
        }
        if (Policy.DEBUG_SAVE_TREE) {
            System.out.println("Save tree for " + project.getFullPath() + ": " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    protected void writeWorkspaceFields(DataOutputStream output, IProgressMonitor monitor) throws IOException {
        monitor = Policy.monitorFor(monitor);
        try {
            output.writeLong(this.workspace.nextNodeId);
            output.writeLong(0L);
            output.writeLong(this.workspace.nextMarkerId);
            ((Synchronizer)this.workspace.getSynchronizer()).savePartners(output);
        }
        finally {
            monitor.done();
        }
    }
}

