/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }

    static final native long getAWTHandle(Canvas var0);

    static final native void setDebug(Frame var0, boolean var1);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {}
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class[] emptyClass = new Class[]{};
            Object[] emptyObject = new Object[]{};
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", emptyClass);
            if (method != null) {
                method.invoke(clazz, emptyObject);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Frame getFrame(Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)parent.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        long handle = parent.embeddedHandle;
        Class<?> clazz = null;
        try {
            String className = embeddedFrameClass != null ? embeddedFrameClass : "sun.awt.X11.XEmbeddedFrame";
            clazz = Class.forName(className);
        }
        catch (Throwable e) {
            SWT.error(20, e, " [need JDK 1.5 or greater]");
        }
        SWT_AWT.initializeSwing();
        Object value = null;
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(Integer.TYPE, Boolean.TYPE);
            value = constructor.newInstance(new Integer((int)handle), Boolean.TRUE);
        }
        catch (Throwable throwable) {
            try {
                constructor = clazz.getConstructor(Long.TYPE, Boolean.TYPE);
                value = constructor.newInstance(new Long(handle), Boolean.TRUE);
            }
            catch (Throwable e2) {
                SWT.error(20, e2);
            }
        }
        final Frame frame = value;
        parent.setData(EMBEDDED_FRAME_KEY, frame);
        if (Device.DEBUG) {
            SWT_AWT.loadLibrary();
            SWT_AWT.setDebug(frame, true);
        }
        try {
            Method method = clazz.getMethod("registerListeners", null);
            if (method != null) {
                method.invoke(value, null);
            }
        }
        catch (Throwable throwable) {}
        final Listener shellListener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                frame.dispatchEvent(new WindowEvent(frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                frame.dispatchEvent(new WindowEvent(frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = parent.getShell();
        shell.addListener(20, shellListener);
        shell.addListener(19, shellListener);
        parent.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                Shell shell = parent.getShell();
                shell.removeListener(20, shellListener);
                shell.removeListener(19, shellListener);
                parent.setVisible(false);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        frame.dispose();
                    }
                });
            }
        });
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (parent.isDisposed()) {
                    return;
                }
                final Rectangle clientArea = parent.getClientArea();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        frame.setSize(clientArea.width, clientArea.height);
                        frame.validate();
                    }
                });
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas parent) {
        if (display == null) {
            SWT.error(4);
        }
        if (parent == null) {
            SWT.error(4);
        }
        long handle = 0L;
        try {
            SWT_AWT.loadLibrary();
            handle = SWT_AWT.getAWTHandle(parent);
        }
        catch (Throwable e) {
            SWT.error(20, e);
        }
        if (handle == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.gtk_new(display, handle);
        parent.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                display.syncExec(new Runnable(){

                    public void run() {
                        Dimension dim = parent.getSize();
                        shell.setSize(dim.width, dim.height);
                    }
                });
            }
        });
        shell.setVisible(true);
        return shell;
    }
}

