/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ImportOperation
extends WorkspaceModifyOperation {
    private static final int POLICY_DEFAULT = 0;
    private static final int POLICY_SKIP_CHILDREN = 1;
    private static final int POLICY_FORCE_OVERWRITE = 2;
    private Object source;
    private IPath destinationPath;
    private IContainer destinationContainer;
    private List selectedFiles;
    private List rejectedFiles;
    private IImportStructureProvider provider;
    private IProgressMonitor monitor;
    protected IOverwriteQuery overwriteCallback;
    private Shell context;
    private List errorTable = new ArrayList();
    private boolean createContainerStructure = true;
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;

    public ImportOperation(IPath containerPath, Object source, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor) {
        this.destinationPath = containerPath;
        this.source = source;
        this.provider = provider;
        this.overwriteCallback = overwriteImplementor;
    }

    public ImportOperation(IPath containerPath, Object source, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor, List filesToImport) {
        this(containerPath, source, provider, overwriteImplementor);
        this.setFilesToImport(filesToImport);
    }

    public ImportOperation(IPath containerPath, IImportStructureProvider provider, IOverwriteQuery overwriteImplementor, List filesToImport) {
        this(containerPath, null, provider, overwriteImplementor);
        this.setFilesToImport(filesToImport);
    }

    void collectExistingReadonlyFiles(IPath sourceStart, List sources, ArrayList noOverwrite, ArrayList overwriteReadonly, int policy) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Iterator sourceIter = sources.iterator();
        Path sourceRootPath = null;
        if (this.source != null) {
            sourceRootPath = new Path(this.provider.getFullPath(this.source));
        }
        while (sourceIter.hasNext()) {
            IPath newDestinationPath;
            Object nextSource = sourceIter.next();
            Path sourcePath = new Path(this.provider.getFullPath(nextSource));
            if (sourceRootPath == null) {
                newDestinationPath = sourceStart.append(this.provider.getLabel(nextSource));
            } else {
                int prefixLength = sourcePath.matchingFirstSegments((IPath)sourceRootPath);
                IPath relativeSourcePath = sourcePath.removeFirstSegments(prefixLength);
                newDestinationPath = this.destinationPath.append(relativeSourcePath);
            }
            IResource newDestination = workspaceRoot.findMember(newDestinationPath);
            if (newDestination == null) continue;
            IFolder folder = this.getFolder(newDestination);
            if (folder != null) {
                if (!(policy == 2 || this.overwriteState != 1 && this.queryOverwrite(newDestinationPath))) {
                    noOverwrite.add(folder);
                    continue;
                }
                if (!this.provider.isFolder(nextSource)) continue;
                this.collectExistingReadonlyFiles(newDestinationPath, this.provider.getChildren(nextSource), noOverwrite, overwriteReadonly, 2);
                continue;
            }
            IFile file = this.getFile(newDestination);
            if (file == null) continue;
            if (!this.queryOverwriteFile(file, policy)) {
                noOverwrite.add(file.getFullPath());
                continue;
            }
            if (!file.isReadOnly()) continue;
            overwriteReadonly.add(file);
        }
    }

    IContainer createContainersFor(IPath path) throws CoreException {
        IContainer currentFolder = this.destinationContainer;
        int segmentCount = path.segmentCount();
        if (segmentCount == 0) {
            return currentFolder;
        }
        if (currentFolder.getType() == 8) {
            return this.createFromRoot(path);
        }
        int i = 0;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder((IPath)new Path(path.segment(i)))).exists()) {
                ((IFolder)currentFolder).create(false, true, null);
            }
            ++i;
        }
        return currentFolder;
    }

    private IContainer createFromRoot(IPath path) throws CoreException {
        int segmentCount = path.segmentCount();
        IProject currentFolder = ((IWorkspaceRoot)this.destinationContainer).getProject(path.segment(0));
        int i = 1;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder((IPath)new Path(path.segment(i)))).exists()) {
                ((IFolder)currentFolder).create(false, true, null);
            }
            ++i;
        }
        return currentFolder;
    }

    void deleteResource(IResource resource) {
        try {
            resource.delete(2, null);
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
        }
    }

    protected void execute(IProgressMonitor progressMonitor) {
        block6: {
            this.monitor = progressMonitor;
            try {
                try {
                    if (this.selectedFiles == null) {
                        this.monitor.beginTask(DataTransferMessages.DataTransfer_importTask, 1000);
                        ContainerGenerator generator = new ContainerGenerator(this.destinationPath);
                        this.monitor.worked(30);
                        this.validateFiles(Arrays.asList(this.source));
                        this.monitor.worked(50);
                        this.destinationContainer = generator.generateContainer((IProgressMonitor)new SubProgressMonitor(this.monitor, 50));
                        this.importRecursivelyFrom(this.source, 0);
                        this.monitor.worked(90);
                        break block6;
                    }
                    int creationCount = this.selectedFiles.size();
                    this.monitor.beginTask(DataTransferMessages.DataTransfer_importTask, creationCount + 100);
                    ContainerGenerator generator = new ContainerGenerator(this.destinationPath);
                    this.monitor.worked(30);
                    this.validateFiles(this.selectedFiles);
                    this.monitor.worked(50);
                    this.destinationContainer = generator.generateContainer((IProgressMonitor)new SubProgressMonitor(this.monitor, 50));
                    this.importFileSystemObjects(this.selectedFiles);
                    this.monitor.done();
                }
                catch (CoreException e) {
                    this.errorTable.add(e.getStatus());
                }
            }
            finally {
                this.monitor.done();
            }
        }
    }

    IContainer getDestinationContainerFor(Object fileSystemObject) throws CoreException {
        Path pathname = new Path(this.provider.getFullPath(fileSystemObject));
        if (this.createContainerStructure) {
            return this.createContainersFor(pathname.removeLastSegments(1));
        }
        if (this.source == fileSystemObject) {
            return null;
        }
        Path sourcePath = new Path(this.provider.getFullPath(this.source));
        IPath destContainerPath = pathname.removeLastSegments(1);
        IPath relativePath = destContainerPath.removeFirstSegments(sourcePath.segmentCount()).setDevice(null);
        return this.createContainersFor(relativePath);
    }

    IFile getFile(IResource resource) {
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        Object adapted = resource.getAdapter(IFile.class);
        if (adapted == null) {
            return null;
        }
        return (IFile)adapted;
    }

    IFolder getFolder(IResource resource) {
        if (resource instanceof IFolder) {
            return (IFolder)resource;
        }
        Object adapted = resource.getAdapter(IFolder.class);
        if (adapted == null) {
            return null;
        }
        return (IFolder)adapted;
    }

    ArrayList getRejectedFiles(IStatus multiStatus, IFile[] files) {
        ArrayList<IPath> filteredFiles = new ArrayList<IPath>();
        IStatus[] status = multiStatus.getChildren();
        int i = 0;
        while (i < status.length) {
            if (!status[i].isOK()) {
                this.errorTable.add(status[i]);
                filteredFiles.add(files[i].getFullPath());
            }
            ++i;
        }
        return filteredFiles;
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ui", 0, errors, DataTransferMessages.ImportOperation_importProblems, null);
    }

    void importFile(Object fileObject, int policy) {
        block18: {
            IContainer containerResource;
            try {
                containerResource = this.getDestinationContainerFor(fileObject);
            }
            catch (CoreException e) {
                IStatus coreStatus = e.getStatus();
                String newMessage = NLS.bind((String)DataTransferMessages.ImportOperation_coreImportError, (Object)fileObject, (Object)coreStatus.getMessage());
                Status status = new Status(coreStatus.getSeverity(), coreStatus.getPlugin(), coreStatus.getCode(), newMessage, null);
                this.errorTable.add(status);
                return;
            }
            String fileObjectPath = this.provider.getFullPath(fileObject);
            this.monitor.subTask(fileObjectPath);
            IFile targetResource = containerResource.getFile((IPath)new Path(this.provider.getLabel(fileObject)));
            this.monitor.worked(1);
            if (this.rejectedFiles.contains(targetResource.getFullPath())) {
                return;
            }
            IPath targetPath = targetResource.getLocation();
            if (targetPath != null && targetPath.toFile().equals(new File(fileObjectPath))) {
                this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_targetSameAsSourceError, (Object)fileObjectPath), null));
                return;
            }
            InputStream contentStream = this.provider.getContents(fileObject);
            if (contentStream == null) {
                this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_openStreamError, (Object)fileObjectPath), null));
                return;
            }
            try {
                try {
                    if (targetResource.exists()) {
                        targetResource.setContents(contentStream, 2, null);
                    } else {
                        targetResource.create(contentStream, false, null);
                    }
                    this.setResourceAttributes(targetResource, fileObject);
                    if (!(this.provider instanceof TarLeveledStructureProvider)) break block18;
                    try {
                        targetResource.setResourceAttributes(((TarLeveledStructureProvider)this.provider).getResourceAttributes(fileObject));
                    }
                    catch (CoreException e) {
                        this.errorTable.add(e.getStatus());
                    }
                }
                catch (CoreException e) {
                    this.errorTable.add(e.getStatus());
                }
            }
            finally {
                try {
                    contentStream.close();
                }
                catch (IOException e) {
                    this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_closeStreamError, (Object)fileObjectPath), (Throwable)e));
                }
            }
        }
    }

    private void setResourceAttributes(IFile targetResource, Object fileObject) {
        if (fileObject instanceof File) {
            try {
                targetResource.setResourceAttributes(ResourceAttributes.fromFile((File)((File)fileObject)));
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    void importFileSystemObjects(List filesToImport) {
        for (Object fileSystemObject : filesToImport) {
            if (this.source == null) {
                IPath sourcePath = new Path(this.provider.getFullPath(fileSystemObject)).removeLastSegments(1);
                if (this.provider.isFolder(fileSystemObject) && sourcePath.isEmpty()) {
                    this.errorTable.add(new Status(1, "org.eclipse.ui", 0, DataTransferMessages.ImportOperation_cannotCopy, null));
                    continue;
                }
                this.source = sourcePath.toFile();
            }
            this.importRecursivelyFrom(fileSystemObject, 0);
        }
    }

    int importFolder(Object folderObject, int policy) {
        IContainer containerResource;
        try {
            containerResource = this.getDestinationContainerFor(folderObject);
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
            return policy;
        }
        if (containerResource == null) {
            return policy;
        }
        this.monitor.subTask(this.provider.getFullPath(folderObject));
        IWorkspace workspace = this.destinationContainer.getWorkspace();
        IPath containerPath = containerResource.getFullPath();
        IPath resourcePath = containerPath.append(this.provider.getLabel(folderObject));
        if (resourcePath.equals((Object)containerPath)) {
            return policy;
        }
        if (workspace.getRoot().exists(resourcePath)) {
            if (this.rejectedFiles.contains(resourcePath)) {
                return 1;
            }
            return 2;
        }
        try {
            workspace.getRoot().getFolder(resourcePath).create(false, true, null);
        }
        catch (CoreException e) {
            this.errorTable.add(e.getStatus());
        }
        return policy;
    }

    void importRecursivelyFrom(Object fileSystemObject, int policy) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.provider.isFolder(fileSystemObject)) {
            this.importFile(fileSystemObject, policy);
            return;
        }
        int childPolicy = this.importFolder(fileSystemObject, policy);
        if (childPolicy != 1) {
            Iterator children = this.provider.getChildren(fileSystemObject).iterator();
            while (children.hasNext()) {
                this.importRecursivelyFrom(children.next(), childPolicy);
            }
        }
    }

    boolean queryOverwrite(IPath resourcePath) throws OperationCanceledException {
        String overwriteAnswer = this.overwriteCallback.queryOverwrite(resourcePath.makeRelative().toString());
        if (overwriteAnswer.equals("CANCEL")) {
            throw new OperationCanceledException(DataTransferMessages.DataTransfer_emptyString);
        }
        if (overwriteAnswer.equals("NO")) {
            return false;
        }
        if (overwriteAnswer.equals("NOALL")) {
            this.overwriteState = 1;
            return false;
        }
        if (overwriteAnswer.equals("ALL")) {
            this.overwriteState = 2;
        }
        return true;
    }

    boolean queryOverwriteFile(IFile targetFile, int policy) {
        if (policy != 2) {
            if (this.overwriteState == 0 && !this.queryOverwrite(targetFile.getFullPath())) {
                return false;
            }
            if (this.overwriteState == 1) {
                return false;
            }
        }
        return true;
    }

    public void setContext(Shell shell) {
        this.context = shell;
    }

    public void setCreateContainerStructure(boolean value) {
        this.createContainerStructure = value;
    }

    public void setFilesToImport(List filesToImport) {
        this.selectedFiles = filesToImport;
    }

    public void setOverwriteResources(boolean value) {
        if (value) {
            this.overwriteState = 2;
        }
    }

    ArrayList validateEdit(List existingFiles) {
        if (existingFiles.size() > 0) {
            IFile[] files = existingFiles.toArray(new IFile[existingFiles.size()]);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateEdit(files, (Object)this.context);
            if (status.isMultiStatus()) {
                return this.getRejectedFiles(status, files);
            }
            if (!status.isOK()) {
                this.errorTable.add(status);
                ArrayList<IPath> filteredFiles = new ArrayList<IPath>();
                int i = 0;
                while (i < files.length) {
                    filteredFiles.add(files[i].getFullPath());
                    ++i;
                }
                return filteredFiles;
            }
        }
        return new ArrayList();
    }

    void validateFiles(List sourceFiles) {
        ArrayList noOverwrite = new ArrayList();
        ArrayList overwriteReadonly = new ArrayList();
        this.collectExistingReadonlyFiles(this.destinationPath, sourceFiles, noOverwrite, overwriteReadonly, 0);
        this.rejectedFiles = this.validateEdit(overwriteReadonly);
        this.rejectedFiles.addAll(noOverwrite);
    }
}

