/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.MultiStepWizard;
import org.eclipse.ui.internal.ide.dialogs.WizardNewProjectNameAndLocationPage;
import org.eclipse.ui.internal.ide.dialogs.WizardStep;

public class NewProjectWizard
extends MultiStepWizard
implements INewWizard {
    private WizardNewProjectNameAndLocationPage creationPage;
    private IProject newProject;
    private String initialProjectName;

    public NewProjectWizard() {
        IDEWorkbenchPlugin plugin = IDEWorkbenchPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewProjectWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewProjectWizard");
        }
        this.setDialogSettings(section);
    }

    protected void addCustomPages() {
        this.creationPage = new WizardNewProjectNameAndLocationPage("newProjectCreationPage");
        this.creationPage.setTitle(IDEWorkbenchMessages.NewProjectWizard_title);
        this.creationPage.setDescription(IDEWorkbenchMessages.WizardNewProjectCreationPage_description);
        this.creationPage.setInitialProjectName(this.initialProjectName);
        this.addPage((IWizardPage)this.creationPage);
    }

    protected boolean canFinishOnReviewPage() {
        return this.getSteps().length == 1;
    }

    protected String getConfigurePageTitle() {
        return IDEWorkbenchMessages.NewProjectWizard_title;
    }

    protected String getConfigurePageDescription() {
        return IDEWorkbenchMessages.WizardProjectConfigurePage_description;
    }

    protected String getReviewPageTitle() {
        return IDEWorkbenchMessages.NewProjectWizard_title;
    }

    protected String getReviewPageDescription() {
        return IDEWorkbenchMessages.WizardProjectReviewPage_description;
    }

    protected String getFinishStepLabel(WizardStep[] steps) {
        if (steps.length > 2) {
            return super.getFinishStepLabel(steps);
        }
        return null;
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public IProject getProject() {
        return this.newProject;
    }

    boolean handleMissingStepWizard(WizardStep step) {
        MessageDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.NewProjectWizard_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.NewProjectWizard_noWizard, (Object)step.getLabel()));
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.initializeDefaultPageImageDescriptor();
        this.setWindowTitle(IDEWorkbenchMessages.NewProjectWizard_windowTitle);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = IDEWorkbenchPlugin.getIDEImageDescriptor("wizban/newprj_wiz.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public void setInitialProjectName(String name) {
        this.initialProjectName = name == null ? null : name.trim();
    }

    void setNewProject(IProject project) {
        this.newProject = project;
    }
}

