/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class DeleteResourceAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.DeleteResourceAction";
    private Shell shell;
    private boolean deleteContent = false;
    private boolean forceOutOfSyncDelete = false;
    protected boolean fTestingMode = false;
    private String[] modelProviderIds;

    public DeleteResourceAction(Shell shell) {
        super(IDEWorkbenchMessages.DeleteResourceAction_text);
        this.setToolTipText(IDEWorkbenchMessages.DeleteResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.delete_resource_action_context");
        this.setId(ID);
        if (shell == null) {
            throw new IllegalArgumentException();
        }
        this.shell = shell;
    }

    private boolean canDelete(IResource[] resources) {
        if (!this.containsOnlyProjects(resources) && !this.containsOnlyNonProjects(resources)) {
            return false;
        }
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.isPhantom()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean containsLinkedResource(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsOnlyNonProjects(IResource[] resources) {
        int types = this.getSelectedResourceTypes(resources);
        if (types == 0) {
            return false;
        }
        return (types & 4) == 0;
    }

    private boolean containsOnlyProjects(IResource[] resources) {
        int types = this.getSelectedResourceTypes(resources);
        return types == 4;
    }

    private IStatus createResult(List exceptions) {
        if (exceptions.isEmpty()) {
            return Status.OK_STATUS;
        }
        int exceptionCount = exceptions.size();
        if (exceptionCount == 1) {
            return ((CoreException)((Object)exceptions.get(0))).getStatus();
        }
        CoreException[] children = exceptions.toArray(new CoreException[exceptionCount]);
        boolean outOfSync = false;
        int i = 0;
        while (i < children.length) {
            if (children[i].getStatus().getCode() == 274) {
                outOfSync = true;
                break;
            }
            ++i;
        }
        String title = outOfSync ? IDEWorkbenchMessages.DeleteResourceAction_outOfSyncError : IDEWorkbenchMessages.DeleteResourceAction_deletionExceptionMessage;
        MultiStatus multi = new MultiStatus("org.eclipse.ui.ide", 0, title, null);
        int i2 = 0;
        while (i2 < exceptionCount) {
            CoreException exception = children[i2];
            IStatus status = exception.getStatus();
            multi.add((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), (Throwable)exception));
            ++i2;
        }
        return multi;
    }

    private boolean confirmDelete(IResource[] resources) {
        if (this.validateDelete(resources)) {
            if (this.containsOnlyProjects(resources)) {
                return this.confirmDeleteProjects(resources);
            }
            return this.confirmDeleteNonProjects(resources);
        }
        return false;
    }

    private boolean confirmDeleteNonProjects(IResource[] resources) {
        String msg;
        String title;
        if (resources.length == 1) {
            title = IDEWorkbenchMessages.DeleteResourceAction_title1;
            IResource resource = resources[0];
            msg = resource.isLinked() ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResource1, (Object)resource.getName()) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirm1, (Object)resource.getName());
        } else {
            title = IDEWorkbenchMessages.DeleteResourceAction_titleN;
            msg = this.containsLinkedResource(resources) ? NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmLinkedResourceN, (Object)new Integer(resources.length)) : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmN, (Object)new Integer(resources.length));
        }
        return MessageDialog.openQuestion((Shell)this.shell, (String)title, (String)msg);
    }

    private boolean confirmDeleteProjects(IResource[] resources) {
        DeleteProjectDialog dialog = new DeleteProjectDialog(this.shell, resources);
        dialog.setTestingMode(this.fTestingMode);
        int code = dialog.open();
        this.deleteContent = dialog.getDeleteContent();
        return code == 0;
    }

    private void delete(IResource[] resourcesToDelete, IProgressMonitor monitor) throws CoreException {
        ArrayList<CoreException> exceptions = new ArrayList<CoreException>();
        this.forceOutOfSyncDelete = false;
        monitor.beginTask("", resourcesToDelete.length);
        try {
            int i = 0;
            while (i < resourcesToDelete.length) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    this.delete(resourcesToDelete[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                }
                catch (CoreException e) {
                    exceptions.add(e);
                }
                ++i;
            }
            IStatus result = this.createResult(exceptions);
            if (!result.isOK()) {
                throw new CoreException(result);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void delete(IResource resourceToDelete, IProgressMonitor monitor) throws CoreException {
        boolean force = false;
        try {
            if (resourceToDelete.getType() == 4) {
                IProject project = (IProject)resourceToDelete;
                project.delete(this.deleteContent, force, monitor);
            } else {
                resourceToDelete.delete(2, monitor);
            }
        }
        catch (CoreException exception) {
            if (resourceToDelete.getType() == 1) {
                IStatus[] children = exception.getStatus().getChildren();
                if (children.length == 1 && children[0].getCode() == 274) {
                    if (this.forceOutOfSyncDelete) {
                        resourceToDelete.delete(3, monitor);
                    } else {
                        int result = this.queryDeleteOutOfSync(resourceToDelete);
                        if (result == 2) {
                            resourceToDelete.delete(3, monitor);
                        } else if (result == 4) {
                            this.forceOutOfSyncDelete = true;
                            resourceToDelete.delete(3, monitor);
                        } else if (result == 1) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                throw exception;
            }
            throw exception;
        }
    }

    private IResource[] getSelectedResourcesArray() {
        List selection = this.getSelectedResources();
        IResource[] resources = new IResource[selection.size()];
        selection.toArray(resources);
        return resources;
    }

    private int getSelectedResourceTypes(IResource[] resources) {
        int types = 0;
        int i = 0;
        while (i < resources.length) {
            types |= resources[i].getType();
            ++i;
        }
        return types;
    }

    public void run() {
        final IResource[] resources = this.getSelectedResourcesArray();
        if (!this.confirmDelete(resources)) {
            return;
        }
        Job deletionCheckJob = new Job(IDEWorkbenchMessages.DeleteResourceAction_checkJobName){

            protected IStatus run(IProgressMonitor monitor) {
                IResource[] resourcesToDelete = DeleteResourceAction.this.getResourcesToDelete(resources);
                if (resourcesToDelete.length == 0) {
                    return Status.CANCEL_STATUS;
                }
                DeleteResourceAction.this.scheduleDeleteJob(resourcesToDelete);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (IDEWorkbenchMessages.DeleteResourceAction_jobName.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        deletionCheckJob.schedule();
    }

    private void scheduleDeleteJob(final IResource[] resourcesToDelete) {
        Job deleteJob = new Job(IDEWorkbenchMessages.DeleteResourceAction_jobName){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            DeleteResourceAction.this.delete(resourcesToDelete, monitor);
                        }
                    }, null, 1, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (IDEWorkbenchMessages.DeleteResourceAction_jobName.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        deleteJob.setRule(this.getDeleteRule(resourcesToDelete));
        deleteJob.setUser(true);
        deleteJob.schedule();
    }

    private ISchedulingRule getDeleteRule(IResource[] resourcesToDelete) {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule combinedRule = null;
        int i = 0;
        while (i < resourcesToDelete.length) {
            IResource resource = resourcesToDelete[i];
            ISchedulingRule deleteRule = ruleFactory.deleteRule(resource);
            combinedRule = combinedRule == null ? deleteRule : MultiRule.combine((ISchedulingRule)combinedRule, (ISchedulingRule)deleteRule);
            ++i;
        }
        return combinedRule;
    }

    private IResource[] getResourcesToDelete(IResource[] resources) {
        if (this.containsOnlyProjects(resources) && !this.deleteContent) {
            return resources;
        }
        ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.shell, IDEWorkbenchMessages.DeleteResourceAction_title1, IDEWorkbenchMessages.DeleteResourceAction_readOnlyQuestion);
        checker.setIgnoreLinkedResources(true);
        return checker.checkReadOnlyResources(resources);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return super.updateSelection(selection) && this.canDelete(this.getSelectedResourcesArray());
    }

    private int queryDeleteOutOfSync(IResource resource) {
        final MessageDialog dialog = new MessageDialog(this.shell, IDEWorkbenchMessages.DeleteResourceAction_messageTitle, null, NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_outOfSyncQuestion, (Object)resource.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        int result = dialog.getReturnCode();
        if (result == 0) {
            return 2;
        }
        if (result == 1) {
            return 4;
        }
        if (result == 2) {
            return 3;
        }
        return 1;
    }

    private boolean validateDelete(IResource[] resources) {
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            factory.delete(resource);
            ++i;
        }
        return IDE.promptToConfirm(this.shell, IDEWorkbenchMessages.DeleteResourceAction_confirm, IDEWorkbenchMessages.DeleteResourceAction_warning, factory.getDelta(), this.getModelProviderIds(), false);
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    static class DeleteProjectDialog
    extends MessageDialog {
        private IResource[] projects;
        private boolean deleteContent = false;
        private boolean fIsTesting = false;
        private Button radio1;
        private Button radio2;
        private SelectionListener selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DeleteProjectDialog.this.deleteContent = button == DeleteProjectDialog.this.radio1;
                }
            }
        };

        DeleteProjectDialog(Shell parentShell, IResource[] projects) {
            super(parentShell, DeleteProjectDialog.getTitle(projects), null, DeleteProjectDialog.getMessage(projects), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            this.projects = projects;
        }

        static String getTitle(IResource[] projects) {
            if (projects.length == 1) {
                return IDEWorkbenchMessages.DeleteResourceAction_titleProject1;
            }
            return IDEWorkbenchMessages.DeleteResourceAction_titleProjectN;
        }

        static String getMessage(IResource[] projects) {
            if (projects.length == 1) {
                IProject project = (IProject)projects[0];
                return NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProject1, (Object)project.getName());
            }
            return NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_confirmProjectN, (Object)new Integer(projects.length));
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.ide.delete_project_dialog_context");
        }

        protected Control createCustomArea(Composite parent) {
            IProject project;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.radio1 = new Button(composite, 16);
            this.radio1.addSelectionListener(this.selectionListener);
            String text1 = this.projects.length == 1 ? ((project = (IProject)this.projects[0]) == null || project.getLocation() == null ? IDEWorkbenchMessages.DeleteResourceAction_deleteContentsN : NLS.bind((String)IDEWorkbenchMessages.DeleteResourceAction_deleteContents1, (Object)project.getLocation().toOSString())) : IDEWorkbenchMessages.DeleteResourceAction_deleteContentsN;
            this.radio1.setText(text1);
            this.radio1.setFont(parent.getFont());
            this.radio2 = new Button(composite, 16);
            this.radio2.addSelectionListener(this.selectionListener);
            String text2 = IDEWorkbenchMessages.DeleteResourceAction_doNotDeleteContents;
            this.radio2.setText(text2);
            this.radio2.setFont(parent.getFont());
            this.radio1.setSelection(this.deleteContent);
            this.radio2.setSelection(!this.deleteContent);
            return composite;
        }

        boolean getDeleteContent() {
            return this.deleteContent;
        }

        public int open() {
            if (this.fIsTesting) {
                this.deleteContent = true;
                return 0;
            }
            return super.open();
        }

        void setTestingMode(boolean t) {
            this.fIsTesting = t;
        }
    }
}

