/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.internal.navigator.resources.actions.CopyAction;
import org.eclipse.ui.internal.navigator.resources.actions.PasteAction;
import org.eclipse.ui.internal.navigator.resources.actions.ResourceSelectionUtil;
import org.eclipse.ui.internal.navigator.resources.actions.TextActionHandler;

public class RefactorActionGroup
extends ActionGroup {
    private Clipboard clipboard;
    private CopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private PasteAction pasteAction;
    private RenameResourceAction renameAction;
    private MoveResourceAction moveAction;
    private TextActionHandler textActionHandler;
    private Shell shell;
    private Tree tree;

    public RefactorActionGroup(Shell aShell, Tree aTree) {
        this.shell = aShell;
        this.tree = aTree;
        this.makeActions();
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(selection, 7);
        this.copyAction.selectionChanged(selection);
        menu.appendToGroup("group.edit", (IAction)this.copyAction);
        this.pasteAction.selectionChanged(selection);
        menu.insertAfter(this.copyAction.getId(), (IAction)this.pasteAction);
        if (anyResourceSelected) {
            this.deleteAction.selectionChanged(selection);
            menu.insertAfter(this.pasteAction.getId(), (IAction)this.deleteAction);
            this.moveAction.selectionChanged(selection);
            menu.insertAfter(this.deleteAction.getId(), (IAction)this.moveAction);
            this.renameAction.selectionChanged(selection);
            menu.insertAfter(this.moveAction.getId(), (IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.textActionHandler == null) {
            this.textActionHandler = new TextActionHandler(actionBars);
        }
        this.textActionHandler.setCopyAction((IAction)this.copyAction);
        this.textActionHandler.setPasteAction((IAction)this.pasteAction);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.renameAction.setTextActionHandler((org.eclipse.ui.actions.TextActionHandler)this.textActionHandler);
        this.updateActionBars();
        this.textActionHandler.updateActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
            event.doit = false;
        } else if (event.keyCode == 0x100000B && event.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeActions() {
        this.clipboard = new Clipboard(this.shell.getDisplay());
        this.pasteAction = new PasteAction(this.shell, this.clipboard);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.pasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.copyAction = new CopyAction(this.shell, this.clipboard, this.pasteAction);
        this.copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.moveAction = new MoveResourceAction(this.shell);
        this.moveAction.setActionDefinitionId("org.eclipse.ui.edit.move");
        this.renameAction = new RenameResourceAction(this.shell, this.tree);
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        this.deleteAction = new DeleteResourceAction(this.shell);
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.copyAction.selectionChanged(selection);
        this.pasteAction.selectionChanged(selection);
        this.deleteAction.selectionChanged(selection);
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }
}

