/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.IStreamMerger;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareDialog;
import org.eclipse.compare.internal.CompareFilter;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.ComparePreferencePage;
import org.eclipse.compare.internal.IViewerDescriptor;
import org.eclipse.compare.internal.SimpleTextViewer;
import org.eclipse.compare.internal.StreamMergerDescriptor;
import org.eclipse.compare.internal.StructureCreatorDescriptor;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class CompareUIPlugin
extends AbstractUIPlugin {
    public static final String DTOOL_NEXT = "dlcl16/next_nav.gif";
    public static final String ETOOL_NEXT = "elcl16/next_nav.gif";
    public static final String CTOOL_NEXT = "elcl16/next_nav.gif";
    public static final String DTOOL_PREV = "dlcl16/prev_nav.gif";
    public static final String ETOOL_PREV = "elcl16/prev_nav.gif";
    public static final String CTOOL_PREV = "elcl16/prev_nav.gif";
    public static final int INTERNAL_ERROR = 1;
    private static boolean NORMALIZE_CASE = true;
    public static final String PLUGIN_ID = "org.eclipse.compare";
    private static final String BINARY_TYPE = "binary";
    private static final String STREAM_MERGER_EXTENSION_POINT = "streamMergers";
    private static final String STREAM_MERGER = "streamMerger";
    private static final String STREAM_MERGER_ID_ATTRIBUTE = "streamMergerId";
    private static final String STRUCTURE_CREATOR_EXTENSION_POINT = "structureCreators";
    private static final String STRUCTURE_CREATOR = "structureCreator";
    private static final String STRUCTURE_CREATOR_ID_ATTRIBUTE = "structureCreatorId";
    private static final String VIEWER_TAG = "viewer";
    private static final String STRUCTURE_MERGE_VIEWER_EXTENSION_POINT = "structureMergeViewers";
    private static final String STRUCTURE_MERGE_VIEWER_ID_ATTRIBUTE = "structureMergeViewerId";
    private static final String CONTENT_MERGE_VIEWER_EXTENSION_POINT = "contentMergeViewers";
    private static final String CONTENT_MERGE_VIEWER_ID_ATTRIBUTE = "contentMergeViewerId";
    private static final String CONTENT_VIEWER_EXTENSION_POINT = "contentViewers";
    private static final String CONTENT_VIEWER_ID_ATTRIBUTE = "contentViewerId";
    private static final String CONTENT_TYPE_BINDING = "contentTypeBinding";
    private static final String COMPARE_EDITOR = "org.eclipse.compare.CompareEditor";
    private static final String STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME = "StructureViewerAliases";
    private static final IContentTypeManager fgContentTypeManager = Platform.getContentTypeManager();
    private static CompareUIPlugin fgComparePlugin;
    private static Map fgImages;
    private static Map fgImageDescriptors;
    private static Map fgImages2;
    private static List fgDisposeOnShutdownImages;
    private ResourceBundle fResourceBundle;
    private boolean fRegistriesInitialized;
    private CompareRegistry fStreamMergers = new CompareRegistry();
    private CompareRegistry fStructureCreators = new CompareRegistry();
    private CompareRegistry fStructureMergeViewers = new CompareRegistry();
    private CompareRegistry fContentViewers = new CompareRegistry();
    private CompareRegistry fContentMergeViewers = new CompareRegistry();
    private Map fStructureViewerAliases;
    private CompareFilter fFilter;
    private IPropertyChangeListener fPropertyChangeListener;

    static {
        fgImages = new Hashtable(10);
        fgImageDescriptors = new Hashtable(10);
        fgImages2 = new Hashtable(10);
        fgDisposeOnShutdownImages = new ArrayList();
    }

    public CompareUIPlugin() {
        Assert.isTrue((fgComparePlugin == null ? 1 : 0) != 0);
        fgComparePlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ComparePreferencePage.initDefaults(this.getPreferenceStore());
    }

    public void stop(BundleContext context) throws Exception {
        IPreferenceStore ps = this.getPreferenceStore();
        this.rememberAliases(ps);
        if (this.fPropertyChangeListener != null) {
            ps.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        super.stop(context);
        if (fgDisposeOnShutdownImages != null) {
            for (Image img : fgDisposeOnShutdownImages) {
                if (img.isDisposed()) continue;
                img.dispose();
            }
            fgImages = null;
        }
    }

    public static CompareUIPlugin getDefault() {
        return fgComparePlugin;
    }

    public ResourceBundle getResourceBundle() {
        if (this.fResourceBundle == null) {
            this.fResourceBundle = Platform.getResourceBundle((Bundle)this.getBundle());
        }
        return this.fResourceBundle;
    }

    public static String getPluginId() {
        return CompareUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    private void initializeRegistries() {
        if (!this.fRegistriesInitialized) {
            this.registerExtensions();
            this.fRegistriesInitialized = true;
        }
    }

    private void registerExtensions() {
        String name;
        IConfigurationElement element;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PLUGIN_ID, STREAM_MERGER_EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (STREAM_MERGER.equals(element.getName())) {
                this.fStreamMergers.register(element, new StreamMergerDescriptor(element));
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fStreamMergers.createBinding(element, STREAM_MERGER_ID_ATTRIBUTE);
            }
            ++i;
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, STRUCTURE_CREATOR_EXTENSION_POINT);
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            name = element.getName();
            if (!CONTENT_TYPE_BINDING.equals(name)) {
                if (!STRUCTURE_CREATOR.equals(name)) {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, STRUCTURE_CREATOR));
                }
                this.fStructureCreators.register(element, new StructureCreatorDescriptor(element));
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fStructureCreators.createBinding(element, STRUCTURE_CREATOR_ID_ATTRIBUTE);
            }
            ++i;
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, STRUCTURE_MERGE_VIEWER_EXTENSION_POINT);
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            name = element.getName();
            if (!CONTENT_TYPE_BINDING.equals(name)) {
                if (!VIEWER_TAG.equals(name)) {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, VIEWER_TAG));
                }
                this.fStructureMergeViewers.register(element, new ViewerDescriptor(element));
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fStructureMergeViewers.createBinding(element, STRUCTURE_MERGE_VIEWER_ID_ATTRIBUTE);
            }
            ++i;
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, CONTENT_MERGE_VIEWER_EXTENSION_POINT);
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            name = element.getName();
            if (!CONTENT_TYPE_BINDING.equals(name)) {
                if (!VIEWER_TAG.equals(name)) {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, VIEWER_TAG));
                }
                this.fContentMergeViewers.register(element, new ViewerDescriptor(element));
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fContentMergeViewers.createBinding(element, CONTENT_MERGE_VIEWER_ID_ATTRIBUTE);
            }
            ++i;
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, CONTENT_VIEWER_EXTENSION_POINT);
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            name = element.getName();
            if (!CONTENT_TYPE_BINDING.equals(name)) {
                if (!VIEWER_TAG.equals(name)) {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, VIEWER_TAG));
                }
                this.fContentViewers.register(element, new ViewerDescriptor(element));
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (CONTENT_TYPE_BINDING.equals(element.getName())) {
                this.fContentViewers.createBinding(element, CONTENT_VIEWER_ID_ATTRIBUTE);
            }
            ++i;
        }
    }

    public static IWorkbench getActiveWorkbench() {
        CompareUIPlugin plugin = CompareUIPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        return plugin.getWorkbench();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = CompareUIPlugin.getActiveWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = CompareUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static Shell getShell() {
        IWorkbenchWindow window = CompareUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static void disposeOnShutdown(Image image) {
        if (image != null) {
            fgDisposeOnShutdownImages.add(image);
        }
    }

    public void openCompareEditor(CompareEditorInput input, IWorkbenchPage page, IReusableEditor editor) {
        if (this.compareResultOK(input)) {
            if (editor != null) {
                editor.setInput((IEditorInput)input);
                return;
            }
            if (page == null) {
                page = CompareUIPlugin.getActivePage();
            }
            if (page != null) {
                try {
                    page.openEditor((IEditorInput)input, COMPARE_EDITOR);
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)CompareUIPlugin.getShell(), (String)Utilities.getString("CompareUIPlugin.openEditorError"), (String)e.getMessage());
                }
            } else {
                MessageDialog.openError((Shell)CompareUIPlugin.getShell(), (String)Utilities.getString("CompareUIPlugin.openEditorError"), (String)Utilities.getString("CompareUIPlugin.noActiveWorkbenchPage"));
            }
        }
    }

    public void openCompareDialog(CompareEditorInput input) {
        if (this.compareResultOK(input)) {
            CompareDialog dialog = new CompareDialog(CompareUIPlugin.getShell(), input);
            dialog.open();
        }
    }

    private boolean compareResultOK(CompareEditorInput input) {
        Shell shell;
        block5: {
            shell = CompareUIPlugin.getShell();
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)input);
            String message = input.getMessage();
            if (message == null) break block5;
            MessageDialog.openError((Shell)shell, (String)Utilities.getString("CompareUIPlugin.compareFailed"), (String)message);
            return false;
        }
        try {
            if (input.getCompareResult() == null) {
                MessageDialog.openInformation((Shell)shell, (String)Utilities.getString("CompareUIPlugin.dialogTitle"), (String)Utilities.getString("CompareUIPlugin.noDifferences"));
                return false;
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            MessageDialog.openError((Shell)shell, (String)Utilities.getString("CompareUIPlugin.compareFailed"), (String)x.getTargetException().getMessage());
        }
        return false;
    }

    private static void registerImage(String type, Image image, boolean dispose) {
        fgImages.put(CompareUIPlugin.normalizeCase(type), image);
        if (image != null && dispose) {
            fgDisposeOnShutdownImages.add(image);
        }
    }

    public static void registerImageDescriptor(String type, ImageDescriptor descriptor) {
        fgImageDescriptors.put(CompareUIPlugin.normalizeCase(type), descriptor);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        if (fgComparePlugin == null) {
            return null;
        }
        IPath path = Utilities.getIconPath(null).append(relativePath);
        URL url = FileLocator.find((Bundle)fgComparePlugin.getBundle(), (IPath)path, null);
        if (url == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static Image getImage(String type) {
        type = CompareUIPlugin.normalizeCase(type);
        boolean dispose = false;
        Image image = null;
        if (type != null) {
            image = (Image)fgImages.get(type);
        }
        if (image == null) {
            ImageDescriptor id = (ImageDescriptor)fgImageDescriptors.get(type);
            if (id != null) {
                image = id.createImage();
                dispose = true;
            }
            if (image == null) {
                if (fgComparePlugin != null) {
                    if ("FOLDER".equals(type)) {
                        image = CompareUIPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                    } else {
                        image = CompareUIPlugin.createWorkbenchImage(type);
                        dispose = true;
                    }
                } else {
                    id = (ImageDescriptor)fgImageDescriptors.get(CompareUIPlugin.normalizeCase("file"));
                    image = id.createImage();
                    dispose = true;
                }
            }
            if (image != null) {
                CompareUIPlugin.registerImage(type, image, dispose);
            }
        }
        return image;
    }

    public static Image getImage(IAdaptable adaptable) {
        ImageDescriptor id;
        Object o;
        if (adaptable != null && (o = adaptable.getAdapter(IWorkbenchAdapter.class)) instanceof IWorkbenchAdapter && (id = ((IWorkbenchAdapter)o).getImageDescriptor((Object)adaptable)) != null) {
            Image image = (Image)fgImages2.get(id);
            if (image == null) {
                image = id.createImage();
                try {
                    fgImages2.put(id, image);
                }
                catch (NullPointerException nullPointerException) {}
                fgDisposeOnShutdownImages.add(image);
            }
            return image;
        }
        return null;
    }

    private static Image createWorkbenchImage(String type) {
        IEditorRegistry er = CompareUIPlugin.getDefault().getWorkbench().getEditorRegistry();
        ImageDescriptor id = er.getImageDescriptor("foo." + type);
        return id.createImage();
    }

    public StructureCreatorDescriptor getStructureCreator(String type) {
        this.initializeRegistries();
        return (StructureCreatorDescriptor)this.fStructureCreators.search(type);
    }

    public IStreamMerger createStreamMerger(String type) {
        this.initializeRegistries();
        StreamMergerDescriptor descriptor = (StreamMergerDescriptor)this.fStreamMergers.search(type);
        if (descriptor != null) {
            return descriptor.createStreamMerger();
        }
        return null;
    }

    public IStreamMerger createStreamMerger(IContentType type) {
        this.initializeRegistries();
        StreamMergerDescriptor descriptor = (StreamMergerDescriptor)this.fStreamMergers.search(type);
        if (descriptor != null) {
            return descriptor.createStreamMerger();
        }
        return null;
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent, CompareConfiguration configuration) {
        IStructureCreator sc;
        if (input.getLeft() == null || input.getRight() == null) {
            return null;
        }
        IContentType ctype = CompareUIPlugin.getCommonType(input);
        if (ctype != null) {
            this.initializeRegistries();
            Viewer viewer = CompareUIPlugin.getViewer(this.fStructureMergeViewers.search(ctype), oldViewer, parent, configuration);
            if (viewer != null) {
                return viewer;
            }
        }
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            String alias;
            type = CompareUIPlugin.normalizeCase(types[0]);
            this.initializeRegistries();
            IViewerDescriptor vd = (IViewerDescriptor)this.fStructureMergeViewers.search(type);
            if (vd == null && (alias = this.getStructureViewerAlias(type)) != null) {
                vd = (IViewerDescriptor)this.fStructureMergeViewers.search(alias);
            }
            if (vd != null) {
                return vd.createViewer(oldViewer, parent, configuration);
            }
        }
        StructureCreatorDescriptor scc = null;
        this.initializeRegistries();
        Object desc = this.fStructureCreators.search(ctype);
        if (desc instanceof StructureCreatorDescriptor) {
            scc = (StructureCreatorDescriptor)desc;
        }
        if (scc == null && type != null) {
            scc = this.getStructureCreator(type);
        }
        if (scc != null && (sc = scc.createStructureCreator()) != null) {
            StructureDiffViewer sdv = new StructureDiffViewer(parent, configuration);
            sdv.setStructureCreator(sc);
            return sdv;
        }
        return null;
    }

    public Viewer findContentViewer(Viewer oldViewer, Object in, Composite parent, CompareConfiguration cc) {
        if (in instanceof IStreamContentAccessor) {
            String type = "txt";
            if (in instanceof ITypedElement) {
                String ty;
                ITypedElement tin = (ITypedElement)in;
                IContentType ct = CompareUIPlugin.getContentType(tin);
                if (ct != null) {
                    this.initializeRegistries();
                    Viewer viewer = CompareUIPlugin.getViewer(this.fContentViewers.search(ct), oldViewer, parent, cc);
                    if (viewer != null) {
                        return viewer;
                    }
                }
                if ((ty = tin.getType()) != null) {
                    type = ty;
                }
            }
            this.initializeRegistries();
            Viewer viewer = CompareUIPlugin.getViewer(this.fContentViewers.search(type), oldViewer, parent, cc);
            if (viewer != null) {
                return viewer;
            }
            return new SimpleTextViewer(parent);
        }
        if (!(in instanceof ICompareInput)) {
            return null;
        }
        ICompareInput input = (ICompareInput)in;
        IContentType ctype = CompareUIPlugin.getCommonType(input);
        if (ctype != null) {
            this.initializeRegistries();
            Viewer viewer = CompareUIPlugin.getViewer(this.fContentMergeViewers.search(ctype), oldViewer, parent, cc);
            if (viewer != null) {
                return viewer;
            }
        }
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            type = types[0];
        }
        if ("FOLDER".equals(type)) {
            return null;
        }
        if (type == null) {
            int n = 0;
            int i = 0;
            while (i < types.length) {
                if (!"???".equals(types[i])) {
                    ++n;
                    if (type == null) {
                        type = types[i];
                    }
                }
                ++i;
            }
            if (n > 1) {
                type = null;
            }
        }
        if (type != null) {
            this.initializeRegistries();
            Viewer viewer = CompareUIPlugin.getViewer(this.fContentMergeViewers.search(type), oldViewer, parent, cc);
            if (viewer != null) {
                return viewer;
            }
        }
        String leftType = CompareUIPlugin.guessType(input.getLeft());
        String rightType = CompareUIPlugin.guessType(input.getRight());
        if (leftType != null || rightType != null) {
            boolean right_text = rightType != null && "txt".equals(rightType);
            boolean left_text = leftType != null && "txt".equals(leftType);
            type = leftType == null && right_text || left_text && rightType == null || left_text && right_text ? "txt" : BINARY_TYPE;
            this.initializeRegistries();
            IViewerDescriptor vd = (IViewerDescriptor)this.fContentMergeViewers.search(type);
            if (vd != null) {
                return vd.createViewer(oldViewer, parent, cc);
            }
        }
        return null;
    }

    private static Viewer getViewer(Object descriptor, Viewer oldViewer, Composite parent, CompareConfiguration cc) {
        if (descriptor instanceof IViewerDescriptor) {
            return ((IViewerDescriptor)descriptor).createViewer(oldViewer, parent, cc);
        }
        return null;
    }

    private static String[] getTypes(ICompareInput input) {
        String type;
        ITypedElement ancestor = input.getAncestor();
        ITypedElement left = input.getLeft();
        ITypedElement right = input.getRight();
        ArrayList<String> tmp = new ArrayList<String>();
        if (ancestor != null && (type = ancestor.getType()) != null) {
            tmp.add(CompareUIPlugin.normalizeCase(type));
        }
        if (left != null && (type = left.getType()) != null) {
            tmp.add(CompareUIPlugin.normalizeCase(type));
        }
        if (right != null && (type = right.getType()) != null) {
            tmp.add(CompareUIPlugin.normalizeCase(type));
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    private static IContentType getContentType(ITypedElement element) {
        IContentType ct;
        String name;
        block13: {
            if (element == null) {
                return null;
            }
            name = element.getName();
            ct = null;
            if (element instanceof IStreamContentAccessor) {
                IStreamContentAccessor isa = (IStreamContentAccessor)((Object)element);
                try {
                    InputStream is = isa.getContents();
                    if (is == null) break block13;
                    BufferedInputStream bis = new BufferedInputStream(is);
                    try {
                        try {
                            ct = fgContentTypeManager.findContentTypeFor(is, name);
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)bis).close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        ((InputStream)bis).close();
                    }
                    catch (IOException iOException) {}
                }
                catch (CoreException coreException) {}
            }
        }
        if (ct == null) {
            ct = fgContentTypeManager.findContentTypeFor(name);
        }
        return ct;
    }

    private static boolean isHomogenous(String[] types) {
        switch (types.length) {
            case 1: {
                return true;
            }
            case 2: {
                return types[0].equals(types[1]);
            }
            case 3: {
                return types[0].equals(types[1]) && types[1].equals(types[2]);
            }
        }
        return false;
    }

    private static IContentType getCommonType(ICompareInput input) {
        ITypedElement ancestor = input.getAncestor();
        ITypedElement left = input.getLeft();
        ITypedElement right = input.getRight();
        int n = 0;
        IContentType[] types = new IContentType[3];
        IContentType type = null;
        if (ancestor != null && (type = CompareUIPlugin.getContentType(ancestor)) != null) {
            types[n++] = type;
        }
        if ((type = CompareUIPlugin.getContentType(left)) == null) {
            return null;
        }
        types[n++] = type;
        type = CompareUIPlugin.getContentType(right);
        if (type == null) {
            return null;
        }
        types[n++] = type;
        IContentType result = null;
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return types[0];
            }
            case 2: {
                if (types[0].equals(types[1])) {
                    return types[0];
                }
                IContentType[] s0 = CompareUIPlugin.toFullPath(types[0]);
                IContentType[] s1 = CompareUIPlugin.toFullPath(types[1]);
                int i = 0;
                while (i < Math.min(s0.length, s1.length)) {
                    if (!s0[i].equals(s1[i])) break;
                    result = s0[i];
                    ++i;
                }
                return result;
            }
            case 3: {
                if (types[0].equals(types[1]) && types[1].equals(types[2])) {
                    return types[0];
                }
                IContentType[] s0 = CompareUIPlugin.toFullPath(types[0]);
                IContentType[] s1 = CompareUIPlugin.toFullPath(types[1]);
                IContentType[] s2 = CompareUIPlugin.toFullPath(types[2]);
                int i = 0;
                while (i < Math.min(Math.min(s0.length, s1.length), s2.length)) {
                    if (!s0[i].equals(s1[i]) || !s1[i].equals(s2[i])) break;
                    result = s0[i];
                    ++i;
                }
                return result;
            }
        }
        return null;
    }

    private static IContentType[] toFullPath(IContentType ct) {
        ArrayList<IContentType> l = new ArrayList<IContentType>();
        while (ct != null) {
            l.add(0, ct);
            ct = ct.getBaseType();
        }
        return l.toArray(new IContentType[l.size()]);
    }

    /*
     * Exception decompiling
     */
    private static String guessType(ITypedElement input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String normalizeCase(String s) {
        if (NORMALIZE_CASE && s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    private String getStructureViewerAlias(String type) {
        return (String)this.getStructureViewerAliases().get(type);
    }

    public void addStructureViewerAlias(String type, String alias) {
        this.getStructureViewerAliases().put(CompareUIPlugin.normalizeCase(alias), CompareUIPlugin.normalizeCase(type));
    }

    private Map getStructureViewerAliases() {
        if (this.fStructureViewerAliases == null) {
            this.fStructureViewerAliases = new Hashtable(10);
            String aliases = this.getPreferenceStore().getString(STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME);
            if (aliases != null && aliases.length() > 0) {
                StringTokenizer st = new StringTokenizer(aliases, " ");
                while (st.hasMoreTokens()) {
                    String pair = st.nextToken();
                    int pos = pair.indexOf(46);
                    if (pos <= 0) continue;
                    String key = pair.substring(0, pos);
                    String alias = pair.substring(pos + 1);
                    this.fStructureViewerAliases.put(key, alias);
                }
            }
        }
        return this.fStructureViewerAliases;
    }

    public void removeAllStructureViewerAliases(String type) {
        if (this.fStructureViewerAliases == null) {
            return;
        }
        String t = CompareUIPlugin.normalizeCase(type);
        Set entrySet = this.fStructureViewerAliases.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!entry.getValue().equals(t)) continue;
            iter.remove();
        }
    }

    private void rememberAliases(IPreferenceStore ps) {
        if (this.fStructureViewerAliases == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        for (String key : this.fStructureViewerAliases.keySet()) {
            String alias = (String)this.fStructureViewerAliases.get(key);
            buffer.append(key);
            buffer.append('.');
            buffer.append(alias);
            buffer.append(' ');
        }
        ps.setValue(STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME, buffer.toString());
    }

    public boolean filter(String name, boolean isFolder, boolean isArchive) {
        if (this.fFilter == null) {
            this.fFilter = new CompareFilter();
            final IPreferenceStore ps = this.getPreferenceStore();
            this.fFilter.setFilters(ps.getString("org.eclipse.compare.PathFilter"));
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("org.eclipse.compare.PathFilter".equals(event.getProperty())) {
                        CompareUIPlugin.this.fFilter.setFilters(ps.getString("org.eclipse.compare.PathFilter"));
                    }
                }
            };
            ps.addPropertyChangeListener(this.fPropertyChangeListener);
        }
        return this.fFilter.filter(name, isFolder, isArchive);
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = CompareUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                int z = 0;
                while (z < editors.length) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (!inputs.contains(input)) {
                        inputs.add(input);
                        result.add(ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public static void logErrorMessage(String message) {
        if (message == null) {
            message = "";
        }
        CompareUIPlugin.log((IStatus)new Status(4, CompareUIPlugin.getPluginId(), 1, message, null));
    }

    public static void log(Throwable e) {
        CompareUIPlugin.log((IStatus)new Status(4, CompareUIPlugin.getPluginId(), 1, CompareMessages.ComparePlugin_internal_error, e));
    }

    public static void log(IStatus status) {
        CompareUIPlugin.getDefault().getLog().log(status);
    }

    static class CompareRegistry {
        private static final String ID_ATTRIBUTE = "id";
        private static final String EXTENSIONS_ATTRIBUTE = "extensions";
        private static final String CONTENT_TYPE_ID_ATTRIBUTE = "contentTypeId";
        private HashMap fIdMap;
        private HashMap fExtensionMap;
        private HashMap fContentTypeBindings;

        CompareRegistry() {
        }

        void register(IConfigurationElement element, Object data) {
            String types;
            String id = element.getAttribute(ID_ATTRIBUTE);
            if (id != null) {
                if (this.fIdMap == null) {
                    this.fIdMap = new HashMap();
                }
                this.fIdMap.put(id, data);
            }
            if ((types = element.getAttribute(EXTENSIONS_ATTRIBUTE)) != null) {
                if (this.fExtensionMap == null) {
                    this.fExtensionMap = new HashMap();
                }
                StringTokenizer tokenizer = new StringTokenizer(types, ",");
                while (tokenizer.hasMoreElements()) {
                    String extension = tokenizer.nextToken().trim();
                    this.fExtensionMap.put(CompareUIPlugin.normalizeCase(extension), data);
                }
            }
        }

        void createBinding(IConfigurationElement element, String idAttributeName) {
            String type = element.getAttribute(CONTENT_TYPE_ID_ATTRIBUTE);
            String id = element.getAttribute(idAttributeName);
            if (id == null) {
                CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.targetIdAttributeMissing", idAttributeName));
            }
            if (type != null && id != null && this.fIdMap != null) {
                Object o = this.fIdMap.get(id);
                if (o != null) {
                    IContentType ct = fgContentTypeManager.getContentType(type);
                    if (ct != null) {
                        if (this.fContentTypeBindings == null) {
                            this.fContentTypeBindings = new HashMap();
                        }
                        this.fContentTypeBindings.put(ct, o);
                    } else {
                        CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.contentTypeNotFound", type));
                    }
                } else {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.targetNotFound", id));
                }
            }
        }

        Object search(IContentType type) {
            if (this.fContentTypeBindings != null) {
                while (type != null) {
                    Object data = this.fContentTypeBindings.get(type);
                    if (data != null) {
                        return data;
                    }
                    type = type.getBaseType();
                }
            }
            return null;
        }

        Object search(String extension) {
            if (this.fExtensionMap != null) {
                return this.fExtensionMap.get(CompareUIPlugin.normalizeCase(extension));
            }
            return null;
        }
    }
}

