/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CompilationUnitProblemFinder;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class ReconcileWorkingCopyOperation
extends JavaModelOperation {
    public static boolean PERF = false;
    public int astLevel;
    public boolean resolveBindings;
    public HashMap problems;
    boolean forceProblemDetection;
    boolean enableStatementsRecovery;
    WorkingCopyOwner workingCopyOwner;
    public org.eclipse.jdt.core.dom.CompilationUnit ast;
    public JavaElementDeltaBuilder deltaBuilder;

    public ReconcileWorkingCopyOperation(IJavaElement workingCopy, int astLevel, boolean forceProblemDetection, boolean enableStatementsRecovery, WorkingCopyOwner workingCopyOwner) {
        super(new IJavaElement[]{workingCopy});
        this.astLevel = astLevel;
        this.forceProblemDetection = forceProblemDetection;
        this.enableStatementsRecovery = enableStatementsRecovery;
        this.workingCopyOwner = workingCopyOwner;
    }

    protected void executeOperation() throws JavaModelException {
        CompilationUnit workingCopy;
        JavaModelManager.PerWorkingCopyInfo problemRequestor;
        if (this.progressMonitor != null) {
            if (this.progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.progressMonitor.beginTask(Messages.element_reconciling, 2);
        }
        this.resolveBindings |= (problemRequestor = (workingCopy = this.getWorkingCopy()).getPerWorkingCopyInfo()) != null && problemRequestor.isActive();
        this.deltaBuilder = new JavaElementDeltaBuilder(workingCopy);
        this.makeConsistent(workingCopy, problemRequestor);
        this.notifyParticipants(workingCopy);
        if (this.ast == null && (this.astLevel > 0 || this.resolveBindings)) {
            this.makeConsistent(workingCopy, problemRequestor);
        }
        if (this.problems != null) {
            try {
                problemRequestor.beginReporting();
                block6: for (CategorizedProblem[] categorizedProblems : this.problems.values()) {
                    if (categorizedProblems == null) continue;
                    int i = 0;
                    int length = categorizedProblems.length;
                    while (i < length) {
                        CategorizedProblem problem = categorizedProblems[i];
                        if (JavaModelManager.VERBOSE) {
                            System.out.println("PROBLEM FOUND while reconciling : " + problem.getMessage());
                        }
                        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) continue block6;
                        problemRequestor.acceptProblem(problem);
                        ++i;
                    }
                }
            }
            finally {
                problemRequestor.endReporting();
            }
        }
        try {
            JavaElementDelta delta = this.deltaBuilder.delta;
            if (delta != null) {
                this.addReconcileDelta(workingCopy, delta);
            }
        }
        finally {
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
        }
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }

    public org.eclipse.jdt.core.dom.CompilationUnit makeConsistent(CompilationUnit workingCopy, IProblemRequestor problemRequestor) throws JavaModelException {
        if (!workingCopy.isConsistent()) {
            if (this.problems == null) {
                this.problems = new HashMap();
            }
            this.ast = workingCopy.makeConsistent(this.astLevel, this.resolveBindings, this.enableStatementsRecovery, this.problems, this.progressMonitor);
            this.deltaBuilder.buildDeltas();
            if (this.ast != null && this.deltaBuilder.delta != null) {
                this.deltaBuilder.delta.changedAST(this.ast);
            }
            return this.ast;
        }
        if (this.ast != null) {
            return this.ast;
        }
        if (this.forceProblemDetection || this.resolveBindings) {
            if (JavaProject.hasJavaNature(workingCopy.getJavaProject().getProject())) {
                HashMap problemMap;
                if (this.problems == null) {
                    problemMap = new HashMap();
                    if (this.forceProblemDetection) {
                        this.problems = problemMap;
                    }
                } else {
                    problemMap = this.problems;
                }
                CompilationUnitDeclaration unit = null;
                try {
                    try {
                        char[] contents = workingCopy.getContents();
                        unit = CompilationUnitProblemFinder.process(workingCopy, contents, this.workingCopyOwner, problemMap, this.astLevel != 0, this.enableStatementsRecovery, this.progressMonitor);
                        if (this.progressMonitor != null) {
                            this.progressMonitor.worked(1);
                        }
                        if (this.astLevel != 0 && unit != null) {
                            Map options = workingCopy.getJavaProject().getOptions(true);
                            this.ast = AST.convertCompilationUnit(this.astLevel, unit, contents, options, true, workingCopy, this.progressMonitor);
                            if (this.ast != null) {
                                this.deltaBuilder.delta = new JavaElementDelta(workingCopy);
                                this.deltaBuilder.delta.changedAST(this.ast);
                            }
                            if (this.progressMonitor != null) {
                                this.progressMonitor.worked(1);
                            }
                        }
                    }
                    catch (JavaModelException e) {
                        if (JavaProject.hasJavaNature(workingCopy.getJavaProject().getProject())) {
                            throw e;
                        }
                    }
                }
                finally {
                    if (unit != null) {
                        unit.cleanUp();
                    }
                }
            }
            return this.ast;
        }
        return null;
    }

    private void notifyParticipants(CompilationUnit workingCopy) {
        IJavaProject javaProject = this.getWorkingCopy().getJavaProject();
        CompilationParticipant[] participants = JavaModelManager.getJavaModelManager().compilationParticipants.getCompilationParticipants(javaProject);
        if (participants == null) {
            return;
        }
        final ReconcileContext context = new ReconcileContext(this, workingCopy);
        int i = 0;
        int length = participants.length;
        while (i < length) {
            final CompilationParticipant participant = participants[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    if (exception instanceof Error) {
                        throw (Error)exception;
                    }
                    if (exception instanceof OperationCanceledException) {
                        throw (OperationCanceledException)exception;
                    }
                    if (exception instanceof UnsupportedOperationException) {
                        Util.log(exception, "Reconcile participant attempted to modify the buffer of the working copy being reconciled");
                    } else {
                        Util.log(exception, "Exception occurred in reconcile participant");
                    }
                }

                public void run() throws Exception {
                    participant.reconcile(context);
                }
            });
            ++i;
        }
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        CompilationUnit workingCopy = this.getWorkingCopy();
        if (!workingCopy.isWorkingCopy()) {
            return new JavaModelStatus(969, workingCopy);
        }
        return status;
    }
}

