/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor.templates;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.texteditor.NLSUtility;
import org.eclipse.ui.texteditor.templates.ColumnLayout;
import org.eclipse.ui.texteditor.templates.EditTemplateDialog;
import org.eclipse.ui.texteditor.templates.TemplateContentProvider;
import org.eclipse.ui.texteditor.templates.TextEditorTemplateMessages;

public abstract class TemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_FORMATTER_PREFERENCE_KEY = "org.eclipse.ui.texteditor.templates.preferences.format_templates";
    private CheckboxTableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fImportButton;
    private Button fExportButton;
    private Button fRemoveButton;
    private Button fRestoreButton;
    private Button fRevertButton;
    private SourceViewer fPatternViewer;
    private Button fFormatButton;
    private TemplateStore fTemplateStore;
    private ContextTypeRegistry fContextTypeRegistry;

    protected TemplatePreferencePage() {
        this.setDescription(TextEditorTemplateMessages.TemplatePreferencePage_message);
    }

    public TemplateStore getTemplateStore() {
        return this.fTemplateStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        return this.fContextTypeRegistry;
    }

    public void setTemplateStore(TemplateStore store) {
        this.fTemplateStore = store;
    }

    public void setContextTypeRegistry(ContextTypeRegistry registry) {
        this.fContextTypeRegistry = registry;
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        Composite tableComposite = new Composite(innerParent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        tableComposite.setLayoutData((Object)data);
        ColumnLayout columnLayout = new ColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(TextEditorTemplateMessages.TemplatePreferencePage_column_name);
        int minWidth = this.computeMinimumColumnWidth(gc, TextEditorTemplateMessages.TemplatePreferencePage_column_name);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(TextEditorTemplateMessages.TemplatePreferencePage_column_context);
        minWidth = this.computeMinimumColumnWidth(gc, TextEditorTemplateMessages.TemplatePreferencePage_column_context);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, minWidth, true));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(TextEditorTemplateMessages.TemplatePreferencePage_column_description);
        minWidth = this.computeMinimumColumnWidth(gc, TextEditorTemplateMessages.TemplatePreferencePage_column_description);
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, minWidth, true));
        TableColumn column4 = new TableColumn(table, 0);
        column4.setAlignment(0x1000000);
        column4.setText(TextEditorTemplateMessages.TemplatePreferencePage_column_autoinsert);
        minWidth = this.computeMinimumColumnWidth(gc, TextEditorTemplateMessages.TemplatePreferencePage_column_autoinsert);
        minWidth = Math.max(minWidth, this.computeMinimumColumnWidth(gc, TextEditorTemplateMessages.TemplatePreferencePage_on));
        columnLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(minWidth, false, false));
        gc.dispose();
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof TemplatePersistenceData && object2 instanceof TemplatePersistenceData) {
                    Template left = ((TemplatePersistenceData)object1).getTemplate();
                    Template right = ((TemplatePersistenceData)object2).getTemplate();
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return left.getDescription().compareToIgnoreCase(right.getDescription());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                TemplatePreferencePage.this.edit();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TemplatePreferencePage.this.selectionChanged1();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TemplatePersistenceData d = (TemplatePersistenceData)event.getElement();
                d.setEnabled(event.getChecked());
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText(TextEditorTemplateMessages.TemplatePreferencePage_new);
        this.fAddButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fAddButton));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(TextEditorTemplateMessages.TemplatePreferencePage_edit);
        this.fEditButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fEditButton));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.edit();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText(TextEditorTemplateMessages.TemplatePreferencePage_remove);
        this.fRemoveButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fRemoveButton));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.remove();
            }
        });
        this.createSeparator(buttons);
        this.fRestoreButton = new Button(buttons, 8);
        this.fRestoreButton.setText(TextEditorTemplateMessages.TemplatePreferencePage_restore);
        this.fRestoreButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fRestoreButton));
        this.fRestoreButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.restoreDeleted();
            }
        });
        this.fRevertButton = new Button(buttons, 8);
        this.fRevertButton.setText(TextEditorTemplateMessages.TemplatePreferencePage_revert);
        this.fRevertButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fRevertButton));
        this.fRevertButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.revert();
            }
        });
        this.createSeparator(buttons);
        this.fImportButton = new Button(buttons, 8);
        this.fImportButton.setText(TextEditorTemplateMessages.TemplatePreferencePage_import);
        this.fImportButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fImportButton));
        this.fImportButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.import_();
            }
        });
        this.fExportButton = new Button(buttons, 8);
        this.fExportButton.setText(TextEditorTemplateMessages.TemplatePreferencePage_export);
        this.fExportButton.setLayoutData((Object)TemplatePreferencePage.getButtonGridData(this.fExportButton));
        this.fExportButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TemplatePreferencePage.this.export();
            }
        });
        this.fPatternViewer = this.doCreateViewer(parent);
        if (this.isShowFormatterSetting()) {
            this.fFormatButton = new Button(parent, 32);
            this.fFormatButton.setText(TextEditorTemplateMessages.TemplatePreferencePage_use_code_formatter);
            GridData gd1 = new GridData();
            gd1.horizontalSpan = 2;
            this.fFormatButton.setLayoutData((Object)gd1);
            this.fFormatButton.setSelection(this.getPreferenceStore().getBoolean(this.getFormatterPreferenceKey()));
        }
        this.fTableViewer.setInput((Object)this.fTemplateStore);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
        this.updateButtons();
        Dialog.applyDialogFont((Control)parent);
        innerParent.layout();
        return parent;
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    protected boolean isShowFormatterSetting() {
        return true;
    }

    private TemplatePersistenceData[] getEnabledTemplates() {
        ArrayList<TemplatePersistenceData> enabled = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] datas = this.fTemplateStore.getTemplateData(false);
        int i = 0;
        while (i < datas.length) {
            if (datas[i].isEnabled()) {
                enabled.add(datas[i]);
            }
            ++i;
        }
        return enabled.toArray(new TemplatePersistenceData[enabled.size()]);
    }

    private SourceViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TextEditorTemplateMessages.TemplatePreferencePage_preview);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(false);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration();
        viewer.configure(configuration);
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        return data;
    }

    private void selectionChanged1() {
        this.updateViewerInput();
        this.updateButtons();
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
            Template template = data.getTemplate();
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        boolean canRestore = this.fTemplateStore.getTemplateData(true).length != this.fTemplateStore.getTemplateData(false).length;
        boolean canRevert = false;
        for (TemplatePersistenceData data : selection) {
            if (!data.isModified()) continue;
            canRevert = true;
            break;
        }
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fExportButton.setEnabled(selectionCount > 0);
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount);
        this.fRestoreButton.setEnabled(canRestore);
        this.fRevertButton.setEnabled(canRevert);
    }

    private void add() {
        Template template;
        Template newTemplate;
        Iterator it = this.fContextTypeRegistry.contextTypes();
        if (it.hasNext() && (newTemplate = this.editTemplate(template = new Template("", "", ((TemplateContextType)it.next()).getId(), "", true), false, true)) != null) {
            TemplatePersistenceData data = new TemplatePersistenceData(newTemplate, true);
            this.fTemplateStore.add(data);
            this.fTableViewer.refresh();
            this.fTableViewer.setChecked((Object)data, true);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)data));
        }
    }

    protected Dialog createTemplateEditDialog(Template template, boolean edit, boolean isNameModifiable) {
        return new EditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.fContextTypeRegistry);
    }

    protected Template editTemplate(Template template, boolean edit, boolean isNameModifiable) {
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.fContextTypeRegistry);
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        TemplatePersistenceData data = (TemplatePersistenceData)selection.getFirstElement();
        this.edit(data);
    }

    private void edit(TemplatePersistenceData data) {
        Template oldTemplate = data.getTemplate();
        Template newTemplate = this.editTemplate(new Template(oldTemplate), true, true);
        if (newTemplate != null) {
            if (!newTemplate.getName().equals(oldTemplate.getName()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)TextEditorTemplateMessages.TemplatePreferencePage_question_create_new_title, (String)TextEditorTemplateMessages.TemplatePreferencePage_question_create_new_message)) {
                data = new TemplatePersistenceData(newTemplate, true);
                this.fTemplateStore.add(data);
                this.fTableViewer.refresh();
            } else {
                data.setTemplate(newTemplate);
                this.fTableViewer.refresh((Object)data);
            }
            this.selectionChanged1();
            this.fTableViewer.setChecked((Object)data, data.isEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)data));
        }
    }

    private void import_() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(TextEditorTemplateMessages.TemplatePreferencePage_import_title);
        dialog.setFilterExtensions(new String[]{TextEditorTemplateMessages.TemplatePreferencePage_import_extension});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(path));
        try {
            TemplateReaderWriter reader = new TemplateReaderWriter();
            if (fileStore.fetchInfo().exists()) {
                BufferedInputStream input = new BufferedInputStream(fileStore.openInputStream(0, null));
                try {
                    TemplatePersistenceData[] datas = reader.read((InputStream)input, null);
                    int i = 0;
                    while (i < datas.length) {
                        TemplatePersistenceData data = datas[i];
                        this.fTemplateStore.add(data);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
            this.fTableViewer.refresh();
            this.fTableViewer.setAllChecked(false);
            this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
        }
        catch (CoreException coreException) {
            this.openReadErrorDialog();
        }
        catch (IOException iOException) {
            this.openReadErrorDialog();
        }
    }

    private void export() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] templates = selection.toArray();
        TemplatePersistenceData[] datas = new TemplatePersistenceData[templates.length];
        int i = 0;
        while (i != templates.length) {
            datas[i] = (TemplatePersistenceData)templates[i];
            ++i;
        }
        this.export(datas);
    }

    private void export(TemplatePersistenceData[] templates) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(TextEditorTemplateMessages.TemplatePreferencePage_export_title);
        dialog.setFilterExtensions(new String[]{TextEditorTemplateMessages.TemplatePreferencePage_export_extension});
        dialog.setFileName(TextEditorTemplateMessages.TemplatePreferencePage_export_filename);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(path));
        IFileInfo fileInfo = fileStore.fetchInfo();
        if (fileInfo.getAttribute(16)) {
            String title = TextEditorTemplateMessages.TemplatePreferencePage_export_error_title;
            String message = NLSUtility.format(TextEditorTemplateMessages.TemplatePreferencePage_export_error_hidden, fileStore.toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (fileInfo.exists() && fileInfo.getAttribute(2)) {
            String title = TextEditorTemplateMessages.TemplatePreferencePage_export_error_title;
            String message = NLSUtility.format(TextEditorTemplateMessages.TemplatePreferencePage_export_error_canNotWrite, fileStore.toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (!fileInfo.exists() || this.confirmOverwrite(fileStore)) {
            OutputStream output = null;
            try {
                try {
                    output = new BufferedOutputStream(fileStore.openOutputStream(0, null));
                    TemplateReaderWriter writer = new TemplateReaderWriter();
                    writer.save(templates, output);
                }
                catch (CoreException coreException) {
                    this.openWriteErrorDialog();
                }
                catch (IOException iOException) {
                    this.openWriteErrorDialog();
                }
            }
            catch (Throwable throwable) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean confirmOverwrite(IFileStore fileStore) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)TextEditorTemplateMessages.TemplatePreferencePage_export_exists_title, (String)NLSUtility.format(TextEditorTemplateMessages.TemplatePreferencePage_export_exists_message, fileStore.toString()));
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        for (TemplatePersistenceData data : selection) {
            this.fTemplateStore.delete(data);
        }
        this.fTableViewer.refresh();
    }

    private void restoreDeleted() {
        this.fTemplateStore.restoreDeleted();
        this.fTableViewer.refresh();
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
        this.updateButtons();
    }

    private void revert() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        for (TemplatePersistenceData data : selection) {
            data.revert();
        }
        this.fTableViewer.refresh();
        this.selectionChanged1();
        this.fTableViewer.setChecked((Object)this.getEnabledTemplates(), true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(TextEditorTemplateMessages.TemplatePreferencePage_title);
        }
    }

    protected void performDefaults() {
        if (this.isShowFormatterSetting()) {
            IPreferenceStore prefs = this.getPreferenceStore();
            this.fFormatButton.setSelection(prefs.getDefaultBoolean(this.getFormatterPreferenceKey()));
        }
        this.fTemplateStore.restoreDefaults();
        this.fTableViewer.refresh();
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements((Object[])this.getEnabledTemplates());
    }

    public boolean performOk() {
        if (this.isShowFormatterSetting()) {
            IPreferenceStore prefs = this.getPreferenceStore();
            prefs.setValue(this.getFormatterPreferenceKey(), this.fFormatButton.getSelection());
        }
        try {
            this.fTemplateStore.save();
        }
        catch (IOException iOException) {
            this.openWriteErrorDialog();
        }
        return super.performOk();
    }

    protected String getFormatterPreferenceKey() {
        return DEFAULT_FORMATTER_PREFERENCE_KEY;
    }

    public boolean performCancel() {
        try {
            this.fTemplateStore.load();
        }
        catch (IOException iOException) {
            this.openReadErrorDialog();
            return false;
        }
        return super.performCancel();
    }

    private void openReadErrorDialog() {
        String title = TextEditorTemplateMessages.TemplatePreferencePage_error_read_title;
        String message = TextEditorTemplateMessages.TemplatePreferencePage_error_read_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openWriteErrorDialog() {
        String title = TextEditorTemplateMessages.TemplatePreferencePage_error_write_title;
        String message = TextEditorTemplateMessages.TemplatePreferencePage_error_write_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    protected SourceViewer getViewer() {
        return this.fPatternViewer;
    }

    protected TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    private class TemplateLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TemplateLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            Template template = data.getTemplate();
            switch (columnIndex) {
                case 0: {
                    return template.getName();
                }
                case 1: {
                    TemplateContextType type = TemplatePreferencePage.this.fContextTypeRegistry.getContextType(template.getContextTypeId());
                    if (type != null) {
                        return type.getName();
                    }
                    return template.getContextTypeId();
                }
                case 2: {
                    return template.getDescription();
                }
                case 3: {
                    return template.isAutoInsertable() ? TextEditorTemplateMessages.TemplatePreferencePage_on : "";
                }
            }
            return "";
        }
    }
}

