/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.help.internal.FilterableUAElement;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.context.Contexts;
import org.eclipse.help.internal.context.ContextsBuilder;
import org.eclipse.help.internal.context.ContextsFile;
import org.eclipse.help.internal.context.ContextsNode;
import org.eclipse.help.internal.context.RelatedTopic;
import org.eclipse.help.internal.util.FastStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ContextsFileParser
extends DefaultHandler {
    protected FastStack stack = new FastStack();
    StringBuffer buffer = new StringBuffer();
    boolean seenDescription = false;
    ContextsFile contextsFile;
    private ContextsBuilder builder;
    private static final SAXParserFactory factory = SAXParserFactory.newInstance();

    public ContextsFileParser(ContextsBuilder builder) {
        this.builder = builder;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.seenDescription) {
            this.buffer.append(ch, start, length);
        }
        if (HelpPlugin.DEBUG_CONTEXT) {
            System.out.println("ContextsFileParser.characters(): got char from parser= " + new StringBuffer().append(ch, start, length).toString());
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("description")) {
            this.seenDescription = false;
            ((Context)this.stack.peek()).setStyledText(this.buffer.toString());
            this.buffer.setLength(0);
        } else if (qName.equals("b")) {
            this.stack.pop();
            if (!this.stack.peek().equals("<@#$b>")) {
                this.buffer.append("</@#$b>");
            }
        } else if (!qName.equals("filter")) {
            ContextsNode node = (ContextsNode)this.stack.pop();
            node.build(this.builder);
        }
    }

    public void error(SAXParseException ex) {
        HelpPlugin.logError("Error parsing " + this.getErrorDetails(ex), null);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        HelpPlugin.logError("Failed to parse " + this.getErrorDetails(ex), ex);
    }

    public String getErrorDetails(SAXParseException ex) {
        String param0 = ex.getSystemId();
        Integer param1 = new Integer(ex.getLineNumber());
        Integer param2 = new Integer(ex.getColumnNumber());
        String param3 = ex.getMessage();
        String message = MessageFormat.format((String)"URL: {0} at line: {1,number,integer}, column: {2,number,integer}.\r\n{3}", (Object[])new Object[]{param0, param1, param2, param3});
        return message;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("description")) {
            this.seenDescription = true;
        } else if (qName.equals("b")) {
            if (!this.stack.peek().equals("<@#$b>")) {
                this.buffer.append("<@#$b>");
            }
            this.stack.push("<@#$b>");
        } else {
            ContextsNode e = null;
            if (qName.equals("contexts")) {
                e = new Contexts(atts);
            } else if (qName.equals("context")) {
                e = new Context(atts);
            } else if (qName.equals("topic")) {
                e = new RelatedTopic(atts);
            } else {
                if (qName.equals("filter")) {
                    Object parent;
                    if (!this.stack.empty() && (parent = this.stack.peek()) instanceof FilterableUAElement && atts != null) {
                        FilterableUAElement filterableNode = (FilterableUAElement)parent;
                        String name = atts.getValue("name");
                        String value = atts.getValue("value");
                        if (name != null && value != null) {
                            filterableNode.addFilter(name, value);
                        }
                    }
                    return;
                }
                return;
            }
            if (!this.stack.empty()) {
                ((ContextsNode)this.stack.peek()).addChild(e);
            }
            this.stack.push(e);
        }
    }

    public void warning(SAXParseException ex) {
        HelpPlugin.logWarning("Warning parsing " + this.getErrorDetails(ex));
    }

    public void parse(ContextsFile contextsFile) {
        this.contextsFile = contextsFile;
        InputStream is = contextsFile.getInputStream();
        if (is == null) {
            return;
        }
        InputSource inputSource = new InputSource(is);
        String file = "/" + contextsFile.getDefiningPluginID() + "/" + contextsFile.getHref();
        inputSource.setSystemId(file);
        try {
            try {
                SAXParser parser = factory.newSAXParser();
                parser.parse(inputSource, (DefaultHandler)this);
            }
            catch (ParserConfigurationException pce) {
                HelpPlugin.logError("SAXParser implementation could not be loaded.", pce);
            }
            catch (SAXException se) {
                HelpPlugin.logError("", se);
            }
            catch (IOException ioe) {
                HelpPlugin.logError("Error loading file " + file + ".", ioe);
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource source = new InputSource(new ByteArrayInputStream(new byte[0]));
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }
}

