/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.jarprocessor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.eclipse.update.internal.jarprocessor.CommandStep;
import org.eclipse.update.internal.jarprocessor.Utils;

public class SignCommandStep
extends CommandStep {
    private Set exclusions = null;

    public SignCommandStep(Properties options, String command) {
        super(options, command, ".jar", false);
        this.exclusions = Utils.getSignExclusions(options);
    }

    public SignCommandStep(Properties options, String command, boolean verbose) {
        super(options, command, ".jar", verbose);
        this.exclusions = Utils.getSignExclusions(options);
    }

    public String recursionEffect(String entryName) {
        if (entryName.endsWith(this.extension) && !this.exclusions.contains(entryName)) {
            return entryName;
        }
        return null;
    }

    public File preProcess(File input, File workingDirectory) {
        return null;
    }

    public File postProcess(File input, File workingDirectory) {
        block5: {
            if (this.command != null) {
                try {
                    String[] cmd = new String[]{this.command, input.getCanonicalPath()};
                    int result = SignCommandStep.execute(cmd, this.verbose);
                    if (result == 0) {
                        this.normalize(input, workingDirectory);
                        return input;
                    }
                    if (this.verbose) {
                        System.out.println("Error: " + result + " was returned from command: " + Utils.concat(cmd));
                    }
                }
                catch (IOException e) {
                    if (!this.verbose) break block5;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void normalize(File input, File workingDirectory) {
        block7: {
            try {
                File tempJar = new File(workingDirectory, "temp_" + input.getName());
                JarFile jar = new JarFile(input, false);
                JarOutputStream jarOut = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(tempJar)));
                BufferedInputStream in = null;
                try {
                    Enumeration<JarEntry> entries = jar.entries();
                    JarEntry entry = entries.nextElement();
                    while (entry != null) {
                        JarEntry newEntry = new JarEntry(entry.getName());
                        newEntry.setTime(entry.getTime());
                        in = new BufferedInputStream(jar.getInputStream(entry));
                        jarOut.putNextEntry(newEntry);
                        Utils.transferStreams(in, jarOut, false);
                        jarOut.closeEntry();
                        ((InputStream)in).close();
                        JarEntry jarEntry = entry = entries.hasMoreElements() ? entries.nextElement() : null;
                    }
                }
                finally {
                    Utils.close(jarOut);
                    Utils.close(jar);
                    Utils.close(in);
                }
                tempJar.setLastModified(input.lastModified());
                input.delete();
                tempJar.renameTo(input);
            }
            catch (IOException e) {
                if (!this.verbose) break block7;
                System.out.println("Error normalizing jar " + input.getName());
                e.printStackTrace();
            }
        }
    }

    public String getStepName() {
        return "Sign";
    }
}

