/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.JarEntryContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;

public class JarContentReference
extends ContentReference {
    private static ArrayList referenceList = new ArrayList();
    private JarFile jarFile = null;

    public JarContentReference(String id, URL url) {
        super(id, url);
        referenceList.add(this);
    }

    public JarContentReference(String id, File file) {
        super(id, file);
        referenceList.add(this);
    }

    public ContentReference createContentReference(String id, File file) {
        return new JarContentReference(id, file, true);
    }

    public JarContentReference(String id, File file, boolean b) {
        this(id, file);
        this.setTempLocal(b);
    }

    protected JarFile asJarFile() throws IOException {
        if (this.jarFile == null) {
            File file = this.asFile();
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                UpdateCore.debug("asJarFile :" + file);
            }
            if (file != null && !file.exists()) {
                UpdateCore.warn("JarFile does not exits:" + file);
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            this.jarFile = new JarFile(file);
        }
        return this.jarFile;
    }

    public ContentReference[] unpack(File dir, ContentSelector selector, InstallMonitor monitor) throws IOException, InstallAbortedException {
        if (selector == null) {
            selector = new ContentSelector();
        }
        JarFile jarArchive = this.asJarFile();
        ArrayList<ContentReference> content = new ArrayList<ContentReference>();
        Enumeration<JarEntry> entries = jarArchive.entries();
        try {
            if (monitor != null) {
                monitor.saveState();
                monitor.setTaskName(Messages.JarContentReference_Unpacking);
                monitor.subTask(this.getIdentifier());
                monitor.showCopyDetails(false);
            }
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry == null || !selector.include(entry)) continue;
                InputStream is = null;
                FileOutputStream os = null;
                String entryId = selector.defineIdentifier(entry);
                File localFile = Utilities.createLocalFile(dir, entryId);
                if (entry.isDirectory()) continue;
                try {
                    is = jarArchive.getInputStream(entry);
                    os = new FileOutputStream(localFile);
                    Utilities.copy(is, os, monitor);
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException) {}
                }
                content.add(new ContentReference(entryId, localFile));
            }
        }
        finally {
            if (monitor != null) {
                monitor.restoreState();
            }
        }
        return content.toArray(new ContentReference[0]);
    }

    public ContentReference unpack(File dir, String entryName, ContentSelector selector, InstallMonitor monitor) throws IOException, InstallAbortedException {
        JarFile jarArchive;
        JarEntry entry;
        if (selector == null) {
            selector = new ContentSelector();
        }
        if ((entry = (jarArchive = this.asJarFile()).getJarEntry(entryName = entryName.replace(File.separatorChar, '/'))) != null) {
            InputStream is = null;
            FileOutputStream os = null;
            String entryId = selector.defineIdentifier(entry);
            File localFile = Utilities.createLocalFile(dir, entryId);
            if (!entry.isDirectory()) {
                try {
                    is = jarArchive.getInputStream(entry);
                    os = new FileOutputStream(localFile);
                    Utilities.copy(is, os, monitor);
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException iOException) {}
                }
                return new ContentReference(entryId, localFile);
            }
            return null;
        }
        throw new FileNotFoundException(String.valueOf(this.asFile().getAbsolutePath()) + " " + entryName);
    }

    public ContentReference[] peek(ContentSelector selector, InstallMonitor monitor) throws IOException {
        if (selector == null) {
            selector = new ContentSelector();
        }
        JarFile jarArchive = this.asJarFile();
        ArrayList<JarEntryContentReference> content = new ArrayList<JarEntryContentReference>();
        Enumeration<JarEntry> entries = jarArchive.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!selector.include(entry)) continue;
            String entryId = selector.defineIdentifier(entry);
            content.add(new JarEntryContentReference(entryId, this, entry));
        }
        return content.toArray(new ContentReference[0]);
    }

    public ContentReference peek(String entryName, ContentSelector selector, InstallMonitor monitor) throws IOException {
        JarFile jarArchive;
        JarEntry entry;
        if (selector == null) {
            selector = new ContentSelector();
        }
        if ((entry = (jarArchive = this.asJarFile()).getJarEntry(entryName = entryName.replace(File.separatorChar, '/'))) == null) {
            return null;
        }
        String entryId = selector.defineIdentifier(entry);
        return new JarEntryContentReference(entryId, this, entry);
    }

    public void closeArchive() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
            this.jarFile = null;
        }
    }

    public static void shutdown() {
        int i = 0;
        while (i < referenceList.size()) {
            JarContentReference ref = (JarContentReference)referenceList.get(i);
            try {
                ref.closeArchive();
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    public static class ContentSelector {
        public boolean include(JarEntry entry) {
            return entry == null ? false : !entry.isDirectory();
        }

        public String defineIdentifier(JarEntry entry) {
            return entry == null ? null : entry.getName();
        }
    }
}

