/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.util.ArtifactType;

public class EntryType {
    private ArtifactType artifactType;
    private String typeName;
    protected static final TreeMap entryTypeMap = new TreeMap();
    protected static final TreeMap entryTypeNameMap = new TreeMap();
    public static final String TYPE_ENVELOPE_REQUEST = "requestEnvelope";
    public static final String TYPE_ENVELOPE_RESPONSE = "responseEnvelope";
    public static final String TYPE_ENVELOPE_ANY = "anyEnvelope";
    public static final String TYPE_MESSAGE_REQUEST = "requestMessage";
    public static final String TYPE_MESSAGE_RESPONSE = "responseMessage";
    public static final String TYPE_MESSAGE_ANY = "anyMessage";
    public static final String TYPE_MIME_PART = "part";
    public static final String TYPE_MIME_ROOT_PART = "root-part";
    public static final String TYPE_DESCRIPTION_DEFINITIONS = "definitions";
    public static final String TYPE_DESCRIPTION_IMPORT = "import";
    public static final String TYPE_DESCRIPTION_TYPES = "types";
    public static final String TYPE_DESCRIPTION_MESSAGE = "message";
    public static final String TYPE_DESCRIPTION_OPERATION = "operation";
    public static final String TYPE_DESCRIPTION_PORTTYPE = "portType";
    public static final String TYPE_DESCRIPTION_BINDING = "binding";
    public static final String TYPE_DESCRIPTION_PORT = "port";
    public static final String TYPE_DISCOVERY_BINDINGTEMPLATE = "bindingTemplate";
    public static final String TYPE_DISCOVERY_TMODEL = "tModel";
    public static final EntryType ENTRY_TYPE_REQUESTENV;
    public static final EntryType ENTRY_TYPE_RESPONSEENV;
    public static final EntryType ENTRY_TYPE_REQUEST;
    public static final EntryType ENTRY_TYPE_RESPONSE;
    public static final EntryType ENTRY_TYPE_DEFINITIONS;
    public static final EntryType ENTRY_TYPE_IMPORT;
    public static final EntryType ENTRY_TYPE_TYPES;
    public static final EntryType ENTRY_TYPE_MESSAGE;
    public static final EntryType ENTRY_TYPE_OPERATION;
    public static final EntryType ENTRY_TYPE_PORTTYPE;
    public static final EntryType ENTRY_TYPE_BINDING;
    public static final EntryType ENTRY_TYPE_PORT;
    public static final EntryType ENTRY_TYPE_BINDINGTEMPLATE;
    public static final EntryType ENTRY_TYPE_TMODEL;

    static {
        entryTypeNameMap.put("envelope", new Vector());
        entryTypeNameMap.put(TYPE_DESCRIPTION_MESSAGE, new Vector());
        entryTypeNameMap.put("description", new Vector());
        entryTypeNameMap.put("discovery", new Vector());
        ENTRY_TYPE_REQUESTENV = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_ENVELOPE, TYPE_ENVELOPE_REQUEST);
        ENTRY_TYPE_RESPONSEENV = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_ENVELOPE, TYPE_ENVELOPE_RESPONSE);
        ENTRY_TYPE_REQUEST = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_MESSAGE, TYPE_MESSAGE_REQUEST);
        ENTRY_TYPE_RESPONSE = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_MESSAGE, TYPE_MESSAGE_RESPONSE);
        ENTRY_TYPE_DEFINITIONS = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DESCRIPTION, TYPE_DESCRIPTION_DEFINITIONS);
        ENTRY_TYPE_IMPORT = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DESCRIPTION, TYPE_DESCRIPTION_IMPORT);
        ENTRY_TYPE_TYPES = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DESCRIPTION, TYPE_DESCRIPTION_TYPES);
        ENTRY_TYPE_MESSAGE = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DESCRIPTION, TYPE_DESCRIPTION_MESSAGE);
        ENTRY_TYPE_OPERATION = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DESCRIPTION, TYPE_DESCRIPTION_OPERATION);
        ENTRY_TYPE_PORTTYPE = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DESCRIPTION, TYPE_DESCRIPTION_PORTTYPE);
        ENTRY_TYPE_BINDING = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DESCRIPTION, TYPE_DESCRIPTION_BINDING);
        ENTRY_TYPE_PORT = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DESCRIPTION, TYPE_DESCRIPTION_PORT);
        ENTRY_TYPE_BINDINGTEMPLATE = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DISCOVERY, TYPE_DISCOVERY_BINDINGTEMPLATE);
        ENTRY_TYPE_TMODEL = EntryType.newEntryType(ArtifactType.ARTIFACT_TYPE_DISCOVERY, TYPE_DISCOVERY_TMODEL);
    }

    private EntryType(ArtifactType artifactType, String typeName) {
        this.artifactType = artifactType;
        this.typeName = typeName;
    }

    public boolean isType(String typeName) {
        return this.typeName.equals(typeName);
    }

    public boolean isType(EntryType entryType) {
        return this.typeName.equals(entryType.getTypeName());
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static final boolean isValidEntryType(String typeName) {
        return entryTypeMap.get(typeName) != null;
    }

    public static final EntryType getEntryType(String typeName) throws RuntimeException {
        EntryType entryType = (EntryType)entryTypeMap.get(typeName);
        if (entryType == null) {
            throw new RuntimeException("Could not get entry type because type name is invalid: " + typeName + ".");
        }
        return entryType;
    }

    public static final Vector getEntryTypeNameList(String artifactTypeName) throws RuntimeException {
        Vector entryTypeNameList = (Vector)entryTypeNameMap.get(artifactTypeName);
        if (entryTypeNameList == null) {
            throw new RuntimeException("Could not get entry type name list because artifact type name is invalid: " + artifactTypeName + ".");
        }
        return entryTypeNameList;
    }

    private static final EntryType newEntryType(ArtifactType artifactType, String typeName) {
        EntryType entryType = null;
        entryType = new EntryType(artifactType, typeName);
        entryTypeMap.put(typeName, entryType);
        Vector entryTypeNameList = (Vector)entryTypeNameMap.get(artifactType.getTypeName());
        entryTypeNameList.add(typeName);
        return entryType;
    }
}

