/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Description;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11EditNamespacesCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDEditNamespacesAction;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.model.AbstractModelCollection;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.INamedObject;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ICategoryAdapter;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.ASDAbstractSection;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonEditNamespacesTargetFieldDialog;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonNamespaceInfoTable;

public class NamespaceSection
extends ASDAbstractSection {
    protected String targetNamespace;
    protected List namespaceInfoList;
    protected CommonEditNamespacesTargetFieldDialog editWSDLNamespacesControl;
    protected Button button;
    Text nameText;
    Text prefixText;
    Text targetNamespaceText;
    protected CommonNamespaceInfoTable tableViewer;
    private boolean handlingEvent;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        String nameString = String.valueOf(Messages.getString("_UI_LABEL_NAME")) + ":";
        String prefixString = String.valueOf(Messages.getString("_UI_LABEL_PREFIX")) + ":";
        String namespaceString = Messages.getString("_UI_LABEL_TARGET_NAMESPACE");
        GC gc = new GC((Drawable)parent);
        int xoffset = Math.max(115, gc.textExtent((String)nameString).x + 20);
        xoffset = Math.max(xoffset, gc.textExtent((String)prefixString).x + 20);
        xoffset = Math.max(xoffset, gc.textExtent((String)namespaceString).x + 20);
        gc.dispose();
        CLabel nameLabel = this.getWidgetFactory().createCLabel(this.composite, nameString);
        this.nameText = this.getWidgetFactory().createText(this.composite, "");
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(this.composite, prefixString);
        this.prefixText = this.getWidgetFactory().createText(this.composite, "");
        CLabel targetNamespaceLabel = this.getWidgetFactory().createCLabel(this.composite, namespaceString);
        this.targetNamespaceText = this.getWidgetFactory().createText(this.composite, "");
        this.button = this.getWidgetFactory().createButton(this.composite, String.valueOf(Messages.getString("_UI_SECTION_ADVANCED_ATTRIBUTES")) + "...", 8);
        FormData dataNameLabel = new FormData();
        dataNameLabel.top = new FormAttachment((Control)this.nameText, 0, 0x1000000);
        nameLabel.setLayoutData((Object)dataNameLabel);
        FormData dataPrefixLabel = new FormData();
        dataPrefixLabel.left = new FormAttachment(0, 0);
        dataPrefixLabel.top = new FormAttachment((Control)this.prefixText, 0, 0x1000000);
        prefixLabel.setLayoutData((Object)dataPrefixLabel);
        FormData datatnsLabel = new FormData();
        datatnsLabel.left = new FormAttachment(0, 0);
        datatnsLabel.right = new FormAttachment((Control)this.targetNamespaceText, 0);
        datatnsLabel.top = new FormAttachment((Control)this.targetNamespaceText, 0, 0x1000000);
        targetNamespaceLabel.setLayoutData((Object)datatnsLabel);
        FormData dataNameText = new FormData();
        dataNameText.left = new FormAttachment(0, xoffset);
        dataNameText.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        dataNameText.top = new FormAttachment(0, 0);
        this.nameText.setLayoutData((Object)dataNameText);
        this.nameText.addListener(24, (Listener)this);
        FormData dataPrefixText = new FormData();
        dataPrefixText.left = new FormAttachment(0, xoffset);
        dataPrefixText.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        dataPrefixText.top = new FormAttachment((Control)this.nameText, 4);
        this.prefixText.setLayoutData((Object)dataPrefixText);
        this.prefixText.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, xoffset);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.prefixText, 4);
        this.targetNamespaceText.setLayoutData((Object)data);
        this.targetNamespaceText.addListener(24, (Listener)this);
        FormData dataButton = new FormData();
        dataButton.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        dataButton.top = new FormAttachment((Control)this.targetNamespaceText, 4);
        this.button.setLayoutData((Object)dataButton);
        this.button.addSelectionListener((SelectionListener)this);
    }

    public void doHandleEvent(Event event) {
        this.handlingEvent = true;
        Object obj = this.getDescription();
        if (obj instanceof IDescription) {
            IDescription description = (IDescription)obj;
            if (event.widget == this.nameText) {
                Command command = description.getSetNameCommand(this.nameText.getText());
                this.executeCommand(command);
            } else if (event.widget == this.prefixText || event.widget == this.targetNamespaceText) {
                W11EditNamespacesCommand command = (W11EditNamespacesCommand)((W11Description)description).getEditNamespacesCommand();
                command.setTargetNamespace(this.targetNamespaceText.getText());
                command.setTargetNamespacePrefix(this.prefixText.getText());
                this.executeCommand(command);
            }
        }
        this.handlingEvent = false;
    }

    protected Object getDescription() {
        Object model = this.getModel();
        if (model instanceof AbstractModelCollection) {
            if ((model = ((AbstractModelCollection)model).getModel()) instanceof IDescription) {
                return (IDescription)model;
            }
        } else if (model instanceof ICategoryAdapter) {
            return ((ICategoryAdapter)model).getOwnerDescription();
        }
        return model;
    }

    public void refresh() {
        super.refresh();
        if (this.nameText == null || this.nameText.isFocusControl()) {
            return;
        }
        this.setListenerEnabled(false);
        this.nameText.setText("");
        if (this.getDescription() instanceof INamedObject) {
            this.nameText.setText(((INamedObject)this.getDescription()).getName());
        }
        this.setListenerEnabled(true);
        if (this.targetNamespaceText == null || this.targetNamespaceText.isFocusControl() || this.handlingEvent) {
            return;
        }
        this.setListenerEnabled(false);
        Object obj = this.getDescription();
        if (obj instanceof IDescription) {
            IDescription description = (IDescription)obj;
            String targetNS = description.getTargetNamespace();
            String newPrefix = description.getTargetNamespacePrefix();
            this.prefixText.setText(newPrefix != null ? newPrefix : "");
            if (targetNS != null) {
                this.targetNamespaceText.setText(targetNS);
            } else {
                this.targetNamespaceText.setText("");
            }
            if (newPrefix != null) {
                this.prefixText.setText(newPrefix);
            }
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj;
        if (e.widget == this.button && (obj = this.getDescription()) instanceof IDescription) {
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            ASDEditNamespacesAction action = new ASDEditNamespacesAction(part, (IDescription)obj);
            action.run();
            this.refresh();
        }
    }
}

