/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.wst.rdb.connection.internal.ui.util.TString;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;

public abstract class RDBWizardPage
extends WizardPage {
    protected static final int SIZING_TEXT_FIELD_WIDTH = 150;
    protected static final int COMBO_HISTORY_LENGTH = 5;
    protected static ResourceBundle bundle;
    protected IWizardPage nextPage = null;

    protected RDBWizardPage(String pageName) {
        super(pageName);
    }

    protected abstract boolean determinePageCompletion();

    public void setNextPage(IWizardPage page) {
        this.nextPage = page;
    }

    public IWizardPage getNextPage() {
        if (this.nextPage != null) {
            return this.nextPage;
        }
        return super.getNextPage();
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        if (history == null) {
            history = new String[]{};
        }
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 5) {
            history.remove(5);
        }
    }

    protected void loadComboSettings(Combo combo, String[] values, boolean set) {
        if (set) {
            combo.setText(values[0].trim());
        }
        int i = 0;
        while (i < values.length) {
            combo.add(values[i]);
            ++i;
        }
    }

    public static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceLoader.INSTANCE.getResourceBundle();
        }
        return bundle;
    }

    public String getString(String key) {
        return RDBWizardPage.getBundle().getString(key);
    }

    public String getString(String key, Object[] substitutions) {
        String str = RDBWizardPage.getBundle().getString(key);
        int s = 0;
        if (substitutions != null) {
            s = substitutions.length;
        }
        if (s > 0 && str.indexOf("%1") > -1) {
            str = TString.change(str, "%1", substitutions[0].toString());
        }
        if (s > 1 && str.indexOf("%2") > -1) {
            str = TString.change(str, "%2", substitutions[1].toString());
        }
        if (s > 2 && str.indexOf("%3") > -1) {
            str = TString.change(str, "%3", substitutions[2].toString());
        }
        return str;
    }

    public void setErrorMessage(String newMessage) {
        String oldMessage = this.getErrorMessage();
        if (newMessage == null && oldMessage != null || newMessage != null && oldMessage == null || newMessage != null && !newMessage.equals(oldMessage) || oldMessage != null && !oldMessage.equals(newMessage)) {
            super.setErrorMessage(newMessage);
        }
    }
}

