/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XSDDOMHelper {
    private static String XMLSchemaURI = "http://www.w3.org/2001/XMLSchema";

    public Node getChildNode(Element parent, String childName) {
        NodeList list = null;
        if (parent != null) {
            list = parent.getChildNodes();
        }
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                if (list.item(i) instanceof Element && list.item(i).getLocalName().equals(childName)) {
                    return list.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public void changeDerivedByType(Element element, String derivedByType, String type) {
        Document doc = element.getOwnerDocument();
        String prefix = element.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element derivedByElement = this.getDerivedByElement(element);
        if (derivedByElement != null && derivedByElement.getLocalName().equals(derivedByType)) {
            return;
        }
        Element newNode = derivedByType.equals("restriction") ? doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + "restriction") : doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + "extension");
        newNode.setAttribute("base", type);
        if (derivedByElement != null) {
            if (derivedByElement.hasChildNodes()) {
                NodeList nodes = derivedByElement.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    Node node = nodes.item(i);
                    newNode.appendChild(node.cloneNode(true));
                    ++i;
                }
            }
            element.replaceChild(newNode, derivedByElement);
        } else {
            Node node;
            Element parent = (Element)element.getParentNode();
            NodeList nodes = parent.getChildNodes();
            ArrayList<Node> nodeSaveList = new ArrayList<Node>();
            int i = 0;
            while (i < nodes.getLength()) {
                node = nodes.item(i);
                nodeSaveList.add(node);
                ++i;
            }
            i = 0;
            while (i < nodeSaveList.size()) {
                node = (Node)nodeSaveList.get(i);
                parent.removeChild(node);
                ++i;
            }
            Element complexContent = doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + "complexContent");
            parent.appendChild(complexContent);
            complexContent.appendChild(newNode);
            int i2 = 0;
            while (i2 < nodeSaveList.size()) {
                Node node2 = (Node)nodeSaveList.get(i2);
                newNode.appendChild(node2.cloneNode(true));
                ++i2;
            }
            parent.appendChild(complexContent);
            XSDDOMHelper.formatChild(complexContent);
        }
    }

    public Element getDerivedByElement(Element element) {
        Node restrictionChild = this.getChildNode(element, "restriction");
        Node extensionChild = this.getChildNode(element, "extension");
        if (restrictionChild != null && restrictionChild instanceof Element) {
            return (Element)restrictionChild;
        }
        if (extensionChild != null && extensionChild instanceof Element) {
            return (Element)extensionChild;
        }
        return null;
    }

    public Element getDerivedByElementFromComplexType(Element element) {
        NodeList nl = element.getChildNodes();
        int j = 0;
        j = 0;
        while (j < nl.getLength()) {
            Node aNode = nl.item(j);
            if (XSDDOMHelper.inputEquals(aNode, "complexContent", false) || XSDDOMHelper.inputEquals(aNode, "simpleContent", false)) break;
            ++j;
        }
        Element derivedByNode = this.getDerivedByElement((Element)nl.item(j));
        return derivedByNode;
    }

    public Element getContentModelFromParent(Element element) {
        NodeList nl = element.getChildNodes();
        int j = 0;
        boolean modelExists = false;
        int length = nl.getLength();
        j = 0;
        while (j < length) {
            Node aNode = nl.item(j);
            if (XSDDOMHelper.inputEquals(aNode, "complexContent", false)) {
                modelExists = true;
                break;
            }
            if (XSDDOMHelper.inputEquals(aNode, "simpleContent", false)) {
                modelExists = true;
                break;
            }
            if (XSDDOMHelper.inputEquals(aNode, "sequence", false)) {
                modelExists = true;
                break;
            }
            if (XSDDOMHelper.inputEquals(aNode, "choice", false)) {
                modelExists = true;
                break;
            }
            if (XSDDOMHelper.inputEquals(aNode, "all", false)) {
                modelExists = true;
                break;
            }
            ++j;
        }
        if (!modelExists) {
            return null;
        }
        Element derivedByNode = (Element)nl.item(j);
        return derivedByNode;
    }

    public void changeContentModel(Element complexTypeElement, String contentModel, Element sequenceChoiceOrAllElement) {
        Document doc = complexTypeElement.getOwnerDocument();
        String prefix = complexTypeElement.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element contentModelElement = this.getContentModelFromParent(complexTypeElement);
        if (contentModelElement.getLocalName().equals(contentModel)) {
            return;
        }
        Element newNode = doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + contentModel);
        if (contentModelElement.hasChildNodes()) {
            NodeList nodes = contentModelElement.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    if (node.getLocalName().equals("annotation")) {
                        if (!(XSDDOMHelper.inputEquals(contentModelElement, "sequence", false) || XSDDOMHelper.inputEquals(contentModelElement, "choice", false) || XSDDOMHelper.inputEquals(contentModelElement, "all", false))) {
                            newNode.appendChild(node.cloneNode(true));
                        }
                    } else if (node.getLocalName().equals("restriction") || node.getLocalName().equals("extension")) {
                        newNode.appendChild(node.cloneNode(true));
                        if (sequenceChoiceOrAllElement != null) {
                            node.appendChild(sequenceChoiceOrAllElement);
                        }
                    } else {
                        XSDDOMHelper.removeNodeAndWhitespace(node);
                    }
                } else {
                    newNode.appendChild(node.cloneNode(true));
                }
                ++i;
            }
        }
        complexTypeElement.replaceChild(newNode, contentModelElement);
    }

    public Element cloneElement(Element parent, Element sourceNode) {
        Document doc = parent.getOwnerDocument();
        String prefix = parent.getPrefix();
        prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
        Element newNode = doc.createElementNS(XMLSchemaURI, String.valueOf(prefix) + sourceNode.getLocalName());
        if (sourceNode.hasChildNodes()) {
            NodeList nodes = sourceNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                newNode.appendChild(node.cloneNode(true));
                ++i;
            }
        }
        return newNode;
    }

    public static void removeNodeAndWhitespace(Node node) {
        Node parentNode = node.getParentNode();
        Node nextElement = XSDDOMHelper.getNextElementNode(node);
        Node previousElement = XSDDOMHelper.getPreviousElementNode(node);
        Node nextSibling = node.getNextSibling();
        if (nextSibling instanceof Text) {
            parentNode.removeChild(nextSibling);
        }
        if (parentNode != null) {
            parentNode.removeChild(node);
        }
        if (nextElement != null) {
            XSDDOMHelper.formatChild(nextElement);
        }
        if (previousElement != null) {
            XSDDOMHelper.formatChild(previousElement);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void formatChild(Node child) {
        if (!(child instanceof IDOMNode)) return;
        IDOMModel model = ((IDOMNode)child).getModel();
        try {
            model.aboutToChangeModel();
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode(child);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            model.changedModel();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        model.changedModel();
    }

    private static Node getNextElementNode(Node node) {
        Node next = node.getNextSibling();
        while (!(next instanceof Element) && next != null) {
            next = next.getNextSibling();
        }
        if (next instanceof Text) {
            return null;
        }
        return next;
    }

    private static Node getPreviousElementNode(Node node) {
        Node previous = node.getPreviousSibling();
        while (!(previous instanceof Element) && previous != null) {
            previous = previous.getPreviousSibling();
        }
        if (previous instanceof Text) {
            return null;
        }
        return previous;
    }

    public static boolean inputEquals(Object input, String tagname, boolean isRef) {
        Element element;
        if (input instanceof Element && (element = (Element)input).getLocalName().equals(tagname)) {
            boolean refPresent = element.hasAttribute("ref");
            return refPresent == isRef;
        }
        return false;
    }
}

