/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.ChangeToLocalSimpleTypeCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateNumericBoundsFacetCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateStringLengthFacetCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateXSDWhiteSpaceFacetCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.SpecificConstraintsWidget;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpace;
import org.eclipse.xsd.XSDWhiteSpaceFacet;

public class XSDFacetSection
extends AbstractSection {
    private String minLengthString;
    private String maxLengthString;
    private String titleString;
    Font titleFont;
    CLabel title;
    Label minLengthLabel;
    Text minLengthText;
    Label maxLengthLabel;
    Text maxLengthText;
    Group simpleTypeModifierGroup;
    String simpleTypeModifierGroupTitle = "";
    Button collapseWhitespaceButton;
    Button useEnumerationsButton;
    Button usePatternsButton;
    Button minimumInclusiveCheckbox;
    Button maximumInclusiveCheckbox;
    boolean isNumericBaseType;
    private XSDTypeDefinition typeDefinition;
    private XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
    private XSDElementDeclaration xsdElementDeclaration;
    private XSDAttributeDeclaration xsdAttributeDeclaration;
    private XSDFeature xsdFeature;
    boolean hasMaxMinFacets;
    SpecificConstraintsWidget constraintsWidget;
    static /* synthetic */ Class class$0;

    protected void createContents(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.composite = factory.createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 1;
        this.composite.setLayout((Layout)gridLayout);
        this.title = factory.createCLabel(this.composite, "");
        FontData fontData = this.composite.getFont().getFontData()[0];
        this.title.setFont(JFaceResources.getFontRegistry().getBold(fontData.getName()));
        this.title.setText(String.valueOf(this.titleString) + (this.isReadOnly ? " - " + Messages._UI_LABEL_READONLY : ""));
        Composite facetComposite = factory.createComposite(this.composite, 0x800000);
        GridData data = new GridData();
        gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 2;
        facetComposite.setLayout((Layout)gridLayout);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        facetComposite.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.simpleTypeModifierGroup = this.getWidgetFactory().createGroup(facetComposite, this.simpleTypeModifierGroupTitle);
        GridLayout groupGrid = new GridLayout();
        groupGrid.marginTop = 0;
        groupGrid.marginBottom = 0;
        groupGrid.numColumns = 1;
        this.simpleTypeModifierGroup.setLayoutData((Object)data);
        this.simpleTypeModifierGroup.setLayout((Layout)groupGrid);
        Composite simpleTypeModifierComposite = this.getWidgetFactory().createFlatFormComposite((Composite)this.simpleTypeModifierGroup);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        GridLayout grid = new GridLayout();
        grid.marginTop = 0;
        grid.marginBottom = 0;
        grid.numColumns = 3;
        simpleTypeModifierComposite.setLayout((Layout)grid);
        simpleTypeModifierComposite.setLayoutData((Object)data);
        if (this.hasMaxMinFacets) {
            this.minLengthLabel = factory.createLabel(simpleTypeModifierComposite, this.minLengthString);
            this.minLengthText = factory.createText(simpleTypeModifierComposite, "");
            this.applyAllListeners((Control)this.minLengthText);
            GridData minGridData = new GridData();
            minGridData.widthHint = 100;
            this.minLengthText.setLayoutData((Object)minGridData);
            this.minimumInclusiveCheckbox = factory.createButton(simpleTypeModifierComposite, Messages._UI_LABEL_INCLUSIVE, 32);
            this.minimumInclusiveCheckbox.addSelectionListener((SelectionListener)this);
            this.maxLengthLabel = factory.createLabel(simpleTypeModifierComposite, this.maxLengthString);
            this.maxLengthText = factory.createText(simpleTypeModifierComposite, "");
            this.applyAllListeners((Control)this.maxLengthText);
            GridData maxGridData = new GridData();
            maxGridData.widthHint = 100;
            this.maxLengthText.setLayoutData((Object)maxGridData);
            this.maximumInclusiveCheckbox = factory.createButton(simpleTypeModifierComposite, Messages._UI_LABEL_INCLUSIVE, 32);
            this.maximumInclusiveCheckbox.addSelectionListener((SelectionListener)this);
            this.minimumInclusiveCheckbox.setVisible(this.isNumericBaseType);
            this.maximumInclusiveCheckbox.setVisible(this.isNumericBaseType);
        }
        this.collapseWhitespaceButton = factory.createButton(simpleTypeModifierComposite, Messages._UI_LABEL_COLLAPSE_WHITESPACE, 32);
        this.collapseWhitespaceButton.addSelectionListener((SelectionListener)this);
        Group specificValueConstraintsGroup = factory.createGroup(facetComposite, Messages._UI_LABEL_SPECIFIC_CONSTRAINT_VALUES);
        gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 2;
        specificValueConstraintsGroup.setLayout((Layout)gridLayout);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        specificValueConstraintsGroup.setLayoutData((Object)data);
        Composite compositeForButtons = factory.createFlatFormComposite((Composite)specificValueConstraintsGroup);
        gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 1;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 1;
        compositeForButtons.setLayout((Layout)gridLayout);
        data = new GridData();
        data.verticalAlignment = 1;
        compositeForButtons.setLayoutData((Object)data);
        factory.createCLabel(compositeForButtons, Messages._UI_LABEL_RESTRICT_VALUES_BY);
        Composite compositeForRadioButtons = factory.createFlatFormComposite(compositeForButtons);
        gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 1;
        compositeForRadioButtons.setLayout((Layout)gridLayout);
        this.useEnumerationsButton = factory.createButton(compositeForRadioButtons, Messages._UI_LABEL_ENUMERATIONS, 16);
        this.useEnumerationsButton.addSelectionListener((SelectionListener)this);
        this.usePatternsButton = factory.createButton(compositeForRadioButtons, Messages._UI_LABEL_PATTERNS, 16);
        this.usePatternsButton.addSelectionListener((SelectionListener)this);
        this.constraintsWidget = new SpecificConstraintsWidget((Composite)specificValueConstraintsGroup, factory, this.input instanceof XSDFeature ? (XSDFeature)this.input : null, this.xsdSimpleTypeDefinition, this);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.constraintsWidget.getControl().setLayoutData((Object)data);
    }

    public void doSetInput() {
        this.setInput(this.getPart(), this.getSelection());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Class<?> clazz;
        super.setInput(part, selection);
        this.init();
        XSDSchema schemaOfType = null;
        if (!this.isReadOnly) {
            schemaOfType = this.xsdSimpleTypeDefinition.getSchema();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.xsd.XSDSchema");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (schemaOfType == this.owningEditor.getAdapter((Class)clazz)) {
            this.isReadOnly = false;
        } else if (!"http://www.w3.org/2001/XMLSchema".equals(this.xsdSimpleTypeDefinition.getTargetNamespace())) {
            this.isReadOnly = true;
        }
        if (this.hasMaxMinFacets) {
            this.title.setText(String.valueOf(this.titleString) + (this.isReadOnly ? " - " + Messages._UI_LABEL_READONLY : ""));
        }
        this.relayout();
        this.constraintsWidget.setCommandStack(this.getCommandStack());
    }

    protected void init() {
        this.hasMaxMinFacets = false;
        try {
            this.updateInput();
            if (this.xsdSimpleTypeDefinition != null) {
                XSDSimpleTypeDefinition targetST = this.xsdSimpleTypeDefinition;
                XSDSimpleTypeDefinition basePrimitive = this.xsdSimpleTypeDefinition.getPrimitiveTypeDefinition();
                targetST = basePrimitive != null ? basePrimitive : this.xsdSimpleTypeDefinition.getBaseTypeDefinition();
                this.minLengthString = "";
                this.maxLengthString = "";
                if (targetST.getValidFacets().contains((Object)"length")) {
                    this.minLengthString = Messages._UI_LABEL_MINIMUM_LENGTH;
                    this.maxLengthString = Messages._UI_LABEL_MAXIMUM_LENGTH;
                    this.simpleTypeModifierGroupTitle = String.valueOf(Messages._UI_LABEL_CONSTRAINTS_ON_LENGTH_OF) + targetST.getName();
                    this.isNumericBaseType = false;
                    this.hasMaxMinFacets = true;
                } else if (targetST.getValidFacets().contains((Object)"maxInclusive")) {
                    this.simpleTypeModifierGroupTitle = String.valueOf(Messages._UI_LABEL_CONSTRAINTS_ON_VALUE_OF) + targetST.getName();
                    this.minLengthString = Messages._UI_LABEL_MINIMUM_VALUE;
                    this.maxLengthString = Messages._UI_LABEL_MAXIMUM_VALUE;
                    this.isNumericBaseType = true;
                    this.hasMaxMinFacets = true;
                } else {
                    this.simpleTypeModifierGroupTitle = String.valueOf(Messages._UI_LABEL_CONTRAINTS_ON) + (basePrimitive != null ? basePrimitive.getName() : "anyType");
                }
            }
        }
        catch (Exception exception) {}
    }

    private void updateInput() {
        if (this.input instanceof XSDFeature) {
            this.xsdFeature = (XSDFeature)this.input;
            this.typeDefinition = this.xsdFeature.getResolvedFeature().getType();
            XSDTypeDefinition anonymousTypeDefinition = null;
            if (this.xsdFeature instanceof XSDElementDeclaration) {
                this.xsdElementDeclaration = (XSDElementDeclaration)this.xsdFeature;
                anonymousTypeDefinition = this.xsdElementDeclaration.getResolvedElementDeclaration().getAnonymousTypeDefinition();
            } else if (this.xsdFeature instanceof XSDAttributeDeclaration) {
                this.xsdAttributeDeclaration = (XSDAttributeDeclaration)this.xsdFeature;
                anonymousTypeDefinition = this.xsdAttributeDeclaration.getResolvedAttributeDeclaration().getAnonymousTypeDefinition();
            }
            if (this.typeDefinition instanceof XSDSimpleTypeDefinition) {
                this.xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.typeDefinition;
            }
            if (anonymousTypeDefinition instanceof XSDSimpleTypeDefinition) {
                this.xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)anonymousTypeDefinition;
            }
            if (this.xsdSimpleTypeDefinition != null) {
                XSDSimpleTypeDefinition basePrimitiveType = this.xsdSimpleTypeDefinition.getPrimitiveTypeDefinition();
                String basePrimitiveTypeString = basePrimitiveType != null ? basePrimitiveType.getName() : "";
                this.titleString = String.valueOf(Messages._UI_LABEL_TYPE) + (anonymousTypeDefinition != null ? "(" + this.xsdFeature.getResolvedFeature().getName() + "Type)" : this.xsdSimpleTypeDefinition.getName()) + " , " + Messages._UI_LABEL_BASE + ": " + basePrimitiveTypeString;
            }
        } else if (this.input instanceof XSDSimpleTypeDefinition) {
            this.xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.input;
            this.titleString = String.valueOf(Messages._UI_LABEL_TYPE) + this.xsdSimpleTypeDefinition.getName() + " , " + Messages._UI_LABEL_BASE + ": " + this.xsdSimpleTypeDefinition.getPrimitiveTypeDefinition().getName();
        }
    }

    public void refresh() {
        super.refresh();
        this.init();
        this.setListenerEnabled(false);
        XSDWhiteSpaceFacet whitespaceFacet = this.xsdSimpleTypeDefinition.getWhiteSpaceFacet();
        if (whitespaceFacet != null && this.xsdSimpleTypeDefinition.getFacetContents().contains((Object)whitespaceFacet) && XSDWhiteSpace.COLLAPSE_LITERAL.equals(whitespaceFacet.getValue())) {
            if (!"http://www.w3.org/2001/XMLSchema".equals(this.xsdSimpleTypeDefinition.getTargetNamespace())) {
                this.collapseWhitespaceButton.setSelection(true);
            } else {
                this.collapseWhitespaceButton.setSelection(false);
            }
        }
        if (this.hasMaxMinFacets) {
            this.minLengthLabel.setText(this.minLengthString);
            this.maxLengthLabel.setText(this.maxLengthString);
            if (!this.isNumericBaseType) {
                this.refreshStringLength();
            } else {
                this.refreshValueLengths();
            }
        }
        if (this.xsdSimpleTypeDefinition.getEnumerationFacets().size() > 0) {
            this.usePatternsButton.setSelection(false);
            this.useEnumerationsButton.setSelection(true);
            this.constraintsWidget.setConstraintKind(SpecificConstraintsWidget.ENUMERATION);
            this.constraintsWidget.addButton.setEnabled(true);
        } else if (this.xsdSimpleTypeDefinition.getPatternFacets().size() > 0) {
            this.usePatternsButton.setSelection(true);
            this.useEnumerationsButton.setSelection(false);
            this.constraintsWidget.setConstraintKind(SpecificConstraintsWidget.PATTERN);
            this.constraintsWidget.addButton.setEnabled(false);
        } else {
            this.usePatternsButton.setSelection(false);
            this.useEnumerationsButton.setSelection(true);
            this.constraintsWidget.setConstraintKind(SpecificConstraintsWidget.ENUMERATION);
            this.constraintsWidget.addButton.setEnabled(true);
        }
        this.constraintsWidget.setInput(this.xsdSimpleTypeDefinition);
        this.setListenerEnabled(true);
    }

    protected void relayout() {
        Composite parent = this.composite.getParent();
        parent.getParent().setRedraw(false);
        if (parent != null && !parent.isDisposed()) {
            Control[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        this.createContents(parent);
        parent.getParent().layout(true, true);
        parent.getParent().setRedraw(true);
        this.refresh();
    }

    public void dispose() {
        if (this.titleFont != null && !this.titleFont.isDisposed()) {
            this.titleFont.dispose();
        }
        this.titleFont = null;
        if (this.minimumInclusiveCheckbox != null && !this.minimumInclusiveCheckbox.isDisposed()) {
            this.minimumInclusiveCheckbox.removeSelectionListener((SelectionListener)this);
        }
        if (this.maximumInclusiveCheckbox != null && !this.maximumInclusiveCheckbox.isDisposed()) {
            this.maximumInclusiveCheckbox.removeSelectionListener((SelectionListener)this);
        }
        if (this.collapseWhitespaceButton != null && !this.collapseWhitespaceButton.isDisposed()) {
            this.collapseWhitespaceButton.removeSelectionListener((SelectionListener)this);
        }
        if (this.maxLengthText != null && !this.maxLengthText.isDisposed()) {
            this.removeListeners((Control)this.maxLengthText);
        }
        if (this.minLengthText != null && !this.minLengthText.isDisposed()) {
            this.removeListeners((Control)this.minLengthText);
        }
        super.dispose();
    }

    public void refreshStringLength() {
        XSDMinLengthFacet minLengthFacet = this.xsdSimpleTypeDefinition.getMinLengthFacet();
        XSDMaxLengthFacet maxLengthFacet = this.xsdSimpleTypeDefinition.getMaxLengthFacet();
        XSDLengthFacet lengthFacet = this.xsdSimpleTypeDefinition.getLengthFacet();
        try {
            int length;
            if (minLengthFacet != null) {
                int minLengthValue = minLengthFacet.getValue();
                if (minLengthValue >= 0) {
                    this.minLengthText.setText(Integer.toString(minLengthValue));
                } else {
                    this.minLengthText.setText("");
                }
            }
            if (maxLengthFacet != null) {
                int maxLength = maxLengthFacet.getValue();
                if (maxLength >= 0) {
                    this.maxLengthText.setText(Integer.toString(maxLength));
                } else {
                    this.maxLengthText.setText("");
                }
            }
            if (lengthFacet != null && (length = lengthFacet.getValue()) >= 0) {
                this.minLengthText.setText(Integer.toString(length));
                this.maxLengthText.setText(Integer.toString(length));
            }
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refreshValueLengths() {
        XSDSimpleTypeDefinition type = this.xsdSimpleTypeDefinition;
        XSDMinFacet minFacet = type.getMinFacet();
        XSDMaxFacet maxFacet = type.getMaxFacet();
        this.minimumInclusiveCheckbox.removeSelectionListener((SelectionListener)this);
        this.maximumInclusiveCheckbox.removeSelectionListener((SelectionListener)this);
        try {
            this.minLengthText.setText("");
            this.maxLengthText.setText("");
            this.minimumInclusiveCheckbox.setSelection(false);
            this.minimumInclusiveCheckbox.setEnabled(false);
            if (minFacet != null && (minFacet.getElement().getNodeName().equals("minExclusive") || minFacet.getElement().getNodeName().equals("minInclusive"))) {
                this.minLengthText.setText(minFacet.getLexicalValue());
                this.minimumInclusiveCheckbox.setSelection(minFacet.isInclusive());
                this.minimumInclusiveCheckbox.setEnabled(true);
            }
            this.maximumInclusiveCheckbox.setSelection(false);
            this.maximumInclusiveCheckbox.setEnabled(false);
            if (maxFacet != null && (maxFacet.getElement().getNodeName().equals("maxExclusive") || maxFacet.getElement().getNodeName().equals("maxInclusive"))) {
                this.maxLengthText.setText(maxFacet.getLexicalValue());
                this.maximumInclusiveCheckbox.setSelection(maxFacet.isInclusive());
                this.maximumInclusiveCheckbox.setEnabled(true);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.minimumInclusiveCheckbox.addSelectionListener((SelectionListener)this);
            this.maximumInclusiveCheckbox.addSelectionListener((SelectionListener)this);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.minimumInclusiveCheckbox.addSelectionListener((SelectionListener)this);
        this.maximumInclusiveCheckbox.addSelectionListener((SelectionListener)this);
    }

    protected void doHandleEvent(Event event) {
        BaseCommand updateCommand;
        BigDecimal bigDecimal;
        BigInteger big;
        super.doHandleEvent(event);
        BaseCommand command = null;
        boolean doUpdateMax = false;
        boolean doUpdateMin = false;
        String minValue = this.minLengthText.getText().trim();
        String maxValue = this.maxLengthText.getText().trim();
        XSDLengthFacet lengthFacet = this.xsdSimpleTypeDefinition.getLengthFacet();
        XSDMinLengthFacet minLengthFacet = this.xsdSimpleTypeDefinition.getMinLengthFacet();
        XSDMaxLengthFacet maxLengthFacet = this.xsdSimpleTypeDefinition.getMaxLengthFacet();
        XSDMinInclusiveFacet minInclusiveFacet = this.xsdSimpleTypeDefinition.getMinInclusiveFacet();
        XSDMinExclusiveFacet minExclusiveFacet = this.xsdSimpleTypeDefinition.getMinExclusiveFacet();
        XSDMaxInclusiveFacet maxInclusiveFacet = this.xsdSimpleTypeDefinition.getMaxInclusiveFacet();
        XSDMaxExclusiveFacet maxExclusiveFacet = this.xsdSimpleTypeDefinition.getMaxExclusiveFacet();
        String currentMinInclusive = null;
        String currentMinExclusive = null;
        String currentMaxInclusive = null;
        String currentMaxExclusive = null;
        if (minInclusiveFacet != null) {
            currentMinInclusive = minInclusiveFacet.getLexicalValue();
        }
        if (minExclusiveFacet != null) {
            currentMinExclusive = minExclusiveFacet.getLexicalValue();
        }
        if (maxInclusiveFacet != null) {
            currentMaxInclusive = maxInclusiveFacet.getLexicalValue();
        }
        if (maxExclusiveFacet != null) {
            currentMaxExclusive = maxExclusiveFacet.getLexicalValue();
        }
        String currentLength = null;
        String currentMin = null;
        String currentMax = null;
        if (lengthFacet != null) {
            currentLength = lengthFacet.getLexicalValue();
        }
        if (minLengthFacet != null) {
            currentMin = minLengthFacet.getLexicalValue();
        }
        if (maxLengthFacet != null) {
            currentMax = maxLengthFacet.getLexicalValue();
        }
        if (event.widget == this.minLengthText) {
            try {
                if (minValue.length() > 0) {
                    if (!this.isNumericBaseType) {
                        big = new BigInteger(minValue);
                        ((Object)big).toString();
                        if (minLengthFacet != null ? minValue.equals(currentMin) || minValue.equals(currentLength) : maxValue != null && minValue.equals(maxValue) && lengthFacet != null) {
                            return;
                        }
                    } else {
                        if (this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("double").equals(this.xsdSimpleTypeDefinition) || this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("float").equals(this.xsdSimpleTypeDefinition) || this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("decimal").equals(this.xsdSimpleTypeDefinition)) {
                            bigDecimal = new BigDecimal(minValue);
                            bigDecimal.toString();
                            if (currentMinInclusive != null && minValue.equals(currentMinInclusive) || currentMinExclusive != null && minValue.equals(currentMinExclusive)) {
                                return;
                            }
                        } else {
                            big = new BigInteger(minValue);
                            ((Object)big).toString();
                        }
                        this.minimumInclusiveCheckbox.setEnabled(true);
                    }
                } else {
                    if (!this.isNumericBaseType) {
                        if (currentMin == null && currentLength == null) {
                            return;
                        }
                    } else {
                        if (currentMinInclusive == null && this.minimumInclusiveCheckbox.getSelection()) {
                            return;
                        }
                        if (currentMinExclusive == null && !this.minimumInclusiveCheckbox.getSelection()) {
                            return;
                        }
                    }
                    this.minimumInclusiveCheckbox.setEnabled(false);
                    minValue = null;
                }
                doUpdateMin = true;
            }
            catch (NumberFormatException numberFormatException) {
                doUpdateMin = false;
            }
        }
        if (event.widget == this.maxLengthText) {
            try {
                if (maxValue.length() > 0) {
                    if (!this.isNumericBaseType) {
                        big = new BigInteger(maxValue);
                        ((Object)big).toString();
                        if (maxLengthFacet != null ? maxValue.equals(currentMax) || maxValue.equals(currentLength) : minValue != null && maxValue.equals(minValue) && lengthFacet != null) {
                            return;
                        }
                    } else {
                        if (this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("double").equals(this.xsdSimpleTypeDefinition) || this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("float").equals(this.xsdSimpleTypeDefinition) || this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("decimal").equals(this.xsdSimpleTypeDefinition)) {
                            bigDecimal = new BigDecimal(maxValue);
                            bigDecimal.toString();
                        } else {
                            big = new BigInteger(maxValue);
                            ((Object)big).toString();
                        }
                        this.maximumInclusiveCheckbox.setEnabled(true);
                    }
                } else {
                    if (!this.isNumericBaseType) {
                        if (currentMax == null && currentLength == null) {
                            return;
                        }
                    } else {
                        if (currentMaxInclusive == null && this.maximumInclusiveCheckbox.getSelection()) {
                            return;
                        }
                        if (currentMaxExclusive == null && !this.maximumInclusiveCheckbox.getSelection()) {
                            return;
                        }
                        this.maximumInclusiveCheckbox.setEnabled(false);
                    }
                    maxValue = null;
                }
                doUpdateMax = true;
            }
            catch (NumberFormatException numberFormatException) {
                doUpdateMax = false;
            }
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(this.xsdSimpleTypeDefinition.getTargetNamespace()) && (doUpdateMax || doUpdateMin)) {
            XSDSimpleTypeDefinition anonymousSimpleType = null;
            CompoundCommand compoundCommand = new CompoundCommand();
            ChangeToLocalSimpleTypeCommand changeToAnonymousCommand = null;
            if (this.input instanceof XSDFeature) {
                anonymousSimpleType = XSDCommonUIUtils.getAnonymousSimpleType((XSDFeature)this.input, this.xsdSimpleTypeDefinition);
                if (anonymousSimpleType == null) {
                    anonymousSimpleType = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                    anonymousSimpleType.setBaseTypeDefinition(this.xsdSimpleTypeDefinition);
                    changeToAnonymousCommand = new ChangeToLocalSimpleTypeCommand(Messages._UI_ACTION_CONSTRAIN_LENGTH, (XSDFeature)this.input);
                    changeToAnonymousCommand.setAnonymousSimpleType(anonymousSimpleType);
                    compoundCommand.add((Command)changeToAnonymousCommand);
                }
                if (!this.isNumericBaseType) {
                    UpdateStringLengthFacetCommand updateCommand2 = new UpdateStringLengthFacetCommand("", anonymousSimpleType);
                    if (doUpdateMax) {
                        updateCommand2.setMax(maxValue);
                    }
                    if (doUpdateMin) {
                        updateCommand2.setMin(minValue);
                    }
                    compoundCommand.add((Command)updateCommand2);
                } else {
                    UpdateNumericBoundsFacetCommand updateCommand3 = new UpdateNumericBoundsFacetCommand(Messages._UI_ACTION_UPDATE_BOUNDS, anonymousSimpleType, this.minimumInclusiveCheckbox.getSelection(), this.maximumInclusiveCheckbox.getSelection());
                    if (doUpdateMax) {
                        updateCommand3.setMax(maxValue);
                    }
                    if (doUpdateMin) {
                        updateCommand3.setMin(minValue);
                    }
                    compoundCommand.add((Command)updateCommand3);
                }
                command = compoundCommand;
                this.getCommandStack().execute((Command)command);
            } else if (this.input instanceof XSDSimpleTypeDefinition) {
                if (!this.isNumericBaseType) {
                    UpdateStringLengthFacetCommand updateCommand4 = new UpdateStringLengthFacetCommand("", this.xsdSimpleTypeDefinition);
                    if (doUpdateMax) {
                        updateCommand4.setMax(maxValue);
                    }
                    if (doUpdateMin) {
                        updateCommand4.setMin(minValue);
                    }
                    command = updateCommand4;
                } else {
                    UpdateNumericBoundsFacetCommand updateCommand5 = new UpdateNumericBoundsFacetCommand(Messages._UI_ACTION_UPDATE_BOUNDS, this.xsdSimpleTypeDefinition, this.minimumInclusiveCheckbox.getSelection(), this.maximumInclusiveCheckbox.getSelection());
                    if (doUpdateMax) {
                        updateCommand5.setMax(maxValue);
                    }
                    if (doUpdateMin) {
                        updateCommand5.setMin(minValue);
                    }
                    command = updateCommand5;
                }
                this.getCommandStack().execute((Command)command);
            }
        } else if (!this.isNumericBaseType) {
            updateCommand = new UpdateStringLengthFacetCommand("", this.xsdSimpleTypeDefinition);
            if (doUpdateMax) {
                ((UpdateStringLengthFacetCommand)updateCommand).setMax(maxValue);
            }
            if (doUpdateMin) {
                ((UpdateStringLengthFacetCommand)updateCommand).setMin(minValue);
            }
            this.getCommandStack().execute((Command)updateCommand);
        } else {
            updateCommand = new UpdateNumericBoundsFacetCommand(Messages._UI_ACTION_UPDATE_BOUNDS, this.xsdSimpleTypeDefinition, this.minimumInclusiveCheckbox.getSelection(), this.maximumInclusiveCheckbox.getSelection());
            if (doUpdateMax) {
                ((UpdateNumericBoundsFacetCommand)updateCommand).setMax(maxValue);
            }
            if (doUpdateMin) {
                ((UpdateNumericBoundsFacetCommand)updateCommand).setMin(minValue);
            }
            this.getCommandStack().execute((Command)updateCommand);
        }
        this.setInput(this.getPart(), this.getSelection());
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.collapseWhitespaceButton) {
            CompoundCommand compoundCommand = new CompoundCommand();
            XSDSimpleTypeDefinition anonymousSimpleType = null;
            if ("http://www.w3.org/2001/XMLSchema".equals(this.xsdSimpleTypeDefinition.getTargetNamespace())) {
                if (this.input instanceof XSDFeature) {
                    anonymousSimpleType = XSDCommonUIUtils.getAnonymousSimpleType((XSDFeature)this.input, this.xsdSimpleTypeDefinition);
                    if (anonymousSimpleType == null) {
                        anonymousSimpleType = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                        anonymousSimpleType.setBaseTypeDefinition(this.xsdSimpleTypeDefinition);
                        ChangeToLocalSimpleTypeCommand changeToAnonymousCommand = new ChangeToLocalSimpleTypeCommand(Messages._UI_ACTION_CONSTRAIN_LENGTH, (XSDFeature)this.input);
                        changeToAnonymousCommand.setAnonymousSimpleType(anonymousSimpleType);
                        compoundCommand.add((Command)changeToAnonymousCommand);
                    }
                    UpdateXSDWhiteSpaceFacetCommand whiteSpaceCommand = new UpdateXSDWhiteSpaceFacetCommand(Messages._UI_ACTION_COLLAPSE_WHITESPACE, anonymousSimpleType, this.collapseWhitespaceButton.getSelection());
                    compoundCommand.add((Command)whiteSpaceCommand);
                    this.getCommandStack().execute((Command)compoundCommand);
                }
                this.setInput(this.getPart(), this.getSelection());
            } else {
                UpdateXSDWhiteSpaceFacetCommand whiteSpaceCommand = new UpdateXSDWhiteSpaceFacetCommand(Messages._UI_ACTION_COLLAPSE_WHITESPACE, this.xsdSimpleTypeDefinition, this.collapseWhitespaceButton.getSelection());
                this.getCommandStack().execute((Command)whiteSpaceCommand);
            }
        } else if (e.widget == this.minimumInclusiveCheckbox) {
            String minValue = this.minLengthText.getText().trim();
            if (minValue.length() == 0) {
                minValue = null;
            }
            UpdateNumericBoundsFacetCommand updateCommand = new UpdateNumericBoundsFacetCommand(Messages._UI_ACTION_UPDATE_BOUNDS, this.xsdSimpleTypeDefinition, this.minimumInclusiveCheckbox.getSelection(), this.maximumInclusiveCheckbox.getSelection());
            updateCommand.setMin(minValue);
            if (minValue != null) {
                this.getCommandStack().execute((Command)updateCommand);
            }
        } else if (e.widget == this.maximumInclusiveCheckbox) {
            String maxValue = this.maxLengthText.getText().trim();
            if (maxValue.length() == 0) {
                maxValue = null;
            }
            UpdateNumericBoundsFacetCommand updateCommand = new UpdateNumericBoundsFacetCommand(Messages._UI_ACTION_UPDATE_BOUNDS, this.xsdSimpleTypeDefinition, this.minimumInclusiveCheckbox.getSelection(), this.maximumInclusiveCheckbox.getSelection());
            updateCommand.setMax(maxValue);
            if (maxValue != null) {
                this.getCommandStack().execute((Command)updateCommand);
            }
        } else if (e.widget == this.useEnumerationsButton) {
            this.constraintsWidget.addButton.setEnabled(true);
            if (this.isListenerEnabled()) {
                this.constraintsWidget.setConstraintKind(SpecificConstraintsWidget.ENUMERATION);
            }
        } else if (e.widget == this.usePatternsButton) {
            this.constraintsWidget.addButton.setEnabled(false);
            if (this.isListenerEnabled()) {
                this.constraintsWidget.setConstraintKind(SpecificConstraintsWidget.PATTERN);
            }
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

