/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.sqlscrapbook.actions;

import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.wst.rdb.internal.sqlscrapbook.wizards.NewSQLScrapbookFileCreationWizard;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;

public class SQLScrapbookAction
implements IViewActionDelegate {
    public static final String ID = "com.ibm.datatools.sqlscrapbook.actions.SQLScrapbookAction";
    public static int extNumber = 0;
    Vector selectionVector = new Vector();
    IStructuredSelection selection;

    public void run(IAction action) {
        try {
            String title = this.getScrapbookName();
            ConnectionInfo connectionInfo = null;
            if (!this.selection.isEmpty()) {
                Iterator iter = this.selection.iterator();
                Object selectedObj = iter.next();
                if (selectedObj instanceof ConnectionInfo) {
                    connectionInfo = (ConnectionInfo)selectedObj;
                } else if (selectedObj instanceof Database) {
                    Database database = (Database)selectedObj;
                    connectionInfo = ((IConnectionNode)IServicesManager.INSTANCE.getServerExplorerNavigationService().getParent((Object)database)).getConnectionInfo();
                }
            }
            NewSQLScrapbookFileCreationWizard wizard = new NewSQLScrapbookFileCreationWizard();
            wizard.setConnectionInfo(connectionInfo);
            WizardDialog dialog = new WizardDialog(SqlscrapbookPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            dialog.open();
            if (connectionInfo != null) {
                title = String.valueOf(title) + " (" + connectionInfo.getName() + " - " + connectionInfo.getDatabaseName() + ")";
            }
        }
        catch (Exception e) {
            System.out.println("\nException: " + e);
        }
    }

    public String getScrapbookName() {
        return String.valueOf(SqlscrapbookPlugin.getResourceString("SQLScrapbookAction.SCRAPBOOK_TITLE")) + Integer.toString(++extNumber);
    }

    private Vector getAllEditors() {
        Vector<IEditorPart> editorVector = new Vector<IEditorPart>();
        IWorkbench workbench = SqlscrapbookPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                WorkbenchPage page = (WorkbenchPage)pages[j];
                IEditorPart[] editors = page.getDirtyEditors();
                int k = 0;
                while (k < editors.length) {
                    editorVector.addElement(editors[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return editorVector;
    }

    public String getID() {
        return ID;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.selectionVector.removeAllElements();
        this.selectionVector.add(connectionInfo);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    public void init(IViewPart view) {
        System.out.println(view.getTitle());
    }

    public class SQLScrapbookEditorInput
    implements IEditorInput {
        private Connection connection;
        private String title;

        public SQLScrapbookEditorInput(String editorTitle, Connection connect) {
            this.title = editorTitle;
            this.connection = connect;
        }

        public Connection getRDBConnection() {
            return this.connection;
        }

        public boolean exists() {
            return false;
        }

        public String getName() {
            return this.title;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return this.title;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

