/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.internal.ActionDefinition;
import org.eclipse.wst.common.project.facet.core.internal.EventHandler;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl;
import org.eclipse.wst.common.project.facet.core.internal.Versionable;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class ProjectFacet
extends Versionable
implements IProjectFacet {
    private static final Versionable.IVersionAdapter VERSION_ADAPTER = new Versionable.IVersionAdapter(){

        public String adapt(Object obj) {
            return ((IProjectFacetVersion)obj).getVersionString();
        }
    };
    private String id;
    private String plugin;
    private String label;
    private String description;
    private ICategory category;
    private final List actionDefinitions = new ArrayList();
    private final List eventHandlers = new ArrayList();

    ProjectFacet() {
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getPluginId() {
        return this.plugin;
    }

    void setPluginId(String plugin) {
        this.plugin = plugin;
    }

    public String getLabel() {
        return this.label;
    }

    void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    void setDescription(String description) {
        this.description = description;
    }

    public ICategory getCategory() {
        return this.category;
    }

    void setCategory(ICategory category) {
        this.category = category;
    }

    public IProjectFacetVersion getVersion(String version) {
        IProjectFacetVersion fv = (IProjectFacetVersion)this.versions.get(version);
        if (fv == null) {
            String msg = NLS.bind((String)Resources.versionNotFound, (Object)this.getId(), (Object)version);
            throw new IllegalArgumentException(msg);
        }
        return fv;
    }

    void addVersion(IProjectFacetVersion version) {
        this.versions.add(version.getVersionString(), version);
    }

    public IProjectFacetVersion getLatestVersion() throws VersionFormatException, CoreException {
        if (this.versions.size() > 0) {
            Comparator comp = this.getVersionComparator(true, VERSION_ADAPTER);
            Object max = Collections.max(this.versions, comp);
            return (IProjectFacetVersion)max;
        }
        return null;
    }

    public IProjectFacetVersion getLatestSupportedVersion(IRuntime r) throws CoreException {
        Iterator itr = this.getSortedVersions(false).iterator();
        while (itr.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            if (!r.supports(fv)) continue;
            return fv;
        }
        return null;
    }

    protected Versionable.IVersionAdapter getVersionAdapter() {
        return VERSION_ADAPTER;
    }

    public Object getAdapter(Class type) {
        return Platform.getAdapterManager().loadAdapter((Object)this, type.getName());
    }

    public String createVersionNotFoundErrMsg(String verstr) {
        return NLS.bind((String)ProjectFacetsManagerImpl.Resources.facetVersionNotDefined, (Object)this.id, (Object)verstr);
    }

    public String toString() {
        return this.label;
    }

    Set getActionDefinitions(IProjectFacetVersion fv) {
        HashSet<IActionDefinition> result = new HashSet<IActionDefinition>();
        Iterator itr = this.actionDefinitions.iterator();
        while (itr.hasNext()) {
            IActionDefinition def = (IActionDefinition)itr.next();
            if (!def.getVersionExpr().evaluate(fv.getVersionString())) continue;
            result.add(def);
        }
        return result;
    }

    void addActionDefinition(ActionDefinition actionDefinition) {
        this.actionDefinitions.add(actionDefinition);
    }

    List getEventHandlers(IProjectFacetVersion fv, EventHandler.Type type) {
        ArrayList<EventHandler> res = new ArrayList<EventHandler>();
        Iterator itr = this.eventHandlers.iterator();
        while (itr.hasNext()) {
            EventHandler h = (EventHandler)itr.next();
            try {
                if (h.getType() != type || !h.getVersionExpr().evaluate((IVersion)((Object)fv))) continue;
                res.add(h);
            }
            catch (CoreException e) {
                FacetCorePlugin.log(e.getStatus());
            }
        }
        return res;
    }

    void addEventHandler(EventHandler h) {
        this.eventHandlers.add(h);
    }

    public static final class Resources
    extends NLS {
        public static String versionNotFound;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacet$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }
    }
}

