/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.BehavioralFeatureOperations;

public class OperationOperations
extends BehavioralFeatureOperations {
    protected OperationOperations() {
    }

    public static boolean validateAtMostOneReturn(Operation operation, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateOnlyBodyForQuery(Operation operation, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        if (operation.getBodyCondition() != null && !operation.isQuery()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 64, UMLPlugin.INSTANCE.getString("_UI_Operation_OnlyBodyForQuery_diagnostic", OperationOperations.getMessageSubstitutions((Map)context, (Object)operation)), new Object[]{operation}));
            }
        }
        return result;
    }

    public static boolean isOrdered(Operation operation) {
        EList returnResult = operation.returnResult();
        return returnResult.size() == 1 ? ((Parameter)returnResult.get(0)).isOrdered() : false;
    }

    public static boolean isUnique(Operation operation) {
        EList returnResult = operation.returnResult();
        return returnResult.size() == 1 ? ((Parameter)returnResult.get(0)).isUnique() : true;
    }

    public static int lowerBound(Operation operation) {
        EList returnResult = operation.returnResult();
        return returnResult.size() == 1 ? ((Parameter)returnResult.get(0)).lowerBound() : 1;
    }

    public static int upperBound(Operation operation) {
        EList returnResult = operation.returnResult();
        return returnResult.size() == 1 ? ((Parameter)returnResult.get(0)).upperBound() : 1;
    }

    public static Type getType(Operation operation) {
        EList returnResult = operation.returnResult();
        return returnResult.size() == 1 ? (Type)((Parameter)returnResult.get(0)).eGet((EStructuralFeature)UMLPackage.Literals.TYPED_ELEMENT__TYPE, false) : null;
    }

    public static EList returnResult(Operation operation) {
        UniqueEList.FastCompare returnResult = new UniqueEList.FastCompare();
        Iterator ownedParameters = operation.getOwnedParameters().iterator();
        while (ownedParameters.hasNext()) {
            Parameter ownedParameter = (Parameter)ownedParameters.next();
            if (ownedParameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            returnResult.add((Object)ownedParameter);
        }
        return ECollections.unmodifiableEList((EList)returnResult);
    }

    public static int getLower(Operation operation) {
        return operation.lowerBound();
    }

    public static int getUpper(Operation operation) {
        return operation.upperBound();
    }

    public static void setIsOrdered(Operation operation, boolean newIsOrdered) {
        EList returnResult = operation.returnResult();
        if (returnResult.size() == 1) {
            ((Parameter)returnResult.get(0)).setIsOrdered(newIsOrdered);
        }
    }

    public static void setIsUnique(Operation operation, boolean newIsUnique) {
        EList returnResult = operation.returnResult();
        if (returnResult.size() == 1) {
            ((Parameter)returnResult.get(0)).setIsUnique(newIsUnique);
        }
    }

    public static void setLower(Operation operation, int newLower) {
        EList returnResult = operation.returnResult();
        if (returnResult.size() == 1) {
            ((Parameter)returnResult.get(0)).setLower(newLower);
        }
    }

    public static void setUpper(Operation operation, int newUpper) {
        EList returnResult = operation.returnResult();
        if (returnResult.size() == 1) {
            ((Parameter)returnResult.get(0)).setUpper(newUpper);
        }
    }

    public static Parameter getReturnResult(Operation operation) {
        Iterator ownedParameters = operation.getOwnedParameters().iterator();
        while (ownedParameters.hasNext()) {
            Parameter ownedParameter = (Parameter)ownedParameters.next();
            if (ownedParameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL) continue;
            return ownedParameter;
        }
        return null;
    }

    public static void setType(Operation operation, Type newType) {
        EList returnResult = operation.returnResult();
        if (returnResult.size() == 1) {
            ((Parameter)returnResult.get(0)).setType(newType);
        }
    }

    public static boolean isConsistentWith(Operation operation, RedefinableElement redefinee) {
        if (redefinee instanceof Operation && redefinee.isRedefinitionContextValid(operation)) {
            Operation op = (Operation)redefinee;
            EList ownedParameters = operation.getOwnedParameters();
            int ownedParametersSize = ownedParameters.size();
            EList opOwnedParameters = op.getOwnedParameters();
            EList returnResult = operation.returnResult();
            int returnResultSize = returnResult.size();
            EList opReturnResult = op.returnResult();
            if (ownedParametersSize == opOwnedParameters.size() && returnResultSize == opReturnResult.size()) {
                int i = 0;
                while (i < ownedParametersSize) {
                    Type opOwnedParameterType = ((Parameter)opOwnedParameters.get(i)).getType();
                    Type ownedParameterType = ((Parameter)ownedParameters.get(i)).getType();
                    if (opOwnedParameterType == null ? ownedParameterType != null : !opOwnedParameterType.conformsTo(ownedParameterType)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < returnResultSize) {
                    Type opReturnResultType = ((Parameter)opReturnResult.get(i)).getType();
                    Type returnResultType = ((Parameter)returnResult.get(i)).getType();
                    if (opReturnResultType == null ? returnResultType != null : !opReturnResultType.conformsTo(returnResultType)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }
}

