/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.operations.ElementOperations;

public class MultiplicityElementOperations
extends ElementOperations {
    protected MultiplicityElementOperations() {
    }

    public static boolean validateUpperGt0(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        int upperBound = multiplicityElement.upperBound();
        if (upperBound != -1 && upperBound < 1) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 42, UMLPlugin.INSTANCE.getString("_UI_MultiplicityElement_UpperGT0_diagnostic", MultiplicityElementOperations.getMessageSubstitutions((Map)context, (Object)multiplicityElement)), new Object[]{multiplicityElement, new Integer(upperBound)}));
            }
        }
        return result;
    }

    public static boolean validateLowerGe0(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        int lowerBound = multiplicityElement.lowerBound();
        if (lowerBound < 0) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 43, UMLPlugin.INSTANCE.getString("_UI_MultiplicityElement_LowerGE0_diagnostic", MultiplicityElementOperations.getMessageSubstitutions((Map)context, (Object)multiplicityElement)), new Object[]{multiplicityElement, new Integer(lowerBound)}));
            }
        }
        return result;
    }

    public static boolean validateUpperGeLower(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        int upperBound = multiplicityElement.upperBound();
        if (upperBound != -1 && upperBound < multiplicityElement.lowerBound()) {
            result = false;
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 44, UMLPlugin.INSTANCE.getString("_UI_MultiplicityElement_UpperGELower_diagnostic", MultiplicityElementOperations.getMessageSubstitutions((Map)context, (Object)multiplicityElement)), new Object[]{multiplicityElement, new Integer(upperBound)}));
            }
        }
        return result;
    }

    public static boolean validateValueSpecificationNoSideEffects(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateValueSpecificationConstant(MultiplicityElement multiplicityElement, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static int getLower(MultiplicityElement multiplicityElement) {
        return multiplicityElement.lowerBound();
    }

    public static int getUpper(MultiplicityElement multiplicityElement) {
        return multiplicityElement.upperBound();
    }

    public static boolean isMultivalued(MultiplicityElement multiplicityElement) {
        int upperBound = multiplicityElement.upperBound();
        return upperBound == -1 || upperBound > 1;
    }

    public static boolean includesCardinality(MultiplicityElement multiplicityElement, int C) {
        if (C == -1) {
            return multiplicityElement.upperBound() == -1;
        }
        if (multiplicityElement.lowerBound() <= C) {
            int upperBound = multiplicityElement.upperBound();
            return upperBound == -1 ? true : upperBound >= C;
        }
        return false;
    }

    public static boolean includesMultiplicity(MultiplicityElement multiplicityElement, MultiplicityElement M) {
        if (multiplicityElement.lowerBound() <= M.lowerBound()) {
            int upperBound = multiplicityElement.upperBound();
            if (upperBound == -1) {
                return true;
            }
            int mUpperBound = M.upperBound();
            return mUpperBound == -1 ? false : upperBound >= mUpperBound;
        }
        return false;
    }

    public static int lowerBound(MultiplicityElement multiplicityElement) {
        ValueSpecification lowerValue = multiplicityElement.getLowerValue();
        return lowerValue instanceof LiteralInteger ? lowerValue.integerValue() : 1;
    }

    public static int upperBound(MultiplicityElement multiplicityElement) {
        ValueSpecification upperValue = multiplicityElement.getUpperValue();
        return upperValue instanceof LiteralUnlimitedNatural ? upperValue.unlimitedValue() : 1;
    }

    public static boolean compatibleWith(MultiplicityElement multiplicityElement, MultiplicityElement other) {
        return other != null && other.includesMultiplicity(multiplicityElement);
    }

    public static boolean is(MultiplicityElement multiplicityElement, int lowerbound, int upperbound) {
        return multiplicityElement.lowerBound() == lowerbound && multiplicityElement.upperBound() == upperbound;
    }

    public static void setLower(MultiplicityElement multiplicityElement, int newLower) {
        ValueSpecification lowerValue = multiplicityElement.getLowerValue();
        ((LiteralInteger)(lowerValue instanceof LiteralInteger ? lowerValue : multiplicityElement.createLowerValue(null, null, UMLPackage.Literals.LITERAL_INTEGER))).setValue(newLower);
    }

    public static void setUpper(MultiplicityElement multiplicityElement, int newUpper) {
        ValueSpecification upperValue = multiplicityElement.getUpperValue();
        ((LiteralUnlimitedNatural)(upperValue instanceof LiteralUnlimitedNatural ? upperValue : multiplicityElement.createUpperValue(null, null, UMLPackage.Literals.LITERAL_UNLIMITED_NATURAL))).setValue(newUpper);
    }
}

