/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.graph.CollapsedEdges;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.InitialRankSolver;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeCluster;
import org.eclipse.draw2d.graph.NodePair;
import org.eclipse.draw2d.graph.Rank;
import org.eclipse.draw2d.graph.RankAssigmentSolver;
import org.eclipse.draw2d.graph.RankList;
import org.eclipse.draw2d.graph.SpanningTreeVisitor;
import org.eclipse.draw2d.graph.TightSpanningTreeSolver;

class HorizontalPlacement
extends SpanningTreeVisitor {
    static int step;
    private List allClusters;
    private Map clusterMap = new HashMap();
    ClusterSet clusterset = new ClusterSet();
    Collection dirtyClusters = new HashSet();
    DirectedGraph graph;
    Map map = new HashMap();
    DirectedGraph prime;
    Node graphRight;
    Node graphLeft;

    HorizontalPlacement() {
    }

    void addEdge(Node u, Node v, Edge e, int weight) {
        Node ne = new Node(new NodePair(u, v));
        this.prime.nodes.add(ne);
        ne.y = (u.y + u.height + v.y) / 2;
        Node uPrime = this.get(u);
        Node vPrime = this.get(v);
        int uOffset = e.getSourceOffset();
        int vOffset = e.getTargetOffset();
        Edge eu = new Edge(ne, uPrime, 0, e.weight * weight);
        Edge ev = new Edge(ne, vPrime, 0, e.weight * weight);
        int dw = uOffset - vOffset;
        if (dw < 0) {
            eu.delta = -dw;
        } else {
            ev.delta = dw;
        }
        this.prime.edges.add(eu);
        this.prime.edges.add(ev);
    }

    void addEdges(Node n) {
        int i = 0;
        while (i < n.incoming.size()) {
            Edge e = n.incoming.getEdge(i);
            this.addEdge(e.source, n, e, 1);
            ++i;
        }
    }

    void applyGPrime() {
        int n = 0;
        while (n < this.prime.nodes.size()) {
            Node node = this.prime.nodes.getNode(n);
            if (node.data instanceof Node) {
                ((Node)node.data).x = node.rank;
            }
            ++n;
        }
    }

    private void balanceClusters() {
        this.findAllClusters();
        step = 0;
        boolean somethingMoved = false;
        int i = 0;
        while (i < this.allClusters.size()) {
            NodeCluster c = (NodeCluster)this.allClusters.get(i);
            int delta = c.getPull();
            if (delta < 0) {
                if (c.leftFreedom > 0) {
                    c.adjustRank(Math.max(delta, -c.leftFreedom), this.dirtyClusters);
                    this.refreshDirtyClusters();
                    this.moveClusterForward(i, c);
                    somethingMoved = true;
                    ++step;
                } else if (this.clusterset.build(c)) {
                    ++step;
                    this.moveClusterForward(i, c);
                    somethingMoved = true;
                }
            } else if (delta > 0) {
                if (c.rightFreedom > 0) {
                    c.adjustRank(Math.min(delta, c.rightFreedom), this.dirtyClusters);
                    this.refreshDirtyClusters();
                    this.moveClusterForward(i, c);
                    somethingMoved = true;
                    ++step;
                } else if (this.clusterset.build(c)) {
                    ++step;
                    this.moveClusterForward(i, c);
                    somethingMoved = true;
                }
            }
            if (++i != this.allClusters.size() || !somethingMoved) continue;
            i = 0;
            somethingMoved = false;
        }
    }

    void buildGPrime() {
        RankList ranks = this.graph.ranks;
        this.buildRankSeparators(ranks);
        int r = 1;
        while (r < ranks.size()) {
            Rank rank = ranks.getRank(r);
            int i = 0;
            while (i < rank.count()) {
                Node n = rank.getNode(i);
                this.addEdges(n);
                ++i;
            }
            ++r;
        }
    }

    void buildRankSeparators(RankList ranks) {
        int r = 0;
        while (r < ranks.size()) {
            Rank rank = ranks.getRank(r);
            Node prevNPrime = null;
            int i = 0;
            while (i < rank.count()) {
                Edge e;
                Node n = rank.getNode(i);
                Node nPrime = new Node(n);
                if (i == 0) {
                    e = new Edge(this.graphLeft, nPrime, 0, 0);
                    this.prime.edges.add(e);
                    e.delta = this.graph.getPadding((Node)n).left + this.graph.getMargin().left;
                } else {
                    e = new Edge(prevNPrime, nPrime);
                    e.weight = 0;
                    this.prime.edges.add(e);
                    this.rowSeparation(e);
                }
                prevNPrime = nPrime;
                this.prime.nodes.add(nPrime);
                this.map(n, nPrime);
                if (i == rank.count() - 1) {
                    e = new Edge(nPrime, this.graphRight, 0, 0);
                    e.delta = n.width + this.graph.getPadding((Node)n).right + this.graph.getMargin().right;
                    this.prime.edges.add(e);
                }
                ++i;
            }
            ++r;
        }
    }

    private void calculateCellLocations() {
        this.graph.cellLocations = new int[this.graph.ranks.size() + 1][];
        int row = 0;
        while (row < this.graph.ranks.size()) {
            Rank rank = this.graph.ranks.getRank(row);
            this.graph.cellLocations[row] = new int[rank.size() + 1];
            int[] locations = this.graph.cellLocations[row];
            Node node = null;
            int cell = 0;
            while (cell < rank.size()) {
                node = rank.getNode(cell);
                locations[cell] = node.x - this.graph.getPadding((Node)node).left;
                ++cell;
            }
            locations[cell] = node.x + node.width + this.graph.getPadding((Node)node).right;
            ++row;
        }
    }

    private void findAllClusters() {
        Node root = this.prime.nodes.getNode(0);
        NodeCluster cluster = new NodeCluster();
        this.allClusters = new ArrayList();
        this.allClusters.add(cluster);
        this.growCluster(root, cluster);
        int i = 0;
        while (i < this.prime.edges.size()) {
            Edge e = this.prime.edges.getEdge(i);
            NodeCluster sourceCluster = (NodeCluster)this.clusterMap.get(e.source);
            NodeCluster targetCluster = (NodeCluster)this.clusterMap.get(e.target);
            if (targetCluster != sourceCluster) {
                CollapsedEdges link = sourceCluster.getRightNeighbor(targetCluster);
                if (link == null) {
                    link = new CollapsedEdges(e);
                    sourceCluster.addRightNeighbor(targetCluster, link);
                    targetCluster.addLeftNeighbor(sourceCluster, link);
                } else {
                    this.prime.removeEdge(link.processEdge(e));
                    --i;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.allClusters.size()) {
            ((NodeCluster)this.allClusters.get(i)).initValues();
            ++i;
        }
    }

    Node get(Node key) {
        return (Node)this.map.get(key);
    }

    void growCluster(Node root, NodeCluster cluster) {
        cluster.add(root);
        this.clusterMap.put(root, cluster);
        EdgeList treeChildren = this.getSpanningTreeChildren(root);
        int i = 0;
        while (i < treeChildren.size()) {
            Edge e = treeChildren.getEdge(i);
            if (e.cut != 0) {
                this.growCluster(this.getTreeTail(e), cluster);
            } else {
                NodeCluster newCluster = new NodeCluster();
                this.allClusters.add(newCluster);
                this.growCluster(this.getTreeTail(e), newCluster);
            }
            ++i;
        }
    }

    void map(Node key, Node value) {
        this.map.put(key, value);
    }

    private void moveClusterForward(int i, NodeCluster c) {
        if (i == 0) {
            return;
        }
        int swapIndex = i / 2;
        Object temp = this.allClusters.get(swapIndex);
        this.allClusters.set(swapIndex, c);
        this.allClusters.set(i, temp);
    }

    void refreshDirtyClusters() {
        Iterator iter = this.dirtyClusters.iterator();
        while (iter.hasNext()) {
            ((NodeCluster)iter.next()).refreshValues();
        }
        this.dirtyClusters.clear();
    }

    void rowSeparation(Edge e) {
        Node source = (Node)e.source.data;
        Node target = (Node)e.target.data;
        e.delta = source.width + this.graph.getPadding((Node)source).right + this.graph.getPadding((Node)target).left;
    }

    public void visit(DirectedGraph g) {
        this.graph = g;
        this.prime = new DirectedGraph();
        this.graphLeft = new Node(null);
        this.prime.nodes.add(this.graphLeft);
        this.graphRight = new Node(null);
        this.prime.nodes.add(this.graphRight);
        if (g.tensorStrength != 0) {
            this.prime.edges.add(new Edge(this.graphLeft, this.graphRight, g.tensorSize, g.tensorStrength));
        }
        this.buildGPrime();
        new InitialRankSolver().visit(this.prime);
        new TightSpanningTreeSolver().visit(this.prime);
        RankAssigmentSolver solver = new RankAssigmentSolver();
        solver.visit(this.prime);
        this.graph.size.width = this.graphRight.rank;
        this.balanceClusters();
        this.prime.nodes.adjustRank(-this.graphLeft.rank);
        this.applyGPrime();
        this.calculateCellLocations();
    }

    class ClusterSet {
        int freedom = Integer.MAX_VALUE;
        boolean isRight;
        public List members = new ArrayList();
        int pullWeight = 0;
        int rawPull = 0;

        ClusterSet() {
        }

        boolean addCluster(NodeCluster seed) {
            this.members.add(seed);
            seed.isSetMember = true;
            this.rawPull += seed.weightedTotal;
            this.pullWeight += seed.weightedDivisor;
            if (this.isRight) {
                this.freedom = Math.min(this.freedom, seed.rightNonzero);
                if (this.freedom == 0 || this.rawPull <= 0) {
                    return true;
                }
                this.addIncomingClusters(seed);
                if (this.addOutgoingClusters(seed)) {
                    return true;
                }
            } else {
                this.freedom = Math.min(this.freedom, seed.leftNonzero);
                if (this.freedom == 0 || this.rawPull >= 0) {
                    return true;
                }
                this.addOutgoingClusters(seed);
                if (this.addIncomingClusters(seed)) {
                    return true;
                }
            }
            return false;
        }

        boolean addIncomingClusters(NodeCluster seed) {
            int i = 0;
            while (i < seed.leftCount) {
                CollapsedEdges edges;
                NodeCluster neighbor = seed.leftNeighbors[i];
                if (!neighbor.isSetMember && (edges = seed.leftLinks[i]).isTight() && (!this.isRight || neighbor.getPull() > 0) && this.addCluster(neighbor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        boolean addOutgoingClusters(NodeCluster seed) {
            int i = 0;
            while (i < seed.rightCount) {
                CollapsedEdges edges;
                NodeCluster neighbor = seed.rightNeighbors[i];
                if (!neighbor.isSetMember && (edges = seed.rightLinks[i]).isTight() && (this.isRight || neighbor.getPull() < 0) && this.addCluster(neighbor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        boolean build(NodeCluster seed) {
            int delta;
            boolean bl = this.isRight = seed.weightedTotal > 0;
            if (!this.addCluster(seed) && (delta = (delta = this.rawPull / this.pullWeight) < 0 ? Math.max(delta, -this.freedom) : Math.min(delta, this.freedom)) != 0) {
                int i = 0;
                while (i < this.members.size()) {
                    NodeCluster c = (NodeCluster)this.members.get(i);
                    c.adjustRank(delta, HorizontalPlacement.this.dirtyClusters);
                    ++i;
                }
                HorizontalPlacement.this.refreshDirtyClusters();
                this.reset();
                return true;
            }
            this.reset();
            return false;
        }

        void reset() {
            this.pullWeight = 0;
            this.rawPull = 0;
            int i = 0;
            while (i < this.members.size()) {
                ((NodeCluster)this.members.get((int)i)).isSetMember = false;
                ++i;
            }
            this.members.clear();
            this.freedom = Integer.MAX_VALUE;
        }
    }
}

