#
# MimeCodeGifs.tcl ---
#
#    Creates tk photos with MIME coded data from all gifs in present directory.

set suff gif

set dir [tk_chooseDirectory -title "Pick gif directory"]
if {$dir == ""} return
cd $dir
set fileNames [glob *.$suff]
puts $fileNames
set base64file [tk_getOpenFile -title "Pick base64.tcl here"]
if {$base64file == ""} return
source $base64file
if {[file tail $base64file] != "base64.tcl"} return

foreach gifFile $fileNames {
    set fd [open $gifFile]
    fconfigure $fd -translation binary
    set data [read $fd]
    close $fd
    set mimedata [base64::encode $data]   
    regexp "(.+)\.$suff" $gifFile match name
    puts " "
    puts "set ::UI::icons($name) \[image create photo -data \{"
    puts $mimedata
    puts "\}\]"
}
