### Name: predict.ellipsoid
### Title: Predict Method for Ellipsoid Objects
### Aliases: predict.ellipsoid ellipsoidPoints
### Keywords: dplot utilities

### ** Examples

 ## see also  example(ellipsoidhull)

## Robust vs. L.S. covariance matrix
set.seed(143)
x <- rt(200, df=3)
y <- 3*x + rt(200, df=2)
plot(x,y, main="non-normal data (N=200)")
X <- cbind(x,y)
C.ls <- cov(X) ; m.ls <- colMeans(X)
lines(ellipsoidPoints(C.ls, d2 = 2, loc=m.ls), col="green")
if(require(MASS)) {
  Cxy <- cov.rob(cbind(x,y))
  lines(ellipsoidPoints(Cxy$cov, d2 = 2, loc=Cxy$center), col="red")
}# MASS



