// -*- c++ -*-
//  Generated by gtkmmproc from /usr/obj/ports/gtkmm-1.2.10p5/gtkmm-1.2.10/src/build_sources/../fileselection.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_FILESELECTION_H
#define _GTKMM_FILESELECTION_H

/* $Id: fileselection.gen_h,v 1.45 2001/07/15 13:33:38 murrayc Exp $ */


/* fileselection.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/window.h>
#include <gtk--/entry.h>
#include <gtk--/label.h>
#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk/gtkfilesel.h>

namespace Gtk {
class FileSelection;
class FileSelection_Class;
}
namespace Gtk { Gtk::FileSelection *wrap (GtkFileSelection *o); }
namespace Gtk
{
//: Prompt the user for a file or directory name.
//- {\class Gtk::FileSelection} should be used to retrieve file or
//- directory names from the user. It will create a new dialog window
//- containing a directory list, and a file list corresponding to the
//- current working directory. The filesystem can be navigated using
//- the directory list or the drop-down history menu. Alternatively,
//- the TAB key can be used to navigate using filename completion -
//- common in text based editors such as emacs and jed.
//-
//- The default filename can be set using {set_filename()} and the
//- selected filename retrieved using {get_filename()}.
//-
//- Use {complete()} to display files that match a given pattern.
//- This can be used for example, to show only *.txt files, or only
//- files beginning with gtk*.
//-
//- Simple file operations; create directory, delete file, and rename
//- file, are available from buttons at the top of the dialog. These
//- can be hidden using {hide_fileop_buttons()} and shown again using
//- {show_fileop_buttons()}.
class FileSelection : public Window {

public:
  typedef FileSelection          CppObjectType;
  typedef FileSelection_Class    CppClassType;
  typedef GtkFileSelection           BaseObjectType;
  typedef GtkFileSelectionClass      BaseClassType;

private:
  friend class FileSelection_Class;
  static CppClassType file_selection_class;

  FileSelection(const FileSelection&);
  FileSelection& operator=(const FileSelection&); // not implemented

protected:
  void   initialize_class();
  explicit FileSelection(GtkFileSelection *castitem);

public:
  static GtkType get_type();
  GtkFileSelection* gtkobj()             { return (GtkFileSelection*)(gtkobject); }
  const GtkFileSelection* gtkobj() const { return (GtkFileSelection*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~FileSelection();

private:

public:

  //: Creates a new file selection dialog box.
  //- By default it will contain a {\class Gtk::CList} of the
  //- application's current working directory, and a file listing.
  //- Operation buttons that allow the user to create a directory,
  //- delete files and rename files, are also present.
  //-
  //- title: A message that will be placed in the file requestor's titlebar.
  explicit FileSelection(const nstring &title=0);



  //: Sets a default path for the file requestor.
  //- If filename includes a directory path, then the requestor will open
  //- with that path as its current working directory.
  //-
  //- filename: A string to set as the default file name.


  void set_filename(const string& filename);

  //: Hides the file operation buttons that normally appear at the top of
  //: the dialog.
  //- Useful if you wish to create a custom file selector, based on
  //- {\class Gtk::FileSelection}.


  void hide_fileop_buttons();

  //- Will attempt to match a pattern to a valid filename in the current directory.
  //- If a match can be made, the matched filename will appear in the text entry
  //- field of the file selection dialog. If a partial match can be made, the
  //- "Files" list will contain those file names which have been partially matched.
  //-
  //- pattern: A string of characters which may or may not match any filenames in
  //- the current directory.


  void complete(const string& pattern);

  //: Retrieves the currently selected filename from the file selection dialog.
  //- If no file is selected then the selected directory path is returned.
  //-
  //- Returns: A string containing the selected file's full path.


  string get_filename() const;

  //: Shows the file operation buttons, if they have previously been hidden.
  //- The rest of the widgets in the dialog will be resized accordingly.


  void show_fileop_buttons();


  //: Accessors
  Gtk::HBox* get_action_area() const;

  Gtk::Entry* get_selection_entry() const;

  Gtk::Label* get_selection_text() const;

  Gtk::Button* get_ok_button() const;

  Gtk::Button* get_cancel_button() const;

public:

protected:
  // impl functions

};

}


#endif
