// -*- c++ -*-
//  Generated by gtkmmproc from /usr/obj/ports/gtkmm-1.2.10p5/gtkmm-1.2.10/src/build_sources/../adjustment.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_ADJUSTMENT_H
#define _GTKMM_ADJUSTMENT_H

/* $Id: adjustment.gen_h,v 1.43 2001/07/15 13:33:38 murrayc Exp $ */

/* adjustment.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/data.h>
#include <gtk/gtkadjustment.h>

namespace Gtk {
class Adjustment;
class Adjustment_Class;
}
namespace Gtk { Gtk::Adjustment *wrap (GtkAdjustment *o); }
namespace Gtk
{
/* gtkadjustment.h */
//: A GtkObject representing an adjustable bounded value.
//- The adjustment is used for holding numerical values and controlling the range
//- of values a widget can take on. It can be used with the {\class Gtk::SpinButton::},
//- {\class Gtk::ScrollBar::}, and {\class Gtk::Scale::} widgets.
class Adjustment : public Data {

public:
  typedef Adjustment          CppObjectType;
  typedef Adjustment_Class    CppClassType;
  typedef GtkAdjustment           BaseObjectType;
  typedef GtkAdjustmentClass      BaseClassType;

private:
  friend class Adjustment_Class;
  static CppClassType adjustment_class;

  Adjustment(const Adjustment&);
  Adjustment& operator=(const Adjustment&); // not implemented

protected:
  void   initialize_class();
  explicit Adjustment(GtkAdjustment *castitem);

public:
  static GtkType get_type();
  GtkAdjustment* gtkobj()             { return (GtkAdjustment*)(gtkobject); }
  const GtkAdjustment* gtkobj() const { return (GtkAdjustment*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Adjustment();

private:

public:

  friend class Range;
  friend class HScrollbar;
  friend class VScrollbar;

  //: Constructor.
  //- value: The initial value of the adjustment, and consequently, the widget that uses this adjustment.
  //-        This value must be between lower and upper.
  //-
  //- lower: The lowest value this adjustment can take.
  //-
  //- upper: An upper value for the adjustment, but see below to determine what this value should be set to.
  //-
  //- step_increment: The amount the adjustment changes when incremented by one. For example, clicking on
  //-                 a scrollbar's left or right arrows will change the value by this amount.
  //-
  //- page_increment: The amount an adjustment changes when "paged". Clicking in the trough of a scrollbar
  //-                 or using the page up and page down keys will change the value by this amount.
  //-
  //- page_size: The relative size of a scrollbar's (or another widget's equivalent) handle. For example, if
  //-            upper-lower equals 100, and page_size equals 25, then the bar will fill 1/4th of the
  //-            width or height of the widget, leaving 3/4ths left as trough.
  //-
  //- The upper value is not the maximum value that the adjustment can achieve. To calculate the upper value,
  //- determine what you want the maximum value for the adjustment to be, and add the page_size amount to that.
  Adjustment(gfloat value,
	     gfloat lower,
	     gfloat upper,
	     gfloat step_increment=1,
	     gfloat page_increment=10,
	     gfloat page_size=0);




  //:


  //: This signal is emmited when the adjustment's value has changed.


  //:

  void clamp_page(gfloat lower,gfloat upper);

  //: Set the adjustment to a specific value. Will by default emit the value_changed signal.

  void set_value(gfloat value);

  //: Returns the current value.
  gfloat get_value()          const {return gtkobj()->value;}

  //: Returns the current lower value.
  gfloat get_lower()          const {return gtkobj()->lower;}
  //: Returns the current upper value.
  gfloat get_upper()          const {return gtkobj()->upper;}
  //: Returns the current step_increment value.
  gfloat get_step_increment() const {return gtkobj()->step_increment;}
  //: Returns the current page_increment value.
  gfloat get_page_increment() const {return gtkobj()->page_increment;}
  //: Returns the current page_size value.
  gfloat get_page_size()      const {return gtkobj()->page_size;}

  //: Sets the lower value.
  void set_lower(gfloat lower)           {gtkobj()->lower = lower; changed();}
  //: Sets the upper value.
  void set_upper(gfloat upper)           {gtkobj()->upper = upper; changed();}
  //: Sets the step_increment value.
  void set_step_increment(gfloat incr)   {gtkobj()->step_increment = incr; changed();}
  //: Sets the page_increment value.
  void set_page_increment(gfloat incr)   {gtkobj()->page_increment = incr; changed();}
  //: Sets the page_size value.
  void set_page_size(gfloat size)        {gtkobj()->page_size = size; changed();}

public:

  union
    {
      CppObjectType * adjustment_self;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,0,&gtk_adjustment_changed> changed;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,1,&gtk_adjustment_value_changed> value_changed;
    };

protected:
  // impl functions
    virtual void changed_impl();
    virtual void value_changed_impl();

};

}


//+ PROPERTIES(Gtk_Adjustment)
//. name: lower
//. type: gfloat
//. get:
//. set:
//. desc:

//. name: upper
//. type: gfloat
//. get:
//. set:
//. desc:

//. name: value
//. type: gfloat
//. get:
//. set:
//. desc:

//. name: step_increment
//. type: gfloat
//. get:
//. set:
//. desc:

//. name: page_increment
//. type: gfloat
//. get:
//. set:
//. desc:

//. name: page_size
//. type: gfloat
//. get:
//. set:
//. desc:

#endif
